/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui.hierarchy.nodes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.shiftone.jrat.provider.tree.ui.hierarchy.nodes.HierarchyNode;
import org.shiftone.jrat.provider.tree.ui.hierarchy.nodes.MethodHierarchyNode;
import org.shiftone.jrat.provider.tree.ui.summary.MethodSummaryModel;

public class ClassHierarchyNode
extends HierarchyNode {
    private final List childMethods = new ArrayList();
    private int executedMethods;
    private long totalDurationMs;
    private long totalMethodDuration;
    private long totalErrors;
    private long totalExists;

    public ClassHierarchyNode(String name, MethodSummaryModel methodSummaryModel) {
        super(name, methodSummaryModel);
    }

    public void finalizeStatistics() {
        Iterator i = this.childMethods.iterator();
        while (i.hasNext()) {
            Long tmd;
            MethodHierarchyNode method = (MethodHierarchyNode)i.next();
            this.totalDurationMs += method.getTotalDuration();
            this.totalErrors += method.getTotalErrors();
            this.totalExists += method.getTotalExits();
            if (method.isExecuted()) {
                ++this.executedMethods;
            }
            if ((tmd = method.getTotalMethodDuration()) == null) continue;
            this.totalMethodDuration += tmd.longValue();
        }
    }

    public void addMethod(MethodHierarchyNode methodNode) {
        this.childMethods.add(methodNode);
    }

    public List getChildren() {
        return this.childMethods;
    }

    public int getTotalMethods() {
        return this.childMethods.size();
    }

    public int getExecutedMethods() {
        return this.executedMethods;
    }

    public long getTotalDuration() {
        return this.totalDurationMs;
    }

    public long getTotalExits() {
        return this.totalExists;
    }

    public long getTotalErrors() {
        return this.totalErrors;
    }

    public Long getTotalMethodDuration() {
        return new Long(this.totalMethodDuration);
    }
}

