/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui.hierarchy.nodes;

import java.util.List;
import org.shiftone.jrat.provider.tree.ui.summary.MethodSummaryModel;
import org.shiftone.jrat.util.Percent;

public abstract class HierarchyNode {
    private final MethodSummaryModel methodSummaryModel;
    private static final HierarchyNode[] EMPTY = new HierarchyNode[0];
    private final String name;

    public HierarchyNode(String name, MethodSummaryModel methodSummaryModel) {
        this.name = name;
        this.methodSummaryModel = methodSummaryModel;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public MethodSummaryModel getMethodSummaryModel() {
        return this.methodSummaryModel;
    }

    public abstract void finalizeStatistics();

    public abstract long getTotalDuration();

    public abstract int getTotalMethods();

    public abstract int getExecutedMethods();

    public abstract long getTotalExits();

    public abstract long getTotalErrors();

    public abstract Long getTotalMethodDuration();

    public Percent getErrorRate() {
        return new Percent((double)this.getTotalErrors() * 100.0 / (double)this.getTotalExits());
    }

    public Percent getCoverage() {
        return new Percent((double)this.getExecutedMethods() * 100.0 / (double)this.getTotalMethods());
    }

    public int getUncalledMethods() {
        return this.getTotalMethods() - this.getExecutedMethods();
    }

    public Percent getTotalMethodPercent() {
        Long tmd = this.getTotalMethodDuration();
        return tmd == null ? null : new Percent((double)tmd.longValue() * 100.0 / (double)this.methodSummaryModel.getTotalMethodDuration());
    }

    public abstract List getChildren();

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public int getIndexOfChild(HierarchyNode node) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (node != this.getChild(i)) continue;
            return i;
        }
        return -1;
    }

    public HierarchyNode getChild(int index) {
        return (HierarchyNode)this.getChildren().get(index);
    }

    public int getChildCount() {
        return this.getChildren().size();
    }
}

