/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui.hierarchy.nodes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.shiftone.jrat.provider.tree.ui.hierarchy.nodes.ClassHierarchyNode;
import org.shiftone.jrat.provider.tree.ui.hierarchy.nodes.HierarchyNode;
import org.shiftone.jrat.provider.tree.ui.summary.MethodSummaryModel;

public class PackageHierarchyNode
extends HierarchyNode {
    private List childPackages = new ArrayList();
    private List childClasses = new ArrayList();
    private int totalMethods;
    private int executedMethods;
    private long totalDuration;
    private long totalMethodDuration;
    private long totalErrors;
    private long totalExits;

    public PackageHierarchyNode(String name, MethodSummaryModel methodSummaryModel) {
        super(name, methodSummaryModel);
    }

    public void finalizeStatistics() {
        HierarchyNode node;
        Iterator i = this.childPackages.iterator();
        while (i.hasNext()) {
            node = (PackageHierarchyNode)i.next();
            this.addStatistics(node);
        }
        i = this.childClasses.iterator();
        while (i.hasNext()) {
            node = (ClassHierarchyNode)i.next();
            this.addStatistics(node);
        }
    }

    private void addStatistics(HierarchyNode node) {
        node.finalizeStatistics();
        this.totalMethods += node.getTotalMethods();
        this.executedMethods += node.getExecutedMethods();
        this.totalDuration += node.getTotalDuration();
        this.totalErrors += node.getTotalErrors();
        this.totalExits += node.getTotalExits();
        Long tmd = node.getTotalMethodDuration();
        if (tmd != null) {
            this.totalMethodDuration += tmd.longValue();
        }
    }

    public Long getTotalMethodDuration() {
        return new Long(this.totalMethodDuration);
    }

    public int getTotalMethods() {
        return this.totalMethods;
    }

    public int getExecutedMethods() {
        return this.executedMethods;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public long getTotalExits() {
        return this.totalExits;
    }

    public long getTotalErrors() {
        return this.totalErrors;
    }

    public List getChildren() {
        ArrayList list = new ArrayList();
        list.addAll(this.childPackages);
        list.addAll(this.childClasses);
        return list;
    }

    public void addClass(ClassHierarchyNode classNode) {
        this.childClasses.add(classNode);
    }

    public void addPackage(PackageHierarchyNode packageNode) {
        this.childPackages.add(packageNode);
    }

    public PackageHierarchyNode getChildPackage(String name) {
        for (int i = 0; i < this.childPackages.size(); ++i) {
            PackageHierarchyNode child = (PackageHierarchyNode)this.childPackages.get(i);
            if (!child.getName().equals(name)) continue;
            return child;
        }
        PackageHierarchyNode node = new PackageHierarchyNode(name, this.getMethodSummaryModel());
        this.addPackage(node);
        return node;
    }

    public PackageHierarchyNode getChildPackage(String[] nameParts) {
        if (nameParts.length == 0) {
            return this;
        }
        PackageHierarchyNode current = this.getChildPackage(nameParts[0]);
        for (int i = 1; i < nameParts.length; ++i) {
            current = current.getChildPackage(nameParts[i]);
        }
        return current;
    }

    public ClassHierarchyNode getChildClass(String name) {
        for (int i = 0; i < this.childClasses.size(); ++i) {
            ClassHierarchyNode child = (ClassHierarchyNode)this.childClasses.get(i);
            if (!child.getName().equals(name)) continue;
            return child;
        }
        ClassHierarchyNode node = new ClassHierarchyNode(name, this.getMethodSummaryModel());
        this.addClass(node);
        return node;
    }
}

