/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui.summary;

import org.shiftone.jrat.core.Accumulator;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.provider.tree.ui.TraceTreeNode;
import org.shiftone.jrat.util.Percent;

public class MethodSummary {
    private final MethodKey methodKey;
    private long totalEnters;
    private long totalExists;
    private long totalErrors;
    private long minDuration = Long.MAX_VALUE;
    private long maxDuration = Long.MIN_VALUE;
    private long totalDuration;
    private long totalMethodDuration;
    private int totalCallers;

    public MethodSummary(MethodKey methodKey) {
        this.methodKey = methodKey;
    }

    public void addStatistics(TraceTreeNode node) {
        Accumulator accumulator = node.getAccumulator();
        this.totalEnters += accumulator.getTotalEnters();
        this.totalExists += accumulator.getTotalExits();
        this.totalErrors += accumulator.getTotalErrors();
        if (this.totalExists > 0L) {
            this.minDuration = Math.min(this.minDuration, accumulator.getMinDuration());
            this.maxDuration = Math.max(this.maxDuration, accumulator.getMaxDuration());
        }
        this.totalDuration += accumulator.getTotalDuration();
        this.totalMethodDuration += node.getTotalMethodDuration();
        ++this.totalCallers;
    }

    public Long getTotalMethodDuration() {
        return this.totalEnters != this.totalExists ? null : new Long(this.totalMethodDuration);
    }

    public Double getAverageMethodDuration() {
        return this.totalExists == 0L || this.totalEnters != this.totalExists ? null : new Double((double)this.totalMethodDuration / (double)this.totalExists);
    }

    public Double getAverageDuration() {
        return this.totalExists == 0L ? null : new Double((double)this.totalDuration / (double)this.totalExists);
    }

    public Percent getErrorRate() {
        return this.totalExists == 0L ? null : new Percent((double)this.totalErrors * 100.0 / (double)this.totalExists);
    }

    public long getUncompletedCalls() {
        return this.totalEnters - this.totalExists;
    }

    public long getTotalEnters() {
        return this.totalEnters;
    }

    public long getTotalExists() {
        return this.totalExists;
    }

    public long getTotalErrors() {
        return this.totalErrors;
    }

    public Long getMinDuration() {
        return this.minDuration == Long.MAX_VALUE ? null : new Long(this.minDuration);
    }

    public Long getMaxDuration() {
        return this.maxDuration == Long.MIN_VALUE ? null : new Long(this.maxDuration);
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public int getTotalCallers() {
        return this.totalCallers;
    }

    public MethodKey getMethodKey() {
        return this.methodKey;
    }
}

