/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui.summary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.provider.tree.ui.TraceTreeNode;
import org.shiftone.jrat.provider.tree.ui.summary.MethodSummary;

public class MethodSummaryModel {
    private final List methodList = new ArrayList();
    private final Map methodMap = new HashMap();
    private final long totalMethodDuration;

    public MethodSummaryModel(TraceTreeNode node) {
        this.process(node);
        this.totalMethodDuration = this.calculateTotalMethodDuration();
    }

    public long getTotalMethodDuration() {
        return this.totalMethodDuration;
    }

    private long calculateTotalMethodDuration() {
        long duration = 0L;
        Iterator i = this.methodList.iterator();
        while (i.hasNext()) {
            MethodSummary summary = (MethodSummary)i.next();
            Long d = summary.getTotalMethodDuration();
            if (d == null) continue;
            duration += d.longValue();
        }
        return duration;
    }

    private void process(TraceTreeNode node) {
        if (!node.isRootNode()) {
            MethodKey methodKey = node.getMethodKey();
            MethodSummary method = this.getMethod(methodKey);
            method.addStatistics(node);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            TraceTreeNode child = node.getChildNodeAt(i);
            this.process(child);
        }
    }

    private MethodSummary getMethod(MethodKey methodKey) {
        MethodSummary summary = (MethodSummary)this.methodMap.get(methodKey);
        if (summary == null) {
            summary = new MethodSummary(methodKey);
            this.methodMap.put(methodKey, summary);
            this.methodList.add(summary);
        }
        return summary;
    }

    public List getMethodSummaryList() {
        return Collections.unmodifiableList(this.methodList);
    }

    public Map getMethodSummaryMap() {
        return Collections.unmodifiableMap(this.methodMap);
    }
}

