/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui.summary;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.shiftone.jrat.depends.jdesktop.swingx.JXHyperlink;
import org.shiftone.jrat.depends.jdesktop.swingx.JXTable;
import org.shiftone.jrat.depends.jdesktop.swingx.JXTaskPane;
import org.shiftone.jrat.depends.jdesktop.swingx.JXTaskPaneContainer;
import org.shiftone.jrat.desktop.util.JXTableWatcher;
import org.shiftone.jrat.desktop.util.Table;
import org.shiftone.jrat.provider.tree.ui.summary.SummaryTableModel;
import org.shiftone.jrat.provider.tree.ui.summary.action.AllColumnVisibilityAction;
import org.shiftone.jrat.provider.tree.ui.summary.action.ResetColumnVisibilityAction;
import org.shiftone.jrat.provider.tree.ui.summary.action.ShowSystemPropertiesAction;
import org.shiftone.jrat.provider.tree.ui.summary.action.SortAndShowColumnAction;
import org.shiftone.jrat.ui.util.PercentTableCellRenderer;

public class SummaryPanel
extends JPanel {
    private final JXTable table;
    private final JXTaskPane tasks;
    private final JXTaskPane details;
    private final JXTaskPane summary;
    private final JLabel detailLabel;
    private final SummaryTableModel summaryTableModel;
    private final long totalMethodDuration;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$tree$ui$summary$SummaryPanel;

    public SummaryPanel(SummaryTableModel summaryTableModel, long totalMethodDuration, long sessionStartMs, long sessionEndMs, Properties systemProperties, String hostName, String hostAddress) {
        JSplitPane splitPane = new JSplitPane(1);
        this.summaryTableModel = summaryTableModel;
        this.totalMethodDuration = totalMethodDuration;
        this.table = new JXTable();
        this.table.setModel(summaryTableModel);
        this.table.setColumnControlVisible(true);
        this.table.getSelectionModel().addListSelectionListener(new SelectionListener());
        splitPane.setRightComponent(new JScrollPane(this.table));
        JXTableWatcher.initialize(this.table, Preferences.userNodeForPackage(class$org$shiftone$jrat$provider$tree$ui$summary$SummaryPanel == null ? (class$org$shiftone$jrat$provider$tree$ui$summary$SummaryPanel = SummaryPanel.class$("org.shiftone.jrat.provider.tree.ui.summary.SummaryPanel")) : class$org$shiftone$jrat$provider$tree$ui$summary$SummaryPanel).node("columns"), SummaryTableModel.getColumns());
        PercentTableCellRenderer.setDefaultRenderer(this.table);
        this.detailLabel = new JLabel();
        JXTaskPaneContainer taskPaneContainer = new JXTaskPaneContainer();
        this.tasks = this.createTasksPane(this.table);
        taskPaneContainer.add(this.tasks);
        this.details = this.createDetailPane(this.detailLabel);
        taskPaneContainer.add(this.details);
        this.summary = this.createSummaryPane(sessionStartMs, sessionEndMs, systemProperties, hostName, hostAddress);
        taskPaneContainer.add(this.summary);
        splitPane.setLeftComponent(taskPaneContainer);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
    }

    private JXTaskPane createDetailPane(Component component) {
        JXTaskPane details = new JXTaskPane();
        details.setVisible(false);
        details.add(component);
        return details;
    }

    private JXTaskPane createTasksPane(JXTable table) {
        JXTaskPane pane = new JXTaskPane();
        pane.setTitle("Tasks");
        pane.add(new JXHyperlink(new SortAndShowColumnAction("Sort by Total Method Duration", table, SummaryTableModel.TOTAL_METHOD)));
        pane.add(new JXHyperlink(new SortAndShowColumnAction("Sort by Exception Rate", table, SummaryTableModel.EXCEPTION_RATE)));
        pane.add(new JXHyperlink(new ResetColumnVisibilityAction(table, SummaryTableModel.getColumns())));
        pane.add(new JXHyperlink(new AllColumnVisibilityAction(table)));
        return pane;
    }

    private JXTaskPane createSummaryPane(long sessionStartMs, long sessionEndMs, Properties systemProperties, String hostName, String hostAddress) {
        DateFormat dateFormat = SimpleDateFormat.getDateTimeInstance(3, 1);
        JXTaskPane pane = new JXTaskPane();
        pane.setTitle("Session Details");
        StringBuffer sb = new StringBuffer("<html><table>");
        sb.append("<tr><td>Start</td><td>");
        sb.append(dateFormat.format(new Date(sessionStartMs)));
        sb.append("</td></tr>");
        sb.append("<tr><td>End</td><td>");
        sb.append(dateFormat.format(new Date(sessionEndMs)));
        sb.append("</td></tr>");
        sb.append("<tr><td>Duration</td><td>");
        sb.append(sessionEndMs - sessionStartMs + " ms");
        sb.append("</td></tr>");
        sb.append("<tr><td>Host</td><td>");
        sb.append(hostName);
        sb.append("</td></tr>");
        sb.append("<tr><td>Address</td><td>");
        sb.append(hostAddress);
        sb.append("</td></tr>");
        sb.append("</table></html>");
        pane.add(new JLabel(sb.toString()));
        pane.add(new JXHyperlink(new ShowSystemPropertiesAction(this, systemProperties)));
        return pane;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private final NumberFormat percentFormat = DecimalFormat.getPercentInstance();

        public SelectionListener() {
            this.percentFormat.setMinimumFractionDigits(1);
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int[] rows = SummaryPanel.this.table.getSelectedRows();
                if (rows.length == 0) {
                    this.hide();
                } else {
                    this.show(rows);
                }
            }
        }

        private void hide() {
            SummaryPanel.this.details.setVisible(false);
        }

        private void show(int[] rows) {
            long methodTime = this.getTotal(rows, SummaryTableModel.TOTAL_METHOD);
            long totalErrors = this.getTotal(rows, SummaryTableModel.EXCEPTIONS);
            long totalExists = this.getTotal(rows, SummaryTableModel.EXITS);
            long uncompleted = this.getTotal(rows, SummaryTableModel.UNCOMPLETED);
            StringBuffer sb = new StringBuffer("<html><table>");
            sb.append("<tr><td>Total Exits</td><td>");
            sb.append(totalExists);
            sb.append("</td></tr>");
            sb.append("<tr><td>Method Time</td><td>");
            sb.append(methodTime);
            sb.append("ms (");
            sb.append(this.percentFormat.format((double)methodTime / (double)SummaryPanel.this.totalMethodDuration));
            sb.append(")</td></tr>");
            sb.append("<tr><td>Exceptions</td><td>");
            sb.append(totalErrors);
            sb.append("</td></tr>");
            if (totalExists > 0L) {
                sb.append("<tr><td>Exception Rate</td><td>");
                sb.append(this.percentFormat.format((double)totalErrors / (double)totalExists));
                sb.append("</td></tr>");
            }
            if (uncompleted > 0L) {
                sb.append("<tr><td>Uncompleted</td><td>");
                sb.append(uncompleted);
                sb.append("</td></tr>");
            }
            if (rows.length == 1) {
                SummaryPanel.this.details.setTitle(this.getMethod(rows[0]));
            } else {
                SummaryPanel.this.details.setTitle(rows.length + " methods selected");
            }
            sb.append("</table></html>");
            SummaryPanel.this.details.setVisible(true);
            SummaryPanel.this.detailLabel.setText(sb.toString());
        }

        private String getMethod(int row) {
            int r = SummaryPanel.this.table.convertRowIndexToModel(row);
            return (String)SummaryPanel.this.summaryTableModel.getValueAt(r, SummaryTableModel.METHOD.getIndex());
        }

        private long getTotal(int[] rows, Table.Column column) {
            long value = 0L;
            for (int i = 0; i < rows.length; ++i) {
                int r = SummaryPanel.this.table.convertRowIndexToModel(rows[i]);
                Long v = (Long)SummaryPanel.this.summaryTableModel.getValueAt(r, column.getIndex());
                if (v == null) continue;
                value += v.longValue();
            }
            return value;
        }
    }
}

