/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui.summary.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import org.shiftone.jrat.depends.jdesktop.swingx.JXTable;
import org.shiftone.jrat.depends.jdesktop.swingx.decorator.SortOrder;

public class ShowSystemPropertiesAction
extends AbstractAction {
    private final Component component;
    private final Properties properties;

    public ShowSystemPropertiesAction(Component component, Properties properties) {
        super("Show System Properties");
        this.component = component;
        this.properties = properties;
    }

    public void actionPerformed(ActionEvent e) {
        TextDialog dialog = new TextDialog(this.properties);
        dialog.setSize(new Dimension(400, 500));
        dialog.setLocationRelativeTo(this.component);
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    private class TextDialog
    extends JDialog {
        public TextDialog(Properties properties) {
            DefaultTableModel tableModel = new DefaultTableModel();
            tableModel.addColumn("Name");
            tableModel.addColumn("Value");
            Iterator<Object> keys = properties.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = properties.getProperty(key);
                tableModel.addRow(new Object[]{key, value});
            }
            JXTable table = new JXTable(tableModel);
            table.setSortOrder(0, SortOrder.ASCENDING);
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(table), "Center");
            this.setTitle("System Properties During Run");
            this.setModal(true);
        }
    }
}

