/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui.trace;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.desktop.util.Icons;
import org.shiftone.jrat.provider.tree.ui.TraceTreeNode;
import org.shiftone.jrat.provider.tree.ui.trace.PercentColorLookup;
import org.shiftone.jrat.util.log.Logger;

public class StackTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$provider$tree$ui$trace$StackTreeCellRenderer == null ? (class$org$shiftone$jrat$provider$tree$ui$trace$StackTreeCellRenderer = StackTreeCellRenderer.class$("org.shiftone.jrat.provider.tree.ui.trace.StackTreeCellRenderer")) : class$org$shiftone$jrat$provider$tree$ui$trace$StackTreeCellRenderer);
    private PercentColorLookup colorLookup = new PercentColorLookup();
    private static Icon EVIL = Icons.getIcon("red.png");
    private static Icon GOOD = Icons.getIcon("green.png");
    private static Icon ROOT2 = Icons.getIcon("output_folder_attrib.png");
    private static Icon ROOT = Icons.getIcon("black.png");
    private TraceTreeNode treeNode = null;
    private DecimalFormat pctDecimalFormat = new DecimalFormat("#,###.#'%'");
    private DecimalFormat msDecimalFormat = new DecimalFormat("#,###,###.##'ms'");
    static /* synthetic */ Class class$org$shiftone$jrat$provider$tree$ui$trace$StackTreeCellRenderer;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.treeNode = (TraceTreeNode)value;
        this.hasFocus = hasFocus;
        this.selected = sel;
        double w = this.treeNode.getPctOfAvgParentDuration();
        Icon icon = null;
        icon = this.treeNode.isRootNode() ? ROOT : (this.treeNode.getDepth() == 1 ? ROOT2 : (w >= 25.0 ? EVIL : GOOD));
        this.setText(this.nodeText(sel));
        if (this.selected) {
            this.setForeground(Color.white);
        } else {
            this.setForeground(Color.black);
        }
        if (!tree.isEnabled()) {
            this.setEnabled(false);
            this.setDisabledIcon(icon);
        } else {
            this.setEnabled(true);
            this.setIcon(icon);
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        return this;
    }

    public String nodeText(boolean selected) {
        String result;
        if (this.treeNode.isRootNode()) {
            result = "Root";
        } else {
            MethodKey methodKey = this.treeNode.getMethodKey();
            String methodName = methodKey.getMethodName();
            if (this.treeNode.getDepth() == 1) {
                Double avg = this.treeNode.getAverageDuration();
                result = methodName + (avg == null ? " - never exited" : " - " + this.msDecimalFormat.format(this.treeNode.getAverageDuration()));
            } else {
                double d = this.treeNode.getPctOfAvgRootDuration();
                result = d > 0.09 ? methodName + " - " + this.pctDecimalFormat.format(d) : methodName;
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

