/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui.trace.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.Scrollable;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.provider.tree.ui.TraceTreeNode;
import org.shiftone.jrat.provider.tree.ui.trace.PercentColorLookup;
import org.shiftone.jrat.provider.tree.ui.trace.graph.BufferedJComponent;
import org.shiftone.jrat.util.log.Logger;

public class TreeGraphComponent
extends BufferedJComponent
implements Scrollable {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$provider$tree$ui$trace$graph$TreeGraphComponent == null ? (class$org$shiftone$jrat$provider$tree$ui$trace$graph$TreeGraphComponent = TreeGraphComponent.class$("org.shiftone.jrat.provider.tree.ui.trace.graph.TreeGraphComponent")) : class$org$shiftone$jrat$provider$tree$ui$trace$graph$TreeGraphComponent);
    private TraceTreeNode node;
    private Color LINE_COLOR = Color.LIGHT_GRAY;
    private PercentColorLookup colorLookup = new PercentColorLookup();
    private DecimalFormat pctDecimalFormat = new DecimalFormat("#,###.#'%'");
    private Font font = new Font("SansSerif", 0, 9);
    private int rowHeight = 12;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$tree$ui$trace$graph$TreeGraphComponent;

    public TreeGraphComponent() {
        this.setDoubleBuffered(false);
        this.setBackground(Color.WHITE);
    }

    protected void paintBuffer(Graphics2D g) {
        Graphics2D g2d = g;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.node != null && !this.node.isRootNode() && this.node.getTotalExits() != 0L) {
            this.paint(g2d, this.node, 0, 0, this.getWidth());
        }
    }

    private void paint(Graphics2D g, TraceTreeNode node, int x, int row, int width) {
        g.setFont(this.font);
        FontMetrics metrics = g.getFontMetrics();
        Color color = this.colorLookup.getColor(node.getPctOfAvgParentDuration());
        int height = metrics.getHeight() + metrics.getDescent();
        int y = row * height;
        this.rowHeight = height;
        g.setColor(color);
        g.fill3DRect(x, y, width, height, true);
        Graphics gg = g.create(x, y, width, height);
        gg.setColor(Color.BLACK);
        MethodKey methodKey = node.getMethodKey();
        String text = methodKey.getClassName() + "." + methodKey.getMethodName() + " " + this.pctDecimalFormat.format(node.getPctOfAvgRootDuration());
        Rectangle2D stringBounds = metrics.getStringBounds(text, g);
        if (stringBounds.getWidth() < (double)width) {
            gg.drawString(text, (int)((double)(width / 2) - stringBounds.getWidth() / 2.0), (int)stringBounds.getHeight());
        } else {
            text = methodKey.getMethodName() + " " + this.pctDecimalFormat.format(node.getPctOfAvgRootDuration());
            stringBounds = metrics.getStringBounds(text, g);
            if (stringBounds.getWidth() < (double)width) {
                gg.drawString(text, (int)((double)(width / 2) - stringBounds.getWidth() / 2.0), (int)stringBounds.getHeight());
            }
        }
        long total = node.getTotalDuration();
        if (total > 0L && node.getChildCount() > 0) {
            int childX = 0;
            for (int i = 0; i < node.getChildCount(); ++i) {
                TraceTreeNode child = (TraceTreeNode)node.getChildAt(i);
                long part = child.getTotalDuration();
                int partWidth = (int)(part * (long)width / total);
                if (partWidth > 1) {
                    this.paint(g, child, x + childX, row + 1, partWidth);
                } else {
                    g.setColor(this.LINE_COLOR);
                    g.drawLine(x + childX, (row + 1) * height, x + childX, (row + 1 + node.getMaxDepth()) * height);
                }
                childX += partWidth;
            }
        }
    }

    public synchronized void setStackTreeNode(TraceTreeNode node) {
        this.node = node;
        this.dataChanged();
        this.setPreferredSize(new Dimension(this.getWidth(), this.rowHeight * node.getMaxDepth()));
        this.setSize(this.getPreferredSize());
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.rowHeight;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.rowHeight;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

