/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui.trace.pie;

import java.awt.Graphics2D;
import org.shiftone.jrat.provider.tree.ui.TraceTreeNode;
import org.shiftone.jrat.provider.tree.ui.trace.PercentColorLookup;
import org.shiftone.jrat.provider.tree.ui.trace.graph.BufferedJComponent;
import org.shiftone.jrat.util.log.Logger;

public class PieGraphComponent
extends BufferedJComponent {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$provider$tree$ui$trace$pie$PieGraphComponent == null ? (class$org$shiftone$jrat$provider$tree$ui$trace$pie$PieGraphComponent = PieGraphComponent.class$("org.shiftone.jrat.provider.tree.ui.trace.pie.PieGraphComponent")) : class$org$shiftone$jrat$provider$tree$ui$trace$pie$PieGraphComponent);
    private TraceTreeNode root;
    private PercentColorLookup colorLookup = new PercentColorLookup();
    static /* synthetic */ Class class$org$shiftone$jrat$provider$tree$ui$trace$pie$PieGraphComponent;

    public synchronized void setStackTreeNode(TraceTreeNode root) {
        this.root = root;
        this.dataChanged();
        if (this.isVisible()) {
            this.repaint();
        }
    }

    protected void paintBuffer(Graphics2D g) {
        double totalRadius = Math.min(this.getWidth(), this.getHeight()) / 2;
        int x = this.getWidth() / 2;
        int y = this.getHeight() / 2;
        int maxDepth = 10;
        double radiusDelta = totalRadius / (double)maxDepth;
        this.paintNode(g, this.root, x, y, radiusDelta, 0, 360, 1, maxDepth);
    }

    public int getMaxEffectiveDepth(TraceTreeNode node) {
        int maxChildDepth = 0;
        for (int i = 0; i < node.getChildCount(); ++i) {
            TraceTreeNode child = (TraceTreeNode)node.getChildAt(i);
            if (child.getTotalDuration() <= 0L) continue;
            maxChildDepth = Math.max(maxChildDepth, this.getMaxEffectiveDepth(child));
        }
        return 1 + maxChildDepth;
    }

    public void paintNode(Graphics2D g, TraceTreeNode node, int x, int y, double radiusDelta, int min, int max, int depth, int maxDepth) {
        if (node == null || depth > maxDepth) {
            return;
        }
        long totalDegrees = max - min;
        long totalNanos = node.getTotalDuration();
        if (totalNanos > 0L && node.getChildCount() > 0) {
            int startDegrees = min;
            for (int i = 0; i < node.getChildCount(); ++i) {
                TraceTreeNode child = (TraceTreeNode)node.getChildAt(i);
                long partNanos = child.getTotalDuration();
                int partDegrees = (int)(partNanos * totalDegrees / totalNanos);
                if (partDegrees > 1) {
                    this.paintNode(g, child, x, y, radiusDelta, startDegrees, startDegrees + partDegrees, depth + 1, maxDepth);
                }
                startDegrees += partDegrees;
            }
        }
        int radius = (int)(radiusDelta * (double)depth);
        int diameter = radius * 2;
        g.setColor(this.colorLookup.getColor(node.getPctOfAvgParentDuration()));
        g.fillArc(x - radius, y - radius, diameter, diameter, min, max - min);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

