/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui.trace.stack;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.desktop.util.Table;
import org.shiftone.jrat.provider.tree.ui.TraceTreeNode;
import org.shiftone.jrat.util.Percent;
import org.shiftone.jrat.util.log.Logger;

public class StackTableModel
extends AbstractTableModel {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$provider$tree$ui$trace$stack$StackTableModel == null ? (class$org$shiftone$jrat$provider$tree$ui$trace$stack$StackTableModel = StackTableModel.class$("org.shiftone.jrat.provider.tree.ui.trace.stack.StackTableModel")) : class$org$shiftone$jrat$provider$tree$ui$trace$stack$StackTableModel);
    private List stack = new ArrayList();
    private long rootTotalDuration;
    private static final Table TABLE = new Table();
    public static final Table.Column PACKAGE = TABLE.column("Package", false);
    public static final Table.Column CLASS = TABLE.column("Class");
    public static final Table.Column METHOD = TABLE.column("Method");
    public static final Table.Column SIGNATURE = TABLE.column("Signature");
    public static final Table.Column ENTERS = TABLE.column("Enters", false);
    public static final Table.Column EXITS = TABLE.column("Exits");
    public static final Table.Column ERRORS = TABLE.column("Errors", false);
    public static final Table.Column THREADS = TABLE.column("Concurrent Threads", false);
    public static final Table.Column TOTAL = TABLE.column("Total ms");
    public static final Table.Column AVERAGE = TABLE.column("Average ms", false);
    public static final Table.Column TOTAL_METHOD = TABLE.column("Total Method ms");
    public static final Table.Column AVERAGE_METHOD = TABLE.column("Average Method ms");
    public static final Table.Column STANDARD_DEVIATION = TABLE.column("Standard Deviation", false);
    public static final Table.Column MIN = TABLE.column("Min ms", false);
    public static final Table.Column MAX = TABLE.column("Max ms", false);
    public static final Table.Column PERCENT_OF_PARENT = TABLE.column("% of Parent");
    public static final Table.Column PERCENT_OF_ROOT = TABLE.column("% of Root");
    static /* synthetic */ Class class$org$shiftone$jrat$provider$tree$ui$trace$stack$StackTableModel;

    public Object getValueAt(int rowIndex, int columnIndex) {
        TraceTreeNode node = (TraceTreeNode)this.stack.get(rowIndex);
        MethodKey methodKey = node.getMethodKey();
        if (methodKey == null) {
            return "?";
        }
        if (columnIndex == PACKAGE.getIndex()) {
            return methodKey.getPackageName();
        }
        if (columnIndex == CLASS.getIndex()) {
            return methodKey.getClassName();
        }
        if (columnIndex == METHOD.getIndex()) {
            return methodKey.getMethodName();
        }
        if (columnIndex == SIGNATURE.getIndex()) {
            return methodKey.getSig().getShortText();
        }
        if (columnIndex == ENTERS.getIndex()) {
            return new Long(node.getTotalEnters());
        }
        if (columnIndex == EXITS.getIndex()) {
            return new Long(node.getTotalExits());
        }
        if (columnIndex == ERRORS.getIndex()) {
            return new Long(node.getTotalErrors());
        }
        if (columnIndex == THREADS.getIndex()) {
            return new Integer(node.getMaxConcurrentThreads());
        }
        if (columnIndex == TOTAL.getIndex()) {
            return new Long(node.getTotalDuration());
        }
        if (columnIndex == AVERAGE.getIndex()) {
            return node.getAverageDuration();
        }
        if (columnIndex == TOTAL_METHOD.getIndex()) {
            return new Long(node.getTotalMethodDuration());
        }
        if (columnIndex == AVERAGE_METHOD.getIndex()) {
            return node.getAverageMethodDuration();
        }
        if (columnIndex == STANDARD_DEVIATION.getIndex()) {
            return node.getStdDeviation();
        }
        if (columnIndex == MIN.getIndex()) {
            return new Long(node.getMinDuration());
        }
        if (columnIndex == MAX.getIndex()) {
            return new Long(node.getMaxDuration());
        }
        if (columnIndex == PERCENT_OF_PARENT.getIndex()) {
            return new Percent(node.getPctOfAvgParentDuration());
        }
        if (columnIndex == PERCENT_OF_ROOT.getIndex()) {
            return new Percent(this.getPctOfAvgRootDuration(node));
        }
        return null;
    }

    public synchronized void setStackTreeNode(TraceTreeNode root, TraceTreeNode node) {
        ArrayList<TraceTreeNode> newStack = new ArrayList<TraceTreeNode>();
        TraceTreeNode currNode = node;
        while (currNode.getParent() != null) {
            newStack.add(currNode);
            if (currNode == root) break;
            currNode = currNode.getParentNode();
        }
        if (newStack.isEmpty()) {
            this.rootTotalDuration = 0L;
        } else {
            TraceTreeNode viewRoot = (TraceTreeNode)newStack.get(newStack.size() - 1);
            this.rootTotalDuration = viewRoot.getTotalDuration();
        }
        this.stack = newStack;
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.stack.size();
    }

    public static List getColumns() {
        return TABLE.getColumns();
    }

    public int getColumnCount() {
        return TABLE.getColumnCount();
    }

    public String getColumnName(int columnIndex) {
        return TABLE.getColumn(columnIndex).getName();
    }

    public Class getColumnClass(int columnIndex) {
        return TABLE.getColumn(columnIndex).getType();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public double getPctOfAvgRootDuration(TraceTreeNode node) {
        return this.rootTotalDuration > 0L ? 100.0 * (double)node.getTotalDuration() / (double)this.rootTotalDuration : 0.0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

