/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.ui.inject;

import java.awt.Insets;
import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.shiftone.jrat.core.spi.ui.View;
import org.shiftone.jrat.inject.Injector;
import org.shiftone.jrat.util.Command;
import org.shiftone.jrat.util.Exceptions;
import org.shiftone.jrat.util.NestedRuntimeException;
import org.shiftone.jrat.util.log.Constants;
import org.shiftone.jrat.util.log.Logger;
import org.shiftone.jrat.util.log.LoggerFactory;
import org.shiftone.jrat.util.log.target.LogTarget;

public class InjectRunnable
implements Runnable {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$ui$inject$InjectRunnable == null ? (class$org$shiftone$jrat$ui$inject$InjectRunnable = InjectRunnable.class$("org.shiftone.jrat.ui.inject.InjectRunnable")) : class$org$shiftone$jrat$ui$inject$InjectRunnable);
    private View view;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private int textOffset = 0;
    private Document document;
    private BoundedRangeModel scrollBarRangeModel;
    private Injector injector = null;
    private File[] targets;
    static /* synthetic */ Class class$org$shiftone$jrat$ui$inject$InjectRunnable;

    public InjectRunnable(Injector injector, File[] targets, View view) {
        LOG.info("InjectFilesRunnable");
        this.injector = injector;
        this.targets = targets;
        this.view = view;
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setMargin(new Insets(10, 10, 10, 10));
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollBarRangeModel = this.scrollPane.getVerticalScrollBar().getModel();
        this.document = this.textArea.getDocument();
        view.setBody(this.scrollPane);
    }

    public void run() {
        LOG.info("run");
        LoggerFactory.executeInThreadScope((LogTarget)new SwingLogTarget(), (Command)new Command(){

            protected void run() throws Exception {
                InjectRunnable.this.view.execute(new Command(){

                    public void run() {
                        InjectRunnable.this.doRun();
                    }
                });
                LOG.info("DONE.");
            }
        });
        LOG.info("run complete");
    }

    private void doRun() {
        TreeSet fileSet = new TreeSet();
        for (int i = 0; i < this.targets.length; ++i) {
            LOG.info("scanning " + this.targets[i] + "...");
            this.scan(this.targets[i], fileSet);
        }
        File[] files = fileSet.toArray(new File[fileSet.size()]);
        BoundedRangeModel rangeModel = this.view.getRangeModel();
        LOG.info("done scanning : " + files.length + " file(s) found");
        rangeModel.setMaximum(files.length);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                LOG.info("inject : " + file);
                this.injector.inject(file);
                rangeModel.setValue(i + 1);
                continue;
            }
            catch (Exception e) {
                throw new NestedRuntimeException("Error injecting file : " + file, e);
            }
        }
    }

    public synchronized void addText(String text) {
        try {
            this.document.insertString(this.textOffset, text, SimpleAttributeSet.EMPTY);
            this.textOffset += text.length();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InjectRunnable.this.scrollBarRangeModel.setValue(InjectRunnable.this.scrollBarRangeModel.getMaximum());
                }
            });
        }
        catch (Exception e) {
            LOG.error("unable to write to log document", e);
        }
    }

    private void scan(File file, Set fileSet) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SwingLogTarget
    implements LogTarget {
        long start = System.currentTimeMillis();

        private SwingLogTarget() {
        }

        public boolean isLevelEnabled(String topic, int level) {
            return true;
        }

        public void log(String topic, int level, Object message, Throwable throwable) {
            if (this.isLevelEnabled(topic, level)) {
                StringBuffer buffer = new StringBuffer(80);
                buffer.append("[");
                buffer.append(Constants.LEVEL_NAMES[level]);
                buffer.append("] ");
                buffer.append(System.currentTimeMillis() - this.start);
                buffer.append(" ");
                buffer.append(topic);
                buffer.append(" -  ");
                buffer.append(String.valueOf(message));
                if (throwable != null) {
                    buffer.append("\n");
                    buffer.append(Exceptions.printStackTrace(throwable));
                }
                buffer.append('\n');
                InjectRunnable.this.addText(buffer.toString());
            }
        }
    }
}

