/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.text.DecimalFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.shiftone.jrat.util.Percent;
import org.shiftone.jrat.util.log.Logger;

public class PercentTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$ui$util$PercentTableCellRenderer == null ? (class$org$shiftone$jrat$ui$util$PercentTableCellRenderer = PercentTableCellRenderer.class$("org.shiftone.jrat.ui.util.PercentTableCellRenderer")) : class$org$shiftone$jrat$ui$util$PercentTableCellRenderer);
    private Object value = null;
    private DecimalFormat floatDecimalFormat = new DecimalFormat("#,##0.00");
    private DecimalFormat doubleDecimalFormat = new DecimalFormat("#,##0.00");
    private DecimalFormat longDecimalFormat = new DecimalFormat("###,###,###");
    private static final Color COLOR_XOR = Color.LIGHT_GRAY;
    static /* synthetic */ Class class$org$shiftone$jrat$ui$util$PercentTableCellRenderer;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$shiftone$jrat$util$Percent;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;

    public static void setDefaultRenderer(JTable table) {
        table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = PercentTableCellRenderer.class$("java.lang.Object")) : class$java$lang$Object, new PercentTableCellRenderer());
        table.setDefaultRenderer(class$org$shiftone$jrat$util$Percent == null ? (class$org$shiftone$jrat$util$Percent = PercentTableCellRenderer.class$("org.shiftone.jrat.util.Percent")) : class$org$shiftone$jrat$util$Percent, new PercentTableCellRenderer());
        table.setDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = PercentTableCellRenderer.class$("java.lang.Number")) : class$java$lang$Number, new PercentTableCellRenderer());
        table.setDefaultRenderer(class$java$lang$Integer == null ? (class$java$lang$Integer = PercentTableCellRenderer.class$("java.lang.Integer")) : class$java$lang$Integer, new PercentTableCellRenderer());
        table.setDefaultRenderer(class$java$lang$Long == null ? (class$java$lang$Long = PercentTableCellRenderer.class$("java.lang.Long")) : class$java$lang$Long, new PercentTableCellRenderer());
        table.setDefaultRenderer(class$java$lang$Double == null ? (class$java$lang$Double = PercentTableCellRenderer.class$("java.lang.Double")) : class$java$lang$Double, new PercentTableCellRenderer());
        table.setDefaultRenderer(class$java$lang$Float == null ? (class$java$lang$Float = PercentTableCellRenderer.class$("java.lang.Float")) : class$java$lang$Float, new PercentTableCellRenderer());
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.value = value;
        if (value instanceof Number) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.value instanceof Percent) {
            double pct = ((Percent)this.value).doubleValue();
            if (pct > 100.0) {
                pct = 100.0;
            }
            int w = (int)((double)this.getWidth() * pct / 100.0);
            g.setXORMode(COLOR_XOR);
            g.fillRect(0, 0, w, this.getHeight());
        }
    }

    protected synchronized void setValue(Object value) {
        if (value == null) {
            value = "";
        } else if (value instanceof Number) {
            Number num = (Number)value;
            if (value instanceof Integer || value instanceof Long) {
                value = this.longDecimalFormat.format(num);
            } else if (value instanceof Float) {
                Float f = (Float)value;
                value = f.isNaN() || f.isInfinite() ? String.valueOf(f) : this.floatDecimalFormat.format(num);
            } else if (value instanceof Double) {
                Double d = (Double)value;
                value = d.isNaN() || d.isInfinite() ? String.valueOf(d) : this.doubleDecimalFormat.format(num);
            }
        }
        super.setValue(value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

