/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Date;
import org.shiftone.jrat.core.JRatException;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.log.Logger;

public class IntrospectionUtil {
    public static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$util$IntrospectionUtil == null ? (class$org$shiftone$jrat$util$IntrospectionUtil = IntrospectionUtil.class$("org.shiftone.jrat.util.IntrospectionUtil")) : class$org$shiftone$jrat$util$IntrospectionUtil);
    static /* synthetic */ Class class$org$shiftone$jrat$util$IntrospectionUtil;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Class;

    public static Method getMethod(Class klass, String methodName, int paramCount) throws NoSuchMethodException {
        Method[] methods = null;
        Method method = null;
        Method foundMethod = null;
        int foundMethodCount = 0;
        LOG.debug("getMethod(" + klass.getName() + " , " + methodName + " , " + paramCount + ")");
        Assert.assertNotNull("klass", klass);
        Assert.assertNotNull("methodName", methodName);
        methods = klass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!method.getName().equalsIgnoreCase(methodName) || method.getParameterTypes().length != paramCount) continue;
            foundMethod = method;
            ++foundMethodCount;
        }
        if (foundMethodCount == 0) {
            throw new NoSuchMethodException(klass.getName() + " has no method " + methodName + " with " + paramCount + " parameter(s)");
        }
        if (foundMethodCount > 1) {
            throw new NoSuchMethodException(klass.getName() + " has " + foundMethodCount + " method " + methodName + " with " + paramCount + " parameter(s)");
        }
        return foundMethod;
    }

    public static Object convertSafe(String text, Class targetType) {
        try {
            return IntrospectionUtil.convert(text, targetType);
        }
        catch (Exception e) {
            return text;
        }
    }

    public static Object convert(String text, Class targetType) {
        Class<?> result;
        block12: {
            result = null;
            LOG.debug("convert(" + text + " , " + targetType.getName() + ")");
            try {
                if (targetType.equals(class$java$lang$String == null ? (class$java$lang$String = IntrospectionUtil.class$("java.lang.String")) : class$java$lang$String)) {
                    result = text;
                    break block12;
                }
                if ((class$java$lang$Short == null ? (class$java$lang$Short = IntrospectionUtil.class$("java.lang.Short")) : class$java$lang$Short).equals(targetType) || Short.TYPE.equals(targetType)) {
                    result = new Short(text);
                    break block12;
                }
                if ((class$java$lang$Integer == null ? (class$java$lang$Integer = IntrospectionUtil.class$("java.lang.Integer")) : class$java$lang$Integer).equals(targetType) || Integer.TYPE.equals(targetType)) {
                    result = new Integer(text);
                    break block12;
                }
                if ((class$java$lang$Long == null ? (class$java$lang$Long = IntrospectionUtil.class$("java.lang.Long")) : class$java$lang$Long).equals(targetType) || Long.TYPE.equals(targetType)) {
                    result = new Long(text);
                    break block12;
                }
                if ((class$java$lang$Float == null ? (class$java$lang$Float = IntrospectionUtil.class$("java.lang.Float")) : class$java$lang$Float).equals(targetType) || Float.TYPE.equals(targetType)) {
                    result = new Float(text);
                    break block12;
                }
                if ((class$java$lang$Double == null ? (class$java$lang$Double = IntrospectionUtil.class$("java.lang.Double")) : class$java$lang$Double).equals(targetType) || Double.TYPE.equals(targetType)) {
                    result = new Double(text);
                    break block12;
                }
                if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = IntrospectionUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(targetType) || Boolean.TYPE.equals(targetType)) {
                    result = new Boolean(text);
                    break block12;
                }
                if ((class$java$util$Date == null ? (class$java$util$Date = IntrospectionUtil.class$("java.util.Date")) : class$java$util$Date).equals(targetType)) {
                    result = new Date(text);
                    break block12;
                }
                if ((class$java$io$File == null ? (class$java$io$File = IntrospectionUtil.class$("java.io.File")) : class$java$io$File).equals(targetType)) {
                    File file = new File(text);
                    result = file.getAbsoluteFile();
                    break block12;
                }
                if ((class$java$lang$Class == null ? (class$java$lang$Class = IntrospectionUtil.class$("java.lang.Class")) : class$java$lang$Class).equals(targetType)) {
                    result = Class.forName(text);
                    break block12;
                }
                throw new JRatException("conversion to " + targetType.getName() + " is not supported");
            }
            catch (Exception e) {
                throw new JRatException("unable to convert " + text + " into a " + targetType.getName(), e);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

