/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util.io;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.shiftone.jrat.core.JRatException;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.io.IOUtil;
import org.shiftone.jrat.util.log.Logger;

public class ResourceUtil {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$util$io$ResourceUtil == null ? (class$org$shiftone$jrat$util$io$ResourceUtil = ResourceUtil.class$("org.shiftone.jrat.util.io.ResourceUtil")) : class$org$shiftone$jrat$util$io$ResourceUtil);
    private static ClassLoader CLASS_LOADER = (class$org$shiftone$jrat$util$io$ResourceUtil == null ? (class$org$shiftone$jrat$util$io$ResourceUtil = ResourceUtil.class$("org.shiftone.jrat.util.io.ResourceUtil")) : class$org$shiftone$jrat$util$io$ResourceUtil).getClassLoader();
    private static Map resourceCache = new Hashtable();
    static /* synthetic */ Class class$org$shiftone$jrat$util$io$ResourceUtil;
    static /* synthetic */ Class class$java$lang$Class;

    public static Object newInstance(String className) {
        Class<?> klass = null;
        Object instance = null;
        Assert.assertNotNull("className", className);
        LOG.debug("newInstance(" + className + ")");
        try {
            klass = CLASS_LOADER.loadClass(className);
        }
        catch (Exception e) {
            throw new JRatException("unable to getPreferences class '" + className + "'", e);
        }
        try {
            instance = klass.newInstance();
        }
        catch (Exception e) {
            throw new JRatException("unable to instantiate '" + className + "'", e);
        }
        return instance;
    }

    public static InputStream loadResourceAsStream(String resourceName) {
        InputStream inputStream = null;
        LOG.info("getPreferences resource : " + resourceName);
        Assert.assertNotNull("resourceName", resourceName);
        inputStream = CLASS_LOADER.getResourceAsStream(resourceName);
        if (inputStream == null) {
            LOG.info("resource not found on classpath, trying to open as file");
            try {
                inputStream = new FileInputStream(resourceName);
                LOG.debug("resource opened as file");
            }
            catch (Exception e) {
                throw new JRatException("unable to locate resource : " + resourceName);
            }
        } else {
            LOG.debug("resource opened from classpath");
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadResourceAsBytes(String resourceName) {
        InputStream inputStream = ResourceUtil.loadResourceAsStream(resourceName);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            IOUtil.copy(inputStream, outputStream);
        }
        finally {
            IOUtil.close(inputStream);
        }
        return outputStream.toByteArray();
    }

    private static String fetchResource(String name) {
        InputStreamReader reader = null;
        StringBuffer sb = null;
        InputStream inputStream = null;
        int c = 0;
        char[] buffer = new char[1025];
        Assert.assertNotNull("name", name);
        LOG.debug("fetchResource : " + name);
        inputStream = ResourceUtil.loadResourceAsStream(name);
        reader = new InputStreamReader(inputStream);
        sb = new StringBuffer();
        try {
            c = 0;
            while (c >= 0) {
                sb.append(buffer, 0, c);
                c = reader.read(buffer);
            }
        }
        catch (IOException e) {
            throw new JRatException("unable to read resource data : " + name, e);
        }
        return sb.toString();
    }

    public static String loadResource(String name) {
        String resource = null;
        Assert.assertNotNull("name", name);
        resource = (String)resourceCache.get(name);
        if (resource == null) {
            LOG.info("loading and caching resource : " + name);
            resource = ResourceUtil.fetchResource(name);
            resourceCache.put(name, resource);
        }
        return resource;
    }

    public static Properties getResourceAsProperties(String name) {
        InputStream inputStream = null;
        Properties props = null;
        Assert.assertNotNull("name", name);
        LOG.debug("getResourceAsProperties : " + name);
        inputStream = ResourceUtil.loadResourceAsStream(name);
        props = new Properties();
        try {
            props.load(inputStream);
        }
        catch (Exception e) {
            throw new JRatException("unable to getPreferences properties from resource : " + name, e);
        }
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (CLASS_LOADER == null) {
            CLASS_LOADER = (class$java$lang$Class == null ? (class$java$lang$Class = ResourceUtil.class$("java.lang.Class")) : class$java$lang$Class).getClassLoader();
        }
    }
}

