/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util.jmx.dynamic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.shiftone.jrat.util.jmx.dynamic.AttributeValue;
import org.shiftone.jrat.util.jmx.dynamic.Operation;
import org.shiftone.jrat.util.jmx.dynamic.OperationKey;
import org.shiftone.jrat.util.log.Logger;

public class ConfigurableMBean
implements DynamicMBean {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$util$jmx$dynamic$ConfigurableMBean == null ? (class$org$shiftone$jrat$util$jmx$dynamic$ConfigurableMBean = ConfigurableMBean.class$("org.shiftone.jrat.util.jmx.dynamic.ConfigurableMBean")) : class$org$shiftone$jrat$util$jmx$dynamic$ConfigurableMBean);
    private String className = (class$org$shiftone$jrat$util$jmx$dynamic$ConfigurableMBean == null ? (class$org$shiftone$jrat$util$jmx$dynamic$ConfigurableMBean = ConfigurableMBean.class$("org.shiftone.jrat.util.jmx.dynamic.ConfigurableMBean")) : class$org$shiftone$jrat$util$jmx$dynamic$ConfigurableMBean).getName();
    private String description;
    private Map attributeValues = new HashMap();
    private Map operations = new HashMap();
    private MBeanAttributeInfo[] attributeInfos;
    private MBeanOperationInfo[] operationInfos;
    private MBeanConstructorInfo[] constructors = null;
    private MBeanNotificationInfo[] notifications = null;
    static /* synthetic */ Class class$org$shiftone$jrat$util$jmx$dynamic$ConfigurableMBean;

    public ConfigurableMBean(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void add(String name, AttributeValue attributeValue) {
        if (this.attributeValues.put(name, attributeValue) != null) {
            LOG.warn("replacing attribute '" + name + "' with new value");
        }
        this.attributeInfos = null;
    }

    public void add(String name, Operation operation) {
        this.add(name, null, operation);
    }

    public void add(String name, String[] signature, Operation operation) {
        if (signature == null) {
            signature = new String[]{};
        }
        if (this.operations.put(new OperationKey(name, signature), operation) != null) {
            LOG.warn("replacing operation '" + name + "' with new operation");
        }
        this.operationInfos = null;
    }

    private AttributeValue getAttributeValue(String attributeName) throws AttributeNotFoundException {
        AttributeValue attribute = (AttributeValue)this.attributeValues.get(attributeName);
        if (attribute == null) {
            throw new AttributeNotFoundException(attributeName);
        }
        return attribute;
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.getAttributeValue(name).getValue();
    }

    public void setAttribute(Attribute newValue) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        AttributeValue attributeValue = this.getAttributeValue(newValue.getName());
        attributeValue.setValue(newValue.getValue());
    }

    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                attributeList.add(this.getAttribute(attributeNames[i]));
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return null;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList setList = new AttributeList();
        for (int i = 0; i < attributes.size(); ++i) {
            try {
                Attribute attribute = (Attribute)attributes.get(i);
                this.setAttribute(attribute);
                setList.add(attribute);
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return setList;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        OperationKey key = new OperationKey(actionName, signature);
        Operation operation = (Operation)this.operations.get(key);
        if (operation == null) {
            throw new MBeanException(new Exception("operation not found : " + key));
        }
        return operation.invoke(params);
    }

    private MBeanOperationInfo[] buildMBeanOperationInfo() {
        MBeanOperationInfo[] operationInfos = new MBeanOperationInfo[this.operations.size()];
        Iterator keys = this.operations.keySet().iterator();
        int i = 0;
        while (keys.hasNext()) {
            OperationKey key = (OperationKey)keys.next();
            Operation operation = (Operation)this.operations.get(key);
            MBeanParameterInfo[] parameterInfos = new MBeanParameterInfo[key.getSignature().length];
            int p = 0;
            while (i < parameterInfos.length) {
                parameterInfos[p] = new MBeanParameterInfo(operation.getParameterName(p), key.getSignature()[p], operation.getParameterDescription(p));
                ++p;
            }
            String returnType = operation.getReturnType();
            if (returnType == null) {
                returnType = Void.TYPE.getName();
            }
            operationInfos[i++] = new MBeanOperationInfo(key.getName(), operation.getDescription(), parameterInfos, returnType, 3);
        }
        return operationInfos;
    }

    private MBeanAttributeInfo[] buildMBeanAttributeInfo() {
        MBeanAttributeInfo[] attributeInfos = new MBeanAttributeInfo[this.attributeValues.size()];
        Iterator keys = this.attributeValues.keySet().iterator();
        int i = 0;
        while (keys.hasNext()) {
            String key = (String)keys.next();
            AttributeValue value = (AttributeValue)this.attributeValues.get(key);
            attributeInfos[i++] = new MBeanAttributeInfo(key, value.getType(), value.getDescription(), value.isReadable(), value.isWritable(), false);
        }
        return attributeInfos;
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        if (this.attributeInfos == null) {
            this.attributeInfos = this.buildMBeanAttributeInfo();
        }
        return this.attributeInfos;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        if (this.operationInfos == null) {
            this.operationInfos = this.buildMBeanOperationInfo();
        }
        return this.operationInfos;
    }

    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.className, this.description, this.getMBeanAttributeInfo(), this.constructors, this.getMBeanOperationInfo(), this.notifications);
    }

    public String toString() {
        return "DynamicAttributeMBean";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

