/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util.log;

import org.shiftone.jrat.util.log.Constants;
import org.shiftone.jrat.util.log.LoggerFactory;
import org.shiftone.jrat.util.log.target.LogTarget;

public class Logger
implements LogTarget,
Constants {
    private final LogTarget target;
    private final String topic;

    Logger(String topic, LogTarget target) {
        this.topic = topic;
        this.target = target;
    }

    public static Logger getLogger(Class klass) {
        return LoggerFactory.getLogger(klass);
    }

    public static Logger getLogger(String topic) {
        return LoggerFactory.getLogger(topic);
    }

    public void log(String topic, int level, Object message, Throwable throwable) {
        this.target.log(topic, level, message, throwable);
    }

    public boolean isLevelEnabled(String topic, int level) {
        return this.target != null && this.target.isLevelEnabled(topic, level);
    }

    public boolean isLevelEnabled(int level) {
        return this.isLevelEnabled(this.topic, level);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(2);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(1);
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(0);
    }

    public void trace(Object obj) {
        this.log(this.topic, 0, obj, null);
    }

    public void debug(Object obj) {
        this.log(this.topic, 1, obj, null);
    }

    public void debug(Object obj, Throwable t) {
        this.log(this.topic, 1, obj, t);
    }

    public void info(Object obj) {
        this.log(this.topic, 2, obj, null);
    }

    public void info(Object obj, Throwable t) {
        this.log(this.topic, 2, obj, t);
    }

    public void warn(Object obj) {
        this.log(this.topic, 3, obj, null);
    }

    public void warn(Object obj, Throwable t) {
        this.log(this.topic, 3, obj, t);
    }

    public void error(Object obj) {
        this.log(this.topic, 4, obj, null);
    }

    public void error(Object obj, Throwable t) {
        this.log(this.topic, 4, obj, t);
        t.printStackTrace(System.err);
    }

    public void fatal(Object obj) {
        this.log(this.topic, 5, obj, null);
    }

    public void fatal(Object obj, Throwable t) {
        this.log(this.topic, 5, obj, t);
    }
}

