/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util.log;

import java.io.PrintWriter;
import org.shiftone.jrat.core.Environment;
import org.shiftone.jrat.core.JRatException;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.log.Constants;
import org.shiftone.jrat.util.log.Logger;
import org.shiftone.jrat.util.log.target.LogTarget;
import org.shiftone.jrat.util.log.target.NullLogTarget;
import org.shiftone.jrat.util.log.target.ProxyLogTarget;
import org.shiftone.jrat.util.log.target.TandemTarget;
import org.shiftone.jrat.util.log.target.ThreadLocalLogTarget;
import org.shiftone.jrat.util.log.target.WriterLogTarget;

public class LoggerFactory
implements Constants {
    private static final NullLogTarget NULL_LOG_TARGET = NullLogTarget.INSTANCE;
    private static final WriterLogTarget SYSTEM_OUT_TARGET = new WriterLogTarget(System.out);
    private static final ProxyLogTarget PROXY_LOG_TARGET = new ProxyLogTarget(SYSTEM_OUT_TARGET);
    private static final ThreadLocalLogTarget THREAD_TARGET = new ThreadLocalLogTarget(SYSTEM_OUT_TARGET);

    public static void initialize() {
        LoggerFactory.setLevel(LoggerFactory.getLevelFromName(Environment.getSettings().getLogLevel()));
    }

    public static Logger getLogger(Class klass) {
        String className = klass.getName();
        String shortName = className.substring(className.lastIndexOf(46) + 1);
        return LoggerFactory.getLogger(shortName);
    }

    public static Logger getLogger(String topic) {
        return new Logger(topic, PROXY_LOG_TARGET);
    }

    public static int getLevelFromName(String levelName) {
        Assert.assertNotNull("levelName", levelName);
        Assert.assertNotNull("LEVEL_NAMES", Constants.LEVEL_NAMES);
        levelName = levelName.toUpperCase();
        for (int i = 0; i < Constants.LEVEL_NAMES.length; ++i) {
            if (!levelName.equals(Constants.LEVEL_NAMES[i])) continue;
            return i;
        }
        throw new JRatException("log level '" + levelName + "' is not known");
    }

    public static void setLevel(int level) {
        PROXY_LOG_TARGET.setCurrentLevel(level);
    }

    public static int getLevel() {
        return PROXY_LOG_TARGET.getCurrentLevel();
    }

    public static void disableLogging() {
        LoggerFactory.setLogTarget(NULL_LOG_TARGET);
    }

    public static void enableThreadBasedLogging() {
        LoggerFactory.setLogTarget(THREAD_TARGET);
    }

    public static void enableSystemOutLogging() {
        LoggerFactory.setLogTarget(SYSTEM_OUT_TARGET);
    }

    public static synchronized void setLogTarget(LogTarget logTarget) {
        PROXY_LOG_TARGET.setLogTarget(logTarget);
    }

    public static synchronized LogTarget getLogTarget() {
        return PROXY_LOG_TARGET.getLogTarget();
    }

    public static void redirectLogging(PrintWriter printWriter) {
        TandemTarget tandemTarget = new TandemTarget(SYSTEM_OUT_TARGET, new WriterLogTarget(printWriter));
        LoggerFactory.setLogTarget(tandemTarget);
    }

    public static void executeInThreadScope(LogTarget newTarget, Runnable runnable) {
        THREAD_TARGET.executeInScope(newTarget, runnable);
    }
}

