/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util.log.target;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.shiftone.jrat.util.io.PrintStreamWriter;
import org.shiftone.jrat.util.log.Constants;
import org.shiftone.jrat.util.log.Logger;
import org.shiftone.jrat.util.log.target.LogTarget;

public class WriterLogTarget
implements LogTarget {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$util$log$target$WriterLogTarget == null ? (class$org$shiftone$jrat$util$log$target$WriterLogTarget = WriterLogTarget.class$("org.shiftone.jrat.util.log.target.WriterLogTarget")) : class$org$shiftone$jrat$util$log$target$WriterLogTarget);
    public static final LogTarget SYSTEM_OUT = new WriterLogTarget(System.out);
    public static final LogTarget SYSTEM_ERROR = new WriterLogTarget(System.err);
    private static final String DATE_FORMAT = "MMM/dd HH:mm:ss,SSS";
    private final Writer writer;
    private final DateFormat dateFormat = new SimpleDateFormat("MMM/dd HH:mm:ss,SSS");
    static /* synthetic */ Class class$org$shiftone$jrat$util$log$target$WriterLogTarget;

    public WriterLogTarget(PrintStream printStream) {
        this(new PrintStreamWriter(printStream));
    }

    public WriterLogTarget(Writer writer) {
        this.writer = writer;
    }

    public boolean isLevelEnabled(String topic, int level) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String topic, int level, Object message, Throwable throwable) {
        StringBuffer buffer = new StringBuffer(80);
        buffer.append("JRat:");
        buffer.append(Constants.LEVEL_NAMES[level]);
        buffer.append(" (");
        buffer.append(this.formatDate(new Date()));
        buffer.append(") (");
        buffer.append(Thread.currentThread().getName());
        buffer.append(") ");
        buffer.append(topic);
        buffer.append(" - ");
        buffer.append(String.valueOf(message));
        if (throwable != null) {
            buffer.append("\n");
            buffer.append(WriterLogTarget.throwableToString(throwable));
        }
        buffer.append('\n');
        WriterLogTarget writerLogTarget = this;
        synchronized (writerLogTarget) {
            try {
                this.writer.write(buffer.toString());
                this.writer.flush();
            }
            catch (Exception e) {
                System.err.print("logging failed!");
                e.printStackTrace(System.err);
            }
        }
    }

    private static String throwableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print('\t');
        printWriter.println(throwable.getMessage());
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private synchronized String formatDate(Date date) {
        return this.dateFormat.format(new Date());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

