/*
 * Decompiled with CFR 0.152.
 */
package documents;

import documents.BOM;
import documents.NRC_Document;
import documents.NRC_HTMLTag;
import documents.NRC_HTMLWriter;
import documents.SousHTMLEditorKit;
import documents.WebPageReader;
import ecriture.Orthographe;
import ecriture.Roman;
import ecriture.Syllabics;
import ecriture.TransCoder;
import html.BetweenTag;
import html.HTMLDocuElement;
import html.HtmlDocu;
import html.HtmlEntities;
import html.Tag;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import polices.Police;
import utilites.Inuktitut;
import utilites1.Util;

public class NRC_HTMLDocument
extends HTMLDocument
implements NRC_Document {
    private static final long serialVersionUID = 1L;
    public String encoding = null;
    public Encoding encodingObject = null;
    public File copyOfFile = null;
    private String contentType = null;
    private String urlName;
    private String base = null;
    private SousHTMLEditorKit editorKit = new SousHTMLEditorKit();
    private URL url = null;
    private Date date;
    private String httpHeaderContentType = null;
    private static File tmpDir = new File(File.separator, "tmp");
    private WebPageReader wpr = null;
    private Hashtable fonts = null;
    private boolean containsInuktitut = false;
    private long lengthOfInuktitutContent = 0L;
    private long lengthOfTotalContent = 0L;
    private String pageContent = null;
    private String inuktitutContent = null;
    private String decoupe;
    private static HtmlDocu docu;
    private static String endOfLine;
    private static File wordFile;
    private static boolean test;
    private static String[] testWords;
    private static Integer[] testFreqs;
    private static Vector elements;
    private static Hashtable transHash;
    private static Pattern pfw;
    private static Vector fontsForHighlighting;
    private static Pattern pfw2;

    static {
        if (!tmpDir.exists() || !tmpDir.isDirectory()) {
            try {
                tmpDir.createNewFile();
            }
            catch (IOException e) {
                System.out.println("unable to create " + tmpDir.getAbsolutePath());
            }
        }
        endOfLine = "\n";
        test = false;
        testWords = null;
        testFreqs = null;
        pfw = Pattern.compile("^\\s*(\\S{0,20})");
        pfw2 = Pattern.compile("(\\S+)(\\s+(\\S+))?(\\s+(\\S+))?");
    }

    public NRC_HTMLDocument(String urlName) throws Exception {
        HTMLEditorKit.Parser parser = this.editorKit.getParser();
        this.setParser(parser);
        this.urlName = urlName;
        this.wpr = new WebPageReader(urlName);
        this.httpHeaderContentType = this.wpr.contentType.toLowerCase();
        if (this.httpHeaderContentType != null) {
            if (this.httpHeaderContentType.indexOf("text/html") < 0) {
                throw new Exception("not html");
            }
            this.encoding = this.getDocEncoding(this.httpHeaderContentType);
        }
        this.date = new Date(this.wpr.connection.getLastModified());
        this.url = this.wpr.url;
        this.contentType = this.wpr.contentType;
        this.putProperty("stream", this.url);
        this.putProperty("IgnoreCharsetDirective", Boolean.FALSE);
        this.copyOfFile = this.copyInCache(this.url);
        String fileCopy = "file://localhost/" + this.copyOfFile.getAbsolutePath();
        BufferedReader br = null;
        if (this.encoding == null) {
            BOM bom = BOM.checkForBOM(this.copyOfFile);
            if (bom.encoding != null) {
                this.encoding = bom.encoding;
                this.encodingObject = new Encoding(this.encoding, "bom");
            }
        } else {
            this.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            this.encodingObject = new Encoding(this.encoding, "http header");
        }
        this.wpr = new WebPageReader(fileCopy);
        br = this.wpr.getBufferedReader(this.encoding);
        try {
            this.editorKit.read(br, (Document)this, 0);
        }
        catch (ChangedCharSetException e) {
            String encFromMeta = this.getDocEncoding(e.getCharSetSpec().toLowerCase());
            this.encoding = encFromMeta == null ? "ISO-8859-1" : encFromMeta.trim();
            this.encodingObject = new Encoding(this.encoding, "meta");
            br.close();
            this.wpr = new WebPageReader(fileCopy);
            br = this.wpr.getBufferedReader(this.encoding);
            this.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            this.editorKit.read(br, (Document)this, 0);
        }
        catch (IOException e) {
            throw new IOException(String.valueOf(e.toString()) + " from editorKit.read(br,this,0) in NRC_HTMLDocument");
        }
        br.close();
        if (this.encoding == null) {
            this.encoding = "ISO-8859-1";
            this.encodingObject = new Encoding(this.encoding, "default");
        }
    }

    String getDocEncoding(String connectionContentType) {
        Pattern p = Pattern.compile("charset=(.+)");
        Matcher mp = p.matcher(connectionContentType);
        if (mp.find()) {
            String charset = mp.group(1);
            String enc = this.getDocEncoding(charset);
            if (enc == null) {
                return charset;
            }
            return enc;
        }
        return null;
    }

    private File copyInCache(URL url) throws IOException {
        File of = null;
        try {
            of = File.createTempFile("copyOfHTML", ".htm", tmpDir);
        }
        catch (IOException e) {
            if (tmpDir != null) {
                throw new IOException(String.valueOf(e.toString()) + " from createTempFile(\"copyOfHTML\",\".htm\",tmpDir[=" + tmpDir.getAbsolutePath() + "]) in copyInCache");
            }
            throw new IOException(String.valueOf(e.toString()) + " from createTempFile(\"copyOfHTML\",\".htm\",tmpDir[=null] in copyInCache");
        }
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (IOException e1) {
            throw new IOException(String.valueOf(e1.toString()) + " from url[=" + url.toExternalForm() + "].openStream()");
        }
        FileOutputStream os = new FileOutputStream(of);
        int b = 0;
        while (b != -1) {
            try {
                b = is.read();
            }
            catch (IOException e2) {
                throw new IOException(String.valueOf(e2.toString()) + " from is.read() in copyInCache");
            }
            try {
                os.write(b);
            }
            catch (IOException e3) {
                throw new IOException(String.valueOf(e3.toString()) + " from os.write(b[=" + b + "]) in copyInCache");
            }
        }
        os.close();
        is.close();
        return of;
    }

    public HTMLEditorKit.ParserCallback getReader(int pos) {
        Object desc = this.getProperty("stream");
        if (desc instanceof URL) {
            this.setBase((URL)desc);
        }
        return new HtmlReader(pos);
    }

    public HTMLEditorKit.ParserCallback getReader(int pos, int popDepth, int pushDepth, HTML.Tag insertTag) {
        Object desc = this.getProperty("stream");
        if (desc instanceof URL) {
            this.setBase((URL)desc);
        }
        return new HtmlReader(pos, popDepth, pushDepth, insertTag);
    }

    public HTMLEditorKit getEditorKit() {
        return this.editorKit;
    }

    public URL resolveUrlFromBase(String ref) {
        URL newURL = null;
        try {
            URL base = this.getBase();
            newURL = new URL(base, ref);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newURL;
    }

    public String getBaseName() {
        return this.base;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date newDate) {
        this.date = newDate;
    }

    public String getTitle() {
        String title = (String)this.getProperty("title");
        if (title == null) {
            title = "";
        }
        return title;
    }

    public String getInuktitutContent() {
        if (this.inuktitutContent != null) {
            return this.inuktitutContent;
        }
        this.getPageContent();
        return this.inuktitutContent;
    }

    public String getPageContent() {
        Element elem;
        if (this.pageContent != null) {
            return this.pageContent;
        }
        ElementIterator iterator = new ElementIterator(this);
        String contenuPage = "";
        String previousElementName = "";
        this.fonts = new Hashtable();
        while ((elem = iterator.next()) != null) {
            if (elem.getName().equals("content")) {
                int beg = elem.getStartOffset();
                int end = elem.getEndOffset();
                String text = null;
                try {
                    text = this.getText(beg, end - beg);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                Element parent = elem.getParentElement();
                String parentName = parent.getName().toLowerCase();
                if (parentName.equals("script") || parent.getName().toLowerCase().equals("style") || parentName.equals("p-implied") && ((parentName = (parent = parent.getParentElement()).getName().toLowerCase()).equals("script") || parent.getName().toLowerCase().equals("style"))) continue;
                String[] elementFonts = this.getFont(elem);
                if (elementFonts != null) {
                    int ifont = 0;
                    while (ifont < elementFonts.length) {
                        String f = elementFonts[ifont].toLowerCase();
                        String[] fs = f.split(",");
                        int ifs = 0;
                        while (ifs < fs.length) {
                            String fsi = fs[ifs].trim();
                            if (!this.fonts.containsKey(fs[ifs])) {
                                this.fonts.put(fsi, new Integer(1));
                            } else {
                                this.fonts.put(fsi, new Integer((Integer)this.fonts.get(fsi) + 1));
                            }
                            ++ifs;
                        }
                        ++ifont;
                    }
                }
                String font = null;
                if (!text.replaceAll("\\s", "").equals("")) {
                    if (Syllabics.containsInuktitut((String)text)) {
                        this.containsInuktitut = true;
                        this.lengthOfInuktitutContent += (long)text.length();
                        this.lengthOfTotalContent += (long)text.length();
                    } else {
                        font = Police.containsLegacyFont((String[])elementFonts);
                        if (font != null) {
                            this.containsInuktitut = true;
                            text = TransCoder.legacyToUnicode((String)text, (String)font);
                            this.lengthOfInuktitutContent += (long)text.length();
                            this.lengthOfTotalContent += (long)text.length();
                        } else {
                            this.lengthOfTotalContent += (long)text.length();
                        }
                    }
                }
                if (Arrays.binarySearch(HTMLDocuElement.tagsThatDoNotAddSpace, previousElementName) < 0) {
                    contenuPage = contenuPage.concat(" ");
                }
                contenuPage = contenuPage.concat(text);
                continue;
            }
            previousElementName = elem.getName().toLowerCase();
        }
        contenuPage = contenuPage.replaceAll("\\s+", " ");
        this.pageContent = new String(contenuPage);
        return contenuPage;
    }

    public URL getURL() {
        return this.url;
    }

    public void write() throws IOException, BadLocationException {
        int doclength = this.getLength();
        OutputStreamWriter out = new OutputStreamWriter(System.out);
        NRC_HTMLWriter myWriter2 = new NRC_HTMLWriter((Writer)out, this, 0, doclength);
        myWriter2.write();
        ((Writer)out).flush();
    }

    public void write(PrintStream out) throws IOException, BadLocationException {
        int doclength = this.getLength();
        OutputStreamWriter out1 = new OutputStreamWriter(out);
        NRC_HTMLWriter myWriter2 = new NRC_HTMLWriter((Writer)out1, this, 0, doclength);
        myWriter2.write();
        ((Writer)out1).flush();
    }

    public void write(String nomFichier) throws IOException, BadLocationException {
        int doclength = this.getLength();
        BufferedWriter out = new BufferedWriter(new FileWriter(nomFichier));
        NRC_HTMLWriter myWriter2 = new NRC_HTMLWriter((Writer)out, this, 0, doclength);
        myWriter2.write();
        ((Writer)out).close();
    }

    public void write(String nomFichier, String enc) throws IOException, BadLocationException {
        int doclength = this.getLength();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(nomFichier), enc);
        NRC_HTMLWriter myWriter2 = new NRC_HTMLWriter((Writer)out, this, 0, doclength);
        myWriter2.write();
        ((Writer)out).flush();
    }

    public void writeUTF8() throws IOException, BadLocationException {
        int doclength = this.getLength();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
        NRC_HTMLWriter myWriter2 = new NRC_HTMLWriter((Writer)out, this, 0, doclength);
        myWriter2.write();
        out.flush();
    }

    public void writeUTF8(PrintStream out) throws IOException, BadLocationException {
        int doclength = this.getLength();
        OutputStreamWriter out1 = new OutputStreamWriter((OutputStream)out, "UTF8");
        NRC_HTMLWriter myWriter2 = new NRC_HTMLWriter((Writer)out1, this, 0, doclength);
        myWriter2.write();
        ((Writer)out1).flush();
    }

    public void writeUTF8(String nomFichier) throws IOException, BadLocationException {
        int doclength = this.getLength();
        OutputStreamWriter outUTF8 = new OutputStreamWriter((OutputStream)new FileOutputStream(nomFichier), "UTF-8");
        NRC_HTMLWriter myWriter2 = new NRC_HTMLWriter((Writer)outUTF8, this, 0, doclength);
        myWriter2.write();
        ((Writer)outUTF8).flush();
    }

    public Object findWord(String word) {
        ElementIterator it = new ElementIterator(this);
        boolean trouve = false;
        Element element = null;
        Element elem = null;
        while (!trouve && (elem = it.next()) != null) {
            String texte;
            if (!elem.getName().equals("content")) continue;
            int deb = elem.getStartOffset();
            int fin = elem.getEndOffset();
            try {
                texte = this.getText(deb, fin - deb);
            }
            catch (BadLocationException e) {
                texte = "";
            }
            if (texte.indexOf(word) == -1) continue;
            trouve = true;
            element = elem;
        }
        return element;
    }

    public Object trouverProprieteCSSHeritage(CSS.Attribute attr, Element element) {
        Element parent;
        Object attrValue = this.trouverProprieteCSS(attr, element);
        if (attrValue == null && (parent = element.getParentElement()) != null) {
            attrValue = this.trouverProprieteCSSHeritage(attr, parent);
        }
        return attrValue;
    }

    public Object trouverProprieteCSS(CSS.Attribute attr, Element element) {
        Object style;
        StyleSheet ss;
        AttributeSet ssrule;
        Object attrValue = null;
        NRC_HTMLTag tag = null;
        if (element == null) {
            return null;
        }
        String elementName = element.getName();
        if (elementName.equals("p-implied")) {
            Element parent = element.getParentElement();
            return this.trouverProprieteCSS(attr, parent);
        }
        AttributeSet as = element.getAttributes();
        if (as.isDefined(HTML.Attribute.STYLE) && (ssrule = (ss = new StyleSheet()).getDeclaration((style = as.getAttribute(HTML.Attribute.STYLE)).toString())).isDefined(attr)) {
            attrValue = ssrule.getAttribute(attr).toString();
        }
        if (attrValue != null) {
            return attrValue;
        }
        StyleSheet styles = this.getStyleSheet();
        Style rule = styles.getRule(tag = new NRC_HTMLTag(elementName), element);
        if (rule != null) {
            attrValue = rule.getAttribute(attr);
        }
        if (attrValue != null) {
            return attrValue;
        }
        Vector<String> attrValuesVector = new Vector<String>();
        Pattern p = Pattern.compile("^[^:]+:");
        Enumeration<?> rules = styles.getStyleNames();
        while (rules.hasMoreElements()) {
            String name = (String)rules.nextElement();
            Matcher mp = p.matcher(name);
            rule = styles.getStyle(name);
            if (!mp.lookingAt() || (attrValue = rule.getAttribute(attr)) == null || attrValuesVector.contains(attrValue.toString())) continue;
            attrValuesVector.add(attrValue.toString());
        }
        attrValue = null;
        if (attrValuesVector.size() != 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < attrValuesVector.size()) {
                sb.append(attrValuesVector.elementAt(i).toString()).append(" ");
                ++i;
            }
            attrValue = sb.toString().trim();
        }
        return attrValue;
    }

    public String[] decouperTexteEnLignes() {
        Element root = this.getRootElements()[0];
        this.decoupe = new String();
        this.decouperTexteEnLignes_String(root);
        String[] lignes = this.decoupe.split("<<.+>>");
        return lignes;
    }

    private void decouperTexteEnLignes_String(Element element) {
        if (!element.isLeaf()) {
            HTML.Tag tag;
            Object display = this.trouverProprieteCSSHeritage(CSS.Attribute.DISPLAY, element);
            display = display != null ? display.toString().toLowerCase() : ((tag = HTML.getTag(element.getName())) == null ? "" : (tag.isBlock() ? "block" : "inline"));
            if (display.equals("block")) {
                this.decoupe = String.valueOf(this.decoupe) + "<<" + element.getName() + ">>";
            }
            int elementCount = element.getElementCount();
            int i = 0;
            while (i < elementCount) {
                Element elem = element.getElement(i);
                this.decouperTexteEnLignes_String(elem);
                ++i;
            }
            if (display.equals("block")) {
                this.decoupe = String.valueOf(this.decoupe) + "<<" + element.getName() + ">>";
            }
        } else {
            int beg = element.getStartOffset();
            int end = element.getEndOffset();
            String text = null;
            try {
                text = this.getText(beg, end - beg);
                text = text.replaceAll("\\s+", " ");
                this.decoupe = String.valueOf(this.decoupe) + text;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public String[] getFont(Element e) {
        return this.trouverFontFamily(e);
    }

    public String[] trouverFontFamily(Element element) {
        String family = null;
        AttributeSet as = element.getAttributes();
        Object familyObject = as.getAttribute(CSS.Attribute.FONT_FAMILY);
        family = familyObject == null ? null : familyObject.toString();
        if (family == null) {
            Element parent = element.getParentElement();
            if (parent != null) {
                String[] families = this.trouverFontFamilyHerit(parent);
                return families;
            }
            return null;
        }
        return new String[]{family};
    }

    private String[] trouverFontFamilyHerit(Element element) {
        Object family = null;
        if (element == null) {
            return null;
        }
        String elementName = element.getName();
        if (elementName.equals("p-implied")) {
            Element parent = element.getParentElement();
            return this.trouverFontFamilyHerit(parent);
        }
        AttributeSet as = element.getAttributes();
        if (elementName.equalsIgnoreCase("font")) {
            if (as.isDefined(HTML.Attribute.FACE)) {
                family = as.getAttribute(HTML.Attribute.FACE);
            }
        } else {
            family = this.trouverProprieteCSS(CSS.Attribute.FONT_FAMILY, element);
            if (family != null) {
                family = family.toString();
            }
        }
        if (family != null) {
            return new String[]{(String)family};
        }
        String[] families = null;
        Element parent = element.getParentElement();
        if (parent != null) {
            families = this.trouverFontFamilyHerit(parent);
        }
        return families;
    }

    public String[] getWords() {
        Element elem;
        Vector<String> words = new Vector<String>();
        ElementIterator iterator = new ElementIterator(this);
        Pattern p = Pattern.compile("([a-z&]+)");
        while ((elem = iterator.next()) != null) {
            TexteHTML texteHTML;
            if (!elem.getName().equals("content") || (texteHTML = this.texteEnInuktitut(elem)) == null) continue;
            texteHTML.transliterer();
            Vector morceaux = texteHTML.getMorceaux();
            String s = "";
            int i = 0;
            while (i < morceaux.size()) {
                s = String.valueOf(s) + ((Inuktitut.MorceauTexte)morceaux.get(i)).getTexte();
                ++i;
            }
            Matcher m = p.matcher(s);
            while (m.find()) {
                String word = m.group();
                if (words.contains(word)) continue;
                words.add(word);
            }
        }
        Object[] wordsArray = words.toArray(new String[0]);
        Arrays.sort(wordsArray);
        return wordsArray;
    }

    public String[] getAllFontFamiliesInStyleSheets() {
        Vector<String> families = new Vector<String>();
        StyleSheet styles = this.getStyleSheet();
        Enumeration<?> styleNames = styles.getStyleNames();
        while (styleNames.hasMoreElements()) {
            String name = (String)styleNames.nextElement();
            Style style = styles.getStyle(name);
            Enumeration<?> attrNames = style.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                Object n = attrNames.nextElement();
                if (!n.toString().equals("resolver")) continue;
                Style nst = (Style)style.getAttribute(n);
                Enumeration<?> nAttrNames = nst.getAttributeNames();
                while (nAttrNames.hasMoreElements()) {
                    Object nAttrName = nAttrNames.nextElement();
                    if (!nAttrName.toString().toLowerCase().equals("font-family")) continue;
                    Object value = nst.getAttribute(nAttrName);
                    String[] values = value.toString().toLowerCase().split(",");
                    int i = 0;
                    while (i < values.length) {
                        String val = values[i].trim();
                        if (!families.contains(val)) {
                            families.add(val);
                        }
                        ++i;
                    }
                }
            }
        }
        Object[] familiesArray = families.toArray(new String[0]);
        Arrays.sort(familiesArray);
        return familiesArray;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String[] getEncodingAndManner() {
        return new String[]{this.encodingObject.value, this.encodingObject.source};
    }

    public String getUrlName() {
        return this.urlName;
    }

    public Object[] highlight(String[] args) throws Exception {
        transHash = new Hashtable();
        String fileCopy = null;
        fontsForHighlighting = new Vector();
        this.traiterDocPourHighlight();
        fileCopy = "file://localhost/" + this.copyOfFile.getAbsolutePath();
        docu = new HtmlDocu(new URL(fileCopy));
        docu.insertBase(this.getBase());
        NRC_HTMLDocument.traiterDocPourHighlight2(docu, this.encoding);
        this.encoding = "utf-8";
        Object[] hl = this.highlightWords(args);
        return hl;
    }

    private void traiterDocPourHighlight() {
        Element elem;
        ElementIterator iterator = new ElementIterator(this);
        while ((elem = iterator.next()) != null) {
            String text;
            if (!elem.getName().equals("content")) continue;
            int beg = elem.getStartOffset();
            int end = elem.getEndOffset();
            try {
                text = this.getText(beg, end - beg);
            }
            catch (BadLocationException e) {
                continue;
            }
            Element parent = elem.getParentElement();
            String parentName = parent.getName().toLowerCase();
            if (parentName.equals("script") || parent.getName().toLowerCase().equals("style") || parentName.equals("p-implied") && ((parentName = (parent = parent.getParentElement()).getName().toLowerCase()).equals("script") || parent.getName().toLowerCase().equals("style"))) continue;
            Matcher mfw = pfw.matcher(text);
            String[] fontFamilies = this.getFont(elem);
            String fontLegacy = Police.containsLegacyFont((String[])fontFamilies);
            if (!mfw.find()) continue;
            String key = mfw.group(1).replaceAll("\\s+", " ");
            if (fontLegacy != null) {
                transHash.put(key, fontLegacy);
                if (fontsForHighlighting.contains(fontLegacy)) continue;
                fontsForHighlighting.add(fontLegacy);
                continue;
            }
            if (fontFamilies != null) {
                transHash.put(key, "");
                continue;
            }
            transHash.put(key, "null");
        }
    }

    static void traiterDocPourHighlight2(HtmlDocu doc2, String enc) {
        int i = 0;
        while (i < doc2.elements.size()) {
            HTMLDocuElement element = (HTMLDocuElement)doc2.elements.elementAt(i);
            if (element.getType() == 1) {
                String tag = ((Tag)element).tag;
                if (tag.charAt(0) != '/' && Arrays.binarySearch(HTMLDocuElement.tagsThatDoNotAddSpace, tag) < 0) {
                    doc2.elements.add(i + 1, new BetweenTag("\u0002 \u0003"));
                    ++i;
                }
            } else if (element.getType() == 2) {
                String txt = null;
                try {
                    txt = new String(element.getBytes(), enc);
                    txt = HtmlEntities.entityToChar(txt);
                    element.setText(txt, "utf-8");
                    Matcher mpfw = pfw.matcher(txt);
                    if (mpfw.find()) {
                        String font;
                        String key = mpfw.group(1).replaceAll("\\s+", " ");
                        ((BetweenTag)element).font = font = (String)transHash.get(key);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    Object[] highlightWords(String[] args) throws Exception {
        String urlName = Util.getArgument((String[])args, (String)"url");
        URL url = new URL(urlName);
        String wordFileName = Util.getArgument((String[])args, (String)"f");
        String directoryName = Util.getArgument((String[])args, (String)"d");
        String latsyl = Util.getArgument((String[])args, (String)"s");
        if (latsyl == null) {
            latsyl = Util.getArgument((String[])args, (String)"outputType");
        }
        if (latsyl.startsWith("syl")) {
            latsyl = "syllabics";
        }
        String wordsSeq = Util.getArgument((String[])args, (String)"m");
        String sessionID = wordFileName.substring(wordFileName.indexOf(95) + 1, wordFileName.lastIndexOf(95));
        if (directoryName != null) {
            tmpDir = new File(directoryName);
        }
        Vector words = null;
        if (wordFileName != null && !wordFileName.equals("null")) {
            wordFile = new File(tmpDir, wordFileName);
            words = NRC_HTMLDocument.getWordsToHighlight(wordFile, latsyl);
        } else if (wordsSeq != null && !wordsSeq.equals("null")) {
            words = NRC_HTMLDocument.getWordsToHighlight(wordsSeq, latsyl);
        }
        Hashtable wordsToCheckInFile = NRC_HTMLDocument.lookForWordsInFile(words, latsyl);
        String httpHeader = "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=" + this.encoding + "\">";
        File of = this.processFile(wordsToCheckInFile, url, latsyl, httpHeader, sessionID);
        return new Object[]{this.encoding, of};
    }

    File processFile(Hashtable wordsToCheckInFile, URL url, String latsyl, String httpHeader, String sessionID) throws IOException {
        elements = NRC_HTMLDocument.docu.elements;
        boolean scriptWritten = false;
        File of = File.createTempFile("ISEcopyForHighlight_" + sessionID + "_", ".htm", tmpDir);
        FileOutputStream os = new FileOutputStream(of);
        int i = 0;
        while (i < elements.size()) {
            String tag;
            HTMLDocuElement elm = (HTMLDocuElement)elements.elementAt(i);
            if (elm.getType() == 1 && !(tag = ((Tag)elm).tag).equals("html")) {
                Tag script;
                Tag base;
                if (tag.equals("head")) {
                    base = new Tag(NRC_HTMLDocument.makeBaseTag(url), null);
                    Tag style = new Tag(NRC_HTMLDocument.makeHLClassStyleTag(), null);
                    elements.add(i + 1, base);
                    elements.add(i + 2, style);
                    break;
                }
                if (Character.isLetter(tag.charAt(0))) {
                    base = new Tag(NRC_HTMLDocument.makeBaseTag(url), null);
                    Tag style = new Tag(NRC_HTMLDocument.makeHLClassStyleTag(), null);
                    elements.add(i, base);
                    elements.add(i + 1, style);
                    break;
                }
                if (test && tag.equals("/body")) {
                    script = new Tag(NRC_HTMLDocument.makeScriptInBody(), null);
                    elements.add(i, script);
                    scriptWritten = true;
                } else if (test && tag.equals("/html") && !scriptWritten) {
                    script = new Tag(NRC_HTMLDocument.makeScriptInBody(), null);
                    elements.add(i, script);
                    scriptWritten = true;
                }
            }
            ++i;
        }
        if (test && !scriptWritten) {
            Tag script = new Tag(NRC_HTMLDocument.makeScriptInBody(), null);
            elements.add(script);
        }
        this.highlightWords(wordsToCheckInFile, latsyl);
        NRC_HTMLDocument.copyInFile(os);
        os.flush();
        ((OutputStream)os).close();
        return of;
    }

    static String makeBaseTag(URL url) {
        return "<base href=\"" + url.toExternalForm() + "\">";
    }

    static String makeHLClassStyleTag() {
        return "<style type=\"text/css\">" + endOfLine + ".hl {background-color:#22C668; color:#FFFFFF;}" + endOfLine + "</style>";
    }

    static String makeScriptInBody() throws IOException {
        String str = "<script type=\"text/javascript\">" + endOfLine + "<!-- " + endOfLine;
        str = String.valueOf(str) + "document.write(\"<p style='font-family:Pigiarniq'>Les mots suivants devraient &ecirc;tre surlign&eacute;s en vert dans cette page:<br>\");" + endOfLine;
        int i = 0;
        while (i < testWords.length) {
            str = String.valueOf(str) + "document.write(\"<b>" + NRC_HTMLDocument.wordToUnicode(testWords[i]) + " - " + testFreqs[i].toString() + " fois</b><br>\");" + endOfLine;
            ++i;
        }
        str = String.valueOf(str) + "document.write(\"</p>\");" + endOfLine;
        str = String.valueOf(str) + "-->" + endOfLine + "</script>" + endOfLine;
        return str;
    }

    public static Vector getWordsToHighlight(File wordFile, String latsyl) throws IOException {
        BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(wordFile), "UTF-8"));
        String word = null;
        String line = null;
        String bomUTF8 = new String(new byte[]{-17, -69, -65}, "UTF-8");
        Pattern p = Pattern.compile("^(.+?)(\\x20//--\\x20.*)?$");
        Vector<String> words = new Vector<String>();
        while ((line = rdr.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (!m.matches() || (word = m.group(1)) == null) continue;
            if (word.startsWith(bomUTF8)) {
                word = word.substring(1);
            }
            if (latsyl.equals("latin")) {
                words.add(word.toLowerCase());
                words.add(word.toUpperCase());
                words.add(Util.premiereMaj((String)word));
                continue;
            }
            words.add(word);
        }
        rdr.close();
        return words;
    }

    public static Vector getWordsToHighlight(String wordSeq, String latsyl) {
        Vector<String> words = new Vector<String>();
        Pattern p = Pattern.compile("\\u0002(.+?)\\u0003");
        Matcher m = p.matcher(wordSeq);
        int pos = 0;
        while (m.find(pos)) {
            String word = m.group(1);
            if (word == null) continue;
            if (latsyl.equals("latin")) {
                words.add(word.toLowerCase());
                words.add(word.toUpperCase());
                words.add(Util.premiereMaj((String)word));
            } else {
                words.add(word);
            }
            pos = m.end();
        }
        return words;
    }

    public static String writeLuceneWordsInTempFile(String[] ws, String directoryName, String filename, boolean useAsIs) throws IOException {
        File wordFile = null;
        wordFile = useAsIs ? new File(directoryName, filename) : File.createTempFile(filename, ".txt", new File(directoryName));
        NRC_HTMLDocument.wlucene(ws, wordFile);
        return wordFile.getName();
    }

    static void wlucene(String[] ws, File wordFile) throws UnsupportedEncodingException, FileNotFoundException {
        PrintWriter wr = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(wordFile), "UTF-8"));
        int i = 0;
        while (i < ws.length) {
            if (ws[i].charAt(0) == '\"' && ws[i].charAt(ws[i].length() - 1) == '\"') {
                wr.println(ws[i].substring(1, ws[i].length() - 1));
            } else {
                wr.println(ws[i]);
            }
            ++i;
        }
        wr.close();
    }

    public static String writeLuceneWordsInTempFileWithOSDependantLineDelimiter(String[] words, String directoryName, String filename, String os) throws IOException {
        String lineDelimiter = "";
        if (os.equals("win")) {
            lineDelimiter = "\r\n";
        } else if (os.equals("mac")) {
            lineDelimiter = "\r";
        } else if (os.equals("x11")) {
            lineDelimiter = "\n";
        }
        File wordFile = File.createTempFile(filename, ".txt", new File(directoryName));
        PrintWriter wr = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(wordFile), "UTF-8"));
        wr.print('\ufeff');
        int i = 0;
        while (i < words.length) {
            if (words[i].charAt(0) == '\"' && words[i].charAt(words[i].length() - 1) == '\"') {
                wr.print(words[i].substring(1, words[i].length() - 1));
            } else {
                wr.print(words[i]);
            }
            wr.print(lineDelimiter);
            ++i;
        }
        wr.close();
        return wordFile.getName();
    }

    public static String writeLuceneWordsInTempFileForTest(String ws, String directoryName, String filename, boolean useAsIs) throws IOException {
        File wordFile = null;
        wordFile = useAsIs ? new File(directoryName, filename) : File.createTempFile(filename, ".txt", new File(directoryName));
        int pos = 0;
        Vector<String> words = new Vector<String>();
        Pattern p = Pattern.compile("\\u0002(.+?)\\u0003");
        Matcher m = p.matcher(ws);
        while (m.find(pos)) {
            words.add(m.group(1));
            pos = m.end();
        }
        String[] wordsArray = words.toArray(new String[0]);
        NRC_HTMLDocument.wlucene(wordsArray, wordFile);
        return wordFile.getName();
    }

    protected static String wordToUnicode(String word) {
        String w = "";
        int j = 0;
        while (j < word.length()) {
            String n = Integer.toHexString(word.charAt(j));
            String ns = String.valueOf(n);
            int nb0 = 4 - ns.length();
            String zeros = "";
            int k = 0;
            while (k < nb0) {
                zeros = String.valueOf(zeros) + "0";
                ++k;
            }
            w = String.valueOf(w) + "\\u" + zeros + ns;
            ++j;
        }
        return w;
    }

    static Hashtable lookForWordsInFile(Vector words, String latsyl) {
        String font;
        Hashtable wordsFontsToHighlight = new Hashtable();
        String[] fonts = fontsForHighlighting.toArray(new String[0]);
        Hashtable wordsFontsToCheck = new Hashtable();
        wordsFontsToCheck.put("unicode_ra", words);
        if (latsyl.equals("syllabics")) {
            int i = 0;
            while (i < fonts.length) {
                Vector<String> wfs = new Vector<String>();
                font = fonts[i];
                int j = 0;
                while (j < words.size()) {
                    String word = (String)words.elementAt(j);
                    String w = TransCoder.unicodeToLegacy((String)word, (String)font);
                    String wp = NRC_HTMLDocument.prepareForRegexp(w);
                    String wd = NRC_HTMLDocument.withDots(wp);
                    if (!wfs.contains(wd)) {
                        wfs.add(wd);
                    }
                    ++j;
                }
                if (wfs.size() != 0) {
                    wordsFontsToCheck.put(font, wfs);
                }
                ++i;
            }
        }
        String textInFile = "";
        int i = 0;
        while (i < NRC_HTMLDocument.docu.elements.size()) {
            HTMLDocuElement element = (HTMLDocuElement)NRC_HTMLDocument.docu.elements.elementAt(i);
            if (element.getType() == 2) {
                textInFile = String.valueOf(textInFile) + ((BetweenTag)NRC_HTMLDocument.docu.elements.elementAt((int)i)).text;
            }
            ++i;
        }
        Enumeration e = wordsFontsToCheck.keys();
        while (e.hasMoreElements()) {
            font = e.nextElement();
            Vector wordPatterns = (Vector)wordsFontsToCheck.get(font);
            String ffont = font;
            if (font.equals("unicode_ra")) {
                ffont = "";
            }
            Vector<String> wordsToHighlight = new Vector<String>();
            int i2 = 0;
            while (i2 < wordPatterns.size()) {
                String w = (String)wordPatterns.elementAt(i2);
                String wp = w.replaceAll("\\s+", "\\\\s+");
                Pattern p = Pattern.compile(wp);
                Matcher m = p.matcher(textInFile);
                int pos = 0;
                while (pos < textInFile.length() && m.find(pos)) {
                    String wordFound;
                    if (!(m.start() != 0 && !Orthographe.isWordDelimiter((char)textInFile.charAt(m.start() - 1), (String)ffont) || m.end() != textInFile.length() && !Orthographe.isWordDelimiter((char)textInFile.charAt(m.end()), (String)ffont) || wordsToHighlight.contains(wordFound = textInFile.substring(m.start(), m.end())))) {
                        wordsToHighlight.add(wordFound);
                    }
                    pos = ffont.equals("") ? textInFile.length() : m.end();
                }
                ++i2;
            }
            if (wordsToHighlight.size() == 0) continue;
            wordsFontsToHighlight.put(ffont, wordsToHighlight);
        }
        return wordsFontsToHighlight;
    }

    static String prepareForRegexp(String x) {
        String y = NRC_HTMLDocument.prepareForRegexpNonAlphanum(x);
        return y;
    }

    static String prepareForRegexpNonAlphanum(String x) {
        if (x.length() == 0) {
            return x;
        }
        String x1 = x.substring(0, 1);
        String x1a = x1.replaceFirst("\\p{Punct}", "\\\\" + x1);
        return String.valueOf(x1a) + NRC_HTMLDocument.prepareForRegexp(x.substring(1));
    }

    static String prepareForRegexpSpaces(String x) {
        String y = x.replaceAll("\\s+", "\\\\s+");
        return y;
    }

    static String withDots(String src) {
        String combinedDotCodesForRegexp = "[<>`~\\\\\\]+|}]";
        String regexp = "\\\\" + combinedDotCodesForRegexp;
        String newsrc = src.replaceAll(regexp, combinedDotCodesForRegexp);
        return newsrc;
    }

    static void copyInFile(OutputStream os) throws IOException {
        Vector elements = NRC_HTMLDocument.docu.elements;
        int i = 0;
        while (i < elements.size()) {
            HTMLDocuElement el = (HTMLDocuElement)elements.elementAt(i);
            if (el.getType() != 2 || !new String(((BetweenTag)el).text).equals("\u0002 \u0003")) {
                os.write(el.getBytes());
            }
            ++i;
        }
    }

    void highlightWords(Hashtable fonts, String latsyl) throws UnsupportedEncodingException {
        Enumeration e = fonts.keys();
        while (e.hasMoreElements()) {
            Object font = e.nextElement();
            Vector words = (Vector)fonts.get(font);
            int i = 0;
            while (i < words.size()) {
                String word = (String)words.elementAt(i);
                this.highlightExp(word, latsyl, (String)font);
                ++i;
            }
        }
    }

    void highlightExp(String word, String latsyl, String font) throws UnsupportedEncodingException {
        boolean toBeConsidered = true;
        int iel = 0;
        while (iel < elements.size()) {
            HTMLDocuElement elm;
            HTMLDocuElement element = (HTMLDocuElement)elements.elementAt(iel);
            int elementType = element.getType();
            if (elementType == 2 && toBeConsidered) {
                elm = (BetweenTag)element;
                String text = elm.text;
                if (elm.font == null || elm.font.equals("null") || elm.font.equals(font)) {
                    int is = 0;
                    while (true) {
                        Integer[] start = this.startInTextNode(word, text, false, is, latsyl, iel, font);
                        int posEnd = 0;
                        if (start == null) break;
                        int posStart = start[0];
                        int endStart = start[1];
                        String wordRest = word.substring(endStart - posStart);
                        if (wordRest.length() == 0) {
                            if (endStart < text.length() && Orthographe.isWordDelimiter((char)text.charAt(endStart), (String)font) || endStart == text.length() && NRC_HTMLDocument.nextNodeStartsWithWordDelimiter(iel, font)) {
                                posEnd = posStart + word.length();
                                iel = this.addHighlight(iel, posStart, text, iel, posEnd, text);
                                break;
                            }
                            is = posStart + 1;
                            continue;
                        }
                        if (endStart == text.length()) {
                            Integer[] js = this.findEndInText(wordRest, iel, latsyl, font);
                            if (js == null) {
                                is = posStart + 1;
                                continue;
                            }
                            int j = js[0];
                            int endPos = js[1];
                            HTMLDocuElement endNode = (HTMLDocuElement)NRC_HTMLDocument.docu.elements.elementAt(j);
                            String endNodeText = ((BetweenTag)endNode).text;
                            if (endPos < endNodeText.length() && Orthographe.isWordDelimiter((char)endNodeText.charAt(endPos), (String)font) || endPos == endNodeText.length() && NRC_HTMLDocument.nextNodeStartsWithWordDelimiter(j, font)) {
                                iel = this.addHighlight(iel, posStart, text, j, endPos, endNodeText);
                                break;
                            }
                            is = posStart + 1;
                            continue;
                        }
                        is = posStart + 1;
                    }
                }
            } else if (elementType == 1) {
                elm = (Tag)element;
                String tagName = ((Tag)elm).tag;
                toBeConsidered = !tagName.equals("title") && !tagName.equals("script") && !tagName.equals("style");
            }
            ++iel;
        }
    }

    Integer[] startInTextNode(String target, String nodeText, boolean startAtBeginning, int is, String latsyl, int nodeIndex, String font) {
        int ltxt = 0;
        int ltgt = 0;
        ltxt = nodeText.length();
        ltgt = target.length();
        if (nodeText.length() != 0 && !nodeText.equals(" ")) {
            if (!startAtBeginning) {
                int i = is;
                while (i < ltxt) {
                    boolean sameChar;
                    if (latsyl.equals("syllabics")) {
                        sameChar = nodeText.charAt(i) == target.charAt(0);
                    } else {
                        boolean bl = sameChar = Character.toLowerCase(nodeText.charAt(i)) == Character.toLowerCase(target.charAt(0));
                    }
                    if (sameChar) {
                        int ic = i + 1;
                        int j = 1;
                        while (ic < ltxt && j < ltgt) {
                            if (latsyl.equals("syllabics")) {
                                sameChar = nodeText.charAt(ic) == target.charAt(j);
                            } else {
                                boolean bl = sameChar = Character.toLowerCase(nodeText.charAt(ic)) == Character.toLowerCase(target.charAt(j));
                            }
                            if (!sameChar) break;
                            ++ic;
                            ++j;
                        }
                        if (i == 0 && this.previousNodeEndsWithWordDelimiter(nodeIndex, font) || i > 0 && Orthographe.isWordDelimiter((char)nodeText.charAt(i - 1), (String)font)) {
                            if (j == ltgt) {
                                return new Integer[]{new Integer(i), new Integer(i + j)};
                            }
                            if (ic == ltxt) {
                                return new Integer[]{new Integer(i), new Integer(ic)};
                            }
                        }
                    }
                    ++i;
                }
            } else {
                int ic = 0;
                int j = 0;
                while (ic < ltxt && j < ltgt) {
                    boolean sameChar;
                    if (latsyl.equals("syllabics")) {
                        sameChar = nodeText.charAt(ic) == target.charAt(j);
                    } else {
                        boolean bl = sameChar = Character.toLowerCase(nodeText.charAt(ic)) == Character.toLowerCase(target.charAt(j));
                    }
                    if (!sameChar) break;
                    ++ic;
                    ++j;
                }
                if (j == ltgt) {
                    return new Integer[]{new Integer(0), new Integer(j)};
                }
                if (ic == ltxt) {
                    return new Integer[]{new Integer(0), new Integer(ic)};
                }
                return null;
            }
        }
        return null;
    }

    Integer[] findEndInText(String target, int nodeIndex, String latsyl, String font) throws UnsupportedEncodingException {
        int i = nodeIndex + 1;
        while (i < elements.size()) {
            HTMLDocuElement elm = null;
            elm = (HTMLDocuElement)elements.elementAt(i);
            if (elm.getType() == 2) {
                String text = ((BetweenTag)elm).text;
                Integer[] start = this.startInTextNode(target, text, true, 0, latsyl, i, font);
                if (start != null && start[0] == 0) {
                    String targetRestant = target.substring(start[1] - start[0]);
                    if (targetRestant.length() == 0) {
                        return new Integer[]{new Integer(i), new Integer(target.length())};
                    }
                    target = targetRestant;
                } else {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    int addHighlight(int startNode, int startPos, String startNodeText, int endNode, int endPos, String endNodeText) throws UnsupportedEncodingException {
        BetweenTag highlightedNode;
        String highlighted;
        HTMLDocuElement elmTxt;
        Tag spanNode = new Tag("<span class=\"hl\">", null);
        Tag endSpan = new Tag("</span>", null);
        startNodeText = ((BetweenTag)NRC_HTMLDocument.elements.elementAt((int)startNode)).text;
        endNodeText = ((BetweenTag)NRC_HTMLDocument.elements.elementAt((int)endNode)).text;
        if (endNode == startNode) {
            if (startPos == 0) {
                if (endPos == startNodeText.length()) {
                    elements.add(startNode, spanNode);
                    elements.add(startNode + 2, endSpan);
                    return startNode + 2;
                }
                HTMLDocuElement elmTxt2 = (HTMLDocuElement)elements.elementAt(startNode);
                elmTxt2.setText(startNodeText.substring(endPos), this.encoding);
                elements.setElementAt(elmTxt2, startNode);
                String highlighted2 = startNodeText.substring(0, endPos);
                BetweenTag highlightedNode2 = new BetweenTag(highlighted2, this.encoding);
                elements.add(startNode, endSpan);
                elements.add(startNode, highlightedNode2);
                elements.add(startNode, spanNode);
                return startNode + 3;
            }
            if (endPos == startNodeText.length()) {
                HTMLDocuElement elmTxt3 = (HTMLDocuElement)elements.elementAt(startNode);
                elmTxt3.setText(startNodeText.substring(0, startPos), this.encoding);
                elements.setElementAt(elmTxt3, startNode);
                String highlighted3 = startNodeText.substring(startPos, endPos);
                BetweenTag highlightedNode3 = new BetweenTag(highlighted3, this.encoding);
                elements.add(startNode + 1, spanNode);
                elements.add(startNode + 2, highlightedNode3);
                elements.add(startNode + 3, endSpan);
                return startNode + 3;
            }
            HTMLDocuElement elmTxt4 = (HTMLDocuElement)elements.elementAt(startNode);
            elmTxt4.setText(startNodeText.substring(0, startPos), this.encoding);
            elements.setElementAt(elmTxt4, startNode);
            String highlighted4 = startNodeText.substring(startPos, endPos);
            BetweenTag highlightedNode4 = new BetweenTag(highlighted4, this.encoding);
            BetweenTag lastText = new BetweenTag(startNodeText.substring(endPos), this.encoding);
            elements.add(startNode + 1, spanNode);
            elements.add(startNode + 2, highlightedNode4);
            elements.add(startNode + 3, endSpan);
            elements.add(startNode + 4, lastText);
            return startNode + 3;
        }
        int nextNode = startNode;
        if (startPos == 0) {
            elements.add(startNode, spanNode);
            elements.add(startNode + 2, endSpan);
            nextNode = startNode + 2;
            endNode += 2;
        } else {
            elmTxt = (HTMLDocuElement)elements.elementAt(startNode);
            elmTxt.setText(startNodeText.substring(0, startPos), this.encoding);
            elements.setElementAt(elmTxt, startNode);
            highlighted = startNodeText.substring(startPos);
            highlightedNode = new BetweenTag(highlighted, this.encoding);
            elements.add(startNode + 1, spanNode);
            elements.add(startNode + 2, highlightedNode);
            elements.add(startNode + 3, endSpan);
            nextNode = startNode + 3;
            endNode += 3;
        }
        while (nextNode != endNode) {
            elements.add(nextNode, spanNode);
            elements.add(nextNode + 2, endSpan);
            nextNode += 3;
            endNode += 2;
        }
        if (endPos == endNodeText.length()) {
            elements.add(endNode, spanNode);
            elements.add(endNode + 2, endSpan);
            return endNode + 2;
        }
        elmTxt = (HTMLDocuElement)elements.elementAt(endNode);
        elmTxt.setText(endNodeText.substring(endPos), this.encoding);
        elements.setElementAt(elmTxt, endNode);
        highlighted = endNodeText.substring(0, endPos);
        highlightedNode = new BetweenTag(highlighted, this.encoding);
        elements.add(endNode, endSpan);
        elements.add(endNode, highlightedNode);
        elements.add(endNode, spanNode);
        return endNode + 3;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("2 arguments: <url> <action - c:contenu  vi:v\u00e9rifier quantit\u00e9 d'inuktitut  htmli:contenu html inuktitut avec http headers   htmlr: contenu html latin avec http headers>");
            System.exit(1);
        }
        NRC_HTMLDocument doc = null;
        try {
            doc = new NRC_HTMLDocument(args[0]);
        }
        catch (Exception e1) {
            if (doc != null) {
                doc.close();
            }
            System.out.println("---erreur de classe '" + e1.getClass().getName() + "' : " + e1.getMessage());
            System.exit(1);
        }
        if (doc != null) {
            if (args[1].equals("c")) {
                try {
                    String contenu = null;
                    contenu = doc.getPageContent();
                    System.out.println(URLEncoder.encode(contenu, "utf-8"));
                }
                catch (UnsupportedEncodingException contenu) {}
            } else if (args[1].equals("vi")) {
                float ip = doc.getInuktitutPercentage();
                System.out.print(Float.toString(ip));
            } else if (args[1].equals("htmli")) {
                try {
                    doc.toUnicode(System.out);
                }
                catch (Exception e) {
                    System.out.print("");
                }
            } else if (args[1].equals("htmlr")) {
                try {
                    doc.toRoman(System.out);
                }
                catch (OutOfMemoryError e) {
                    System.out.print("");
                }
                catch (Exception e) {
                    System.out.print("");
                }
            } else {
                System.out.print("");
            }
            doc.close();
        }
    }

    private boolean previousNodeEndsWithWordDelimiter(int nodeIndex, String fontName) {
        HTMLDocuElement previousElement;
        if (nodeIndex == 0) {
            return true;
        }
        if ((previousElement = (HTMLDocuElement)NRC_HTMLDocument.docu.elements.elementAt(--nodeIndex)).getType() == 2) {
            String text = null;
            try {
                text = new String(previousElement.getBytes(), this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                text = new String(previousElement.getBytes());
            }
            if (text.equals("\u0002 \u0003")) {
                return true;
            }
            return Orthographe.isWordDelimiter((char)text.charAt(text.length() - 1), (String)fontName);
        }
        String tag = ((Tag)previousElement).tag;
        if (Arrays.binarySearch(HTMLDocuElement.tagsThatDoNotAddSpace, tag) >= 0) {
            return this.previousNodeEndsWithWordDelimiter(nodeIndex, fontName);
        }
        return false;
    }

    private static boolean nextNodeStartsWithWordDelimiter(int nodeIndex, String fontName) {
        HTMLDocuElement nextElement;
        while (nodeIndex < NRC_HTMLDocument.docu.elements.size() - 1 && new String((nextElement = (HTMLDocuElement)NRC_HTMLDocument.docu.elements.elementAt(++nodeIndex)).getBytes()).startsWith("</")) {
        }
        if (nodeIndex == NRC_HTMLDocument.docu.elements.size() - 1) {
            return true;
        }
        if ((nextElement = (HTMLDocuElement)NRC_HTMLDocument.docu.elements.elementAt(++nodeIndex)).getType() == 2) {
            String text = nextElement.toString();
            return Orthographe.isWordDelimiter((char)text.charAt(0), (String)fontName);
        }
        if (nodeIndex == NRC_HTMLDocument.docu.elements.size() - 1) {
            return true;
        }
        if ((nextElement = (HTMLDocuElement)NRC_HTMLDocument.docu.elements.elementAt(++nodeIndex)).getType() == 2) {
            String text = ((BetweenTag)nextElement).text;
            if (text.equals("\u0002 \u0003")) {
                return true;
            }
            return Orthographe.isWordDelimiter((char)text.charAt(0), (String)fontName);
        }
        return false;
    }

    public Object[] transliterate() throws OutOfMemoryError, Exception {
        transHash = new Hashtable();
        String fileCopy = null;
        this.traiterDocPourTranslit();
        fileCopy = "file://localhost/" + this.copyOfFile.getAbsolutePath();
        HtmlDocu doc2 = new HtmlDocu(new URL(fileCopy));
        doc2.insertBase(this.getBase());
        File fout2 = NRC_HTMLDocument.traiterDocPourTranslit2(doc2, this.encoding, this.encoding);
        return new Object[]{this.encoding, fout2};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toRoman(OutputStream out) throws Exception {
        Exception exc;
        block10: {
            File fout2 = null;
            exc = null;
            try {
                try {
                    transHash = new Hashtable();
                    this.traiterDocPourTranslit();
                    HtmlDocu doc2 = new HtmlDocu(this.copyOfFile, this.encoding);
                    doc2.insertBase(this.getBase());
                    fout2 = NRC_HTMLDocument.traiterDocPourTranslit3(doc2, this.encoding, "latin");
                    out.write(("Content-Type: text/html; charset=" + this.encoding).getBytes());
                    out.write("\n\n".getBytes());
                    out.write("<!--END OF HTTP HEADERS-->".getBytes());
                    FileInputStream fr = new FileInputStream(fout2);
                    while (true) {
                        int c;
                        if ((c = fr.read()) == -1) {
                            fr.close();
                            fout2.delete();
                            out.flush();
                        }
                        out.write(c);
                    }
                }
                catch (Exception e) {
                    exc = e;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (fout2 != null) {
                    fout2.delete();
                }
                if (exc != null) {
                    throw exc;
                }
                throw throwable;
            }
            {
                Object var7_10 = null;
                if (fout2 == null) break block10;
                fout2.delete();
            }
        }
        if (exc != null) {
            throw exc;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toUnicode(OutputStream out) throws Exception {
        Exception exc;
        block10: {
            File fout2 = null;
            exc = null;
            try {
                try {
                    transHash = new Hashtable();
                    this.traiterDocPourTranslit();
                    HtmlDocu doc2 = new HtmlDocu(this.copyOfFile, this.encoding);
                    doc2.insertBase(this.getBase());
                    fout2 = NRC_HTMLDocument.traiterDocPourTranslit3(doc2, this.encoding, "utf-8");
                    out.write("Content-Type: text/html; charset=utf-8".getBytes());
                    out.write("\n\n".getBytes());
                    out.write("<!--END OF HTTP HEADERS-->".getBytes());
                    FileInputStream fr = new FileInputStream(fout2);
                    while (true) {
                        int c;
                        if ((c = fr.read()) == -1) {
                            fr.close();
                            fout2.delete();
                            out.flush();
                        }
                        out.write(c);
                    }
                }
                catch (Exception e) {
                    exc = e;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (fout2 != null) {
                    fout2.delete();
                }
                if (exc != null) {
                    throw exc;
                }
                throw throwable;
            }
            {
                Object var7_10 = null;
                if (fout2 == null) break block10;
                fout2.delete();
            }
        }
        if (exc != null) {
            throw exc;
        }
    }

    private void traiterDocPourTranslit() {
        ElementIterator iterator = new ElementIterator(this);
        try {
            Element elem;
            while ((elem = iterator.next()) != null) {
                Matcher mfw;
                AttributeSet as = elem.getAttributes();
                if (elem.getName().equals("title")) {
                    String title;
                    if (as.getAttribute(HTML.Attribute.ENDTAG) == null || (title = (String)this.getProperty("title")) == null) continue;
                    title = TransCoder.unicodeToRoman((String)title);
                    this.putProperty("title", title);
                    continue;
                }
                if (!elem.getName().equals("content")) continue;
                int beg = elem.getStartOffset();
                int end = elem.getEndOffset();
                String text = this.getText(beg, end - beg);
                String[] fontFamilies = this.getFont(elem);
                String font = Police.containsLegacyFont((String[])fontFamilies);
                if (font == null || !(mfw = pfw2.matcher(text)).find()) continue;
                String firstWord = String.valueOf(mfw.group(1)) + (mfw.group(2) != null ? mfw.group(2) : "") + (mfw.group(4) != null ? mfw.group(4) : "");
                transHash.put(firstWord, font);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static File traiterDocPourTranslit2(HtmlDocu doc2, String enc, String translitMode) throws IOException {
        String translitFont = translitMode.equals("utf-8") ? "pigiarniq" : "arial";
        int i = 0;
        while (i < doc2.elements.size()) {
            HTMLDocuElement element = (HTMLDocuElement)doc2.elements.elementAt(i);
            if (element.getType() == 2) {
                String txt = null;
                try {
                    HTMLDocuElement precElement;
                    txt = new String(element.getBytes(), enc);
                    String txttmp = HtmlEntities.entityToChar(txt.replaceAll("\\s+", " "));
                    Matcher mfw = pfw2.matcher(txttmp);
                    String key = null;
                    if (mfw.find()) {
                        key = String.valueOf(mfw.group(1)) + (mfw.group(2) != null ? mfw.group(2) : "") + (mfw.group(4) != null ? mfw.group(4) : "");
                    }
                    if (i != 0 && (precElement = (HTMLDocuElement)doc2.elements.elementAt(i - 1)).getType() == 1 && ((Tag)precElement).text.endsWith("/>")) {
                        key = ">" + key;
                    }
                    if (key != null && transHash.containsKey(key)) {
                        int pos = 0;
                        String transText = "";
                        String font = (String)transHash.get(key);
                        Matcher mh = HtmlEntities.pHtmlEntity.matcher(txt);
                        while (pos < txt.length() && mh.find(pos)) {
                            String htmlEntity = mh.group();
                            String transPart = translitMode.equals("utf-8") ? TransCoder.legacyToUnicode((String)txt.substring(pos, mh.start()), (String)font) : TransCoder.legacyToRoman((String)txt.substring(pos, mh.start()), (String)font);
                            transText = String.valueOf(transText) + transPart;
                            transText = String.valueOf(transText) + htmlEntity;
                            pos = mh.end();
                            if (txt.charAt(pos) != ';') continue;
                            transText = String.valueOf(transText) + ';';
                            ++pos;
                        }
                        String transPart = translitMode.equals("utf-8") ? TransCoder.legacyToUnicode((String)txt.substring(pos), (String)font) : TransCoder.legacyToRoman((String)txt.substring(pos), (String)font);
                        transText = String.valueOf(transText) + transPart;
                        String fontAndTxt = "<FONT face=" + translitFont + ">" + transText + "</FONT>";
                        byte[] bs = fontAndTxt.getBytes(translitMode.equals("utf-8") ? translitMode : enc);
                        element.setBytes(bs);
                    } else {
                        String txtentity = HtmlEntities.toStringInuktitut(txt);
                        byte[] bs = txtentity.getBytes(translitMode.equals("utf-8") ? translitMode : enc);
                        element.setBytes(bs);
                    }
                    doc2.elements.setElementAt(element, i);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            ++i;
        }
        File fout = null;
        fout = File.createTempFile("translitOutput", ".htm", tmpDir);
        FileOutputStream os = new FileOutputStream(fout);
        doc2.write(os);
        ((OutputStream)os).close();
        return fout;
    }

    static File traiterDocPourTranslit3(HtmlDocu doc2, String enc, String translitMode) throws IOException {
        String translitFont = translitMode.equals("utf-8") ? "pigiarniq" : "arial";
        int i = 0;
        while (i < doc2.elements.size()) {
            HTMLDocuElement element = (HTMLDocuElement)doc2.elements.elementAt(i);
            if (element.getType() == 2) {
                String txt = null;
                try {
                    HTMLDocuElement precElement;
                    txt = new String(element.getBytes(), enc);
                    String txttmp = HtmlEntities.entityToChar(txt);
                    Matcher mfw = pfw2.matcher(txttmp);
                    String key = null;
                    if (mfw.find()) {
                        key = String.valueOf(mfw.group(1)) + (mfw.group(2) != null ? mfw.group(2) : "") + (mfw.group(4) != null ? mfw.group(4) : "");
                        key = key.replaceAll("\\s+", " ");
                    }
                    if (i != 0 && (precElement = (HTMLDocuElement)doc2.elements.elementAt(i - 1)).getType() == 1 && ((Tag)precElement).text.endsWith("/>")) {
                        key = ">" + key;
                    }
                    if (key != null && transHash.containsKey(key)) {
                        String script;
                        String transPart;
                        String transText = "";
                        String font = (String)transHash.get(key);
                        if (translitMode.equals("utf-8")) {
                            transPart = TransCoder.legacyToUnicode((String)txttmp, (String)font);
                            script = "s";
                        } else {
                            transPart = TransCoder.legacyToRoman((String)txttmp, (String)font);
                            script = "l";
                        }
                        transText = String.valueOf(transText) + transPart;
                        String fontAndTxt = "<FONT face=" + translitFont + " class=\"inuk-" + script + "\">" + transText + "</FONT>";
                        byte[] bs = fontAndTxt.getBytes(translitMode.equals("utf-8") ? translitMode : enc);
                        element.setBytes(bs);
                    } else {
                        String txtentity = HtmlEntities.toStringInuktitut(txt);
                        if (Syllabics.containsInuktitut((String)txttmp)) {
                            String script;
                            if (translitMode.equals("utf-8")) {
                                script = "s";
                            } else {
                                txtentity = TransCoder.unicodeToRoman((String)txttmp);
                                script = "l";
                            }
                            txtentity = "<FONT face=" + translitFont + " class=\"inuk-" + script + "\">" + txtentity + "</FONT>";
                        }
                        byte[] bs = txtentity.getBytes(translitMode.equals("utf-8") ? translitMode : enc);
                        element.setBytes(bs);
                    }
                    doc2.elements.setElementAt(element, i);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            ++i;
        }
        File fout = null;
        fout = File.createTempFile("translitOutput", ".htm", tmpDir);
        FileOutputStream os = new FileOutputStream(fout);
        doc2.write(os);
        ((OutputStream)os).close();
        return fout;
    }

    public WebPageReader getWpr() {
        return this.wpr;
    }

    public Object[] getAllFonts() {
        if (this.fonts == null) {
            this.getPageContent();
        }
        return this.fonts.keySet().toArray();
    }

    public String[] getAllFontsNames() {
        Object[] fnts = this.getAllFonts();
        String[] fontNames = new String[fnts.length];
        int i = 0;
        while (i < fnts.length) {
            fontNames[i] = (String)fnts[i];
            ++i;
        }
        return fontNames;
    }

    public String[] getInuktitutFonts() {
        String[] allFonts = this.getAllFontsNames();
        Vector<String> fs = new Vector<String>();
        List<String> inuktitutFonts = Arrays.asList(Police.polices);
        int i = 0;
        while (i < allFonts.length) {
            String fnt = allFonts[i];
            if (inuktitutFonts.contains(fnt) && !fs.contains(fnt)) {
                fs.add(fnt);
            }
            ++i;
        }
        return fs.toArray(new String[0]);
    }

    public String getPreferredFont() {
        return null;
    }

    public void close() {
        this.copyOfFile.delete();
    }

    public boolean containsInuktitut() {
        if (this.pageContent == null) {
            this.getPageContent();
        }
        return this.containsInuktitut;
    }

    public float getInuktitutPercentage() {
        if (this.containsInuktitut()) {
            return (float)this.lengthOfInuktitutContent / (float)this.lengthOfTotalContent;
        }
        return 0.0f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TexteHTML texteEnInuktitut(Element element) {
        Vector<Inuktitut.MorceauTexte> morceaux;
        boolean enInuktitut;
        TexteHTML txtHTML;
        block17: {
            txtHTML = new TexteHTML(element, this);
            enInuktitut = false;
            morceaux = new Vector<Inuktitut.MorceauTexte>();
            try {
                Inuktitut.MorceauTexte morceau;
                String text;
                int end;
                int beg;
                block15: {
                    beg = element.getStartOffset();
                    end = element.getEndOffset();
                    text = this.getText(beg, end - beg);
                    int longu = text.length();
                    int i = 0;
                    int deb = 0;
                    boolean dansInuk = false;
                    boolean dansNonInuk = false;
                    if (longu == 1 && text.charAt(0) == '\n') {
                        return null;
                    }
                    while (true) {
                        if (i >= longu) {
                            if (enInuktitut) {
                                txtHTML.setCodage(Roman.UNICODE);
                            }
                            break block15;
                        }
                        if (Syllabics.isInuktitutCharacter((char)text.charAt(i))) {
                            enInuktitut = true;
                            if (!dansInuk) {
                                if (dansNonInuk) {
                                    dansNonInuk = false;
                                    dansInuk = true;
                                    morceau = new Inuktitut.MorceauTexte(false, deb, i, text.substring(deb, i), null);
                                    morceaux.add(morceau);
                                    deb = i;
                                } else {
                                    dansInuk = true;
                                    deb = i;
                                }
                            }
                        } else if (!dansNonInuk) {
                            if (dansInuk) {
                                dansInuk = false;
                                dansNonInuk = true;
                                morceau = new Inuktitut.MorceauTexte(true, deb, i, text.substring(deb, i), null);
                                morceaux.add(morceau);
                                deb = i;
                            } else {
                                dansNonInuk = true;
                                deb = i;
                            }
                        }
                        ++i;
                    }
                    morceau = new Inuktitut.MorceauTexte(dansInuk, deb, i, text.substring(deb, i), null);
                    morceaux.add(morceau);
                    break block17;
                }
                txtHTML.setCodage(Roman.NONUNICODE);
                String[] fontFamilies = this.getFont(element);
                String font = Police.containsLegacyFont((String[])fontFamilies);
                if (font != null) {
                    Inuktitut.fontInuk = font;
                    enInuktitut = true;
                    morceau = new Inuktitut.MorceauTexte(true, beg, end, text, Inuktitut.fontInuk);
                    String txtUnicode = TransCoder.legacyToUnicode((String)text, (String)Inuktitut.fontInuk);
                    morceau.setTexte(txtUnicode);
                    morceaux = new Vector();
                    morceaux.add(morceau);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        txtHTML.setMorceaux(morceaux);
        if (!enInuktitut) return null;
        TexteHTML texteHTML = txtHTML;
        return texteHTML;
    }

    public Object[][] getInuktitutFontsAndPercentages() {
        return null;
    }

    class CacheFilter
    implements FilenameFilter {
        CacheFilter() {
        }

        public boolean accept(File dir, String name) {
            if (new File(dir, name).isDirectory()) {
                return false;
            }
            name = name.toLowerCase();
            Pattern p = Pattern.compile("copy\\[[0-9]+\\].htm");
            Matcher m = p.matcher(name);
            return m.matches();
        }
    }

    public static class Encoding {
        public String value;
        public String source;

        public Encoding(String enc, String source) {
            this.value = enc;
            this.source = source;
        }

        public String toString() {
            return "Encoding{" + this.value + "," + this.source + "}";
        }
    }

    class HtmlReader
    extends HTMLDocument.HTMLReader {
        private boolean inStyle = false;

        public HtmlReader(int offset) {
            this(offset, 0, 0, null);
        }

        public HtmlReader(int offset, int popDepth, int pushDepth, HTML.Tag insertTag) {
            super(NRC_HTMLDocument.this, offset, popDepth, pushDepth, insertTag);
            this.registerTag(HTML.Tag.H1, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.H2, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.H3, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.H4, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.H5, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.H6, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.A, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.ADDRESS, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.B, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.BASEFONT, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.BIG, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.CITE, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.CODE, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.DFN, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.EM, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.FONT, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.I, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.KBD, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.SAMP, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.SMALL, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.STRIKE, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.S, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.STRONG, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.SUB, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.SUP, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.TT, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.U, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.VAR, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.DT, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(NRC_HTMLTag.TBODY, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(NRC_HTMLTag.LABEL, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(NRC_HTMLTag.NOINDEX, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.SCRIPT, new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(HTML.Tag.SPAN, new HTMLDocument.HTMLReader.BlockAction(this));
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == HTML.Tag.STYLE) {
                this.inStyle = true;
            }
            Object styleAtt = a.isDefined(HTML.Attribute.STYLE) ? a.getAttribute(HTML.Attribute.STYLE) : null;
            super.handleStartTag(t, a, pos);
            if (styleAtt != null) {
                AttributeSet styleAttributes = NRC_HTMLDocument.this.getStyleSheet().getDeclaration((String)styleAtt);
                DefaultStyledDocument.ElementSpec es = (DefaultStyledDocument.ElementSpec)this.parseBuffer.lastElement();
                MutableAttributeSet attrEs = (MutableAttributeSet)es.getAttributes();
                Enumeration<?> e = styleAttributes.getAttributeNames();
                while (e.hasMoreElements()) {
                    attrEs.removeAttribute(e.nextElement());
                }
                attrEs.addAttribute(HTML.Attribute.STYLE, styleAtt);
            }
        }

        public void handleEndTag(HTML.Tag t, int pos) {
            if (t == HTML.Tag.STYLE) {
                this.inStyle = false;
            }
            super.handleEndTag(t, pos);
        }

        public void handleText(char[] dat, int pos) {
            super.handleText(dat, pos);
            if (this.inStyle && dat.length >= 1) {
                String text = new String(dat);
                NRC_HTMLDocument.this.getStyleSheet().addRule(text.toLowerCase());
            }
        }

        public void handleComment(char[] dat, int pos) {
            super.handleComment(dat, pos);
            if (this.inStyle && dat.length >= 1) {
                String text = new String(dat);
                NRC_HTMLDocument.this.getStyleSheet().addRule(text.toLowerCase());
            }
        }

        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            block12: {
                block14: {
                    block13: {
                        String httpequiv;
                        block15: {
                            int posCharset;
                            String charsetContent;
                            block11: {
                                charsetContent = null;
                                if (t != HTML.Tag.SPAN && !t.toString().toLowerCase().equals("tbody") && !t.toString().toLowerCase().equals("label")) break block11;
                                if (a.isDefined(HTML.Attribute.ENDTAG) && ((String)a.getAttribute(HTML.Attribute.ENDTAG)).equals("true")) {
                                    this.blockClose(t);
                                } else {
                                    this.blockOpen(t, a);
                                }
                                break block12;
                            }
                            if (t != HTML.Tag.META) break block13;
                            if (!a.isDefined(HTML.Attribute.HTTPEQUIV)) break block14;
                            httpequiv = (String)a.getAttribute(HTML.Attribute.HTTPEQUIV);
                            if (!httpequiv.toLowerCase().equals("content-type")) break block15;
                            if (!a.isDefined(HTML.Attribute.CONTENT) || (posCharset = (charsetContent = (String)a.getAttribute(HTML.Attribute.CONTENT)).indexOf("charset")) == -1) break block14;
                            int posEndCharset = charsetContent.indexOf(59, posCharset);
                            if (posEndCharset == -1) {
                                posEndCharset = charsetContent.length();
                            }
                            String encodage = charsetContent.substring(posCharset + "charset=".length(), posEndCharset);
                            if (NRC_HTMLDocument.this.encoding != null) break block14;
                            NRC_HTMLDocument.this.encoding = encodage;
                            break block14;
                        }
                        if (!httpequiv.toLowerCase().equals("refresh")) break block14;
                        a.isDefined(HTML.Attribute.CONTENT);
                        break block14;
                    }
                    if (t == HTML.Tag.LINK) {
                        Object rel = null;
                        if (a.isDefined(HTML.Attribute.REL)) {
                            rel = a.getAttribute(HTML.Attribute.REL);
                        }
                        if (rel != null) {
                            Object type = null;
                            if (rel.toString().equalsIgnoreCase("stylesheet")) {
                                if (a.isDefined(HTML.Attribute.TYPE)) {
                                    type = a.getAttribute(HTML.Attribute.TYPE);
                                }
                                if (type == null || type.toString().equalsIgnoreCase("text/css")) {
                                    a.isDefined(HTML.Attribute.TITLE);
                                    String href = a.getAttribute(HTML.Attribute.HREF).toString();
                                    URL linkUrl = NRC_HTMLDocument.this.resolveUrlFromBase(href);
                                    if (linkUrl != null) {
                                        NRC_HTMLDocument.this.getStyleSheet().importStyleSheet(linkUrl);
                                        StyleSheet ss = NRC_HTMLDocument.this.getStyleSheet();
                                        Enumeration<?> styleNames = ss.getStyleNames();
                                        while (styleNames.hasMoreElements()) {
                                            String name = (String)styleNames.nextElement();
                                            Style style = ss.getStyle(name);
                                            style.getName();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                super.handleSimpleTag(t, a, pos);
            }
        }

        public void handleError(String msg, int pos) {
            msg.toString();
        }

        void mythrow(Exception e) throws Exception {
            throw e;
        }
    }

    public static class TexteHTML {
        Element element;
        int codage;
        Vector morceaux;
        HTMLDocument doc;
        String texte;

        public TexteHTML(String text) {
            this.texte = text;
        }

        public TexteHTML(Element elem, HTMLDocument docum) {
            this.doc = docum;
            this.element = elem;
            try {
                int beg = this.element.getStartOffset();
                int end = this.element.getEndOffset();
                this.texte = this.doc.getText(beg, end - beg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int getCodage() {
            return this.codage;
        }

        public Vector getMorceaux() {
            return this.morceaux;
        }

        public void setCodage(int cod) {
            this.codage = cod;
        }

        public void setMorceaux(Vector morcx) {
            this.morceaux = morcx;
        }

        public String toString() {
            String police = ((Inuktitut.MorceauTexte)this.morceaux.get(0)).getPolice();
            String s = this.codage == Roman.UNICODE ? "u" : "f/" + police;
            s = String.valueOf(s) + "/" + this.texte + "/";
            return s;
        }

        public void transliterer() {
            try {
                String text = this.texte;
                if (text.length() != 0 && (text.length() != 1 || text.charAt(0) != '\n')) {
                    int i = 0;
                    while (i < this.morceaux.size()) {
                        Inuktitut.MorceauTexte morceau = (Inuktitut.MorceauTexte)this.morceaux.get(i);
                        if (morceau.isInuk()) {
                            String txt1 = morceau.getTexte();
                            String txt = morceau.getTexte().replace('\u00a0', ' ');
                            txt = txt1;
                            String textSyllabes = TransCoder.unicodeToRoman((String)txt);
                            ((Inuktitut.MorceauTexte)this.morceaux.get(i)).setTexte(textSyllabes);
                            ((Inuktitut.MorceauTexte)this.morceaux.get(i)).setSyllabic(false);
                        } else {
                            String newText = new String();
                            String txt1 = morceau.getTexte();
                            newText = txt1.replaceAll(new String(new char[]{'\u00a0'}), "&nbsp;");
                            ((Inuktitut.MorceauTexte)this.morceaux.get(i)).setTexte(newText);
                            ((Inuktitut.MorceauTexte)this.morceaux.get(i)).setSyllabic(false);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class TitreHTML {
        Element element;
        int codage;
        Vector morceaux;
        HTMLDocument doc;
        String texte;

        public TitreHTML(Element elem, HTMLDocument docum) {
            this.doc = docum;
            this.element = elem;
            this.texte = (String)this.doc.getProperty("title");
        }

        public TitreHTML(String txt) {
            this.texte = txt;
        }

        public int getCodage() {
            return this.codage;
        }

        public Vector getMorceaux() {
            return this.morceaux;
        }

        public void setCodage(int cod) {
            this.codage = cod;
        }

        public void setMorceaux(Vector morcx) {
            this.morceaux = morcx;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.morceaux.size()) {
                Inuktitut.MorceauTexte m = (Inuktitut.MorceauTexte)this.morceaux.elementAt(i);
                sb.append(m.getTexte());
                ++i;
            }
            return sb.toString();
        }

        public void transliterer() {
            try {
                String text = this.texte;
                if (text.length() != 0 && (text.length() != 1 || text.charAt(0) != '\n')) {
                    int i = 0;
                    while (i < this.morceaux.size()) {
                        Inuktitut.MorceauTexte morceau = (Inuktitut.MorceauTexte)this.morceaux.get(i);
                        if (morceau.isInuk()) {
                            String txt = morceau.getTexte().replace('\u00a0', ' ');
                            String textSyllabes = TransCoder.unicodeToRoman((String)txt);
                            ((Inuktitut.MorceauTexte)this.morceaux.get(i)).setTexte(textSyllabes);
                            ((Inuktitut.MorceauTexte)this.morceaux.get(i)).setSyllabic(false);
                        } else {
                            ((Inuktitut.MorceauTexte)this.morceaux.get(i)).setSyllabic(false);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

