/*
 * Decompiled with CFR 0.152.
 */
package documents;

import documents.HTMLReaderPatch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;

public class WebPageReader {
    public URLConnection connection;
    public URL url;
    public String contentType;

    public WebPageReader(URL url) throws Exception {
        this.url = url;
        this.wpr(url);
    }

    public WebPageReader(String urlName) throws MalformedURLException, IOException {
        try {
            this.url = new URL(urlName);
            this.wpr(this.url);
            this.connection.connect();
        }
        catch (MalformedURLException e1) {
            throw new MalformedURLException(String.valueOf(e1.toString()) + " [" + urlName + "]");
        }
        catch (IOException e2) {
            throw new IOException("From WebPageReader: " + e2.toString() + " [" + urlName + "]");
        }
    }

    void wpr(URL url) throws IOException {
        int code;
        this.connection = url.openConnection();
        this.connection.setReadTimeout(120000);
        if (url.getProtocol().startsWith("http") && WebPageReader.mustRedirect(code = ((HttpURLConnection)this.connection).getResponseCode())) {
            this.secureRedirect(this.connection.getHeaderField("Location"));
        }
        this.contentType = this.connection.getContentType();
    }

    public BufferedReader getBufferedReader() throws IOException {
        return this.getBufferedReader("ISO-8859-1");
    }

    public BufferedReader getBufferedReader(String encodage) throws IOException {
        BufferedReader in = null;
        if (encodage == null) {
            encodage = "ISO-8859-1";
        }
        InputStream is = null;
        try {
            is = this.connection.getInputStream();
        }
        catch (IOException e) {
            throw new IOException(String.valueOf(e.toString()) + " from connection[" + this.connection.toString() + "].getInputStream() in getBufferedReader");
        }
        in = new BufferedReader(new HTMLReaderPatch(new InputStreamReader(is, encodage)));
        return in;
    }

    public String getContents() {
        BufferedReader in = null;
        StringBuffer contents = new StringBuffer();
        String encoding = "iso-8859-1";
        try {
            String inputLine;
            in = new BufferedReader(new HTMLReaderPatch(new InputStreamReader(this.connection.getInputStream(), encoding)));
            while ((inputLine = in.readLine()) != null) {
                contents.append("\n" + inputLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contents.toString();
    }

    private static boolean mustRedirect(int code) {
        return code == 301 || code == 302;
    }

    private void secureRedirect(String location) throws IOException {
        this.url = new URL(location);
        this.connection = (HttpsURLConnection)this.url.openConnection();
    }
}

