/*
 * Decompiled with CFR 0.152.
 */
package documents;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.net.www.protocol.http.HttpURLConnection;

public class CharsetOfURL {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: java -classpath <...>/documentHandling.jar documents.CharsetOfURL <URL>");
            System.exit(1);
        }
        Vector<String> list = new Vector<String>(Arrays.asList(args));
        int n = 0;
        while (n < list.size()) {
            try {
                String match;
                int c;
                Matcher ctM;
                URL url = new URL(list.get(n).toString());
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Accept-Charset", "utf-8,*;q=0.8");
                Map<String, List<String>> requestProperties = conn.getRequestProperties();
                Set<String> keysSet = requestProperties.keySet();
                Object[] keys = keysSet.toArray();
                char[] spaces = new char[list.get(n).toString().length()];
                Arrays.fill(spaces, '-');
                System.out.println(spaces);
                System.out.println(list.get(n).toString());
                System.out.println("Request properties:");
                int i = 0;
                while (i < keys.length) {
                    System.out.print("    " + keys[i].toString());
                    System.out.println(" = " + requestProperties.get(keys[i]).toString());
                    ++i;
                }
                conn.connect();
                String contentType = conn.getContentType();
                String contentLanguage = conn.getHeaderField("content-language");
                System.out.println("content-language: " + contentLanguage);
                String contentLength = conn.getHeaderField("content-length");
                System.out.println("content-length: " + contentLength);
                System.out.println("content-type: " + contentType);
                String x = conn.getHeaderField("refresh");
                System.out.println("refresh: " + x);
                String transferEncoding = conn.getHeaderField("Client-Transfer-Encoding");
                System.out.println("client-transfer-encoding: " + transferEncoding);
                Pattern ct = Pattern.compile("text/html;\\s*charset=(.+)");
                if (contentType != null && (ctM = ct.matcher(contentType)).find()) {
                    System.out.println("charset dans HTTP: " + ctM.group(1));
                }
                InputStream is = conn.getInputStream();
                byte[] buf = new byte[2048];
                int len = 0;
                while ((c = is.read()) != -1 && len < 2047) {
                    buf[len++] = (byte)c;
                }
                String str = new String(buf);
                Pattern bom = Pattern.compile("^(\u00ef\u00bb\u00bf)<");
                Pattern xml = Pattern.compile("<\\?xml\\s+?(.+?)\\s*?\\?>");
                Pattern html = Pattern.compile("<[mM][eE][tT][aA]\\s+?(.+?)\\s*?/?>");
                Matcher bomM = bom.matcher(str);
                Matcher xmlM = xml.matcher(str);
                Matcher htmlM = html.matcher(str);
                if (xmlM.find()) {
                    String match2 = xmlM.group(1);
                    Pattern encoding = Pattern.compile("encoding=\"(.+?)\"");
                    Matcher encodingM = encoding.matcher(match2);
                    if (encodingM.find()) {
                        System.out.println("*** charset dans <?xml>: " + encodingM.group(1));
                    }
                }
                int pos = 0;
                boolean found = false;
                while (!found && pos < str.length() && htmlM.find(pos)) {
                    match = htmlM.group(1);
                    Pattern content = Pattern.compile("content=\"text/html;\\s*charset=(.+)\"");
                    Matcher contentM = content.matcher(match);
                    if (contentM.find()) {
                        found = true;
                        System.out.println("*** charset dans <meta>: " + contentM.group(1));
                        continue;
                    }
                    pos = htmlM.end();
                }
                if (bomM.find()) {
                    match = bomM.group(1);
                    System.out.println("*** charset par BOM: " + match);
                }
                conn.disconnect();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                System.out.println("*** error: File Not Found");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n;
        }
    }
}

