/*
 * Decompiled with CFR 0.152.
 */
package documents;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLWriter;

public class NRC_HTMLWriter
extends HTMLWriter {
    private int maxLineLength = 70;
    private int lineLength = 0;
    private boolean inPre = false;
    private boolean wrap = false;
    private HTMLDocument doc;
    private static PrintWriter out = null;
    private Writer writer;

    public NRC_HTMLWriter(Writer w, HTMLDocument doc) {
        this(w, doc, 0, doc.getLength());
        this.doc = doc;
        this.writer = w;
    }

    public NRC_HTMLWriter(Writer w, HTMLDocument doc, int pos, int len) {
        super(w, doc, pos, len);
        this.doc = doc;
        this.writer = w;
    }

    public void write() throws IOException, BadLocationException {
        ElementIterator it = this.getElementIterator();
        Element next = null;
        this.setCanWrapLines(false);
        this.lineLength = 0;
        while ((next = it.next()) != null) {
            this.writeElement(next, it);
            this.writer.flush();
        }
        if (out != null) {
            out.flush();
            out.close();
        }
    }

    void writeElement(Element elem, ElementIterator it) throws IOException {
        Object endTag;
        AttributeSet attr;
        AttributeSet as = elem.getAttributes();
        if (out != null) {
            out.println("-------------------------------");
            out.println("<" + elem.getName() + ">");
            Enumeration<?> e = as.getAttributeNames();
            while (e.hasMoreElements()) {
                Object name = e.nextElement();
                out.println("  " + name + ": " + as.getAttribute(name));
            }
            if (elem.getName().equals("content")) {
                int beg = elem.getStartOffset();
                int end = elem.getEndOffset();
                try {
                    String tx = this.doc.getText(beg, end - beg);
                    out.println("  texte: /" + tx + "/");
                }
                catch (Exception tx) {
                    // empty catch block
                }
            }
        }
        Object nameTag = (attr = elem.getAttributes()) != null ? attr.getAttribute(StyleConstants.NameAttribute) : null;
        Object object = endTag = attr != null ? attr.getAttribute(HTML.Attribute.ENDTAG) : null;
        if (!this.matchNameAttribute(attr, HTML.Tag.CONTENT)) {
            this.write("\n");
        }
        if (this.matchNameAttribute(attr, HTML.Tag.CONTENT)) {
            try {
                int pos = elem.getStartOffset();
                int length = elem.getEndOffset() - pos;
                String text = this.getDocument().getText(pos, length);
                String tx = new String();
                int j = 0;
                while (j < text.length()) {
                    tx = text.charAt(j) == '\u00a0' ? String.valueOf(tx) + "&nbsp;" : String.valueOf(tx) + text.charAt(j);
                    ++j;
                }
                this.write(tx);
                if (!this.inPre) {
                    this.lineLength += length;
                }
            }
            catch (Exception pos) {}
        } else if (this.matchNameAttribute(attr, HTML.Tag.COMMENT)) {
            this.write("<!--");
            this.write((String)attr.getAttribute(HTML.Attribute.COMMENT));
            this.write("-->");
        } else if (this.matchNameAttribute(attr, HTML.Tag.TITLE) && endTag == null) {
            Document doc;
            String title;
            this.write('<');
            this.write(nameTag.toString());
            this.write('>');
            this.lineLength = this.lineLength + 2 + nameTag.toString().length();
            if (this.wrap && this.lineLength > this.maxLineLength) {
                this.writeLineSeparator();
                this.lineLength = 0;
            }
            if ((title = (String)(doc = elem.getDocument()).getProperty("title")) != null) {
                this.write(title);
                this.lineLength += title.length();
            }
        } else {
            if (this.matchNameAttribute(attr, HTML.Tag.PRE)) {
                this.inPre = true;
            }
            boolean wroteSlash = false;
            this.write('<');
            if (endTag != null && endTag instanceof String && ((String)endTag).equals("true")) {
                this.write('/');
                wroteSlash = true;
            }
            this.write(nameTag.toString());
            this.lineLength = this.lineLength + (wroteSlash ? 2 : 1) + nameTag.toString().length();
            this.writeAttributes(attr);
            this.write('>');
            if (!this.inPre) {
                ++this.lineLength;
            }
            int nbChildren = elem.getElementCount();
            if (this.matchNameAttribute(attr, HTML.Tag.HEAD)) {
                String base0 = "<base href=\"";
                String base = ((HTMLDocument)this.getDocument()).getBase().toString();
                this.write(base0);
                this.write(base);
                this.write("\">");
                this.lineLength = this.lineLength + base0.length() + base.length() + 2;
                if (this.wrap && this.lineLength > this.maxLineLength) {
                    this.writeLineSeparator();
                    this.lineLength = 0;
                }
            }
            int i = 0;
            while (i < nbChildren) {
                block37: {
                    Element enfant = it.next();
                    if (i == nbChildren - 1) {
                        if (!this.matchNameAttribute(enfant.getAttributes(), HTML.Tag.CONTENT)) {
                            this.writeElement(enfant, it);
                        } else {
                            try {
                                int pos = enfant.getStartOffset();
                                int length = enfant.getEndOffset() - pos;
                                String text = this.getDocument().getText(pos, length);
                                if (length == 1 && text.charAt(0) == '\n') {
                                    if (this.matchNameAttribute(attr, HTML.Tag.IMPLIED) && this.inPre) {
                                        this.writeElement(enfant, it);
                                    }
                                    break block37;
                                }
                                this.writeElement(enfant, it);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        this.writeElement(enfant, it);
                    }
                }
                ++i;
            }
            if (nbChildren != 0) {
                this.write('<');
                this.write('/');
                this.write(nameTag.toString());
                this.write('>');
                if (this.matchNameAttribute(attr, HTML.Tag.PRE) && this.inPre) {
                    this.inPre = false;
                }
                if (!this.inPre) {
                    this.lineLength = this.lineLength + 3 + nameTag.toString().length();
                    if (this.wrap && this.lineLength > this.maxLineLength) {
                        this.writeLineSeparator();
                        this.lineLength = 0;
                    }
                }
            }
        }
    }

    protected void writeAttributes(AttributeSet attr) throws IOException {
        Enumeration<?> names = attr.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (name instanceof HTML.Tag && name != HTML.Tag.STYLE || name instanceof StyleConstants || name == HTML.Attribute.ENDTAG) continue;
            String satt = " " + name + "=\"" + attr.getAttribute(name) + "\"";
            if (this.wrap && !this.inPre && this.lineLength + satt.length() > this.maxLineLength) {
                satt = name + "=\"" + attr.getAttribute(name) + "\"";
                this.writeLineSeparator();
                this.lineLength = 0;
            }
            this.write(satt);
            if (this.inPre) continue;
            this.lineLength += satt.length();
        }
    }
}

