<?php

require_once 'lib/utf8.php';

/**
 * Test class for utf8.
 * Generated by PHPUnit on 2010-05-17 at 14:47:17.
 */
class utf8Test extends PHPUnit_Framework_TestCase
{
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->object = new utf8;
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
    }

    public function testUtf8_to_numeric()
    {
    	$s = 'é';
    	$as = 0xe9;
    	$rs = utf8::utf8_to_numeric($s);
    	$this->assertEquals($as,$rs,'1 - ');
    	$s = '5';
    	$as = 0x35;
    	$rs = utf8::utf8_to_numeric($s);
    	$this->assertEquals($as,$rs,'2 - ');
    }

    public function test__one_numeric_to_utf8()
    {
    	$n = 0x1403;
    	$a = chr(0xe1).chr(0x90).chr(0x83);
    	$r = utf8::_one_numeric_to_utf8($n);
    	$this->assertEquals($a,$r);
    }
    
    public function testNumeric_to_utf8() {
    	$ns = array(0x1403,0x1403,0x1403);
    	$a = chr(0xe1).chr(0x90).chr(0x83).chr(0xe1).chr(0x90).chr(0x83).chr(0xe1).chr(0x90).chr(0x83);
    	$r = utf8::numeric_to_utf8($ns);
    	$this->assertEquals($a,$r);    	
    }
    
    public function testIs_numeric() 
    {
    	$r = is_numeric('1}Q');
    	$this->assertFalse($r,"1)");
    	$r = is_numeric('1');
    	$this->assertTrue($r,"2)");
    }
    
}


?>
