<?php

require_once 'script/Syllabics.php';

require_once "lib/log4php/Logger.php";
Logger::configure(getenv('PHP_INUKTITUT').'/log4php.properties.xml');

mb_internal_encoding('UTF-8');

/**
 * Test class for Syllabics.
 * Generated by PHPUnit on 2010-05-17 at 12:54:34.
 */
class SyllabicsTest extends PHPUnit_Framework_TestCase
{
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->object = new Syllabics;
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
    }

    public function test_is_syllabic_word ()
    {
    	$motCodes= array( 0x14EF, 0x14C2, 0x1483, 0x1433, 0x1583 ); // sinikpunga
    	$mot = utf8::numeric_to_utf8($motCodes);
    	$is_syllabic = Syllabics::is_syllabic_word($mot);
    	$attendu = true;
    	$this->assertEquals($attendu,$is_syllabic,"Cas 1.");

        $motCodes= array( 0x14EF, 0x14C2, 0x1483, 0x1433, 0x1583, 65 ); // sinikpunga
    	$mot = utf8::numeric_to_utf8($motCodes);
    	$is_syllabic = Syllabics::is_syllabic_word($mot);
    	$attendu = false;
    	$this->assertEquals($attendu,$is_syllabic,"Cas 2.");
    }
    
    public function testAlphabet_latin_a_unicode()
    {
    	$latin = 'inuit';
    	$attCodes = array( 0x1403, 0x14C4, 0x1403, 0x1466 );
    	$att = utf8::numeric_to_utf8($attCodes);
    	$syll = Syllabics::latinAlphabetToUnicode($latin,false);
    	$this->assertEquals($att,$syll,"Erreur");
    	
    	$latin = 'taima';
    	$attCodes = array( 0x144c, 0x14AA );
    	$att = utf8::numeric_to_utf8($attCodes);
    	$syll = Syllabics::latinAlphabetToUnicode($latin,true);
    	$this->assertEquals($att,$syll,"Erreur");
    }

    public function testGet_alphabet_latin_de_unicode()
    {
    	$unicode = 0x1542;
    	$latin = Syllabics::get_alphabet_latin_de_unicode($unicode);
    	$att = 'rai';
    	$this->assertEquals($att, $latin, "Erreur");
    }

    public function testUnicode_a_alphabet_latin()
    {
    	$att = 'inuit';
    	$syllCodes = array( 0x1403, 0x14C4, 0x1403, 0x1466 );
    	$syll = utf8::numeric_to_utf8($syllCodes);
    	$latin = Syllabics::unicodeToLatinAlphabet($syll);
    	$this->assertEquals($att,$latin,"Erreur");
    	
    	$att = 'taima';
    	$syllCodes = array( 0x144c, 0x14AA );
    	$syll = utf8::numeric_to_utf8($syllCodes);
    	$latin = Syllabics::unicodeToLatinAlphabet($syll);
    	$this->assertEquals($att,$latin,"Erreur");
    }

    public function testGet_aipaitai()
    {
    	$unicode = 0x14AA;
    	$att = 0x14A3;
    	$unicode_aipaitai = Syllabics::get_aipaitai($unicode);
    	$this->assertEquals($att,$unicode_aipaitai,"");
    }

    public function testUnicode_ici_a_aipaitai()
    {
    	$unicodes = array( 0x1455, 0x1403, 0x14AA ); // taima
    	$ici = utf8::numeric_to_utf8($unicodes);
    	$aipaitai = Syllabics::iciUnicodeToLatinAlphabet($ici);
    	$attCodes = array( 0x144c, 0x14AA ); // taima en aipaitai
    	$att = utf8::numeric_to_utf8($attCodes);
    	$this->assertEquals($att,$aipaitai,"Erreur");
    }

    public function test_prepare_string()
    {
    	$s = 'anngarnngi';
    	$as = 'aXarXi';
    	$rs = Syllabics::_prepare_string($s);
    	$this->assertEquals($as,$rs);
    }
}
?>
