<?php

require_once 'tools/NunHanSearch/Alignment.php';
require_once 'lib/log4php/Logger.php';
Logger::configure("../log4php.properties.xml");

/**
 * Test class for Alignment.
 * Generated by PHPUnit on 2010-05-17 at 15:52:40.
 */
class AlignmentTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Alignment
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
//         $this->object = new Alignment;
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
    }

      public function test_to_html_string__Case_query_language_is_en()
    {
    	$alignment = new Alignment(null,'inuit amma nunanga','Inuits and Their Land','en');
    	$str = $alignment->to_html_string('their land',null,null,1);
    	$expected_str = 
    	"<tr class='nhs_alignment'>\n"
    	. "<td class='no'>1</td>\n"
    	. "<td>" . 'inuit amma nunanga' . "</td>\n"
    	. "<td>" . 'Inuits and <font color=red><b>Their Land</b></font>' . "</td>\n"
    	. "<td class='no'>" . '' . "</td>\n"
    	. "</tr>\n";
    	$this->assertEquals($expected_str, $str, "Wrong html rendering of the alignment.");
    }
    
    public function test_to_html_string__Case_query_language_is_iu()
    {
    	$alignment = new Alignment(null,'inuit amma nunanga','Inuits and Their Land','iu');
    	$str = $alignment->to_html_string('nunanga',null,null,1);
    	$expected_str =
    	"<tr class='nhs_alignment'>\n"
    	. "<td class='no'>1</td>\n"
    	. "<td>" . 'inuit amma <font color=red><b>nunanga</b></font>' . "</td>\n"
    	. "<td>" . 'Inuits and Their Land' . "</td>\n"
    	. "<td class='no'>" . '' . "</td>\n"
    	. "</tr>\n";
    	$this->assertEquals($expected_str, $str, "Wrong html rendering of the alignment.");
    }
    
    public function test_highlight() {
    	$str = 'inuit amma nunanga';
    	$regexp = '\S*?nga';
    	$lang = 'iu';
    	$highlighted = Alignment::highlight($str,$regexp,$lang);
    	$expected = 'inuit amma <font color=red><b>nunanga</b></font>';
    	$this->assertEquals($expected, $highlighted, "Wrong highlighting of inuktitut text");
    }
    
    public function test_greediness() {
    	$str = 'inuit amma nunanga';
    	$replaced = preg_replace('/\S*?nga/','XXX',$str);
    	$expected = 'inuit amma XXX';
    	$this->assertEquals($expected, $replaced, "Wrong replacement");
    }
    
    
    
    
    function arrays_are_similar($a, $b) {
    	// if the indexes don't match, return immediately
    	if (count(array_diff_assoc($a, $b))) {
    		return false;
    	}
    	// we know that the indexes, but maybe not values, match.
    	// compare the values between the two arrays
    	foreach($a as $k => $v) {
    		if ($v !== $b[$k]) {
    			return false;
    		}
    	}
    	// we have identical indexes, and no unequal values
    	return true;
    }

}
?>
