<?php

require_once 'tools/NunHanSearch/Grepper.php';
require_once 'script/Syllabics.php';
require_once 'lib/log4php/Logger.php';
Logger::configure("../log4php.properties.xml");

/**
 * Test class for Grepper.
 * Generated by PHPUnit on 2010-05-17 at 15:52:40.
 */
class GrepperTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Grepper
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
//         $this->object = new Grepper;
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
    }

    public function test_escapeChars__Case_no_wildchar()
    {
    	$query_roman = 'inuit';
    	$query_syll = Syllabics::latinAlphabetToUnicode($query_roman, '0');
    	$escaped = Grepper::escapeChars($query_syll);
    	$expected = '\x{e1}\x{90}\x{83}\x{e1}\x{93}\x{84}\x{e1}\x{90}\x{83}\x{e1}\x{91}\x{a6}';
    	$this->assertEquals($expected, $escaped, "The escaping has failed.");
  	}
    
  	public function test_escapeChars__Case_wildchar_at_beginning()
  	{
  		$query_roman = 'inuit';
    	$query_syll =  '\S*?' . Syllabics::latinAlphabetToUnicode($query_roman, '0');
  		$escaped = Grepper::escapeChars($query_syll);
  		$expected = '\S*?\x{e1}\x{90}\x{83}\x{e1}\x{93}\x{84}\x{e1}\x{90}\x{83}\x{e1}\x{91}\x{a6}';
  		$this->assertEquals($expected, $escaped, "The escaping has failed.");
  	}
  	
  	public function test_escapeChars__Case_wildchar_inside()
  	{
  		$roman = 'inuit';
    	$syll = Syllabics::latinAlphabetToUnicode($roman, '0');
  		$query_syll = $syll .  '\S*?' . $syll;
  		$escaped = Grepper::escapeChars($query_syll);
  		$expected = '\x{e1}\x{90}\x{83}\x{e1}\x{93}\x{84}\x{e1}\x{90}\x{83}\x{e1}\x{91}\x{a6}\S*?\x{e1}\x{90}\x{83}\x{e1}\x{93}\x{84}\x{e1}\x{90}\x{83}\x{e1}\x{91}\x{a6}';
  		$this->assertEquals($expected, $escaped, "The escaping has failed.");
  	}
  	 
  	 
    
    function arrays_are_similar($a, $b) {
    	// if the indexes don't match, return immediately
    	if (count(array_diff_assoc($a, $b))) {
    		return false;
    	}
    	// we know that the indexes, but maybe not values, match.
    	// compare the values between the two arrays
    	foreach($a as $k => $v) {
    		if ($v !== $b[$k]) {
    			return false;
    		}
    	}
    	// we have identical indexes, and no unequal values
    	return true;
    }

}
?>
