/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Action;
import data.Morpheme;
import data.Suffix;
import data.constraints.Condition;
import data.constraints.Conditions;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Affix
extends Morpheme {
    String function = null;
    String position = null;
    String[] vform = null;
    Action[] vaction1 = null;
    Action[] vaction2 = null;
    String[] tform = null;
    Action[] taction1 = null;
    Action[] taction2 = null;
    String[] kform = null;
    Action[] kaction1 = null;
    Action[] kaction2 = null;
    String[] qform = null;
    Action[] qaction1 = null;
    Action[] qaction2 = null;

    public abstract String getTransitivityConstraint();

    public abstract void addToHash(String var1, Object var2);

    @Override
    abstract boolean agreeWithTransitivity(String var1);

    @Override
    public String getOriginalMorpheme() {
        return this.morpheme;
    }

    public boolean isNonMobileSuffix() {
        return this.getClass() == Suffix.class && ((Suffix)this).mobility != null && ((Suffix)this).mobility.equals("nm");
    }

    public void addPrecConstraint(Condition cond) {
        this.preCondition = this.preCondition == null ? (Conditions)((Object)cond) : new Condition.And((Condition)((Object)this.preCondition), cond);
    }

    @Override
    void setAttributes(HashMap attrs) {
        HashMap<String, Object> affAttrs = new HashMap<String, Object>();
        affAttrs.put("function", this.function);
        affAttrs.put("position", this.position);
        affAttrs.put("vform", this.vform);
        affAttrs.put("vaction1", this.vaction1);
        affAttrs.put("vaction2", this.vaction2);
        affAttrs.put("tform", this.tform);
        affAttrs.put("taction1", this.taction1);
        affAttrs.put("taction2", this.taction2);
        affAttrs.put("kform", this.kform);
        affAttrs.put("kaction1", this.kaction1);
        affAttrs.put("kaction2", this.kaction2);
        affAttrs.put("qform", this.qform);
        affAttrs.put("qaction1", this.qaction1);
        affAttrs.put("qaction2", this.qaction2);
        affAttrs.putAll(attrs);
        super.setAttributes(affAttrs);
    }

    String[] getForm(char context) {
        if (context == 'V' || context == 'a' || context == 'i' || context == 'u') {
            return this.vform;
        }
        if (context == 't') {
            return this.tform;
        }
        if (context == 'k') {
            return this.kform;
        }
        if (context == 'q') {
            return this.qform;
        }
        return null;
    }

    Action[] getAction1(char context) {
        if (context == 'V' || context == 'a' || context == 'i' || context == 'u') {
            return this.vaction1;
        }
        if (context == 't') {
            return this.taction1;
        }
        if (context == 'k') {
            return this.kaction1;
        }
        if (context == 'q') {
            return this.qaction1;
        }
        return null;
    }

    Action[] getAction2(char context) {
        if (context == 'V' || context == 'a' || context == 'i' || context == 'u') {
            return this.vaction2;
        }
        if (context == 't') {
            return this.taction2;
        }
        if (context == 'k') {
            return this.kaction2;
        }
        if (context == 'q') {
            return this.qaction2;
        }
        return null;
    }

    void makeFormsAndActions(String context, String morpheme, String alternateForms, String action1, String action2) {
        String allForms = null;
        if (action1.equals("-")) {
            allForms = "";
            action1 = "";
            action2 = "";
        } else if (alternateForms == null) {
            allForms = new String(morpheme);
        } else {
            alternateForms = alternateForms.replaceAll("\\x2a", morpheme);
            allForms = context.equals("V") ? String.valueOf(morpheme) + " " + alternateForms : new String(alternateForms);
        }
        StringTokenizer stf = new StringTokenizer(allForms);
        int nbf = stf.countTokens();
        StringTokenizer st1 = new StringTokenizer(action1);
        int nba1 = st1.countTokens();
        if (action2 == null) {
            action2 = new String("");
        }
        StringTokenizer st2 = new StringTokenizer(action2);
        int nba2 = st2.countTokens();
        if (nba1 > nbf && nbf == 1) {
            String initialValue = new String(allForms);
            int j = nbf;
            while (j < nba1) {
                allForms = String.valueOf(allForms) + " " + initialValue;
                ++j;
            }
            stf = new StringTokenizer(allForms);
            nbf = stf.countTokens();
        } else if (nbf > nba1 && nba1 == 1) {
            String act1 = new String(action1);
            int j = nba1;
            while (j < nbf) {
                action1 = String.valueOf(action1) + " " + act1;
                ++j;
            }
            st1 = new StringTokenizer(action1);
            nba1 = st1.countTokens();
            if (nba2 == 1) {
                String act2 = new String(action2);
                int j2 = nba2;
                while (j2 < nbf) {
                    action2 = String.valueOf(action2) + " " + act2;
                    ++j2;
                }
                st2 = new StringTokenizer(action2);
                nba2 = st2.countTokens();
            }
        }
        Vector<String> VForms = new Vector<String>();
        Vector<Action> a1V = new Vector<Action>();
        Vector<Action> a2V = new Vector<Action>();
        while (stf.hasMoreTokens()) {
            String actPos;
            String condition;
            String f = stf.nextToken();
            VForms.add(f);
            String act1 = st1.nextToken();
            Pattern pif1 = Pattern.compile("^if\\((.+),([a-z]+),([a-z]+)\\)$");
            Matcher mif1 = pif1.matcher(act1);
            Pattern pif2 = Pattern.compile("^if\\((.+),([a-z]+)\\)$");
            Matcher mif2 = pif2.matcher(act1);
            if (mif1.matches()) {
                condition = mif1.group(1).replaceAll("\\x7c", " ");
                actPos = mif1.group(2);
                String actNeg = null;
                actNeg = mif1.group(3);
                a1V.add(Action.makeAction(String.valueOf(actPos) + "si(" + condition + ")"));
                if (actNeg != null) {
                    VForms.add(f);
                    a1V.add(Action.makeAction(String.valueOf(actNeg) + "si(!(" + condition + "))"));
                }
                if (!action2.equals("")) {
                    String ac2 = st2.nextToken();
                    a2V.add(Action.makeAction(ac2));
                    a2V.add(Action.makeAction(ac2));
                    continue;
                }
                a2V.add(Action.makeAction(null));
                a2V.add(Action.makeAction(null));
                continue;
            }
            if (mif2.matches()) {
                condition = mif2.group(1).replaceAll("\\x7c", " ");
                actPos = mif2.group(2);
                a1V.add(Action.makeAction(String.valueOf(actPos) + "si(" + condition + ")"));
                if (!action2.equals("")) {
                    String ac2 = st2.nextToken();
                    a2V.add(Action.makeAction(ac2));
                    a2V.add(Action.makeAction(ac2));
                    continue;
                }
                a2V.add(Action.makeAction(null));
                a2V.add(Action.makeAction(null));
                continue;
            }
            a1V.add(Action.makeAction(act1));
            if (!action2.equals("")) {
                a2V.add(Action.makeAction(st2.nextToken()));
                continue;
            }
            a2V.add(Action.makeAction(null));
        }
        String[] forms = VForms.toArray(new String[0]);
        Action[] a1 = a1V.toArray(new Action[]{Action.makeAction()});
        Action[] a2 = a2V.toArray(new Action[]{Action.makeAction()});
        if (context.equals("V")) {
            this.vform = forms;
            this.vaction1 = a1;
            this.vaction2 = a2;
        } else if (context.equals("t")) {
            this.tform = forms;
            this.taction1 = a1;
            this.taction2 = a2;
        } else if (context.equals("k")) {
            this.kform = forms;
            this.kaction1 = a1;
            this.kaction2 = a2;
        } else if (context.equals("q")) {
            this.qform = forms;
            this.qaction1 = a1;
            this.qaction2 = a2;
        }
    }

    @Override
    public String showData() {
        StringBuffer sb = new StringBuffer();
        sb.append("vform= [");
        int i = 0;
        while (i < this.vform.length - 1) {
            sb.append(String.valueOf(this.vform[i]) + ",");
            ++i;
        }
        sb.append(String.valueOf(this.vform[i]) + "]\n");
        sb.append("vaction1= [");
        i = 0;
        while (i < this.vaction1.length - 1) {
            sb.append(this.vaction1[i] + ",");
            ++i;
        }
        sb.append(this.vaction1[i] + "]\n");
        sb.append("vaction2= [");
        i = 0;
        while (i < this.vaction2.length - 1) {
            sb.append(this.vaction2[i] + ",");
            ++i;
        }
        sb.append(this.vaction2[i] + "]\n");
        sb.append("tform= [");
        i = 0;
        while (i < this.tform.length - 1) {
            sb.append(String.valueOf(this.tform[i]) + ",");
            ++i;
        }
        sb.append(String.valueOf(this.tform[i]) + "]\n");
        sb.append("taction1= [");
        i = 0;
        while (i < this.taction1.length - 1) {
            sb.append(this.taction1[i] + ",");
            ++i;
        }
        sb.append(this.taction1[i] + "]\n");
        sb.append("taction2= [");
        i = 0;
        while (i < this.taction2.length - 1) {
            sb.append(this.taction2[i] + ",");
            ++i;
        }
        sb.append(this.taction2[i] + "]\n");
        sb.append("kform= [");
        i = 0;
        while (i < this.kform.length - 1) {
            sb.append(String.valueOf(this.kform[i]) + ",");
            ++i;
        }
        sb.append(String.valueOf(this.kform[i]) + "]\n");
        sb.append("kaction1= [");
        i = 0;
        while (i < this.kaction1.length - 1) {
            sb.append(this.kaction1[i] + ",");
            ++i;
        }
        sb.append(this.kaction1[i] + "]\n");
        sb.append("kaction2= [");
        i = 0;
        while (i < this.kaction2.length - 1) {
            sb.append(this.kaction2[i] + ",");
            ++i;
        }
        sb.append(this.kaction2[i] + "]\n");
        sb.append("qform= [");
        i = 0;
        while (i < this.qform.length - 1) {
            sb.append(String.valueOf(this.qform[i]) + ",");
            ++i;
        }
        sb.append(String.valueOf(this.qform[i]) + "]\n");
        sb.append("qaction1= [");
        i = 0;
        while (i < this.qaction1.length - 1) {
            sb.append(this.qaction1[i] + ",");
            ++i;
        }
        sb.append(this.qaction1[i] + "]\n");
        sb.append("qaction2= [");
        i = 0;
        while (i < this.qaction2.length - 1) {
            sb.append(this.qaction2[i] + ",");
            ++i;
        }
        sb.append(this.qaction2[i] + "]\n");
        return sb.toString();
    }
}

