/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Action;
import data.Affix;
import data.Base;
import data.Demonstrative;
import data.DemonstrativeEnding;
import data.LinguisticDataAbstract;
import data.NounEnding;
import data.Pronoun;
import data.Source;
import data.Suffix;
import data.SurfaceFormOfAffix;
import data.VerbEnding;
import data.VerbWord;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import script.Orthography;

public abstract class Data {
    public static HashSet finalRadInitAffHashSet = new HashSet();

    public static void makeBase(HashMap v) {
        Base x2;
        HashMap v2;
        StringTokenizer st;
        Base x = new Base(v);
        Data.addToHash(x);
        LinguisticDataAbstract.basesId.put(x.id, x);
        if (x.getVariant() != null) {
            st = new StringTokenizer(x.getVariant());
            while (st.hasMoreTokens()) {
                v2 = (HashMap)v.clone();
                v2.put("morpheme", st.nextToken());
                v2.put("variant", null);
                v2.put("nb", "-" + x.getNb());
                v2.put("originalMorpheme", x.id);
                x2 = new Base(v2);
                Data.addToHash(x2);
            }
        }
        if (x.getCompositionRoot() != null) {
            st = new StringTokenizer(x.getCompositionRoot());
            while (st.hasMoreTokens()) {
                v2 = (HashMap)v.clone();
                v2.put("morpheme", st.nextToken());
                v2.put("variant", null);
                v2.put("nb", "-" + x.getNb());
                v2.put("originalMorpheme", x.id);
                v2.put("compositionRoot", null);
                v2.put("subtype", "nc");
                x2 = new Base(v2);
                Data.addToHash(x2);
            }
        }
    }

    public static void makeDemonstrative(HashMap v) {
        Demonstrative x = new Demonstrative(v);
        Data.addToHash(x);
        LinguisticDataAbstract.basesId.put(x.id, x);
        String[] roots = x.getRoot().split(" ");
        int i = 0;
        while (i < roots.length) {
            HashMap v2 = (HashMap)v.clone();
            v2.put("morpheme", roots[i]);
            v2.put("root", roots[i]);
            Demonstrative x2 = new Demonstrative(v2, "r");
            Data.addToHash(x2);
            LinguisticDataAbstract.basesId.put(x2.id, x2);
            ++i;
        }
    }

    public static void makePronoun(HashMap v) {
        Pronoun x = new Pronoun(v);
        Data.addToHash(x);
        LinguisticDataAbstract.basesId.put(x.id, x);
        if (x.getVariant() != null) {
            StringTokenizer st = new StringTokenizer(x.getVariant());
            while (st.hasMoreTokens()) {
                HashMap v2 = (HashMap)v.clone();
                v2.put("morpheme", st.nextToken());
                v2.put("variant", null);
                v2.put("nb", "-" + x.getNb());
                v2.put("originalMorpheme", x.id);
                Pronoun x2 = new Pronoun(v2);
                Data.addToHash(x2);
            }
        }
    }

    public static void makeSuffix(HashMap v) {
        Suffix x = new Suffix(v);
        LinguisticDataAbstract.affixesId.put(x.id, x);
        Data.addToForms(x, x.morpheme);
    }

    public static void makeNounEnding(HashMap v) {
        NounEnding x = new NounEnding(v);
        LinguisticDataAbstract.affixesId.put(x.id, x);
        Data.addToForms(x, x.morpheme);
    }

    public static void makeVerbEnding(HashMap v) {
        VerbEnding x = new VerbEnding(v);
        LinguisticDataAbstract.affixesId.put(x.id, x);
        Data.addToForms(x, x.morpheme);
    }

    public static void makeDemonstrativeEnding(HashMap v) {
        DemonstrativeEnding x = new DemonstrativeEnding(v);
        LinguisticDataAbstract.affixesId.put(x.id, x);
        Data.addToForms(x, x.morpheme);
    }

    public static void makeVerbWord(HashMap v) {
        VerbWord x = new VerbWord(v);
        LinguisticDataAbstract.words.put(x.verb, x);
    }

    public static void makeSource(HashMap v) {
        Source s = new Source(v);
        LinguisticDataAbstract.sources.put(s.id, s);
    }

    public static void addToForms(DemonstrativeEnding ending, String key) {
        Data.addToForms1(new String[]{ending.morpheme}, key, ending.type, ending.id, null, new Action[]{Action.makeAction("neutre")}, new Action[]{Action.makeAction(null)});
    }

    public static void addToForms(Affix affix, String key) {
        Data.addToForms1(affix.vform, key, affix.type, affix.id, "V", affix.vaction1, affix.vaction2);
        Data.addToForms1(affix.tform, key, affix.type, affix.id, "t", affix.taction1, affix.taction2);
        Data.addToForms1(affix.kform, key, affix.type, affix.id, "k", affix.kaction1, affix.kaction2);
        Data.addToForms1(affix.qform, key, affix.type, affix.id, "q", affix.qaction1, affix.qaction2);
    }

    private static void addToForms1(String[] altForms, String key, String type, String id, String context, Action[] actions1, Action[] actions2) {
        if (altForms != null) {
            int i = 0;
            while (i < altForms.length) {
                if (!altForms[i].equals("?") && actions1[i].getType() != Action.UNKNOWN && actions2[i].getType() != Action.UNKNOWN) {
                    String form2;
                    String form = altForms[i].equals("*") ? key : altForms[i];
                    String form1 = actions1[i].surfaceForm(form = Orthography.simplifiedOrthographyLat(form));
                    if (form1 != null) {
                        form1 = Orthography.simplifiedOrthographyLat(form1);
                        SurfaceFormOfAffix newForm = new SurfaceFormOfAffix(form1, key, id, type, context, actions1[i], actions2[i]);
                        LinguisticDataAbstract.addForm(form1, newForm);
                    }
                    if ((form2 = actions2[i].surfaceForm(form)) != null) {
                        form2 = Orthography.simplifiedOrthographyLat(form2);
                        SurfaceFormOfAffix otherForm = new SurfaceFormOfAffix(form2, key, id, type, context, actions1[i], actions2[i]);
                        LinguisticDataAbstract.addForm(form2, otherForm);
                    }
                }
                ++i;
            }
        }
    }

    public static void addToHash(Base x) {
        Hashtable hash = LinguisticDataAbstract.bases;
        Vector<Base> current = null;
        try {
            current = (Vector<Base>)hash.get(x.morpheme);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (current == null) {
            current = new Vector<Base>();
        }
        current.add(x);
        hash.put(x.morpheme, current);
    }
}

