/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.LinguisticDataAbstract;
import java.util.Vector;
import utilities.Debugging;

public class Lexicon {
    static String[] consonants = new String[]{"k", "p", "q", "t"};
    static String[] consonantsSyl = new String[]{"\u14a1", "\u153e", "\u1483", "\u14ea", "\u14bb", "\u14d0", "\u1449", "\u1585", "\u1550", "\u1505", "\u1466", "\u155d", "\u15a6", "\u1596"};
    static String[] vowels = new String[]{"a", "i", "u"};
    static String[] vowelsSyl = new String[]{"\u140a", "\u1403", "\u1405"};

    public static Vector lookForForms(String term, boolean syllabic) {
        String[] vows;
        Vector termsFound = null;
        String[] cons = syllabic ? consonantsSyl : consonants;
        String[] stringArray = vows = syllabic ? vowelsSyl : vowels;
        if (term.endsWith("%*")) {
            termsFound = new Vector();
            String termWithoutPniE = term.substring(0, term.length() - 2);
            Vector termWithoutStarFound = Lexicon.lookForForms(String.valueOf(termWithoutPniE) + "*", syllabic);
            if (termWithoutStarFound != null) {
                termsFound.addAll(termWithoutStarFound);
            }
            int i = 0;
            while (i < vows.length) {
                String termWithVowel = String.valueOf(termWithoutPniE) + vows[i] + "*";
                Vector termFound = Lexicon.lookForForms(termWithVowel, syllabic);
                if (termFound != null) {
                    termsFound.addAll(termFound);
                }
                ++i;
            }
            if (termsFound.size() == 0) {
                termsFound = null;
            }
        } else if (term.endsWith("*")) {
            termsFound = new Vector();
            String termWithoutStar = term.substring(0, term.length() - 1);
            int i = 0;
            while (i < cons.length) {
                String termWithConsonant = String.valueOf(termWithoutStar) + cons[i];
                Vector termFound = Lexicon.lookForForms(termWithConsonant, syllabic);
                if (termFound != null) {
                    termsFound.addAll(termFound);
                }
                ++i;
            }
            if (termsFound.size() == 0) {
                termsFound = null;
            }
        } else {
            termsFound = LinguisticDataAbstract.getSurfaceForms(term);
        }
        return termsFound;
    }

    public static Vector lookForBase(String term, boolean syllabic) {
        Vector termsFound;
        String[] vows;
        Debugging.mess("lookForBase/2", 1, "> term= " + term + "  syllabic=" + syllabic);
        String[] cons = syllabic ? consonantsSyl : consonants;
        String[] stringArray = vows = syllabic ? vowelsSyl : vowels;
        if (term.endsWith("%*")) {
            termsFound = new Vector();
            String termWithoutPniE = term.substring(0, term.length() - 2);
            Vector termWithoutStarFound = Lexicon.lookForBase(String.valueOf(termWithoutPniE) + "*", syllabic);
            if (termWithoutStarFound != null) {
                termsFound.addAll(termWithoutStarFound);
            }
            int i = 0;
            while (i < vows.length) {
                String termWithVowel = String.valueOf(termWithoutPniE) + vows[i] + "*";
                Vector termFound = Lexicon.lookForBase(termWithVowel, syllabic);
                if (termFound != null) {
                    termsFound.addAll(termFound);
                }
                ++i;
            }
            if (termsFound.size() == 0) {
                termsFound = null;
            }
        } else if (term.endsWith("*")) {
            termsFound = new Vector();
            String termWithoutStar = term.substring(0, term.length() - 1);
            Vector termWithoutStarFound = Lexicon.lookForBase(termWithoutStar, syllabic);
            if (termWithoutStarFound != null) {
                termsFound.addAll(termWithoutStarFound);
            }
            int i = 0;
            while (i < cons.length) {
                String termWithConsonant = String.valueOf(termWithoutStar) + cons[i];
                Vector termFound = Lexicon.lookForBase(termWithConsonant, syllabic);
                if (termFound != null) {
                    termsFound.addAll(termFound);
                }
                ++i;
            }
            if (termsFound.size() == 0) {
                termsFound = null;
            }
        } else {
            termsFound = LinguisticDataAbstract.getBases(term);
        }
        Debugging.mess("lookForBase/2", 1, "termsFound= " + termsFound);
        return termsFound;
    }
}

