/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Affix;
import data.Base;
import data.Data;
import data.Demonstrative;
import data.Example;
import data.Examples;
import data.Inchoative;
import data.Morpheme;
import data.Source;
import data.Suffix;
import data.SurfaceFormOfAffix;
import data.VerbWord;
import dataCSV.LinguisticDataCSV;
import dataCompiled.LinguisticDataCompiled;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import phonology.Dialect;
import script.Orthography;
import script.Roman;
import utilities.MyStringTokenizer;

public abstract class LinguisticDataAbstract {
    static Hashtable affixesExp = new Hashtable();
    static Hashtable surfaceFormsOfAffixesExp = new Hashtable();
    static Hashtable textualRenderings;
    static Hashtable examples;
    static LinguisticDataAbstract database;
    protected static Hashtable surfaceFormsOfAffixes;
    protected static Hashtable bases;
    protected static Hashtable basesId;
    protected static Hashtable affixesId;
    protected static Hashtable words;
    protected static Hashtable sources;
    public static Hashtable groupsOfConsonants;

    static {
        groupsOfConsonants = new Hashtable();
    }

    public static boolean init() {
        return LinguisticDataAbstract.init(null, null);
    }

    public static boolean init(String source) {
        return LinguisticDataAbstract.init(source, null);
    }

    public static boolean init(String source, String type) {
        if (source != null && !source.equals("csv") && !source.equals("compiled")) {
            return false;
        }
        if (type != null && !type.equals("r") && !type.equals("s")) {
            return false;
        }
        LinguisticDataAbstract.makeHashOfTextualRenderings();
        LinguisticDataAbstract.makeHashOfExamples();
        if (source == null || source.equals("compiled")) {
            database = new LinguisticDataCompiled(type);
        } else if (source.equals("csv")) {
            database = new LinguisticDataCSV(type);
        }
        if (type == null || type.equals("s")) {
            Inchoative spec = new Inchoative();
            affixesId.put(spec.id, spec);
            Data.addToForms(spec, spec.morpheme);
        }
        LinguisticDataAbstract.makeGroupsOfConsonants();
        return true;
    }

    private static void makeGroupsOfConsonants() {
        int i;
        String[] keys;
        if (bases != null) {
            keys = LinguisticDataAbstract.getAllBasesKeys();
            i = 0;
            while (i < keys.length) {
                String key = Orthography.simplifiedOrthographyLat(keys[i]);
                LinguisticDataAbstract.groupsOfConsonants(key);
                ++i;
            }
        }
        if (surfaceFormsOfAffixes != null) {
            String[] forms = LinguisticDataAbstract.getAllAffixesSurfaceFormsKeys();
            i = 0;
            while (i < forms.length) {
                LinguisticDataAbstract.groupsOfConsonants(forms[i]);
                ++i;
            }
        }
        keys = Dialect.getKeys();
        i = 0;
        while (i < keys.length) {
            LinguisticDataAbstract.groupsOfConsonants(keys[i]);
            ++i;
        }
    }

    private static void groupsOfConsonants(String str) {
        char[] chars = str.toCharArray();
        int i = 0;
        while (i < chars.length - 1) {
            if (Roman.isConsonant(chars[i]) && Roman.isConsonant(chars[i + 1])) {
                String newGr;
                Character charac = new Character(chars[i + 1]);
                Vector grCons = groupsOfConsonants.containsKey(charac) ? (Vector)groupsOfConsonants.get(charac) : new Vector();
                if (!grCons.contains(newGr = new String(new char[]{chars[i], chars[i + 1]}))) {
                    grCons.add(newGr);
                }
                groupsOfConsonants.put(charac, grCons);
            }
            ++i;
        }
    }

    public static Morpheme getMorpheme(String morphId) {
        Morpheme morph = LinguisticDataAbstract.getBase(morphId);
        if (morph == null) {
            morph = LinguisticDataAbstract.getAffix(morphId);
        }
        return morph;
    }

    public static Affix getAffix(String uniqueId) {
        Affix aff = (Affix)affixesId.get(uniqueId);
        return aff;
    }

    public static Suffix getSuffix(String uniqueId) {
        Suffix afs = (Suffix)affixesId.get(uniqueId);
        return afs;
    }

    protected static VerbWord getVerbWord(String term) {
        VerbWord mv = (VerbWord)words.get(term);
        return mv;
    }

    protected static Source getSource(String sourceId) {
        Source s = (Source)sources.get(sourceId);
        return s;
    }

    public static Vector getBases(String term) {
        Vector bs = null;
        Vector gets = (Vector)bases.get(term);
        if (gets != null) {
            bs = (Vector)gets.clone();
        }
        return bs;
    }

    protected static Vector getExample(String key) {
        Vector ex = (Vector)examples.get(key);
        return ex;
    }

    public static Base getBase(String morphId) {
        Base b = null;
        if (basesId != null) {
            b = (Base)basesId.get(morphId);
        }
        return b;
    }

    protected static Base getBase(Morpheme.Id morphId) {
        Base b = null;
        if (basesId != null) {
            b = (Base)basesId.get(morphId.id);
        }
        return b;
    }

    public static Vector getSurfaceForms(String form) {
        String simplifiedForm = Orthography.simplifiedOrthographyLat(form);
        return (Vector)surfaceFormsOfAffixes.get(simplifiedForm);
    }

    public static SurfaceFormOfAffix getForm(String morph) {
        return (SurfaceFormOfAffix)LinguisticDataAbstract.getSurfaceForms(morph).elementAt(0);
    }

    protected static void addForm(String str, Object form) {
        String simplifiedForm = Orthography.simplifiedOrthographyLat(str);
        Vector<Object> v = (Vector<Object>)surfaceFormsOfAffixes.get(simplifiedForm);
        if (v == null) {
            v = new Vector<Object>();
        }
        v.add(form);
        surfaceFormsOfAffixes.put(simplifiedForm, v);
    }

    protected static String[] getAllExamplesKeys() {
        return examples.keySet().toArray(new String[0]);
    }

    public static String[] getAllAffixesSurfaceFormsKeys() {
        return surfaceFormsOfAffixes.keySet().toArray(new String[0]);
    }

    protected static Hashtable getAllSuffixes() {
        Hashtable hash = Suffix.hash;
        if (hash.size() == 0) {
            Enumeration keys = affixesId.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Affix aff = (Affix)affixesId.get(key);
                aff.addToHash((String)key, aff);
            }
        }
        return Suffix.hash;
    }

    public static String[] getAllBasesIds() {
        return basesId.keySet().toArray(new String[0]);
    }

    public static String[] getAllAffixesIds() {
        return affixesId.keySet().toArray(new String[0]);
    }

    public static String[] getAllSuffixesIds() {
        Hashtable suffixes = LinguisticDataAbstract.getAllSuffixes();
        String[] suffixesIds = new String[suffixes.size()];
        int i = 0;
        Enumeration keys = suffixes.keys();
        while (keys.hasMoreElements()) {
            Suffix suf = (Suffix)suffixes.get(keys.nextElement());
            suffixesIds[i++] = suf.id;
        }
        return suffixesIds;
    }

    protected static String[] getAllVerbWords() {
        return words.keySet().toArray(new String[0]);
    }

    protected static String[] getAllSources() {
        return sources.keySet().toArray(new String[0]);
    }

    protected static Hashtable getAllRoots() {
        Base sample = new Base();
        Class<?> clazz = sample.getClass();
        Hashtable hash = Base.hash;
        if (hash.size() == 0) {
            Enumeration keys = basesId.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object obj = basesId.get(key);
                if (obj.getClass() != clazz) continue;
                Base root = (Base)basesId.get(key);
                root.addToHash((String)key, root);
            }
        }
        return Base.hash;
    }

    protected static String[] getAllBasesKeys() {
        return bases.keySet().toArray(new String[0]);
    }

    protected static Base[] getGiVerbs() {
        Hashtable giverbsHash = new Hashtable();
        Hashtable bases = LinguisticDataAbstract.getAllRoots();
        Enumeration keys = bases.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Base base = (Base)bases.get(key);
            if (!base.isGiVerb()) continue;
            giverbsHash.put(key, base);
        }
        Object[] giverbsKeysArray = giverbsHash.keySet().toArray(new String[0]);
        Arrays.sort(giverbsKeysArray);
        Base[] giverbs = new Base[giverbsKeysArray.length];
        int i = 0;
        while (i < giverbsKeysArray.length) {
            giverbs[i] = (Base)giverbsHash.get(giverbsKeysArray[i]);
            ++i;
        }
        return giverbs;
    }

    protected static Hashtable getAllDemonstratives() {
        Demonstrative sample = new Demonstrative();
        Class<?> clazz = sample.getClass();
        Hashtable hash = Demonstrative.hash;
        if (hash.size() == 0) {
            Enumeration keys = basesId.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object obj = basesId.get(key);
                if (obj.getClass() != clazz) continue;
                Demonstrative dem = (Demonstrative)basesId.get(key);
                dem.addToHash((String)key, dem);
            }
        }
        return Demonstrative.hash;
    }

    protected static String getTextualRendering(String key, String lang) {
        return LinguisticDataAbstract._getTextualRendering(key, lang);
    }

    protected static String getTextualRendering(String key, String lang, String additionalText, int position) {
        String keyPlus;
        Object valPlus;
        String res = LinguisticDataAbstract._getTextualRendering(key, lang);
        if (additionalText != null) {
            res = position == 0 ? String.valueOf(additionalText) + " " + res : String.valueOf(res) + " " + additionalText;
        }
        if ((valPlus = textualRenderings.get(keyPlus = String.valueOf(key) + "+")) != null) {
            String[] textualRenderingsPlus = (String[])valPlus;
            res = String.valueOf(res) + ".  " + (lang.equals("en") ? textualRenderingsPlus[0] : textualRenderingsPlus[1]);
        }
        return res;
    }

    protected static String _getTextualRendering(String key, String lang) {
        Object val = textualRenderings.get(key);
        String res = null;
        if (val == null) {
            res = "";
        } else {
            String[] txt = (String[])val;
            res = lang.equals("en") ? txt[0] : txt[1];
        }
        return res;
    }

    private static boolean makeHashOfTextualRenderings() {
        textualRenderings = new Hashtable();
        textualRenderings.put("dec", new String[]{"declarative", "d\u00c3\u00a9claratif"});
        textualRenderings.put("int", new String[]{"interrogative", "interrogatif"});
        textualRenderings.put("imp", new String[]{"imperative", "imp\u00c3\u00a9ratif"});
        textualRenderings.put("part", new String[]{"participle", "participe"});
        textualRenderings.put("prespas", new String[]{"present and past", "pr\u00c3\u00a9sent et pass\u00c3\u00a9"});
        textualRenderings.put("fut", new String[]{"future", "futur"});
        textualRenderings.put("pos", new String[]{"positive", "positif"});
        textualRenderings.put("neg", new String[]{"negative", "n\u00c3\u00a9gatif"});
        textualRenderings.put("caus", new String[]{"becausative", "causatif"});
        textualRenderings.put("freq", new String[]{"frequentative", "fr\u00c3\u00a9quentatif"});
        textualRenderings.put("cond", new String[]{"conditional", "conditionnel"});
        textualRenderings.put("dub", new String[]{"dubitative", "dubitatif"});
        textualRenderings.put("tv", new String[]{"verbal ending", "terminaison verbale"});
        textualRenderings.put("q", new String[]{"tail suffix", "suffixe de queue"});
        textualRenderings.put("tn", new String[]{"noun ending", "terminaison nominale"});
        textualRenderings.put("sv", new String[]{"verbal suffix", "suffixe verbal"});
        textualRenderings.put("sn", new String[]{"noun suffix", "suffixe nominal"});
        textualRenderings.put("function", new String[]{"producing a", "produisant un"});
        textualRenderings.put("vv", new String[]{"verb-to-verb", "verbe-\u00c3\u00a0-verbe"});
        textualRenderings.put("nv", new String[]{"noun-to-verb", "nom-\u00c3\u00a0-verbe"});
        textualRenderings.put("vn", new String[]{"verb-to-noun", "verbe-\u00c3\u00a0-nom"});
        textualRenderings.put("nn", new String[]{"noun-to-noun", "nom-\u00c3\u00a0-nom"});
        textualRenderings.put("nsp", new String[]{"non-specific", "non-sp\u00c3\u00a9cifique"});
        textualRenderings.put("sp", new String[]{"specific", "sp\u00c3\u00a9cifique"});
        textualRenderings.put("s", new String[]{"singular", "singulier"});
        textualRenderings.put("d", new String[]{"dual", "duel"});
        textualRenderings.put("p", new String[]{"plural", "plural"});
        textualRenderings.put("n", new String[]{"noun", "nom"});
        textualRenderings.put("v", new String[]{"verb", "verbe"});
        textualRenderings.put("a", new String[]{"adverb", "adverbe"});
        textualRenderings.put("e", new String[]{"expression or exclamation", "expression ou exclamation"});
        textualRenderings.put("c", new String[]{"conjunction", "conjonction"});
        textualRenderings.put("pr", new String[]{"pronoun", "pronom"});
        textualRenderings.put("m", new String[]{"medial", "m\u00c3\u00a9diane"});
        textualRenderings.put("t", new String[]{"terminal", "terminale"});
        textualRenderings.put("f", new String[]{"final", "finale"});
        textualRenderings.put("V", new String[]{"vowel", "voyelle"});
        textualRenderings.put("C", new String[]{"consonant", "consonne"});
        textualRenderings.put("VV", new String[]{"vowels", "voyelles"});
        textualRenderings.put("VC", new String[]{"vowel or consonant", "voyelle ou consonne"});
        textualRenderings.put("1ordinal", new String[]{"1st", "1\u00c3\u00a8re"});
        textualRenderings.put("2ordinal", new String[]{"2nd", "2\u00c3\u00a8me"});
        textualRenderings.put("3ordinal", new String[]{"3rd", "3\u00c3\u00a8me"});
        textualRenderings.put("4ordinal", new String[]{"4th", "4\u00c3\u00a8me"});
        textualRenderings.put("personne", new String[]{"person", "personne"});
        textualRenderings.put("nom", new String[]{"nominative", "nominatif"});
        textualRenderings.put("gen", new String[]{"genitive", "g\u00c3\u00a9nitif"});
        textualRenderings.put("acc", new String[]{"accusative", "accusatif"});
        textualRenderings.put("abl", new String[]{"ablative", "ablatif"});
        textualRenderings.put("dat", new String[]{"dative", "datif"});
        textualRenderings.put("loc", new String[]{"locative", "locatif"});
        textualRenderings.put("sim", new String[]{"similaris", "similaris"});
        textualRenderings.put("via", new String[]{"vialis", "vialis"});
        textualRenderings.put("possessif", new String[]{"possessive", "possessif"});
        textualRenderings.put("possesseur", new String[]{"Possessor", "Possesseur"});
        textualRenderings.put("vt", new String[]{"transtitive", "transitif"});
        textualRenderings.put("vt1", new String[]{"transtitive", "transitif"});
        textualRenderings.put("vt2", new String[]{"transtitive", "transitif"});
        textualRenderings.put("vi", new String[]{"intransitive", "transitive"});
        textualRenderings.put("va", new String[]{"adjectival", "adjectif"});
        textualRenderings.put("ve", new String[]{"emotion, feeling", "d'\u00c3\u00a9motion,de sentiment"});
        textualRenderings.put("vres", new String[]{"result", "de r\u00c3\u00a9sultat"});
        textualRenderings.put("vres+", new String[]{"When this kind of verb is used transitively, the thing upon which the action is done is the object of the verb.  When it is used intransitively, that thing is the subject of the verb.  Similar verbs in English: to boil, to shatter.", "Quand ce type de verbe est utilis\u00c3\u00a9 transitivement, la chose sur laquelle porte l'action est l'objet du verbe.  Quand il est utilis\u00c3\u00a9 intransitivement, cette chose est le sujet du verbe."});
        textualRenderings.put("m!", new String[]{"must be followed by another suffix, i.e. it cannot occur in word-final position", "doit \u00c3\u00aatre suivi d'un autre suffixe, i.e. il ne peut pas se trouver \u00c3\u00a0 la fin d'un mot"});
        textualRenderings.put("f!", new String[]{"occurs only in word-final position, i.e. it cannot be followed by another suffix", "ne peut se trouver qu'\u00c3\u00a0 la fin d'un mot, i.e. il ne peut pas \u00c3\u00aatre suivi d'un autre suffixe"});
        textualRenderings.put("t!", new String[]{"may occur in word-final position, but may also be followed by additional suffixes", "peut se trouver \u00c3\u00a0 la fin d'un mot, mais peut cependant \u00c3\u00aatre suivi d'autres suffixes"});
        textualRenderings.put("neutre", new String[]{"does not affect", "n'affecte pas"});
        textualRenderings.put("suppr", new String[]{"deletes", "supprime"});
        textualRenderings.put("suppr1", new String[]{"is deleted", "est supprim\u00c3\u00a9"});
        textualRenderings.put("nasal", new String[]{"nasalizes", "nasalise"});
        textualRenderings.put("nasal1", new String[]{"is nasalized to", "est nasalis\u00c3\u00a9 en"});
        textualRenderings.put("sonor", new String[]{"vocalizes", "sonorise"});
        textualRenderings.put("assim", new String[]{"assimilates", "assimile"});
        textualRenderings.put("assim2", new String[]{"to", "pr\u00c3\u00a9c\u00c3\u00a9dent \u00c3\u00a0"});
        textualRenderings.put("allonge", new String[]{"lengthens", "allonge"});
        textualRenderings.put("fusion", new String[]{"fusions", "fusionne"});
        textualRenderings.put("sonor", new String[]{"vocalizes", "sonorise"});
        textualRenderings.put("sur", new String[]{"on", "sur"});
        textualRenderings.put("en", new String[]{"into", "en"});
        textualRenderings.put("au", new String[]{"to the", "au"});
        textualRenderings.put("du", new String[]{"of the", "du"});
        textualRenderings.put("\u00c3\u00a0", new String[]{"to", "\u00c3\u00a0"});
        textualRenderings.put("avec", new String[]{"with", "avec"});
        textualRenderings.put("voyellefinale", new String[]{"end vowel", "voyelle finale"});
        textualRenderings.put("finale", new String[]{"final", "finale"});
        textualRenderings.put("le", new String[]{"the", "le"});
        textualRenderings.put("la", new String[]{"the", "la"});
        textualRenderings.put("duradical", new String[]{"of the stem", "du radical"});
        textualRenderings.put("dusuffixe", new String[]{"of the suffix", "du suffixe"});
        textualRenderings.put("ins1", new String[]{"inserts", "ins\u00c3\u00a9re"});
        textualRenderings.put("devantsuffixe", new String[]{"in front of the suffix", "devant le suffixe"});
        textualRenderings.put("derniereVoyelle", new String[]{"last vowel", "derni\u00c3\u00a8re voyelle"});
        textualRenderings.put("casVV", new String[]{"the stem ends with 2 vowels", "le radical se termine par 2 voyelles"});
        textualRenderings.put("supprv2", new String[]{"the second vowel is deleted", "la seconde voyelle est supprim\u00c3\u00a9e"});
        textualRenderings.put("apr\u00c3\u00a8s", new String[]{"After", "Apr\u00c3\u00a8s"});
        textualRenderings.put("une", new String[]{"a", "une"});
        textualRenderings.put("deux", new String[]{"two", "deux"});
        textualRenderings.put("il", new String[]{"it", "il"});
        textualRenderings.put("et", new String[]{"and", "et"});
        textualRenderings.put("si", new String[]{"if", "si"});
        textualRenderings.put("estSing", new String[]{"is", "est"});
        textualRenderings.put("l'", new String[]{"the", "l'"});
        textualRenderings.put("inconnue", new String[]{"unknown", "inconnue"});
        textualRenderings.put("A1", new String[]{"Alex Spalding, \"Inuktitut - A Grammar of North Baffin Dialects\", Wuerz Publishing Ltd., Winnipeg, 1992", "Alex Spalding, \"Inuktitut - A Grammar of North Baffin Dialects\", Wuerz Publishing Ltd., Winnipeg, 1992"});
        textualRenderings.put("A2", new String[]{"A. Spalding, \"Inuktitut - A Multi-dialectal Outline Dictionary (with an Aivilingmiutaq base)\", Nunavut Arctic College, 1998", "A. Spalding, \"Inuktitut - A Multi-dialectal Outline Dictionary (with an Aivilingmiutaq base)\", Nunavut Arctic College, 1998"});
        textualRenderings.put("H1", new String[]{"Kenn Harper, \"Suffixes of the Eskimo dialects of Cumberland Peninsula and North Baffin Island\", National Museum of Man, Mercury Series, Canadian Ethnology Service, Paper no. 54, Ottawa, 1979", "Kenn Harper, \"Suffixes of the Eskimo dialects of Cumberland Peninsula and North Baffin Island\", Mus\u00c3\u00a9e national de l'Homme, Collecion Mercure, Service canadien d'ethnologie, Dossier no. 54, Ottawa, 1979"});
        textualRenderings.put("H2", new String[]{"Kenn Harper, \"Some aspects of the grammar of the Eskimo dialects of Cumberland Peninsula and North Baffin Island\", National Museum of Man, Mercury Series, Ethnology Division, Paper no. 15, Ottawa, 1974", "Kenn Harper, \"Some aspects of the grammar of the Eskimo dialects of Cumberland Peninsula and North Baffin Island\", Mus\u00c3\u00a9e national de l'Homme, Collection Mercure, Division d'ethnologie, Dossier no. 15, Ottawa, 1974"});
        textualRenderings.put("M1", new String[]{"M. Mallon, \"Introductory Inuktitut Reference Grammar version 2.1\", Nunavut Arctic College, Ittukuluuk Language Programs, Iqaluit & Victoria, 1995", "M. Mallon, \"Introductory Inuktitut Reference Grammar version 2.1\", Nunavut Arctic College, Ittukuluuk Language Programs, Iqaluit & Victoria, 1995"});
        textualRenderings.put("Hnsrd", new String[]{"Hansards of Nunavut", "Hansards du Nunavut"});
        textualRenderings.put("S1", new String[]{"L. Schneider, \"Dictionnaire des infixes de la langue eskimaude\", Minist\u00ef\u00bf\u00bdre des Affaires culturelles, Direction g\u00c3\u00a9n\u00c3\u00a9rale du Patrimoine, Dossier 43, 1979", "L. Schneider, \"Dictionnaire des infixes de la langue eskimaude\", Minist\u00ef\u00bf\u00bdre des Affaires culturelles, Direction g\u00c3\u00a9n\u00c3\u00a9rale du Patrimoine, Dossier 43, 1979"});
        textualRenderings.put("S2", new String[]{"L. Schneider, \"Ulirnaisigutiit - An Inuktitut-English Dictionary of Northern Quebec, Labrador and Eastern Arctic Dialects\", Les Presses de l'Universit\u00c3\u00a9 Laval, Qu\u00c3\u00a9bec, 1985", "L. Schneider, \"Ulirnaisigutiit - An Inuktitut-English Dictionary of Northern Quebec, Labrador and Eastern Arctic Dialects\", Les Presses de l'Universit\u00c3\u00a9 Laval, Qu\u00c3\u00a9bec, 1985"});
        return true;
    }

    private static boolean makeHashOfExamples() {
        try {
            BufferedReader r = null;
            InputStream is = new Examples().getExampleStream();
            if (is != null) {
                InputStreamReader isr;
                try {
                    isr = new InputStreamReader(is, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    isr = new InputStreamReader(is);
                }
                r = new BufferedReader(isr);
            }
            examples = new Hashtable();
            boolean eof = false;
            while (r != null && !eof) {
                String line = r.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                MyStringTokenizer mst = new MyStringTokenizer(line, ' ', '\"');
                Vector<Object> v = new Vector<Object>();
                String term = null;
                String id = null;
                while (mst.hasMoreTokens()) {
                    v.add(mst.nextToken());
                }
                if (v.size() == 0) continue;
                if (((String)v.elementAt(0)).equals("*")) {
                    v.setElementAt(term, 0);
                    v.setElementAt(id, 1);
                } else {
                    term = (String)v.elementAt(0);
                    id = (String)v.elementAt(1);
                }
                Example ex = new Example(v);
                String key = String.valueOf(term) + id;
                Vector<Example> current = (Vector<Example>)examples.get(key);
                if (current == null) {
                    current = new Vector<Example>();
                }
                current.add(ex);
                examples.put(key, current);
            }
            if (r != null) {
                r.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return true;
    }
}

