/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.LinguisticDataAbstract;
import data.SurfaceFormOfAffix;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import script.Orthography;

public class ListMorphemes {
    public static void main(String[] args) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter("ressources/morphemes.txt"));
            LinguisticDataAbstract.init("csv");
            Object[] bases = LinguisticDataAbstract.getAllBasesKeys();
            Arrays.sort(bases);
            bw.write("Roots (simple & composite), including demonstratives:");
            bw.newLine();
            int i = 0;
            while (i < bases.length) {
                bw.write(Orthography.simplifiedOrthographyLat((String)bases[i]));
                bw.newLine();
                ++i;
            }
            bw.newLine();
            bw.flush();
            Vector<Object> suffixesV = new Vector<Object>();
            Vector<Object> endingsV = new Vector<Object>();
            Object[] affixes = LinguisticDataAbstract.getAllAffixesSurfaceFormsKeys();
            Arrays.sort(affixes);
            int i2 = 0;
            while (i2 < affixes.length) {
                Vector vecForms = LinguisticDataAbstract.getSurfaceForms((String)affixes[i2]);
                int j = 0;
                while (j < vecForms.size()) {
                    SurfaceFormOfAffix fa = (SurfaceFormOfAffix)vecForms.elementAt(j);
                    if (fa.type.equals("sn") || fa.type.equals("sv") || fa.type.equals("q")) {
                        if (!suffixesV.contains(affixes[i2])) {
                            suffixesV.add(affixes[i2]);
                        }
                    } else if (fa.type.equals("tn") || fa.type.equals("tv") || fa.type.equals("td") || fa.type.equals("tpd") || fa.type.equals("tad")) {
                        if (!endingsV.contains(affixes[i2])) {
                            endingsV.add(affixes[i2]);
                        }
                    } else {
                        System.out.println("??? " + (String)affixes[i2] + " (" + fa.type + ")");
                    }
                    ++j;
                }
                ++i2;
            }
            Object[] suffixes = suffixesV.toArray(new String[0]);
            Object[] endings = endingsV.toArray(new String[0]);
            Arrays.sort(suffixes);
            Arrays.sort(endings);
            bw.write("Infixes:");
            bw.newLine();
            int i3 = 0;
            while (i3 < suffixes.length) {
                bw.write((String)suffixes[i3]);
                bw.newLine();
                ++i3;
            }
            bw.newLine();
            bw.flush();
            bw.write("Endings:");
            bw.newLine();
            i3 = 0;
            while (i3 < endings.length) {
                bw.write((String)endings[i3]);
                bw.newLine();
                ++i3;
            }
            bw.newLine();
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

