/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Affix;
import data.constraints.Conditions;
import data.constraints.Imacond;
import data.constraints.ParseException;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Suffix
extends Affix {
    String nb;
    String transitivity;
    String antipassive;
    String nature;
    String constraintOnTransitivity = null;
    String pl;
    String mobility;
    static Class conditionClass = null;
    public static Hashtable hash = new Hashtable();
    static String[] functions = new String[]{"nn", "nv", "vn", "vv"};

    public Suffix() {
    }

    public Suffix(HashMap v) {
        String comb;
        String srcs;
        this.morpheme = (String)v.get("morpheme");
        this.nb = (String)v.get("nb");
        this.num = new Integer(this.nb);
        this.transitivity = (String)v.get("transitivity");
        this.nature = (String)v.get("nature");
        this.antipassive = (String)v.get("antipassive");
        this.type = (String)v.get("type");
        this.function = (String)v.get("function");
        this.position = (String)v.get("position");
        this.constraintOnTransitivity = (String)v.get("condPrecTrans");
        this.pl = (String)v.get("plural");
        this.mobility = (String)v.get("mobility");
        String form = (String)v.get("V-form");
        String act1 = (String)v.get("V-action1");
        String act2 = (String)v.get("V-action2");
        this.makeFormsAndActions("V", this.morpheme, form, act1, act2);
        form = (String)v.get("t-form");
        act1 = (String)v.get("t-action1");
        act2 = (String)v.get("t-action2");
        this.makeFormsAndActions("t", this.morpheme, form, act1, act2);
        form = (String)v.get("k-form");
        act1 = (String)v.get("k-action1");
        act2 = (String)v.get("k-action2");
        this.makeFormsAndActions("k", this.morpheme, form, act1, act2);
        form = (String)v.get("q-form");
        act1 = (String)v.get("q-action1");
        act2 = (String)v.get("q-action2");
        this.makeFormsAndActions("q", this.morpheme, form, act1, act2);
        this.englishMeaning = (String)v.get("engMean");
        this.frenchMeaning = (String)v.get("freMean");
        this.dbName = (String)v.get("dbName");
        this.tableName = (String)v.get("tableName");
        String cs = (String)v.get("condPrec");
        if (cs == null || cs.equals("")) {
            if (this.type.equals("sn") && this.function.equals("nv")) {
                String condStr = "!type:tn,!(type:n,number:d),!(type:n,number:p)";
                try {
                    this.preCondition = (Conditions)((Object)new Imacond(new ByteArrayInputStream(condStr.getBytes())).ParseCondition());
                }
                catch (ParseException parseException) {}
            }
        } else {
            try {
                this.preCondition = (Conditions)((Object)new Imacond(new ByteArrayInputStream(cs.getBytes())).ParseCondition());
            }
            catch (ParseException condStr) {
                // empty catch block
            }
        }
        if ((cs = (String)v.get("condOnNext")) != null && !cs.equals("")) {
            try {
                this.nextCondition = (Conditions)((Object)new Imacond(new ByteArrayInputStream(cs.getBytes())).ParseCondition());
            }
            catch (ParseException condStr) {
                // empty catch block
            }
        }
        if ((srcs = (String)v.get("sources")) != null) {
            StringTokenizer st2 = new StringTokenizer(srcs);
            this.sources = new String[st2.countTokens()];
            int n = 0;
            while (st2.hasMoreTokens()) {
                this.sources[n++] = st2.nextToken();
            }
        }
        if ((comb = (String)v.get("combination")) != null && !comb.equals("")) {
            this.combinedMorphemes = comb.split("[+]");
            if (this.combinedMorphemes.length < 2) {
                this.combinedMorphemes = null;
            }
        }
        this.setAttrs();
    }

    @Override
    public void addToHash(String key, Object obj) {
        hash.put(key, obj);
    }

    @Override
    public String getSignature() {
        return String.valueOf(this.nb) + (this.type.equals("q") ? this.type : this.function);
    }

    @Override
    public String getTransitivityConstraint() {
        return this.constraintOnTransitivity;
    }

    @Override
    boolean agreeWithTransitivity(String trans) {
        if (trans == null) {
            return true;
        }
        if (this.transitivity == null || this.transitivity.equals("n")) {
            return true;
        }
        if (this.transitivity.equals("t") && trans.equals("t")) {
            return true;
        }
        if (this.transitivity.equals("i") && (trans.equals("i") || trans.equals("t") && this.nature != null && this.nature.equals("t"))) {
            return true;
        }
        return this.transitivity.equals("t") && trans.equals("i") && this.antipassive != null;
    }

    boolean is_the_same_affix(Affix aff) {
        if (this.morpheme.equals(aff.morpheme) && this.type.equals(aff.type)) {
            if (this.type.equals("q")) {
                return true;
            }
            return this.function.equals(aff.function);
        }
        return false;
    }

    boolean needsAntipassive(String apId) {
        if (this.antipassive != null) {
            StringTokenizer st = new StringTokenizer(this.antipassive);
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(apId)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    void setAttrs() {
        this.setAttributes();
        this.setId();
    }

    void setAttributes() {
        HashMap<String, String> suffAttrs = new HashMap<String, String>();
        suffAttrs.put("nb", this.nb);
        suffAttrs.put("transitivity", this.transitivity);
        suffAttrs.put("antipassive", this.antipassive);
        suffAttrs.put("nature", this.nature);
        suffAttrs.put("constraintOnTransitivity", this.constraintOnTransitivity);
        suffAttrs.put("pl", this.pl);
        super.setAttributes(suffAttrs);
    }

    @Override
    public String showData() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Suffix:\n");
        sb.append("morpheme= " + this.morpheme + "\n");
        sb.append("nb: " + this.nb + "\n");
        sb.append("type= " + this.type + "\n");
        sb.append("function= " + this.function + "\n");
        sb.append("position= " + this.position + "\n");
        sb.append("antipassive= " + this.antipassive + "\n");
        sb.append(super.showData());
        if (this.preCondition != null) {
            sb.append("precedingSpecificCondition= " + this.preCondition.toString() + "\n");
        }
        if (this.nextCondition != null) {
            sb.append("followingSpecificConditions= " + this.nextCondition.toString() + "\n");
        }
        sb.append("englishMeaning= " + this.englishMeaning + "\n");
        sb.append("tableName= " + this.tableName + "\n");
        sb.append("sources= ");
        if (this.sources == null) {
            sb.append(this.sources);
        } else {
            int n = 0;
            while (n < this.sources.length) {
                sb.append(String.valueOf(this.sources[n]) + " ");
                ++n;
            }
        }
        sb.append("]\n");
        return sb.toString();
    }
}

