/*
 * Decompiled with CFR 0.152.
 */
package data.constraints;

import data.Morpheme;
import data.constraints.Conditions;
import java.util.Vector;

public class Condition {
    public Condition cond;
    public boolean truth = true;
    public String parameters;

    public static class And
    extends Condition
    implements Conditions,
    Cloneable {
        protected Vector conds;

        public And(Vector c2s) {
            this.conds = c2s;
        }

        public And(Condition c1, Condition c2) {
            this.conds = new Vector();
            this.conds.add(c1);
            this.conds.add(c2);
        }

        @Override
        public boolean isMetBy(Morpheme m) {
            boolean res = true;
            Morpheme lm = m.getLastCombiningMorpheme();
            int i = 0;
            while (i < this.conds.size()) {
                if (!((Conditions)this.conds.elementAt(i)).isMetBy(m)) {
                    res = false;
                    break;
                }
                ++i;
            }
            if (!res && lm != null && !lm.id.equals("#incho#/1vv")) {
                res = true;
                i = 0;
                while (i < this.conds.size()) {
                    if (!((Conditions)this.conds.elementAt(i)).isMetBy(lm)) {
                        res = false;
                        break;
                    }
                    ++i;
                }
            }
            if (this.truth) {
                return res;
            }
            return !res;
        }

        @Override
        public boolean isMetByFullMorphem(Morpheme m) {
            boolean res = true;
            int i = 0;
            while (i < this.conds.size()) {
                if (!((Conditions)this.conds.elementAt(i)).isMetBy(m)) {
                    res = false;
                    break;
                }
                ++i;
            }
            if (this.truth) {
                return res;
            }
            return !res;
        }

        public String toString() {
            String str = ((Condition)this.conds.elementAt(0)).toString();
            int i = 1;
            while (i < this.conds.size()) {
                str = String.valueOf(str) + "," + ((Condition)this.conds.elementAt(i)).toString();
                ++i;
            }
            if (!this.truth) {
                str = "!(" + str + ")";
            }
            return str;
        }

        @Override
        public String toText(String lang) {
            String str = ((Conditions)this.conds.elementAt(0)).toText(lang);
            int i = 1;
            while (i < this.conds.size()) {
                str = String.valueOf(str) + (lang.equals("e") ? " AND " : " ET ") + ((Conditions)this.conds.elementAt(i)).toText(lang);
                ++i;
            }
            if (!this.truth) {
                str = String.valueOf(lang.equals("e") ? "NOT " : "PAS ") + "(" + str + ")";
            }
            return str;
        }

        @Override
        public Condition expand() {
            And cond = null;
            try {
                cond = (And)this.clone();
                int i = 0;
                while (i < cond.conds.size()) {
                    ((Condition)cond.conds.elementAt((int)i)).truth = !cond.truth;
                    this.conds.setElementAt(((Conditions)cond.conds.elementAt(i)).expand(), i);
                    ++i;
                }
                if (!cond.truth) {
                    cond.truth = true;
                }
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return cond;
        }
    }

    public static class Cid
    extends Condition
    implements Conditions {
        protected String pn;
        protected String morphid;

        public Cid(String pn, String morphid) {
            this.pn = pn;
            String[] s = morphid.split(":");
            this.morphid = s[1];
        }

        @Override
        public boolean isMetBy(Morpheme m) {
            Morpheme lm = m.getLastCombiningMorpheme();
            Morpheme morphWithCond = Morpheme.getMorpheme(this.morphid);
            Conditions cond = this.pn.equals("cp") ? morphWithCond.getPrecCond() : morphWithCond.getNextCond();
            boolean res = cond.isMetBy(m);
            if (!res && lm != null && !lm.id.equals("#incho#/1vv")) {
                res = cond.isMetBy(lm);
            }
            if (this.truth) {
                return res;
            }
            return !res;
        }

        @Override
        public boolean isMetByFullMorphem(Morpheme m) {
            Morpheme morphWithCond = Morpheme.getMorpheme(this.morphid);
            Conditions cond = this.pn.equals("cp") ? morphWithCond.getPrecCond() : morphWithCond.getNextCond();
            boolean res = cond.isMetBy(m);
            if (this.truth) {
                return res;
            }
            return !res;
        }

        public String toString() {
            String str = String.valueOf(this.pn) + "(" + this.morphid + ")";
            if (!this.truth) {
                str = "!" + str;
            }
            return str;
        }

        @Override
        public String toText(String lang) {
            String str;
            if (this.pn.equals("cp")) {
                str = lang.equals("en") ? "the condition of " : "la condition de ";
                str = String.valueOf(str) + this.morphid;
                str = String.valueOf(str) + (lang.equals("en") ? " on the preceding morpheme" : "sur le morph\u00c3\u00a8me pr\u00c3\u00a9c\u00c3\u00a9dent");
            } else {
                str = String.valueOf(this.pn) + "(" + this.morphid + ")";
            }
            if (!this.truth) {
                str = String.valueOf(lang.equals("en") ? "NOT " : "PAS ") + str;
            }
            return str;
        }

        @Override
        public Condition expand() {
            return null;
        }
    }

    public static class NonMobilityOfInfix
    extends Condition
    implements Conditions {
        String infixId;

        public NonMobilityOfInfix(String infixId) {
            this.infixId = infixId;
        }

        @Override
        public boolean isMetBy(Morpheme m) {
            return true;
        }

        @Override
        public boolean isMetByFullMorphem(Morpheme m) {
            return true;
        }

        @Override
        public String toText(String lang) {
            return null;
        }

        @Override
        public Condition expand() {
            NonMobilityOfInfix cond = null;
            try {
                cond = (NonMobilityOfInfix)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return cond;
        }
    }

    public static class Or
    extends Condition
    implements Conditions {
        protected Vector conds;

        public Or(Vector c2s) {
            this.conds = c2s;
        }

        @Override
        public boolean isMetBy(Morpheme m) {
            boolean res = false;
            Morpheme lm = m.getLastCombiningMorpheme();
            int i = 0;
            while (i < this.conds.size()) {
                if (((Conditions)this.conds.elementAt(i)).isMetBy(m) || lm != null && !lm.id.equals("#incho#/1vv") && ((Conditions)this.conds.elementAt(i)).isMetBy(lm)) {
                    res = true;
                    break;
                }
                ++i;
            }
            if (this.truth) {
                return res;
            }
            return !res;
        }

        @Override
        public boolean isMetByFullMorphem(Morpheme m) {
            boolean res = false;
            int i = 0;
            while (i < this.conds.size()) {
                if (((Conditions)this.conds.elementAt(i)).isMetBy(m)) {
                    res = true;
                    break;
                }
                ++i;
            }
            if (this.truth) {
                return res;
            }
            return !res;
        }

        public String toString() {
            String str = ((Condition)this.conds.elementAt(0)).toString();
            int i = 1;
            while (i < this.conds.size()) {
                str = String.valueOf(str) + " " + ((Condition)this.conds.elementAt(i)).toString();
                ++i;
            }
            if (!this.truth) {
                str = "!(" + str + ")";
            }
            return str;
        }

        @Override
        public String toText(String lang) {
            String str = ((Conditions)this.conds.elementAt(0)).toText(lang);
            int i = 1;
            while (i < this.conds.size()) {
                str = String.valueOf(str) + (lang.equals("e") ? " OR " : " OU ") + ((Conditions)this.conds.elementAt(i)).toText(lang);
                ++i;
            }
            if (!this.truth) {
                str = String.valueOf(lang.equals("e") ? "NOT " : "PAS ") + "(" + str + ")";
            }
            return str;
        }

        @Override
        public Condition expand() {
            Or cond = null;
            try {
                cond = (Or)this.clone();
                int i = 0;
                while (i < cond.conds.size()) {
                    ((Condition)cond.conds.elementAt((int)i)).truth = !((Condition)cond.conds.elementAt((int)i)).truth;
                    this.conds.setElementAt(((Conditions)cond.conds.elementAt(i)).expand(), i);
                    ++i;
                }
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return cond;
        }
    }

    public static class OverSeveralMorphemes
    extends Condition
    implements Conditions,
    Cloneable {
        protected Vector conds;

        public OverSeveralMorphemes(Vector cs) {
            this.conds = cs;
        }

        private OverSeveralMorphemes() {
        }

        @Override
        public boolean isMetBy(Morpheme m) {
            return true;
        }

        @Override
        public boolean isMetByFullMorphem(Morpheme morph) {
            return true;
        }

        public String toString() {
            String str = ((Condition)this.conds.elementAt(0)).toString();
            int i = 1;
            while (i < this.conds.size()) {
                str = String.valueOf(str) + "+" + ((Condition)this.conds.elementAt(i)).toString();
                ++i;
            }
            if (!this.truth) {
                str = "!(" + str + ")";
            }
            return str;
        }

        @Override
        public String toText(String lang) {
            String text = lang.equals("e") ? "Condition on the preceding morpheme:<br>" : "Condition sur le morph\u00c3\u00a8me pr\u00c3\u00a9c\u00c3\u00a9dent:<br>";
            text = String.valueOf(text) + ((Conditions)this.conds.elementAt(0)).toText(lang);
            int i = 1;
            while (i < this.conds.size()) {
                text = String.valueOf(text) + (lang.equals("e") ? "Condition on the next preceding morpheme:<br>" : "Condition sur le morph\u00c3\u00a8me pr\u00c3\u00a9c\u00c3\u00a9dent suivant:<br>");
                text = String.valueOf(text) + ((Conditions)this.conds.elementAt(i)).toText(lang);
                ++i;
            }
            return text;
        }

        @Override
        public Condition expand() {
            return null;
        }
    }
}

