/*
 * Decompiled with CFR 0.152.
 */
package morph;

import data.Morpheme;
import java.util.Arrays;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morph.AffixPartOfComposition;
import morph.PartOfComposition;
import morph.RootPartOfComposition;
import script.Orthography;

public class Decomposition
implements Comparable {
    String word;
    RootPartOfComposition stem;
    Object[] morphParts;
    static String startDelimitor = "{";
    static String endDelimitor = "}";
    static String interDelimitor = ":";

    public Decomposition(String word, RootPartOfComposition r, Object[] parts) {
        AffixPartOfComposition m;
        this.word = word;
        this.stem = r;
        String origState = this.stem.arc.startState.id;
        int nextPos = word.length();
        int i = parts.length - 1;
        while (i >= 0) {
            m = (AffixPartOfComposition)parts[i];
            int pos = m.getPosition();
            m.setTerme(Orthography.orthographyICI(word.substring(pos, nextPos), false));
            nextPos = pos;
            --i;
        }
        i = 0;
        while (i < parts.length) {
            m = (AffixPartOfComposition)parts[i];
            int j = 0;
            while (j < m.arcs.length) {
                if (m.arcs[j].destState.id.equals(origState)) {
                    m.arc = m.arcs[j];
                    origState = m.arc.startState.id;
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.morphParts = parts;
    }

    public RootPartOfComposition getRootMorphpart() {
        return this.stem;
    }

    public Object[] getMorphParts() {
        return this.morphParts;
    }

    public void setMorphParts(Object[] parts) {
        this.morphParts = parts;
    }

    public AffixPartOfComposition getLastMorphpart() {
        if (this.morphParts.length == 0) {
            return null;
        }
        return (AffixPartOfComposition)this.morphParts[this.morphParts.length - 1];
    }

    public int getNbMorphparts() {
        return this.morphParts.length;
    }

    public int compareTo(Object obj) {
        int returnValue = 0;
        Decomposition otherDec = (Decomposition)obj;
        if (returnValue == 0) {
            Integer lengthOfRoot = new Integer(this.stem.getRoot().morpheme.length());
            Integer lengthOfRootOfOtherDec = new Integer(otherDec.stem.getRoot().morpheme.length());
            returnValue = lengthOfRootOfOtherDec.compareTo(lengthOfRoot);
            if (returnValue == 0) {
                Integer nbOfMorphparts = new Integer(this.morphParts.length);
                Integer nbOfMorphpartsOfOtherDec = new Integer(otherDec.morphParts.length);
                returnValue = nbOfMorphparts.compareTo(nbOfMorphpartsOfOtherDec);
            }
        }
        return returnValue;
    }

    public boolean isEqualDecomposition(Decomposition dec) {
        return this.toStr2().equals(dec.toStr2());
    }

    static Decomposition[] removeMultiples(Decomposition[] decs) {
        if (decs == null || decs.length == 0) {
            return decs;
        }
        Vector<Decomposition> v = new Vector<Decomposition>();
        Vector<String> vc = new Vector<String>();
        v.add(decs[0]);
        vc.add(decs[0].toStr2());
        int i = 1;
        while (i < decs.length) {
            String c = decs[i].toStr2();
            if (!vc.contains(c)) {
                v.add(decs[i]);
                vc.add(c);
            }
            ++i;
        }
        return v.toArray(new Decomposition[0]);
    }

    static Decomposition[] removeCombinedSuffixes(Decomposition[] decs) {
        Object[][] objs = new Object[decs.length][2];
        int i = 0;
        while (i < decs.length) {
            objs[i][0] = decs[i];
            objs[i][1] = new Boolean(true);
            ++i;
        }
        i = 0;
        while (i < objs.length) {
            if (((Boolean)objs[i][1]).booleanValue()) {
                Decomposition dec = (Decomposition)objs[i][0];
                Vector<Object> vParts = new Vector<Object>(Arrays.asList(dec.morphParts));
                vParts.add(0, dec.stem);
                int j = 0;
                while (j < vParts.size()) {
                    PartOfComposition morphPart = (PartOfComposition)vParts.elementAt(j);
                    Morpheme morph = morphPart.getMorpheme();
                    String[] cs = null;
                    if (morph != null) {
                        cs = morph.getCombiningParts();
                    }
                    if (cs != null) {
                        String prec = j == 0 ? null : (j == 1 ? dec.stem.root.id : ((PartOfComposition)vParts.elementAt((int)(j - 1))).getMorpheme().id);
                        String follow = j == vParts.size() - 1 ? null : ((PartOfComposition)vParts.elementAt((int)(j + 1))).getMorpheme().id;
                        int k = 0;
                        while (k < objs.length) {
                            if (((Boolean)objs[k][1]).booleanValue()) {
                                Decomposition deck = (Decomposition)objs[k][0];
                                Object[] morphPartsk = deck.morphParts;
                                Vector<Object> vPartsk = new Vector<Object>(Arrays.asList(deck.morphParts));
                                vPartsk.add(0, deck.stem);
                                int l = 0;
                                boolean cont = true;
                                boolean inCombined = false;
                                int iCombined = 0;
                                while (l < vPartsk.size() && cont) {
                                    Morpheme morphk = ((PartOfComposition)vPartsk.elementAt(l)).getMorpheme();
                                    if (inCombined) {
                                        if (morphk.id.equals(cs[iCombined])) {
                                            if (++iCombined == cs.length) {
                                                String followk = l == vPartsk.size() - 1 ? null : ((PartOfComposition)vPartsk.elementAt((int)(l + 1))).getMorpheme().id;
                                                if (follow == null && followk == null || follow != null && followk != null && followk.equals(follow)) {
                                                    objs[k][1] = new Boolean(false);
                                                }
                                                cont = false;
                                            }
                                        } else {
                                            inCombined = false;
                                            iCombined = 0;
                                        }
                                    } else if (morphk.id.equals(cs[iCombined])) {
                                        inCombined = true;
                                        ++iCombined;
                                        String preck = l == 0 ? null : (l == 1 ? deck.stem.root.id : ((PartOfComposition)vPartsk.elementAt((int)(l - 1))).getMorpheme().id);
                                        if (preck == null && prec != null || preck != null && prec == null || preck != null && prec != null && !preck.equals(prec)) {
                                            cont = false;
                                        }
                                    }
                                    ++l;
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        Vector<Object> v = new Vector<Object>();
        int i2 = 0;
        while (i2 < objs.length) {
            if (((Boolean)objs[i2][1]).booleanValue()) {
                v.add(objs[i2][0]);
            }
            ++i2;
        }
        Decomposition[] ndecs = v.toArray(new Decomposition[0]);
        return ndecs;
    }

    public String toStr2() {
        StringBuffer sb = new StringBuffer();
        Object[] morphParts = this.getMorphParts();
        sb.append(this.stem.toStr());
        int j = 0;
        while (j < morphParts.length) {
            AffixPartOfComposition ma = (AffixPartOfComposition)morphParts[j];
            sb.append(ma.toStr());
            ++j;
        }
        return sb.toString();
    }

    public static String[] getMeaningsInArrayOfStrings(String decstr, String lang, boolean includeSurface, boolean includeId) {
        DecompositionExpression de = new DecompositionExpression(decstr);
        String[] mngs = de.getMeanings(lang);
        int i = 0;
        while (i < mngs.length) {
            if (includeSurface && includeId) {
                mngs[i] = String.valueOf(de.parts[i].str) + "---" + mngs[i];
            } else if (includeSurface) {
                mngs[i] = String.valueOf(de.parts[i].surface) + "---" + mngs[i];
            } else if (includeId) {
                mngs[i] = String.valueOf(de.parts[i].morphid) + "---" + mngs[i];
            }
            ++i;
        }
        return mngs;
    }

    public static String getMeaningsInString(String decstr, String lang, boolean includeSurface, boolean includeId) {
        DecompositionExpression de = new DecompositionExpression(decstr);
        StringBuffer sb = new StringBuffer();
        String[] mngs = de.getMeanings(lang);
        int i = 0;
        while (i < mngs.length) {
            if (includeSurface && includeId) {
                sb.append("{").append(de.parts[i].str).append("---").append(mngs[i]).append("}");
            } else if (includeSurface) {
                sb.append("{").append(de.parts[i].surface).append("---").append(mngs[i]).append("}");
            } else if (includeId) {
                sb.append("{").append(de.parts[i].morphid).append("---").append(mngs[i]).append("}");
            } else {
                sb.append("{").append(mngs[i]).append("}");
            }
            ++i;
        }
        return sb.toString();
    }

    public static class DecompositionExpression {
        String decstr;
        String[] partsStr;
        DecPart[] parts;

        public DecompositionExpression(String decstr) {
            this.decstr = decstr;
            this.partsStr = this.expr2parts();
            this.parts = new DecPart[this.partsStr.length];
            int i = 0;
            while (i < this.parts.length) {
                this.parts[i] = new DecPart(this.partsStr[i]);
                ++i;
            }
        }

        public String[] getMeanings(String lang) {
            String[] meanings = new String[this.parts.length];
            int i = 0;
            while (i < this.parts.length) {
                meanings[i] = lang.equals("en") ? Morpheme.getMorpheme((String)this.parts[i].morphid).englishMeaning : Morpheme.getMorpheme((String)this.parts[i].morphid).frenchMeaning;
                meanings[i] = meanings[i].replaceAll(" /", " ");
                meanings[i] = meanings[i].replace("^/", "");
                ++i;
            }
            return meanings;
        }

        private String[] expr2parts() {
            Pattern p = Pattern.compile("\\{[^}]+?\\}");
            Matcher mp = p.matcher(this.decstr);
            Vector<String> v = new Vector<String>();
            int pos = 0;
            while (mp.find(pos)) {
                v.add(mp.group());
                pos = mp.end();
            }
            return v.toArray(new String[0]);
        }

        public static class DecPart {
            String str;
            String surface;
            String morphid;

            public DecPart(String str) {
                this.str = str;
                Pattern p = Pattern.compile("\\" + startDelimitor + "(.+?)" + "\\" + endDelimitor);
                Matcher m = p.matcher(str);
                m.matches();
                String[] partParts = Pattern.compile(":").split(m.group(1));
                this.surface = partParts[0];
                this.morphid = partParts[1];
            }

            public DecPart(String terme, String id) {
                this.surface = terme;
                this.morphid = id;
                this.str = String.valueOf(startDelimitor) + this.surface + interDelimitor + id + endDelimitor;
            }
        }
    }
}

