/*
 * Decompiled with CFR 0.152.
 */
package script;

import fonts.Font;
import html.HtmlEntities;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import script.Roman;
import script.Syllabics;

public class TransCoder {
    int maxLatLength = 0;
    Hashtable conversionHash;
    String dotCodes = null;
    static char[] macRomanToCP1252;

    static {
        char[] cArray = new char[128];
        cArray[0] = 196;
        cArray[1] = 197;
        cArray[2] = 199;
        cArray[3] = 201;
        cArray[4] = 209;
        cArray[5] = 214;
        cArray[6] = 220;
        cArray[7] = 225;
        cArray[8] = 224;
        cArray[9] = 226;
        cArray[10] = 228;
        cArray[11] = 227;
        cArray[12] = 229;
        cArray[13] = 231;
        cArray[14] = 233;
        cArray[15] = 232;
        cArray[16] = 234;
        cArray[17] = 235;
        cArray[18] = 237;
        cArray[19] = 236;
        cArray[20] = 238;
        cArray[21] = 239;
        cArray[22] = 241;
        cArray[23] = 243;
        cArray[24] = 242;
        cArray[25] = 244;
        cArray[26] = 246;
        cArray[27] = 245;
        cArray[28] = 250;
        cArray[29] = 249;
        cArray[30] = 251;
        cArray[31] = 252;
        cArray[32] = 134;
        cArray[33] = 176;
        cArray[34] = 162;
        cArray[35] = 163;
        cArray[36] = 167;
        cArray[37] = 149;
        cArray[38] = 182;
        cArray[39] = 223;
        cArray[40] = 174;
        cArray[41] = 169;
        cArray[42] = 153;
        cArray[43] = 180;
        cArray[44] = 168;
        cArray[46] = 198;
        cArray[47] = 216;
        cArray[49] = 177;
        cArray[52] = 165;
        cArray[53] = 181;
        cArray[59] = 170;
        cArray[60] = 186;
        cArray[62] = 230;
        cArray[63] = 248;
        cArray[64] = 191;
        cArray[65] = 161;
        cArray[66] = 172;
        cArray[68] = 131;
        cArray[71] = 171;
        cArray[72] = 187;
        cArray[73] = 133;
        cArray[74] = 160;
        cArray[75] = 192;
        cArray[76] = 195;
        cArray[77] = 213;
        cArray[78] = 140;
        cArray[79] = 156;
        cArray[80] = 150;
        cArray[81] = 151;
        cArray[82] = 147;
        cArray[83] = 148;
        cArray[84] = 145;
        cArray[85] = 146;
        cArray[86] = 247;
        cArray[88] = 255;
        cArray[89] = 159;
        cArray[91] = 128;
        cArray[92] = 139;
        cArray[93] = 155;
        cArray[96] = 135;
        cArray[97] = 183;
        cArray[98] = 130;
        cArray[99] = 132;
        cArray[100] = 137;
        cArray[101] = 194;
        cArray[102] = 202;
        cArray[103] = 193;
        cArray[104] = 203;
        cArray[105] = 200;
        cArray[106] = 205;
        cArray[107] = 206;
        cArray[108] = 207;
        cArray[109] = 204;
        cArray[110] = 211;
        cArray[111] = 212;
        cArray[113] = 210;
        cArray[114] = 218;
        cArray[115] = 219;
        cArray[116] = 217;
        cArray[118] = 136;
        cArray[119] = 152;
        cArray[120] = 175;
        cArray[124] = 184;
        macRomanToCP1252 = cArray;
    }

    public TransCoder(String[][] conversionTable, int direction) {
        this.conversionHash = new Hashtable();
        int i = 0;
        while (i < conversionTable.length) {
            String key = "";
            String val = null;
            switch (direction) {
                case 1: {
                    key = conversionTable[i][1];
                    val = conversionTable[i][0];
                    break;
                }
                case -1: {
                    key = conversionTable[i][0];
                    val = conversionTable[i][1];
                }
            }
            if (!this.conversionHash.containsKey(key)) {
                this.conversionHash.put(key, val);
                this.maxLatLength = Math.max(this.maxLatLength, key.length());
            }
            ++i;
        }
    }

    static String prepareForPattern(String dotCodes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < dotCodes.length()) {
            sb.append("\\" + dotCodes.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public TransCoder(String[][] conversionTable, String dotCodes, int direction) {
        this.dotCodes = dotCodes;
        this.conversionHash = new Hashtable();
        Pattern p = Pattern.compile(TransCoder.prepareForPattern(dotCodes));
        int i = 0;
        while (i < conversionTable.length) {
            String key = "";
            String val = null;
            switch (direction) {
                case 1: {
                    key = conversionTable[i][1];
                    val = conversionTable[i][0];
                    break;
                }
                case -1: {
                    key = conversionTable[i][0];
                    val = conversionTable[i][1];
                }
            }
            Matcher m = p.matcher(key);
            if (m.find()) {
                int j = 0;
                while (j < dotCodes.length()) {
                    String keyWithDot = m.replaceFirst(dotCodes.substring(j, j + 1));
                    if (!this.conversionHash.containsKey(keyWithDot)) {
                        this.conversionHash.put(keyWithDot, val);
                        this.maxLatLength = Math.max(this.maxLatLength, keyWithDot.length());
                    }
                    ++j;
                }
            } else if (!this.conversionHash.containsKey(key)) {
                this.conversionHash.put(key, val);
                this.maxLatLength = Math.max(this.maxLatLength, key.length());
            }
            ++i;
        }
    }

    public String transcode(String src) {
        if (src.length() == 0 || src == null) {
            return src;
        }
        String output = "";
        int location = 0;
        while (location < src.length()) {
            int len = Math.min(this.maxLatLength, src.length() - location);
            String arr = null;
            String sub = "";
            while (len > 0) {
                sub = src.substring(location, location + len);
                arr = (String)this.conversionHash.get(sub);
                if (arr != null) break;
                --len;
            }
            if (arr == null) {
                output = String.valueOf(output) + sub;
                ++location;
                continue;
            }
            output = String.valueOf(output) + arr;
            location += len;
        }
        return output;
    }

    public static String unistringToUnicode(String s) {
        return TransCoder.unistringToUnicode(s, "2,4");
    }

    public static String unistringToUnicode(String s, String nbHex) {
        String str = "";
        Pattern p = Pattern.compile("\\\\u([a-fA-F0-9]{" + nbHex + "})");
        Matcher mp = p.matcher(s);
        int pos = 0;
        while (pos < s.length() && mp.find(pos)) {
            str = String.valueOf(str) + s.substring(pos, mp.start());
            String ns = mp.group(1);
            char i = (char)Integer.valueOf(ns, 16).intValue();
            str = String.valueOf(str) + i;
            pos = mp.end();
        }
        str = String.valueOf(str) + s.substring(pos);
        return str;
    }

    public static String unicodeToUrlencoding(String word) {
        String wordUtf8 = null;
        try {
            wordUtf8 = new String(word.getBytes("utf-8"), "iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            wordUtf8 = word;
        }
        String w = "";
        int j = 0;
        while (j < wordUtf8.length()) {
            String n = Integer.toHexString(wordUtf8.charAt(j));
            int nb0 = 2 - n.length();
            String zeros = "";
            int k = 0;
            while (k < nb0) {
                zeros = String.valueOf(zeros) + "0";
                ++k;
            }
            w = String.valueOf(w) + "%" + n.toUpperCase();
            ++j;
        }
        return w;
    }

    public static String unicodeToHtmlEntity(String uni) {
        String text = HtmlEntities.toHtmlEntity((String)uni);
        String html2 = text.replaceAll("&", "&amp;");
        return html2;
    }

    public static String unicodeToUnistring(String word) {
        String w = "";
        int j = 0;
        while (j < word.length()) {
            String n = Integer.toHexString(word.charAt(j));
            String ns = String.valueOf(n);
            int nb0 = 4 - ns.length();
            String zeros = "";
            int k = 0;
            while (k < nb0) {
                zeros = String.valueOf(zeros) + "0";
                ++k;
            }
            w = String.valueOf(w) + "\\u" + zeros + ns;
            ++j;
        }
        return w;
    }

    public static String romanToUnicode(String s) {
        String syll = Roman.transcodeToUnicode(s, null);
        return syll;
    }

    public static String romanToUnicode(String s, boolean aipaitai) {
        String apt = aipaitai ? "aipaitai" : null;
        String syll = Roman.transcodeToUnicode(s, apt);
        return syll;
    }

    public static String romanToLegacy(String s, String fontName) {
        String syl = TransCoder.romanToUnicode(s);
        String leg = TransCoder.unicodeToLegacy(syl, fontName);
        return leg;
    }

    public static String unicodeToRoman(String s) {
        String roman = Syllabics.transcodeToRoman(s);
        return roman;
    }

    public static String macRoman2cp1252(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            if (c >= 128 && c <= 255) {
                sb.append(macRomanToCP1252[c - 128]);
            } else {
                sb.append((char)c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String windows1252Toiso88591(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c;
            switch (s.codePointAt(i)) {
                case 128: {
                    c = '\u20ac';
                    break;
                }
                case 130: {
                    c = '\u201a';
                    break;
                }
                case 131: {
                    c = '\u0192';
                    break;
                }
                case 132: {
                    c = '\u201e';
                    break;
                }
                case 133: {
                    c = '\u2026';
                    break;
                }
                case 134: {
                    c = '\u2020';
                    break;
                }
                case 135: {
                    c = '\u2021';
                    break;
                }
                case 136: {
                    c = '\u02c6';
                    break;
                }
                case 137: {
                    c = '\u2030';
                    break;
                }
                case 138: {
                    c = '\u0160';
                    break;
                }
                case 139: {
                    c = '\u2039';
                    break;
                }
                case 140: {
                    c = '\u0152';
                    break;
                }
                case 142: {
                    c = '\u017d';
                    break;
                }
                case 145: {
                    c = '\u2018';
                    break;
                }
                case 146: {
                    c = '\u2019';
                    break;
                }
                case 147: {
                    c = '\u201c';
                    break;
                }
                case 148: {
                    c = '\u201d';
                    break;
                }
                case 149: {
                    c = '\u2022';
                    break;
                }
                case 150: {
                    c = '\u2013';
                    break;
                }
                case 151: {
                    c = '\u2014';
                    break;
                }
                case 152: {
                    c = '\u02dc';
                    break;
                }
                case 153: {
                    c = '\u2122';
                    break;
                }
                case 154: {
                    c = '\u0161';
                    break;
                }
                case 155: {
                    c = '\u203a';
                    break;
                }
                case 156: {
                    c = '\u0153';
                    break;
                }
                case 158: {
                    c = '\u017e';
                    break;
                }
                case 159: {
                    c = '\u0178';
                    break;
                }
                default: {
                    c = s.charAt(i);
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String legacyToRoman(String s, String fontName) {
        String sNormalized = TransCoder.windows1252Toiso88591(s);
        String syl = TransCoder.legacyToUnicode(sNormalized, fontName);
        String roman = TransCoder.unicodeToRoman(syl);
        return roman;
    }

    public static String unicodeToLegacy(String s, String fontName) {
        String res = "";
        Method meth = Font.getTranscoder3((String)fontName, (String)"ToFont");
        if (meth != null) {
            try {
                res = (String)meth.invoke(null, s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return res;
    }

    public static String legacyToUnicode(String s, String fontName) {
        String res = TransCoder.legacyToUnicode(s, fontName, false);
        return res;
    }

    public static String legacyToUnicode(String s, String fontName, boolean aipaitai) {
        String sNormalized = TransCoder.windows1252Toiso88591(s);
        String dotCodes = null;
        try {
            Field field;
            Class fontClass = Font.getFontClass((String)fontName);
            if (fontClass != null && (field = fontClass.getDeclaredField("dotCodes")) != null) {
                dotCodes = (String)field.get(null);
            }
        }
        catch (IllegalArgumentException fontClass) {
        }
        catch (SecurityException fontClass) {
        }
        catch (IllegalAccessException fontClass) {
        }
        catch (NoSuchFieldException fontClass) {
            // empty catch block
        }
        if (dotCodes != null) {
            String dotCodesForPattern = TransCoder.prepareForPattern(dotCodes);
            Pattern patDotCodes = Pattern.compile("([" + dotCodesForPattern + "])\\s+");
            patDotCodes = Pattern.compile("(([" + dotCodesForPattern + "])\\s+)");
            Matcher mpatDotCodes = patDotCodes.matcher(sNormalized);
            int pos = 0;
            while (mpatDotCodes.find(pos)) {
                String replacementPattern = TransCoder.prepareForPattern(mpatDotCodes.group(1));
                String replacementValue = mpatDotCodes.group(2);
                try {
                    sNormalized = sNormalized.replaceFirst(replacementPattern, replacementValue);
                }
                catch (PatternSyntaxException e) {
                    e.printStackTrace(System.err);
                }
                pos = mpatDotCodes.end();
                mpatDotCodes = patDotCodes.matcher(sNormalized);
            }
        }
        String res = "";
        String apt = aipaitai ? "aipaitai" : null;
        Method meth = Font.getTranscoder3((String)fontName, (String)"ToUnicode");
        if (meth != null) {
            try {
                res = (String)meth.invoke(null, sNormalized, apt);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return res;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        if (args.length > 1 && Font.isLegacy((String)args[1])) {
            String str = HtmlEntities.entityToChar((String)args[0]);
            str = TransCoder.unistringToUnicode(str, "4");
            String translit = TransCoder.legacyToRoman(str, args[1]);
            String translitEncoded = URLEncoder.encode(translit, "utf-8");
            System.out.print(translitEncoded);
        } else {
            String str = URLDecoder.decode(args[0], "utf-8");
            str = HtmlEntities.entityToChar((String)str);
            str = TransCoder.unistringToUnicode(str, "4");
            String translit = TransCoder.unicodeToRoman(str);
            String translitEncoded = URLEncoder.encode(translit, "utf-8");
            System.out.print(translit);
        }
    }
}

