/*
 * Decompiled with CFR 0.152.
 */
package applications;

import data.LinguisticDataAbstract;
import java.util.Calendar;
import morph.Decomposition;
import morph.MorphInuk;
import script.TransCoder;
import utilities.MonURLDecoder;
import utilities.Text;

public class Decompose {
    static String lang = "en";

    static void usage() {
        Decompose.usage(null);
    }

    static void usage(String mess) {
        if (lang.equals("en")) {
            System.err.println("\nusage: java -jar Uqailaut.jar [-h[elp]] [-a[ide]] [-t] [-csv] [-l [en|fr]] <word>");
            System.err.println("\n-h[elp] : print this in English");
            System.err.println("-a[ide] : print this in French");
            System.err.println("-t : display initialization time and decomposition time");
            System.err.println("-csv : use linguistic data in .csv files");
            System.err.println("-l [en|fr] : user's language - en: english   fr: french (default: en)");
            System.err.println("\n<word>: in latin alphabet or in URI-encoded syllabics");
            System.err.println("        Note: the inuktitut '&' consonant in latin alphabet must be input as %26 (that is, as its URI encoding)");
        } else {
            System.err.println("\nusage: java -jar Uqailaut.jar [-h[elp]] [-a[ide]] [-t] [-csv] [-l [en|fr]] <mot>");
            System.err.println("\n-h[elp] : imprimer ceci en anglais");
            System.err.println("-a[ide] : imprimer ceci en fran\u00c3\u00a7ais");
            System.err.println("-t : imprimer le temps d'initialisation et le temps de d\u00c3\u00a9composition");
            System.err.println("-csv : utiliser les donn\u00c3\u00a9es linguistiques dans les fichiers .csv");
            System.err.println("-l [en|fr] : langue de l'utilisateur - en: anglais   fr: fran\u00c3\u00a7ais (d\u00c3\u00a9faut: en)");
            System.err.println("\n<mot>: en alphabet latin ou en syllabique encod\u00c3\u00a9 \u00c3\u00a0 URI");
            System.err.println("        Note: la consonne inuktitut '&' en alphabet latin doit \u00c3\u00aatre entr\u00c3\u00a9e comme %26 (c'est-\u00c3\u00a0-dire encod\u00c3\u00a9e \u00c3\u00a0 URI)");
        }
        if (mess != null) {
            System.err.println(mess);
        }
        System.exit(1);
    }

    public static void main(String[] args) {
        String dataSource = null;
        String word = null;
        boolean displayTimes = false;
        boolean printHelp = false;
        boolean printUsage = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-csv")) {
                dataSource = "csv";
            } else if (args[i].equals("-t")) {
                displayTimes = true;
            } else if (args[i].equals("-h") || args[i].equals("-help")) {
                lang = "en";
                printHelp = true;
            } else if (args[i].equals("-a") || args[i].equals("-aide")) {
                lang = "fr";
                printHelp = true;
            } else if (args[i].equals("-l")) {
                if (i + 1 < args.length && (args[i + 1].equals("en") || args[i + 1].equals("fr"))) {
                    lang = args[++i];
                } else {
                    printUsage = true;
                }
            } else if (args[i].startsWith("-")) {
                printUsage = true;
            } else {
                word = args[i];
            }
            ++i;
        }
        if (printHelp) {
            Decompose.usage();
        } else if (printUsage) {
            Decompose.usage();
        } else if (word == null) {
            String mess = lang.equals("en") ? "Error: no input word." : "Erreur : le mot \u00c3\u00a0 d\u00c3\u00a9composer n'a pas \u00c3\u00a9t\u00c3\u00a9 d\u00c3\u00a9fini.";
            Decompose.usage(mess);
        }
        long startInitTime = Calendar.getInstance().getTimeInMillis();
        LinguisticDataAbstract.init(dataSource);
        long endInitTime = Calendar.getInstance().getTimeInMillis();
        long startTime = Calendar.getInstance().getTimeInMillis();
        String decsS = Decompose.decomposeToMultilineString(word);
        long endTime = Calendar.getInstance().getTimeInMillis();
        System.out.print(decsS);
        if (displayTimes) {
            System.out.println(String.valueOf(lang.equals("en") ? "init time: " : "temps d'initialisation : ") + (endInitTime - startInitTime));
            System.out.println(String.valueOf(lang.equals("en") ? "init time: " : "temps de d'analyse : ") + (endTime - startTime));
        }
    }

    public static String decomposeToMultilineString(String word) {
        String[] decExprs = Decompose.decomposeToArrayOfStrings(word);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < decExprs.length) {
            sb.append(decExprs[i]).append(System.getProperty("line.separator"));
            ++i;
        }
        return sb.toString();
    }

    public static String[] decomposeToArrayOfStrings(String word) {
        Text txt = new Text(word = MonURLDecoder.decode(word).trim());
        if (txt.containsUnicodeInuktitut()) {
            word = TransCoder.unicodeToRoman(word);
        }
        Decomposition[] decs = MorphInuk.decomposeWord(word);
        String[] decExprs = new String[decs.length];
        int i = 0;
        while (i < decs.length) {
            decExprs[i] = decs[i].toStr2();
            ++i;
        }
        return decExprs;
    }

    public static String getMeaningsInString(String decstr, String lang, boolean includeSurface, boolean includeId) {
        return Decomposition.getMeaningsInString(decstr, lang, includeSurface, includeId);
    }

    public static String[] getMeaningsInArrayOfStrings(String decstr, String lang, boolean includeSurface, boolean includeId) {
        return Decomposition.getMeaningsInArrayOfStrings(decstr, lang, includeSurface, includeId);
    }
}

