/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import script.Orthography;
import script.Roman;

public abstract class Action {
    public static int NULLACTION = 0;
    public static int INSERTION = 1;
    public static int SPECIFICDELETION = 2;
    public static int DELETION = 3;
    public static int VOICING = 4;
    public static int NASALIZATION = 5;
    public static int NEUTRAL = 6;
    public static int FUSION = 7;
    public static int ASSIMILATION = 8;
    public static int SPECIFICASSIMILATION = 9;
    public static int VOWELLENGTHENING = 11;
    public static int CANCELLATION = 12;
    public static int SELFDECAPITATION = 13;
    public static int INSERTIONVOWELLENGTHENING = 14;
    public static int DELETIONVOWELLENGTHENING = 15;
    public static int CONDITIONALDELETION = 16;
    public static int DELETIONINSERTION = 17;
    public static int CONDITIONALDELETIONMORPHEME = 18;
    public static int CONDITIONALNASALIZATION = 19;
    public static int UNKNOWN = 1000;
    public int type;
    String strng;

    public static Action makeAction() {
        return null;
    }

    public static Action makeAction(String strng) {
        Pattern p;
        Matcher m;
        Action action = null;
        String inside = null;
        if (strng != null && (m = (p = Pattern.compile("^[a-z]+\\((.+)\\)$")).matcher(strng)).matches()) {
            inside = m.group(1);
        }
        if (strng == null || strng.equals("-") || strng.equals("0")) {
            action = new NullAction();
        } else if (strng.equals("?")) {
            action = new Unknow();
        } else if (strng.startsWith("i(") || strng.startsWith("ins(")) {
            action = new Insertion(strng);
        } else if (strng.startsWith("s(") || strng.startsWith("suppr(")) {
            action = new SpecificSuppression(inside);
        } else if (strng.startsWith("ssi(") || strng.startsWith("supprsi(")) {
            String[] condSupp = inside.split(",");
            action = condSupp.length == 1 ? new ConditionalSuppression(strng) : new SpecificSuppression(condSupp[0], condSupp[1]);
        } else if (strng.startsWith("si(") || strng.startsWith("sins(") || strng.startsWith("suppri(") || strng.startsWith("supprins(")) {
            action = new SuppressionAndInsertion(strng);
        } else if (strng.equals("s") || strng.equals("suppr")) {
            action = new Suppression();
        } else if (strng.equals("son") || strng.equals("sonor")) {
            action = new Voicing();
        } else if (strng.equals("nas") || strng.equals("nasal")) {
            action = new Nasalization();
        } else if (strng.startsWith("nassi(")) {
            action = new ConditionalNasalization(inside);
        } else if (strng.equals("fus") || strng.equals("fusion")) {
            action = new Fusion();
        } else if (strng.equals("n") || strng.equals("neutre")) {
            action = new Neutral();
        } else if (strng.startsWith("nsi(")) {
            action = new Neutral(inside);
        } else if (strng.equals("a") || strng.equals("assim")) {
            action = new Assimilation();
        } else if (strng.startsWith("a(") || strng.startsWith("assim(")) {
            action = new SpecificAssimilation(strng);
        } else if (strng.equals("allV")) {
            action = new VowelLengthening();
        } else if (strng.equals("x") || strng.equals("annul")) {
            action = new Cancellation();
        } else if (strng.equals("decap")) {
            action = new Selfdecapitation();
        } else if (strng.startsWith("iallV(") || strng.startsWith("insallV(")) {
            action = new InsertionAndVowelLengthening(strng);
        } else if (strng.equals("sallV") || strng.equals("supprallV")) {
            action = new SuppressionAndVowelLengthening();
        }
        if (action != null) {
            action.strng = strng;
            ((Action)action).type = action.getType();
        }
        return action;
    }

    public abstract String surfaceForm(String var1);

    public abstract String expressionResult(String var1, String var2, Action var3);

    public abstract String combine(String var1, String var2, Action var3);

    public String getInsert() {
        return null;
    }

    public String getSuppr() {
        return null;
    }

    public String getAssimA() {
        return null;
    }

    public String getCondition() {
        return null;
    }

    public String toString() {
        return this.strng;
    }

    public int getType() {
        try {
            return this.getClass().getField("type").getInt(null);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public String toString(String lang) {
        try {
            String fieldName = null;
            if (lang.equals("en")) {
                fieldName = "expressionAng";
            } else if (lang.equals("fr")) {
                fieldName = "expressionFran";
            }
            if (fieldName != null) {
                return (String)this.getClass().getField(fieldName).get(null);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    static class Assimilation
    extends Action
    implements Cloneable {
        public static final int type = ASSIMILATION;
        public static final String expressionAng = "the assimilation";
        public static final String expressionFran = "l'assimilation";

        @Override
        public String surfaceForm(String form) {
            return form;
        }

        public Object clone() {
            Assimilation cl = new Assimilation();
            cl.strng = new String(this.strng);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act1) {
            return "_" + context + "+" + form + " &rarr; " + "_" + form.charAt(0) + form;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return String.valueOf(form1.substring(0, form1.length() - 1)) + form2.charAt(0) + form2;
        }
    }

    static class Cancellation
    extends Action
    implements Cloneable {
        public static final int type = CANCELLATION;

        @Override
        public String surfaceForm(String form) {
            return null;
        }

        public Object clone() {
            Cancellation cl = new Cancellation();
            cl.strng = new String(this.strng);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act1) {
            return null;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return null;
        }
    }

    static class ConditionalNasalization
    extends Action
    implements Cloneable {
        public static final int type = CONDITIONALNASALIZATION;
        public static final String expressionAng = "the nasalization";
        public static final String expressionFran = "la nasalisation";
        String condition = null;

        public ConditionalNasalization(String str) {
            this.condition = str;
        }

        private ConditionalNasalization() {
        }

        @Override
        public String getCondition() {
            return this.condition;
        }

        @Override
        public String surfaceForm(String form) {
            return form;
        }

        public Object clone() {
            ConditionalNasalization cl = new ConditionalNasalization();
            cl.strng = new String(this.strng);
            cl.condition = new String(this.condition);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act2) {
            return "_" + context + "+" + form + " &rarr; " + "_" + Orthography.orthographyICILat(Roman.nasalOfOcclusiveUnvoicedLat(context.charAt(0))) + form;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return String.valueOf(form1.substring(0, form1.length() - 1)) + Orthography.orthographyICILat(Roman.nasalOfOcclusiveUnvoicedLat(form1.charAt(form1.length() - 1))) + form2;
        }
    }

    static class ConditionalSuppression
    extends Action
    implements Cloneable {
        public static final int type = CONDITIONALDELETION;
        public static final String expressionAng = "the deletion";
        public static final String expressionFran = "la suppression";
        String condition = null;

        public ConditionalSuppression(String str) {
            this.condition = str.substring(str.indexOf(40) + 1, str.indexOf(41));
        }

        private ConditionalSuppression() {
        }

        @Override
        public String getCondition() {
            return this.condition;
        }

        @Override
        public String surfaceForm(String form) {
            return form;
        }

        public Object clone() {
            ConditionalSuppression cl = new ConditionalSuppression();
            cl.strng = new String(this.strng);
            cl.condition = new String(this.condition);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act1) {
            return "_" + context + "+" + form + " &rarr; " + "_" + form;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return String.valueOf(form1.substring(0, form1.length() - 1)) + form2;
        }
    }

    static class Fusion
    extends Action
    implements Cloneable {
        public static final int type = FUSION;
        public static final String expressionAng = "the fusion";
        public static final String expressionFran = "la fusion";

        @Override
        public String surfaceForm(String form) {
            return form;
        }

        public Object clone() {
            Fusion cl = new Fusion();
            cl.strng = new String(this.strng);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act1) {
            return "_" + context + "+" + form + " &rarr; " + "_" + form;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return String.valueOf(form1.substring(0, form1.length() - 1)) + form2;
        }
    }

    static class Insertion
    extends Action
    implements Cloneable {
        public static final int type = INSERTION;
        public static final String expressionAng = "the insertion";
        public static final String expressionFran = "l'insertion";
        String inserted = null;

        public Insertion(String str) {
            this.inserted = str.substring(str.indexOf(40) + 1, str.indexOf(41));
        }

        private Insertion() {
        }

        @Override
        public String getInsert() {
            return this.inserted;
        }

        @Override
        public String surfaceForm(String form) {
            return String.valueOf(this.inserted) + form;
        }

        public Object clone() {
            Insertion cl = new Insertion();
            cl.strng = new String(this.strng);
            cl.inserted = new String(this.inserted);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act2) {
            return "_" + context + "+" + form + " &rarr; " + "_" + context + this.inserted + form;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return String.valueOf(form1) + this.inserted + form2;
        }
    }

    static class InsertionAndVowelLengthening
    extends Action
    implements Cloneable {
        public static final int type = INSERTIONVOWELLENGTHENING;
        public static final String expressionAng = "the insertion and lengthening";
        public static final String expressionFran = "l'insertion et l'allongement";
        String inserted = null;

        public InsertionAndVowelLengthening(String str) {
            this.inserted = str.substring(str.indexOf(40) + 1, str.indexOf(41));
        }

        private InsertionAndVowelLengthening() {
        }

        @Override
        public String getInsert() {
            return this.inserted;
        }

        @Override
        public String surfaceForm(String form) {
            return String.valueOf(this.inserted) + this.inserted + form;
        }

        public Object clone() {
            InsertionAndVowelLengthening cl = new InsertionAndVowelLengthening();
            cl.strng = new String(this.strng);
            cl.inserted = new String(this.inserted);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act2) {
            return "_" + context + "+" + form + " &rarr; " + "_" + context + this.inserted + this.inserted + form;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return String.valueOf(form1) + this.inserted + this.inserted + form2;
        }
    }

    public static class Nasalization
    extends Action
    implements Cloneable {
        public static final int type = NASALIZATION;
        public static final String expressionAng = "the nasalization";
        public static final String expressionFran = "la nasalisation";

        @Override
        public String surfaceForm(String form) {
            return form;
        }

        public Object clone() {
            Nasalization cl = new Nasalization();
            cl.strng = new String(this.strng);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act1) {
            return "_" + context + "+" + form + " &rarr; " + "_" + Orthography.orthographyICILat(Roman.nasalOfOcclusiveUnvoicedLat(context.charAt(0))) + form;
        }

        public static String changementPhonologique(char context) {
            switch (context) {
                case 't': {
                    return "n";
                }
                case 'k': {
                    return "ng";
                }
                case 'q': {
                    return "r";
                }
                case 'p': {
                    return "m";
                }
            }
            return "";
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return String.valueOf(form1.substring(0, form1.length() - 1)) + Orthography.orthographyICILat(Roman.nasalOfOcclusiveUnvoicedLat(form1.charAt(form1.length() - 1))) + form2;
        }
    }

    static class Neutral
    extends Action
    implements Cloneable {
        public static final int type = NEUTRAL;
        public static final String expressionAng = "the neutral action";
        public static final String expressionFran = "l'action neutre";
        String condition = null;

        public Neutral() {
        }

        public Neutral(String cond) {
            this.condition = cond;
        }

        @Override
        public String getCondition() {
            return this.condition;
        }

        @Override
        public String surfaceForm(String form) {
            return form;
        }

        public Object clone() {
            Neutral cl = new Neutral();
            cl.strng = new String(this.strng);
            cl.condition = new String(this.condition);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act2) {
            String addForm = "+" + form;
            if (act2 == null) {
                return "_" + context + addForm + " &rarr; " + "_" + context + form;
            }
            int act2Type = -1;
            act2Type = act2.type;
            if (act2Type == NULLACTION) {
                return "_" + context + addForm + " &rarr; " + "_" + context + form;
            }
            if (act2Type == DELETION) {
                return "_VV" + addForm + " &rarr; " + "_" + "V" + form;
            }
            if (act2Type == SELFDECAPITATION) {
                return "_VV" + addForm + " &rarr; " + "_" + "VV" + form.substring(1);
            }
            if (act2Type == INSERTION) {
                return "_VV" + addForm + " &rarr; " + "_" + "VV" + act2.getInsert() + form;
            }
            return "";
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            if (act2 == null) {
                return String.valueOf(form1) + form2;
            }
            int act2Type = -1;
            act2Type = act2.type;
            if (act2Type == NULLACTION) {
                return String.valueOf(form1) + form2;
            }
            if (act2Type == DELETION) {
                return String.valueOf(form1.substring(0, form1.length() - 1)) + form2;
            }
            if (act2Type == SELFDECAPITATION) {
                return String.valueOf(form1) + form2.substring(1);
            }
            if (act2Type == INSERTION) {
                return String.valueOf(form1) + act2.getInsert() + form2;
            }
            return "";
        }
    }

    static class NullAction
    extends Action
    implements Cloneable {
        public static final int type = NULLACTION;

        @Override
        public String surfaceForm(String form) {
            return null;
        }

        public Object clone() {
            NullAction cl = new NullAction();
            cl.strng = new String(this.strng);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act1) {
            String res = null;
            if (act1 != null) {
                res = act1.expressionResult(context, form, null);
            }
            return res;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return null;
        }
    }

    static class Selfdecapitation
    extends Action
    implements Cloneable {
        public static final int type = SELFDECAPITATION;
        public static final String expressionAng = "the self-decapitation ";
        public static final String expressionFran = "l'autod\u00ef\u00bf\u00bdcapitation";

        @Override
        public String surfaceForm(String form) {
            return form.substring(1);
        }

        public Object clone() {
            Selfdecapitation cl = new Selfdecapitation();
            cl.strng = new String(this.strng);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act1) {
            return "_" + context + " &rarr; " + "_" + form.substring(1);
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return String.valueOf(form1) + form2.substring(1);
        }
    }

    static class SpecificAssimilation
    extends Action
    implements Cloneable {
        public static final int type = SPECIFICASSIMILATION;
        public static final String expressionAng = "the assimilation";
        public static final String expressionFran = "l'assimilation";
        String assimileA = null;

        public SpecificAssimilation(String str) {
            this.assimileA = str.substring(str.indexOf(40) + 1, str.indexOf(41));
        }

        private SpecificAssimilation() {
        }

        @Override
        public String getAssimA() {
            return this.assimileA;
        }

        @Override
        public String surfaceForm(String form) {
            return form;
        }

        public Object clone() {
            SpecificAssimilation cl = new SpecificAssimilation();
            cl.strng = new String(this.strng);
            cl.assimileA = new String(this.assimileA);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act1) {
            return "_" + context + "+" + form + " &rarr; " + "_" + this.assimileA + form;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return String.valueOf(form1.substring(0, form1.length() - 1)) + this.assimileA + form2;
        }
    }

    static class SpecificSuppression
    extends Action
    implements Cloneable {
        public static final int type = SPECIFICDELETION;
        public static final String expressionAng = "the deletion";
        public static final String expressionFran = "la suppression";
        String suppressed = null;
        String condition = null;

        public SpecificSuppression(String str) {
            this.suppressed = str;
        }

        public SpecificSuppression(String cond, String str) {
            this.suppressed = str;
            this.condition = cond;
        }

        private SpecificSuppression() {
        }

        @Override
        public String getSuppr() {
            return this.suppressed;
        }

        @Override
        public String getCondition() {
            return this.condition;
        }

        @Override
        public String surfaceForm(String form) {
            return form;
        }

        public Object clone() {
            SpecificSuppression cl = new SpecificSuppression();
            cl.strng = new String(this.strng);
            cl.suppressed = new String(this.suppressed);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act2) {
            return null;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return null;
        }
    }

    static class Suppression
    extends Action
    implements Cloneable {
        public static final int type = DELETION;
        public static final String expressionAng = "the deletion";
        public static final String expressionFran = "la suppression";

        @Override
        public String surfaceForm(String form) {
            return form;
        }

        public Object clone() {
            Suppression cl = new Suppression();
            cl.strng = new String(this.strng);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act2) {
            String addForm = "+" + form;
            if (act2 == null) {
                return "_" + context + addForm + " &rarr; " + "_" + form;
            }
            int act2Type = -1;
            act2Type = act2.type;
            if (act2Type == NULLACTION) {
                return "_" + context + addForm + " &rarr; " + "_" + form;
            }
            if (act2Type == DELETION) {
                return "_VV" + context + addForm + " &rarr; " + "_" + "V" + form;
            }
            if (act2Type == SELFDECAPITATION) {
                return "_VV" + context + addForm + " &rarr; " + "_" + "VV" + form.substring(1);
            }
            if (act2Type == INSERTION) {
                return "_VV" + context + addForm + " &rarr; " + "_" + "VV" + act2.getInsert() + form;
            }
            if (act2Type == SPECIFICDELETION) {
                return "_V" + act2.getSuppr() + context + addForm + " &rarr; " + "_" + "V" + form;
            }
            return "";
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            if (act2 == null) {
                return String.valueOf(form1.substring(0, form1.length() - 1)) + form2;
            }
            int act2Type = -1;
            act2Type = act2.type;
            if (act2Type == NULLACTION) {
                return String.valueOf(form1.substring(0, form1.length() - 1)) + form2;
            }
            if (act2Type == DELETION) {
                return String.valueOf(form1.substring(0, form1.length() - 2)) + form2;
            }
            if (act2Type == SELFDECAPITATION) {
                return String.valueOf(form1.substring(0, form1.length() - 1)) + form2.substring(1);
            }
            if (act2Type == INSERTION) {
                return String.valueOf(form1.substring(0, form1.length() - 1)) + act2.getInsert() + form2;
            }
            if (act2Type == SPECIFICDELETION) {
                return String.valueOf(form1.substring(0, form1.length() - 2)) + form2;
            }
            return "";
        }
    }

    static class SuppressionAndInsertion
    extends Action
    implements Cloneable {
        public static final int type = DELETIONINSERTION;
        public static final String expressionAng = "the deletion";
        public static final String expressionFran = "la suppression";
        String inserted = null;

        public SuppressionAndInsertion(String str) {
            this.inserted = str.substring(str.indexOf(40) + 1, str.indexOf(41));
        }

        private SuppressionAndInsertion() {
        }

        @Override
        public String getInsert() {
            return this.inserted;
        }

        @Override
        public String surfaceForm(String form) {
            return String.valueOf(this.inserted) + form;
        }

        public Object clone() {
            SuppressionAndInsertion cl = new SuppressionAndInsertion();
            cl.strng = new String(this.strng);
            cl.inserted = new String(this.inserted);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act2) {
            return "_" + context + "+" + form + " &rarr; " + "_" + this.inserted + form;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return String.valueOf(form1.substring(0, form1.length() - 1)) + this.inserted + form2;
        }
    }

    static class SuppressionAndVowelLengthening
    extends Action
    implements Cloneable {
        public static final int type = DELETIONVOWELLENGTHENING;
        public static final String expressionAng = "the deletion and the lengthening";
        public static final String expressionFran = "la suppression et l'allongement";

        @Override
        public String surfaceForm(String form) {
            return form;
        }

        public Object clone() {
            SuppressionAndVowelLengthening cl = new SuppressionAndVowelLengthening();
            cl.strng = new String(this.strng);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act2) {
            return "_V" + context + "+" + form + " &rarr; " + "_VV" + form;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            String sform = form1.substring(0, form1.length() - 1);
            return String.valueOf(sform) + sform.charAt(sform.length() - 1) + form2;
        }
    }

    static class Unknow
    extends Action
    implements Cloneable {
        public static final int type = UNKNOWN;

        @Override
        public String surfaceForm(String form) {
            return null;
        }

        public Object clone() {
            Unknow cl = new Unknow();
            cl.strng = new String(this.strng);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act1) {
            return null;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return null;
        }
    }

    public static class Voicing
    extends Action
    implements Cloneable {
        public static final int type = VOICING;
        public static final String expressionAng = "the voicing";
        public static final String expressionFran = "la sonorisation";

        @Override
        public String surfaceForm(String form) {
            return form;
        }

        public Object clone() {
            Voicing cl = new Voicing();
            cl.strng = new String(this.strng);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act2) {
            return "_" + context + "+" + form + " &rarr; " + "_" + Roman.voicedOfOcclusiveUnvoicedLat(context.charAt(0)) + form;
        }

        public static String changementPhonologique(char context) {
            switch (context) {
                case 't': {
                    return "d";
                }
                case 'k': {
                    return "g";
                }
                case 'q': {
                    return "r";
                }
                case 'p': {
                    return "b";
                }
            }
            return "";
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return String.valueOf(form1.substring(0, form1.length() - 1)) + Roman.voicedOfOcclusiveUnvoicedLat(form1.charAt(form1.length() - 1)) + form2;
        }
    }

    static class VowelLengthening
    extends Action
    implements Cloneable {
        public static final int type = VOWELLENGTHENING;
        public static final String expressionAng = "the lengthening";
        public static final String expressionFran = "l'allongement";

        @Override
        public String surfaceForm(String form) {
            return form;
        }

        public Object clone() {
            VowelLengthening cl = new VowelLengthening();
            cl.strng = new String(this.strng);
            return cl;
        }

        @Override
        public String expressionResult(String context, String form, Action act2) {
            return "_" + context + "+" + form + " &rarr; " + "_" + context + context + form;
        }

        @Override
        public String combine(String form1, String form2, Action act2) {
            return String.valueOf(form1) + form1.charAt(form1.length() - 1) + form2;
        }
    }
}

