/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.LinguisticDataAbstract;
import data.Morpheme;
import data.VerbWord;
import data.constraints.Conditions;
import data.constraints.Imacond;
import data.constraints.ParseException;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import utilities1.Util;

public class Base
extends Morpheme {
    String variant = null;
    String originalMorpheme = null;
    String nature = null;
    Boolean known = new Boolean(true);
    String transitivity = null;
    String transinfix = null;
    String intransinfix = null;
    String antipassive = null;
    String number = null;
    String subtype = null;
    String source = null;
    String compositionRoot = null;
    private String transitiveMeaning_e = null;
    private String passiveMeaning_e = null;
    private String reflexiveMeaning_e = null;
    private String resultMeaning_e = null;
    private String transitiveMeaning_f = null;
    private String passiveMeaning_f = null;
    private String reflexiveMeaning_f = null;
    private String resultMeaning_f = null;
    private Vector idsOfCompositesWithThisRoot = null;
    public static Hashtable hash = new Hashtable();

    public Base(HashMap v) {
        this.makeRoot(v);
    }

    public Base() {
    }

    private void makeRoot(HashMap v) {
        String cs;
        this.getAndSetBaseAttributes(v);
        this.variant = (String)v.get("variant");
        this.originalMorpheme = (String)v.get("originalMorpheme");
        this.nb = (String)v.get("nb");
        if (this.nb == null || this.nb.equals("")) {
            this.nb = "1";
        }
        this.num = new Integer(this.nb);
        this.type = (String)v.get("type");
        this.number = (String)v.get("number");
        if (this.number == null || this.number.equals("")) {
            this.number = "s";
        }
        this.antipassive = (String)v.get("antipassive");
        this.transinfix = (String)v.get("transSuffix");
        this.intransinfix = (String)v.get("intransSuffix");
        this.transitivity = (String)v.get("transitivity");
        this.cf = (String)v.get("cf");
        if (this.cf != null && !this.cf.equals("")) {
            this.cfs = this.cf.split(" ");
        }
        this.dialect = (String)v.get("dialect");
        this.nature = (String)v.get("nature");
        this.source = (String)v.get("source");
        if (this.source != null && !this.source.equals("")) {
            this.sources = this.source.split(" ");
        }
        if ((cs = (String)v.get("condOnNext")) != null && !cs.equals("")) {
            try {
                this.nextCondition = (Conditions)((Object)new Imacond(new ByteArrayInputStream(cs.getBytes())).ParseCondition());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.compositionRoot = (String)v.get("compositionRoot");
        this.subtype = (String)v.get("subtype");
        String comb = (String)v.get("combination");
        if (comb != null && !comb.equals("")) {
            this.combinedMorphemes = comb.split("[+]");
            if (this.combinedMorphemes.length < 2) {
                this.combinedMorphemes = null;
            } else {
                String rootId = this.combinedMorphemes[0];
                Base b = LinguisticDataAbstract.getBase(rootId);
                if (b != null) {
                    Vector<String> vids = b.idsOfCompositesWithThisRoot;
                    if (vids == null) {
                        vids = new Vector<String>();
                    }
                    vids.add(comb);
                    b.setIdsOfCompositesWithThisRoot(vids);
                }
            }
        }
        this.setAttrs();
    }

    public void addToHash(String key, Object obj) {
        hash.put(key, obj);
    }

    @Override
    public String getSignature() {
        if (this.originalMorpheme != null) {
            return new Morpheme.Id((String)this.originalMorpheme).signature;
        }
        return String.valueOf(this.nb) + this.type;
    }

    @Override
    public String getOriginalMorpheme() {
        if (this.originalMorpheme != null) {
            return new Morpheme.Id((String)this.originalMorpheme).morphemeName;
        }
        return this.morpheme;
    }

    boolean isGiVerb() {
        return this.type.equals("v") && this.transinfix != null && this.transinfix.startsWith("gi");
    }

    boolean isSingular() {
        return this.number != null && this.number.equals("s");
    }

    boolean isDual() {
        return this.number != null && this.number.equals("d");
    }

    boolean isPlural() {
        return this.number != null && this.number.equals("p");
    }

    boolean isTransitiveVerb() {
        return this.type.equals("v") && this.transitivity != null && this.transitivity.equals("t");
    }

    boolean isIntransitiveVerb() {
        return this.type.equals("v") && this.transitivity != null && this.transitivity.equals("i");
    }

    String getAntipassive() {
        return this.antipassive;
    }

    String getVariant() {
        return this.variant;
    }

    @Override
    boolean agreeWithTransitivity(String trans) {
        if (trans == null) {
            return true;
        }
        if (this.transitivity == null) {
            return false;
        }
        if (this.transitivity.equals("t") && trans.equals("t")) {
            return true;
        }
        if (this.transitivity.equals("i") && (trans.equals("i") || trans.equals("t") && this.transinfix != null && this.transinfix.equals("nil"))) {
            return true;
        }
        return this.transitivity.equals("t") && this.antipassive != null && trans.equals("i");
    }

    String[] getVariants() {
        return this.variant.split(" ");
    }

    String getCompositionRoot() {
        return this.compositionRoot;
    }

    void getAndSetBaseAttributes(HashMap v) {
        this.morpheme = (String)v.get("morpheme");
        this.englishMeaning = (String)v.get("engMean");
        this.frenchMeaning = (String)v.get("freMean");
        this.dbName = (String)v.get("dbName");
        this.tableName = (String)v.get("tableName");
    }

    void setCombiningParts(String comb) {
        this.combinedMorphemes = comb.split("[+]");
        if (this.combinedMorphemes.length < 2) {
            this.combinedMorphemes = null;
        }
    }

    boolean needsAntipassive(String apId) {
        if (this.antipassive != null) {
            StringTokenizer st = new StringTokenizer(this.antipassive);
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(apId)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    String getTransitiveMeaning(String lang) {
        if (this.type.equals("v") && this.transitivity != null && this.transitivity.equals("t")) {
            String transitiveMeaning;
            String string = transitiveMeaning = lang.equals("en") ? this.transitiveMeaning_e : this.transitiveMeaning_f;
            if (transitiveMeaning == null) {
                this.makeVerbMeanings();
            }
            return lang.equals("en") ? this.transitiveMeaning_e : this.transitiveMeaning_f;
        }
        return "";
    }

    String getPassiveMeaning(String lang) {
        if (this.type.equals("v") && this.transitivity != null && this.transitivity.equals("t")) {
            String passiveMeaning;
            String string = passiveMeaning = lang.equals("en") ? this.passiveMeaning_e : this.passiveMeaning_f;
            if (passiveMeaning == null) {
                this.makeVerbMeanings();
            }
            return lang.equals("en") ? this.passiveMeaning_e : this.passiveMeaning_f;
        }
        return null;
    }

    String getResultMeaning(String lang) {
        if (this.type.equals("v") && this.transitivity != null && this.transitivity.equals("t")) {
            String resultMeaning;
            String string = resultMeaning = lang.equals("en") ? this.resultMeaning_e : this.resultMeaning_f;
            if (resultMeaning == null) {
                this.makeVerbMeanings();
            }
            return lang.equals("en") ? this.resultMeaning_e : this.resultMeaning_f;
        }
        return "";
    }

    String getReflexiveMeaning(String lang) {
        if (this.type.equals("v") && this.transitivity != null && this.transitivity.equals("t")) {
            String reflexiveMeaning;
            String string = reflexiveMeaning = lang.equals("en") ? this.reflexiveMeaning_e : this.reflexiveMeaning_f;
            if (reflexiveMeaning == null) {
                this.makeVerbMeanings();
            }
            return lang.equals("en") ? this.reflexiveMeaning_e : this.reflexiveMeaning_f;
        }
        return null;
    }

    boolean isKnown() {
        return this.known;
    }

    @Override
    void setAttrs() {
        this.setAttributes();
        this.setId();
    }

    void setAttributes() {
        this.setAttributes(new HashMap());
    }

    @Override
    void setAttributes(HashMap attrs) {
        HashMap<String, Object> baseAttrs = new HashMap<String, Object>();
        baseAttrs.put("variant", this.variant);
        baseAttrs.put("originalMorpheme", this.originalMorpheme);
        baseAttrs.put("nature", this.nature);
        baseAttrs.put("nb", this.nb);
        baseAttrs.put("known", this.known);
        baseAttrs.put("transitivity", this.transitivity);
        baseAttrs.put("transinfix", this.transinfix);
        baseAttrs.put("intransinfix", this.intransinfix);
        baseAttrs.put("antipassive", this.antipassive);
        baseAttrs.put("number", this.number);
        baseAttrs.put("subtype", this.subtype);
        baseAttrs.put("source", this.source);
        baseAttrs.putAll(attrs);
        super.setAttributes(baseAttrs);
    }

    String getNature() {
        return this.nature;
    }

    private void setIdsOfCompositesWithThisRoot(Vector v) {
        this.idsOfCompositesWithThisRoot = v;
    }

    private void makeVerbMeanings() {
        String[] frenchMeanings;
        String[] englishMeanings = Base.makeVerbMeanings(this.englishMeaning, "en");
        if (englishMeanings != null) {
            this.transitiveMeaning_e = englishMeanings[0];
            this.passiveMeaning_e = englishMeanings[1];
            this.reflexiveMeaning_e = englishMeanings[2];
            this.resultMeaning_e = englishMeanings[3];
        }
        if ((frenchMeanings = Base.makeVerbMeanings(this.frenchMeaning, "fr")) != null) {
            this.transitiveMeaning_f = frenchMeanings[0];
            this.passiveMeaning_f = frenchMeanings[1];
            this.reflexiveMeaning_f = frenchMeanings[2];
            this.resultMeaning_f = frenchMeanings[3];
        }
    }

    private static String[] makeVerbMeanings(String sense, String lang) {
        if (sense == null) {
            return null;
        }
        String transitiveMeaning = "";
        String passiveMeaning = "";
        String resultMeaning = "";
        String reflexiveMeaning = "";
        Pattern pt = Pattern.compile("\\x5B(-)?([RTPAI])\\x5D([^\\x5B]+)");
        Matcher mpt = pt.matcher(sense);
        int pos = 0;
        if (!sense.startsWith("[")) {
            sense = "[A]" + sense;
            mpt = pt.matcher(sense);
        }
        while (mpt.find(pos)) {
            String texte = null;
            boolean modeBool = true;
            boolean trans = true;
            boolean pass = true;
            boolean refl = true;
            texte = mpt.group(3);
            String mode = mpt.group(2);
            if (mpt.group(1) != null) {
                modeBool = false;
            }
            if (mode.equals("R")) {
                if (modeBool) {
                    trans = false;
                    pass = false;
                } else {
                    refl = false;
                }
            } else if (mode.equals("T")) {
                if (modeBool) {
                    refl = false;
                    pass = false;
                } else {
                    trans = false;
                }
            } else if (mode.equals("P")) {
                if (modeBool) {
                    trans = false;
                    refl = false;
                } else {
                    pass = false;
                }
            }
            Pattern pm = Pattern.compile("(to )?/(([a-zA-Z\u00c3\u00a0\u00c3\u00a2\u00c3\u00a9\u00c3\u00a8\u00c3\u00aa\u00c3\u00ab\u00c3\u00ae\u00c3\u00af\u00c3\u00b4\u00c3\u00b9\u00c3\u00bb\u00c3\u00bc]|-)+)");
            Matcher mpm = pm.matcher(texte);
            int pos2 = 0;
            boolean toBool = !lang.equals("en");
            while (mpm.find(pos2)) {
                String key;
                String to = "";
                if (mpm.group(1) != null) {
                    to = mpm.group(1);
                    toBool = true;
                } else if (lang.equals("en")) {
                    toBool = false;
                }
                String verbWord = key = mpm.group(2);
                verbWord = verbWord.replaceFirst("-[^-]+$", "");
                String verbPart = key.replace(verbWord, "");
                VerbWord verb = (VerbWord)LinguisticDataAbstract.words.get(verbWord);
                String partPassive = texte.substring(pos2, mpm.start());
                String partReflexive = texte.substring(pos2, mpm.start());
                if (lang.equals("en")) {
                    partPassive = partPassive.replaceAll("on top of s.t.", "atop");
                    partPassive = partPassive.replaceAll("s.t.'s", "its");
                    partPassive = partPassive.replaceAll("s.o.'s", "his or her");
                    partPassive = partPassive.replaceAll(" s[.]o[.] or s[.]t[.]", "");
                    partPassive = partPassive.replaceAll(" s[.]t[.] or s[.]o[.]", "");
                    partPassive = partPassive.replaceAll(" s[.]o[.]", "");
                    partPassive = partPassive.replaceAll(" s[.]t[.]", "");
                    partReflexive = partReflexive.replaceAll("s.t.'s", "its own");
                    partReflexive = partReflexive.replaceAll("s.o.'s", "his or her own");
                    partReflexive = partReflexive.replaceAll("s[.]o[.] or s[.]t[.]", "oneself or itself");
                    partReflexive = partReflexive.replaceAll("s[.]t[.] or s[.]o[.]", "itself or oneself");
                    partReflexive = partReflexive.replaceAll("s[.]o[.]", "oneself");
                    partReflexive = partReflexive.replaceAll("s[.]t[.]", "itself");
                } else if (lang.equals("fr")) {
                    partPassive = partPassive.replaceAll(" qqn ou qqch[.]", "");
                    partPassive = partPassive.replaceAll(" qqch[.] ou qqn", "");
                    partPassive = partPassive.replaceAll(" qqn", "");
                    partPassive = partPassive.replaceAll(" qqch[.]", "");
                    if (pass) {
                        passiveMeaning = String.valueOf(passiveMeaning) + partPassive;
                    }
                    partReflexive = partReflexive.replaceAll(" qqn ou qqch[.]", "");
                    partReflexive = partReflexive.replaceAll(" qqch[.] ou qqn", "");
                    partReflexive = partReflexive.replaceAll(" qqn", "");
                    partReflexive = partReflexive.replaceAll(" qqch[.]", "");
                }
                if (refl) {
                    reflexiveMeaning = String.valueOf(reflexiveMeaning) + partReflexive + to;
                }
                if (refl) {
                    resultMeaning = String.valueOf(resultMeaning) + partPassive + to;
                }
                if (lang.equals("fr")) {
                    if (refl) {
                        reflexiveMeaning = String.valueOf(reflexiveMeaning) + (Util.isVowel(key.charAt(0)) ? "s'" : "se ");
                    }
                    if (pass) {
                        passiveMeaning = String.valueOf(passiveMeaning) + (toBool ? "\u00c3\u00aatre " : "");
                    }
                    toBool = false;
                } else if (pass) {
                    passiveMeaning = String.valueOf(passiveMeaning) + partPassive + (toBool ? String.valueOf(to) + "be " : "");
                }
                if (pass) {
                    String vpass = null;
                    if (lang.equals("en")) {
                        vpass = verb != null ? verb.passive : (key.endsWith("e") ? String.valueOf(key) + "d" : (key.endsWith("y") ? String.valueOf(key.substring(0, key.length() - 1)) + "ied" : String.valueOf(key) + "ed"));
                    } else if (lang.equals("fr")) {
                        if (verb != null) {
                            vpass = String.valueOf(verb.passive) + verbPart;
                        } else if (verbWord.endsWith("er")) {
                            vpass = String.valueOf(verbWord.replaceAll("er$", "\u00c3\u00a9")) + verbPart;
                        } else if (verbWord.endsWith("ir")) {
                            vpass = String.valueOf(verbWord.replaceAll("ir$", "i")) + verbPart;
                        }
                        if (verbWord.startsWith("se-")) {
                            verbWord = verbWord.replace("se-", "");
                        }
                        if (key.endsWith("-\u00c3\u00a0") || key.endsWith("-contre") || key.endsWith("-de") || key.endsWith("-dans")) {
                            vpass = "se faire " + verbWord;
                        } else if (key.endsWith("-sur")) {
                            vpass = "se faire " + verbWord + " dessus";
                        }
                    } else {
                        vpass = key;
                    }
                    passiveMeaning = String.valueOf(passiveMeaning) + "/" + vpass;
                    passiveMeaning = passiveMeaning.replace("\u00c3\u00aatre /se faire", "/se faire");
                }
                if (refl) {
                    reflexiveMeaning = String.valueOf(reflexiveMeaning) + key.replaceFirst("-[^-]+$", "");
                }
                if (refl) {
                    resultMeaning = String.valueOf(resultMeaning) + "/" + key;
                }
                if (trans) {
                    transitiveMeaning = String.valueOf(transitiveMeaning) + texte.substring(pos2, mpm.start()) + to + key;
                }
                pos2 = mpm.end();
            }
            String partPassive = texte.substring(pos2);
            String partReflexive = texte.substring(pos2);
            if (trans) {
                transitiveMeaning = String.valueOf(transitiveMeaning) + texte.substring(pos2);
            }
            if (trans && pos2 != 0) {
                if (lang.equals("en")) {
                    partPassive = partPassive.replaceAll("on top of s.t.", "atop");
                    partPassive = partPassive.replaceAll("s.t.'s", "its");
                    partPassive = partPassive.replaceAll("s.o.'s", "his or her");
                    partPassive = partPassive.replaceAll(" s[.]o[.] or s[.]t[.]", "");
                    partPassive = partPassive.replaceAll(" s[.]t[.] or s[.]o[.]", "");
                    partPassive = partPassive.replaceAll(" s[.]o[.]", "");
                    partPassive = partPassive.replaceAll(" s[.]t[.]", "");
                    partReflexive = partReflexive.replaceAll("s.t.'s", "its own");
                    partReflexive = partReflexive.replaceAll("s.o.'s", "his or her own");
                    partReflexive = partReflexive.replaceAll("s[.]o[.] or s[.]t[.]", "oneself or itself");
                    partReflexive = partReflexive.replaceAll("s[.]t[.] or s[.]o[.]", "itself or oneself");
                    partReflexive = partReflexive.replaceAll("s[.]o[.]", "oneself");
                    partReflexive = partReflexive.replaceAll("s[.]t[.]", "itself");
                } else if (lang.equals("fr")) {
                    partPassive = partPassive.replaceAll(" qqn ou qqch[.]", "");
                    partPassive = partPassive.replaceAll(" qqch[.] ou qqn", "");
                    partPassive = partPassive.replaceAll(" qqn", "");
                    partPassive = partPassive.replaceAll(" qqch[.]", "");
                    partReflexive = partReflexive.replaceAll(" qqn ou qqch[.]", "");
                    partReflexive = partReflexive.replaceAll(" qqch[.] ou qqn", "");
                    partReflexive = partReflexive.replaceAll(" qqn", "");
                    partReflexive = partReflexive.replaceAll(" qqch[.]", "");
                }
            }
            if (trans) {
                transitiveMeaning = transitiveMeaning.replace("se-", "se ");
            }
            if (trans) {
                transitiveMeaning = transitiveMeaning.replace("-\u00c3\u00a0", " \u00c3\u00a0");
            }
            if (trans) {
                transitiveMeaning = transitiveMeaning.replace("-contre", " contre");
            }
            if (trans) {
                transitiveMeaning = transitiveMeaning.replace("-de ", " de ");
            }
            if (trans) {
                transitiveMeaning = transitiveMeaning.replace("-dans ", " dans ");
            }
            if (trans) {
                transitiveMeaning = transitiveMeaning.replace("-sur ", " sur ");
            }
            if (refl) {
                reflexiveMeaning = reflexiveMeaning.replace("-\u00c3\u00a0", "");
            }
            if (pass) {
                passiveMeaning = String.valueOf(passiveMeaning) + partPassive;
            }
            if (pass) {
                passiveMeaning = passiveMeaning.replaceAll("be /made ", "be made to ");
            }
            if (pass) {
                passiveMeaning = passiveMeaning.replaceAll("/", "");
            }
            if (refl) {
                reflexiveMeaning = String.valueOf(reflexiveMeaning) + partReflexive;
            }
            if (refl) {
                resultMeaning = String.valueOf(resultMeaning) + partPassive;
            }
            if (refl) {
                resultMeaning = resultMeaning.replaceAll("to /make", "to");
            }
            if (refl) {
                resultMeaning = resultMeaning.replaceAll("/make", "to");
            }
            if (refl) {
                resultMeaning = resultMeaning.replaceAll("/", "");
            }
            pos = mpt.end();
        }
        passiveMeaning = passiveMeaning.trim();
        if (reflexiveMeaning.equals("")) {
            reflexiveMeaning = null;
        }
        if (resultMeaning.equals("")) {
            resultMeaning = null;
        }
        return new String[]{transitiveMeaning, passiveMeaning, reflexiveMeaning, resultMeaning};
    }

    @Override
    public String showData() {
        String res;
        String pass;
        String refl;
        String trans;
        StringBuffer sb = new StringBuffer();
        sb.append("[Base: morpheme= " + this.morpheme + "\n");
        sb.append("id= " + this.id + "\n");
        sb.append("variant= " + this.variant + "\n");
        sb.append("nb= " + this.nb + "\n");
        sb.append("type= " + this.type + "\n");
        sb.append("nature= " + this.nature + "\n");
        sb.append("number= " + this.number + "\n");
        sb.append("compositionRoot= " + this.compositionRoot + "\n");
        if (this.type.equals("v")) {
            sb.append("antipassive= " + this.antipassive + "\n");
        }
        if (this.nextCondition != null) {
            sb.append("followingSpecificConditions= " + this.nextCondition.toString() + "\n");
        }
        sb.append("englishMeaning= " + this.englishMeaning + "\n");
        if (this.type.equals("v") && this.transitivity != null && this.transitivity.equals("t")) {
            trans = this.getTransitiveMeaning("en");
            refl = this.getReflexiveMeaning("en");
            pass = this.getPassiveMeaning("en");
            res = this.getResultMeaning("en");
            sb.append("(trans) " + trans + "\n" + (pass != null ? "(pass) " + pass : "") + "\n" + (refl != null ? "(reflex) " + refl : "") + "\n" + (res != null ? "(res) " + res : "") + "\n");
        }
        sb.append("frenchMeaning= " + this.frenchMeaning + "\n");
        if (this.type.equals("v") && this.transitivity != null && this.transitivity.equals("t")) {
            trans = this.getTransitiveMeaning("fr");
            refl = this.getReflexiveMeaning("fr");
            pass = this.getPassiveMeaning("fr");
            res = this.getResultMeaning("fr");
            sb.append("(trans) " + trans + "\n" + (pass != null ? "(pass) " + pass : "") + "\n" + (refl != null ? "(reflex) " + refl : "") + "\n" + (res != null ? "(res) " + res : "") + "\n");
        }
        sb.append("dbName= " + this.dbName + "\n");
        sb.append("tableName= " + this.tableName + "\n");
        sb.append("dialect= " + this.dialect + "\n");
        sb.append("cf= " + this.cf + "\n");
        sb.append("]");
        return sb.toString();
    }
}

