/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Action;
import data.Affix;
import data.LinguisticDataAbstract;
import data.constraints.Conditions;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import morph.AffixPartOfComposition;

public abstract class Morpheme
implements Cloneable {
    public String id = null;
    public String type = null;
    public String morpheme;
    public String englishMeaning = null;
    public String frenchMeaning = null;
    String nb = null;
    String[] sources = null;
    Integer num = null;
    String dbName = null;
    String tableName = null;
    Id idObj = null;
    String dialect = null;
    String[] combinedMorphemes = null;
    String cf = null;
    String[] cfs = null;
    Conditions preCondition = null;
    Conditions nextCondition = null;
    private HashMap attributes = null;

    abstract boolean agreeWithTransitivity(String var1);

    public abstract String showData();

    abstract void setAttrs();

    public abstract String getSignature();

    public abstract String getOriginalMorpheme();

    public String[] getCombiningParts() {
        return this.combinedMorphemes;
    }

    public Morpheme copyOf() throws CloneNotSupportedException {
        return (Morpheme)this.clone();
    }

    public Conditions getPrecCond() {
        return this.preCondition;
    }

    public Conditions getNextCond() {
        return this.nextCondition;
    }

    public boolean meetsTransitivityCondition(String transitivity) {
        boolean res = this.agreeWithTransitivity(transitivity);
        return res;
    }

    public boolean meetsConditions(Conditions conds, Vector followingMorphemes) {
        boolean res = true;
        if (conds != null) {
            res = conds.isMetBy(this);
        }
        if (res && this.getNextCond() != null && followingMorphemes.size() != 0) {
            Affix affPrec = ((AffixPartOfComposition)followingMorphemes.elementAt(0)).getAffix();
            res = this.getNextCond().isMetBy(affPrec);
        }
        return res;
    }

    public Morpheme getLastCombiningMorpheme() {
        String[] parts = this.getCombiningParts();
        String lastPart = null;
        Morpheme lastMorpheme = null;
        if (parts != null && !(lastPart = parts[parts.length - 1]).equals("?")) {
            lastMorpheme = Morpheme.getMorpheme(lastPart);
        }
        return lastMorpheme;
    }

    public static Morpheme getMorpheme(String morphemeId) {
        Morpheme morph = LinguisticDataAbstract.getAffix(morphemeId);
        if (morph == null) {
            morph = LinguisticDataAbstract.getBase(morphemeId);
        }
        return morph;
    }

    public boolean attrEqualsValue(String attr, String val, boolean eq) {
        boolean res = false;
        String valAttr = attr.equals("cas") ? this.getAttr("grammCase") : this.getAttr(attr);
        String valAspect = val;
        if (this.attributes.containsKey(valAspect)) {
            valAspect = this.getAttr(valAspect);
        }
        if (valAspect.equals("null")) {
            res = eq ? valAttr == null : valAttr != null;
        } else if (valAttr != null) {
            String[] valAttrs = valAttr.split(" ");
            if (eq) {
                int iValAttrs = 0;
                while (iValAttrs < valAttrs.length) {
                    res = valAttrs[iValAttrs].equals(valAspect);
                    if (!res) {
                        ++iValAttrs;
                        continue;
                    }
                    break;
                }
            } else {
                int iValAttrs = 0;
                while (iValAttrs < valAttrs.length) {
                    res = !valAttr.equals(valAspect);
                    ++iValAttrs;
                }
            }
        } else {
            res = false;
        }
        return res;
    }

    String getNb() {
        return this.nb;
    }

    void setId() {
        this.idObj = new Id(this.getOriginalMorpheme(), this.getSignature());
        this.id = this.idObj.id;
        this.attributes.put("id", this.id);
    }

    String getAttr(String attr) {
        return (String)this.attributes.get(attr);
    }

    void setAttributes(HashMap attrs) {
        this.attributes = new HashMap();
        this.attributes.putAll(attrs);
        this.attributes.put("type", this.type);
        this.attributes.put("nb", this.nb);
        this.attributes.put("morpheme", this.morpheme);
        this.attributes.put("englishMeaning", this.englishMeaning);
        this.attributes.put("frenchMeaning", this.frenchMeaning);
        this.attributes.put("sources", this.sources);
        this.attributes.put("num", this.num);
        this.attributes.put("dbName", this.dbName);
        this.attributes.put("tableName", this.tableName);
        this.attributes.put("idObj", this.idObj);
        this.attributes.put("dialect", this.dialect);
        this.attributes.put("cf", this.cf);
        this.attributes.put("cfs", this.cfs);
        this.attributes.put("preCondition", this.preCondition);
        this.attributes.put("nextCondition", this.nextCondition);
        this.attributes.put("combinedMorphemes", this.combinedMorphemes);
    }

    public static String combine(String combination, boolean withAction2, String highlightedMorpheme) {
        String[] morphemes = combination.split("\\x2b");
        Morpheme morpheme = LinguisticDataAbstract.getMorpheme(morphemes[0]);
        String combinedForm = morpheme.morpheme;
        char context = combinedForm.charAt(combinedForm.length() - 1);
        int i = 1;
        while (i < morphemes.length) {
            String precForm = combinedForm;
            Affix aff = (Affix)LinguisticDataAbstract.getMorpheme(morphemes[i]);
            Action[] action1 = aff.getAction1(context);
            Action[] action2 = aff.getAction2(context);
            String formAff = aff.getForm(context)[0];
            Action a2 = null;
            if (withAction2) {
                a2 = action2[0];
            }
            combinedForm = action1[0].combine(precForm, formAff, a2);
            context = combinedForm.charAt(combinedForm.length() - 1);
            if (highlightedMorpheme != null && morphemes[i].equals(highlightedMorpheme)) {
                combinedForm = combinedForm.replaceFirst(formAff, "<span style=\"color:red\">" + formAff + "</span>");
            }
            ++i;
        }
        return combinedForm;
    }

    public static class Id {
        public static String delimiter = "/";
        public String morphemeName;
        public String signature;
        public String id;

        public Id(String morphId) {
            StringTokenizer st = new StringTokenizer(morphId, delimiter);
            if (st.countTokens() == 2) {
                this.morphemeName = st.nextToken();
                this.signature = st.nextToken();
                this.id = morphId;
            }
        }

        public Id(String morphName, String sign) {
            this.morphemeName = morphName;
            this.signature = sign;
            this.id = String.valueOf(this.morphemeName) + delimiter + this.signature;
        }

        public String toHTML() {
            return String.valueOf(this.morphemeName) + "<sup>" + this.signature + "</sup>";
        }

        public static String toHTML(String morphemeId) {
            String morphName = morphemeId.substring(0, morphemeId.indexOf(delimiter));
            String sign = morphemeId.substring(morphemeId.indexOf(delimiter) + 1);
            return String.valueOf(morphName) + "<sub>" + sign + "</sub>";
        }
    }
}

