/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Action;
import data.Example;
import data.Item;
import data.LinguisticDataAbstract;
import data.Morpheme;
import data.NounEnding;
import data.Roots;
import data.Source;
import data.Suffix;
import data.VerbEnding;
import data.constraints.Conditions;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import script.Roman;
import script.TransCoder;
import utilities1.Util;

public class Suffixes {
    private static Logger LOG = Logger.getLogger(Suffixes.class);
    static boolean syllabic = true;
    static String lang = "en";
    static String lang_default = "en";
    static String inuktitutDisplayFont = null;
    static boolean plain = false;
    static String nl = System.getProperty("line.separator");

    public static void getDef(String[] args, PrintStream out) {
        try {
            String suffixId = null;
            lang = Util.getArgument(args, "l");
            suffixId = Util.getArgument(args, "m");
            String font = Util.getArgument(args, "p");
            String plainFlag = Util.getArgument(args, "plain");
            if (plainFlag != null && plainFlag.toLowerCase().equals("1")) {
                plain = true;
            }
            if (font != null) {
                inuktitutDisplayFont = font;
            }
            if (lang == null) {
                lang = lang_default;
            }
            StringBuffer output = new StringBuffer();
            Suffix suf = LinguisticDataAbstract.getSuffix(suffixId);
            output.append(Suffixes.startParagraph());
            output.append(Suffixes.composeSuffixeDisplay(suf));
            output.append(Suffixes.blankLine());
            output.append(Suffixes.endParagraph());
            out.print(output.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String startParagraph() {
        return plain ? String.valueOf(nl) + nl : String.valueOf(nl) + "<p>" + nl;
    }

    private static String endParagraph() {
        return plain ? "" : "</p>" + nl;
    }

    private static String blankLine() {
        return plain ? String.valueOf(nl) + nl : "<br><br>" + nl;
    }

    private static String twoSpaces() {
        return plain ? "  " : "&nbsp;&nbsp;";
    }

    private static String threeSpaces() {
        return plain ? "   " : "&nbsp;&nbsp;&nbsp;";
    }

    private static String horizontalLine() {
        return plain ? String.valueOf(nl) + "----------------------------------------------" : "<hr>" + nl;
    }

    private static String newLine() {
        return plain ? nl : "<br>";
    }

    private static String composeSuffixeDisplay(Suffix aff) {
        StringBuffer output = new StringBuffer();
        if (!plain) {
            output.append("<span style=\"font-size:10pt;color:green\">");
            output.append("<span style=\"font-weight:bold;\">");
        }
        if (inuktitutDisplayFont == null) {
            LOG.debug((Object)aff.morpheme);
            String unicode = TransCoder.romanToUnicode(aff.morpheme);
            LOG.debug((Object)unicode);
            output.append(unicode);
        } else {
            if (!plain) {
                output.append("<span style=\"font-family:" + inuktitutDisplayFont + "\">");
            }
            output.append(TransCoder.romanToLegacy(aff.morpheme, inuktitutDisplayFont));
            if (!plain) {
                output.append("</span>");
            }
        }
        output.append(Suffixes.twoSpaces());
        output.append(String.valueOf(aff.morpheme) + " ");
        if (!plain) {
            output.append("</span>" + nl);
            output.append("<span style=\"font-style:italic;font-size:8pt\">");
        }
        output.append("(" + aff.getSignature() + ")");
        if (!plain) {
            output.append("</span>");
        }
        if (!plain) {
            output.append("</span>");
        }
        output.append(Suffixes.horizontalLine());
        output.append(Suffixes.startParagraph());
        if (!plain) {
            output.append("<span style=\"font-weight:bold\">");
        }
        output.append(lang.equals("en") ? "Meaning" : "Signification");
        if (!plain) {
            output.append("</span>");
        } else {
            output.append(":");
        }
        output.append(Suffixes.newLine());
        String meaning = lang.equals("en") ? aff.englishMeaning : aff.frenchMeaning;
        output.append(Item.process_marked_up(meaning, plain));
        if (aff.nature != null && aff.nature.equals("freq")) {
            output.append(Suffixes.blankLine());
            if (lang.equals("en")) {
                output.append("This infix is a frequentative.  Frequentatives are often used ");
                output.append("with perfect verb roots (action in the past with result in the present) to indicate that the action is ");
                output.append("actually taking place in the present time.  For example: ");
                output.append(Suffixes.newLine());
                output.append(Suffixes.threeSpaces());
                if (!plain) {
                    output.append("<b>iqqanaiqpaa</b> - he has finished it");
                } else {
                    output.append("iqqanaiqpaa - he has finished it");
                }
                output.append(Suffixes.newLine());
                output.append(Suffixes.threeSpaces());
                if (!plain) {
                    output.append("<b>iqqanai<i>jaq</i>paa</b> - he is finishing it");
                } else {
                    output.append("iqqanaijaqpaa - he is finishing it");
                }
            } else if (lang.equals("fr")) {
                output.append("Cet infixe est un fr\u00c3\u00a9quentatif.  Les fr\u00c3\u00a9quentatifs sont souvent utilis\u00c3\u00a9s ");
                output.append("avec les racines verbales \u00c3\u00a0 aspect r\u00c3\u00a9sultatif (une action dans le pass\u00c3\u00a9 avec un effet dans le pr\u00c3\u00a9sent), pour indiquer que l'action se d\u00c3\u00a9roule ");
                output.append("dans le pr\u00c3\u00a9sent.  Par exemple:");
                output.append(Suffixes.newLine());
                output.append(Suffixes.threeSpaces());
                if (!plain) {
                    output.append("<b>iqqanaiqpaa</b> - il l'a termin\u00c3\u00a9");
                } else {
                    output.append("iqqanaiqpaa - il l'a termin\u00c3\u00a9");
                }
                output.append(Suffixes.newLine());
                output.append(Suffixes.threeSpaces());
                if (!plain) {
                    output.append("<b>iqqanai<i>jaq</i>paa</b> - il le termine, est en train de le terminer");
                } else {
                    output.append("iqqanaijaqpaa - il le termine, est en train de le terminer");
                }
            }
        }
        output.append(Suffixes.endParagraph());
        output.append(Suffixes.startParagraph());
        if (!plain) {
            output.append("<span style=\"font-weight:bold\">");
        }
        output.append("Type");
        if (!plain) {
            output.append("</span>");
        } else {
            output.append(":");
        }
        output.append(Suffixes.newLine());
        output.append(LinguisticDataAbstract.getTextualRendering(aff.type, lang));
        if (aff.type.equals("sn") || aff.type.equals("sv")) {
            output.append(", " + LinguisticDataAbstract.getTextualRendering(aff.function, lang));
            output.append(", " + LinguisticDataAbstract.getTextualRendering("function", lang) + " " + LinguisticDataAbstract.getTextualRendering(aff.function.substring(1, 2), lang));
            if (aff.antipassive != null) {
                output.append("<ul><li>");
                if (lang.equals("en")) {
                    output.append("requires the suffix(es) ");
                } else if (lang.equals("fr")) {
                    output.append("requiert le(s) suffixe(s) ");
                }
                String[] antipassives = aff.antipassive.split(" ");
                int i = 0;
                while (i < antipassives.length) {
                    String[] parts = antipassives[i].split("/");
                    output.append("<a href=");
                    output.append("\"javascript:appelerDescriptionSuffixe(");
                    if (inuktitutDisplayFont == null) {
                        output.append("'" + antipassives[i] + "',null");
                    } else {
                        output.append("'" + antipassives[i] + "','" + inuktitutDisplayFont + "'");
                    }
                    output.append(")\">");
                    output.append(parts[0]);
                    output.append("</a>");
                    output.append("<sub style=\"font-size:75%\">" + parts[1] + "</sub>");
                    output.append("&nbsp;");
                    ++i;
                }
                if (lang.equals("en")) {
                    output.append(" when used with intransitive verb endings or suffixes in order to keep the transitive sense of the verbal suffix and avoid a passive or reflexive interpretation:");
                } else if (lang.equals("fr")) {
                    output.append(" lorsqu'utilis\u00c3\u00a9e avec des terminaisons verbales ou des suffixes intransitifs de fa\u00c3\u00a7on \u00c3\u00a0 conserver le sens transitif du suffixe verbal et ne pas \u00c3\u00aatre interpr\u00c3\u00a9t\u00c3\u00a9 passivement ou r\u00c3\u00a9flexivement&nbsp;:");
                }
                i = 0;
                while (i < antipassives.length) {
                    String combination = String.valueOf(aff.id) + "+" + antipassives[i];
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("combination= '" + combination + "'"));
                    }
                    String combined = Morpheme.combine(combination, true, null);
                    output.append(Roots.composeCombinationDisplay(combined));
                    ++i;
                }
                output.append("</li></ul>");
            }
            if (aff.mobility != null) {
                output.append(Suffixes.startParagraph());
                if (!plain) {
                    output.append("<span style=\"font-weight:bold\">");
                }
                output.append(lang.equals("en") ? "Mobility" : "Mobilit\u00c3\u00a9");
                if (!plain) {
                    output.append("</span>");
                } else {
                    output.append(":");
                }
                output.append(Suffixes.newLine());
                if (aff.mobility.equals("non")) {
                    output.append(lang.equals("en") ? "not " : "non ");
                }
                output.append("mobile: ");
                if (lang.equals("en")) {
                    if (aff.mobility.equals("non")) {
                        output.append("this suffix cannot be used at will; it can be used only with certain well defined roots.");
                    } else {
                        output.append("this suffix can be used at will with all roots and stems of the proper type.");
                    }
                } else if (lang.equals("fr")) {
                    if (aff.mobility.equals("non")) {
                        output.append("ce suffixe ne peut pas \u00c3\u00aatre utilis\u00c3\u00a9 \u00c3\u00a0 volont\u00c3\u00a9; il peut \u00c3\u00aatre utilis\u00c3\u00a9 uniquement avec certaines racines bien d\u00c3\u00a9finies.");
                    } else {
                        output.append("ce suffixe peut \u00c3\u00aatre utilis\u00c3\u00a9 \u00c3\u00a0 volont\u00c3\u00a9 avec toutes les racines et tous les radicaux du type appropri\u00c3\u00a9.");
                    }
                }
                output.append(Suffixes.endParagraph());
            }
            output.append(Suffixes.endParagraph());
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append("Position");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            output.append(String.valueOf(lang.equals("en") ? "This suffix" : "Ce suffixe") + " " + LinguisticDataAbstract.getTextualRendering(String.valueOf(aff.position) + "!", lang) + ".");
            output.append(Suffixes.endParagraph());
        } else if (aff.type.equals("tv")) {
            String specif = ((VerbEnding)((Object)aff)).spec;
            output.append(", " + LinguisticDataAbstract.getTextualRendering(specif, lang) + ", ");
            String mode = ((VerbEnding)((Object)aff)).mode;
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(lang.equals("en") ? "Mood" : "Mode");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            output.append(LinguisticDataAbstract.getTextualRendering(mode, lang));
            if (mode.equals("part")) {
                String tense = ((VerbEnding)((Object)aff)).tense;
                String pn = ((VerbEnding)((Object)aff)).posneg;
                if (tense != null) {
                    output.append(", " + LinguisticDataAbstract.getTextualRendering(tense, lang));
                }
                output.append(", " + LinguisticDataAbstract.getTextualRendering(pn, lang));
            }
            output.append(Suffixes.endParagraph());
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(lang.equals("en") ? "Subject" : "Sujet");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            String persSubj = ((VerbEnding)((Object)aff)).subjPers;
            String numbSuj = ((VerbEnding)((Object)aff)).subjNumber;
            output.append(LinguisticDataAbstract.getTextualRendering(String.valueOf(persSubj) + "ordinal", lang));
            output.append(" " + LinguisticDataAbstract.getTextualRendering("personne", lang));
            output.append(" " + LinguisticDataAbstract.getTextualRendering("du", lang));
            output.append(" " + LinguisticDataAbstract.getTextualRendering(numbSuj, lang));
            output.append(Suffixes.endParagraph());
            if (specif.equals("sp")) {
                output.append(Suffixes.startParagraph());
                if (!plain) {
                    output.append("<span style=\"font-weight:bold\">");
                }
                output.append(lang.equals("en") ? "Object" : "Objet");
                if (!plain) {
                    output.append("</span>");
                } else {
                    output.append(":");
                }
                output.append(Suffixes.newLine());
                String persObj = ((VerbEnding)((Object)aff)).objPers;
                String numbObj = ((VerbEnding)((Object)aff)).objNumber;
                output.append(LinguisticDataAbstract.getTextualRendering(String.valueOf(persObj) + "ordinal", lang));
                output.append(" " + LinguisticDataAbstract.getTextualRendering("personne", lang));
                output.append(" " + LinguisticDataAbstract.getTextualRendering("du", lang));
                output.append(" " + LinguisticDataAbstract.getTextualRendering(numbObj, lang));
                output.append(Suffixes.endParagraph());
            }
        } else if (aff.type.equals("tn")) {
            String grammCase = ((NounEnding)((Object)aff)).grammCase;
            String nb = ((NounEnding)((Object)aff)).number;
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(lang.equals("en") ? "Case and number" : "Cas et number");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            output.append(LinguisticDataAbstract.getTextualRendering(grammCase, lang));
            output.append(" " + LinguisticDataAbstract.getTextualRendering(nb, lang));
            String persPos = ((NounEnding)((Object)aff)).possPers;
            String nbPos = ((NounEnding)((Object)aff)).possNumber;
            if (persPos != null) {
                output.append(" " + LinguisticDataAbstract.getTextualRendering("possessif", lang));
                output.append(Suffixes.endParagraph());
                output.append(Suffixes.startParagraph());
                if (!plain) {
                    output.append("<span style=\"font-weight:bold\">");
                }
                output.append(LinguisticDataAbstract.getTextualRendering("possesseur", lang));
                if (!plain) {
                    output.append("</span>");
                } else {
                    output.append(":");
                }
                output.append(Suffixes.newLine());
                output.append(LinguisticDataAbstract.getTextualRendering(String.valueOf(persPos) + "ordinal", lang));
                output.append(" " + LinguisticDataAbstract.getTextualRendering("personne", lang));
                output.append(" " + LinguisticDataAbstract.getTextualRendering("du", lang));
                output.append(" " + LinguisticDataAbstract.getTextualRendering(nbPos, lang));
                output.append(Suffixes.endParagraph());
            }
        } else {
            output.append(Suffixes.endParagraph());
        }
        if (aff.combinedMorphemes != null) {
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(lang.equals("en") ? "Combination" : "Combinaison");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            output.append(lang.equals("en") ? "This complex suffix is a combination of the suffixes: " : "Ce suffixe complexe est la combinaison des suffixes: ");
            int i = 0;
            while (i < aff.combinedMorphemes.length) {
                if (i != 0) {
                    if (!plain) {
                        output.append("&nbsp;+&nbsp;");
                    } else {
                        output.append(" + ");
                    }
                }
                if (!plain) {
                    output.append("<a href=\"javascript:appelerDescriptionSuffixe(");
                    if (inuktitutDisplayFont == null) {
                        output.append("'" + aff.combinedMorphemes[i] + "',null");
                    } else {
                        output.append("'" + aff.combinedMorphemes[i] + "','" + inuktitutDisplayFont + "'");
                    }
                    output.append(")\">");
                }
                String[] ps = aff.combinedMorphemes[i].split("/");
                output.append(ps[0]);
                if (!plain) {
                    output.append("</a>");
                }
                if (!plain) {
                    output.append("<sub style=\"font-size:75%\">");
                } else {
                    output.append("/");
                }
                output.append(ps[1]);
                if (!plain) {
                    output.append("</sub>");
                }
                ++i;
            }
            output.append(Suffixes.endParagraph());
        }
        output.append(Suffixes.startParagraph());
        if (!plain) {
            output.append("<span style=\"font-weight:bold\">");
        }
        output.append(lang.equals("en") ? "Variants and actions" : "Variantes et actions");
        if (!plain) {
            output.append("</span>");
        } else {
            output.append(":");
        }
        output.append(Suffixes.newLine());
        Vector<Object[]> vars = new Vector<Object[]>();
        vars.add(new Object[]{"V", aff.vform, aff.vaction1, aff.vaction2});
        vars.add(new Object[]{"t", aff.tform, aff.taction1, aff.taction2});
        vars.add(new Object[]{"k", aff.kform, aff.kaction1, aff.kaction2});
        vars.add(new Object[]{"q", aff.qform, aff.qaction1, aff.qaction2});
        if (!plain) {
            output.append("<table border=1 style=\"font-family:Pigiarniq;font-size:8pt\">");
        }
        String fintd = "</td>";
        int k = 0;
        while (k < vars.size()) {
            Object[] var = (Object[])vars.elementAt(k);
            String cntxt = (String)var[0];
            String[] forms = (String[])var[1];
            Action[] act1 = (Action[])var[2];
            Action[] act2 = (Action[])var[3];
            if (!plain) {
                output.append(String.valueOf(nl) + "<tr valign=top>");
                output.append(String.valueOf(nl) + "<td colspan=4 style=\"background-color:#ffffcc;\">");
            } else {
                output.append(nl);
            }
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("apr\u00c3\u00a8s", lang)) + " ");
            if (cntxt.equals("V")) {
                output.append(LinguisticDataAbstract.getTextualRendering(cntxt, lang));
            } else {
                output.append(cntxt);
            }
            if (!plain) {
                output.append("</td>");
                output.append("</tr>");
            }
            if (forms.length == 0) {
                if (!plain) {
                    output.append(String.valueOf(nl) + "<tr valign=top>");
                    output.append(String.valueOf(nl) + "<td colspan=4>");
                } else {
                    output.append(nl);
                }
                if (lang.equals("en")) {
                    output.append("This morpheme is never encountered in this context.");
                } else if (lang.equals("fr")) {
                    output.append("Ce morph\u00c3\u00a8me n'est jamais rencontr\u00c3\u00a9 dans ce contexte.");
                }
                if (!plain) {
                    output.append("</td>");
                    output.append("</tr>");
                }
            } else {
                int z = 0;
                while (z < forms.length) {
                    String outputAction = null;
                    if (!plain) {
                        output.append(String.valueOf(nl) + "<tr valign=top>");
                    } else {
                        output.append(nl);
                    }
                    if (forms[z].equals("?")) {
                        if (!plain) {
                            output.append(String.valueOf(nl) + "<td colspan=4>");
                        }
                        if (lang.equals("en")) {
                            output.append("The form in this context is not known to us at this moment.  ");
                        } else {
                            output.append("La forme dans ce contexte ne nous est pas connue actuellement.  ");
                        }
                        if (!plain) {
                            output.append("</td>");
                        }
                    } else {
                        String form;
                        int rowSpan = 1;
                        if (act2[z].getType() != Action.NULLACTION) {
                            rowSpan = 2;
                        }
                        String string = form = forms[z].equals("*") ? aff.morpheme : forms[z];
                        if (!plain) {
                            output.append(String.valueOf(nl) + "<td rowspan=" + rowSpan + ">");
                            output.append("<span style=\"font-weight:bold\">");
                        }
                        if (inuktitutDisplayFont == null) {
                            output.append(TransCoder.romanToUnicode(form));
                        } else {
                            if (!plain) {
                                output.append("<span style=\"font-family:" + inuktitutDisplayFont + "\">");
                            }
                            output.append(TransCoder.romanToLegacy(form, inuktitutDisplayFont));
                            if (!plain) {
                                output.append("</span>");
                            }
                        }
                        if (!plain) {
                            output.append("</span>");
                            output.append("</td>");
                        }
                        if (!plain) {
                            output.append(String.valueOf(nl) + "<td rowspan=" + rowSpan + ">");
                            output.append("<span style=\"font-weight:bold\">");
                        } else {
                            output.append("\t");
                        }
                        output.append(form);
                        if (!plain) {
                            output.append("</span></td>");
                        }
                        if (!plain) {
                            output.append(String.valueOf(nl) + "<td style=\"width:50%;\">");
                        } else {
                            output.append("\t");
                        }
                        outputAction = Suffixes.composeAction1(act1[z], aff, forms[z], cntxt, lang);
                        output.append(outputAction);
                        if (!plain) {
                            output.append("</td>");
                        }
                        if (!plain) {
                            output.append("<td><i>");
                        } else {
                            output.append("\t");
                        }
                        String actRes = act1[z].expressionResult(cntxt, forms[z], null);
                        if (plain) {
                            actRes = actRes.replace("&rarr;", "-->");
                        }
                        output.append(actRes);
                        if (!plain) {
                            output.append("</i></td>");
                        }
                    }
                    if (!plain) {
                        output.append("</tr>");
                    }
                    if (act2[z].getType() != Action.NULLACTION) {
                        if (!plain) {
                            output.append("<tr>");
                            output.append("<td>");
                        } else {
                            output.append(nl);
                        }
                        outputAction = Suffixes.composeAction2(act1[z], act2[z], aff, forms[z], cntxt, lang);
                        output.append(outputAction);
                        if (!plain) {
                            output.append("</td>");
                        }
                        if (!plain) {
                            output.append("<td><i>");
                        } else {
                            output.append("\t");
                        }
                        String actRes = act1[z].expressionResult(cntxt, forms[z], act2[z]);
                        if (plain) {
                            actRes = actRes.replace("&rarr;", "-->");
                        }
                        output.append(actRes);
                        if (!plain) {
                            output.append("</i></td>");
                            output.append("</tr>");
                        }
                    }
                    ++z;
                }
            }
            if (!plain) {
                output.append("</tr>");
            }
            ++k;
        }
        if (!plain) {
            output.append("</table>");
        }
        output.append(Suffixes.startParagraph());
        if (!plain) {
            output.append("<i>");
        }
        output.append("Note");
        if (!plain) {
            output.append("</i>");
        }
        output.append(": ");
        if (lang.equals("en")) {
            output.append("When the final consonant of the stem is not affected by the suffix, or when it is voiced or nasalized, or when a consonant is inserted before the suffix, and the suffix starts with a consonant, that group of consonants may be subject to gemination, a phenomenon encountered in several dialects by which the first consonant is assimilated to the second one, for example, ");
        } else if (lang.equals("fr")) {
            output.append("Lorsque la consonne finale du radical n'est pas affect\u00c3\u00a9e par le suffixe, ou lorsqu'elle est sonoris\u00c3\u00a9e ou nasalis\u00c3\u00a9e, ou lorsqu'une consonne est ins\u00c3\u00a9r\u00c3\u00a9e devant le suffixe, et que le suffixe commence par une consonne, ce groupe de consonnes peut \u00c3\u00aatre sujet \u00c3\u00a0 la g\u00c3\u00a9mination, un ph\u00c3\u00a9nom\u00c3\u00a8ne rencontr\u00c3\u00a9 dans plusieurs dialectes selon lequel la premi\u00c3\u00a8re consonne est assimil\u00c3\u00a9e \u00c3\u00a0 la deuxi\u00c3\u00a8me, par exemple, ");
        }
        String ex = "TP &rarr; PP, PV &rarr; VV";
        if (plain) {
            ex = ex.replaceAll("&rarr;", "-->");
        }
        output.append(ex);
        output.append(lang.equals("en") ? ", that is, in syllabics: " : "soit, en syllabique&nbsp;: ");
        ex = "  \u1466\u1431 &rarr; \u1449\u1431, \u1449\u1555 &rarr; \u155d\u1555.";
        if (plain) {
            ex = ex.replaceAll("&rarr;", "-->");
        }
        output.append(ex);
        output.append(Suffixes.endParagraph());
        if (aff.getPrecCond() != null) {
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(lang.equals("en") ? "Special conditions on the preceding morpheme" : "Conditions sp\u00c3\u00a9ciales sur le morph\u00c3\u00a8me pr\u00c3\u00a9c\u00c3\u00a9dent");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            output.append(aff.getPrecCond().toText(lang));
        }
        if (aff.getNextCond() != null) {
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(lang.equals("en") ? "Special conditions on the following morpheme" : "Conditions sp\u00c3\u00a9ciales sur le morph\u00c3\u00a8me suivant");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            output.append(aff.getNextCond().toText(lang));
        }
        output.append(Suffixes.startParagraph());
        if (!plain) {
            output.append("<span style=\"font-weight:bold\">");
        }
        output.append(lang.equals("en") ? "Examples" : "Examples");
        if (!plain) {
            output.append("</span>");
        } else {
            output.append(":");
        }
        output.append(Suffixes.newLine());
        if (!plain) {
            output.append("<table style=\"font-family:Pigiarniq;font-size:8pt\">");
        }
        String signatureKey = String.valueOf(aff.morpheme) + aff.getSignature();
        boolean keyFound = false;
        String endTDplusNBSP = "&nbsp;&nbsp;&nbsp;</td>";
        String[] exKeys = LinguisticDataAbstract.getAllExamplesKeys();
        int ie = 0;
        while (ie < exKeys.length) {
            String key = exKeys[ie];
            if (key.equals(signatureKey)) {
                Vector exs = LinguisticDataAbstract.getExample(signatureKey);
                int i = 0;
                while (i < exs.size()) {
                    Example ex1 = (Example)exs.elementAt(i);
                    if (!plain) {
                        output.append("<tr><td>" + nl);
                    } else {
                        output.append(nl);
                    }
                    output.append(ex1.termExLat);
                    if (!plain) {
                        output.append(endTDplusNBSP);
                    }
                    if (!plain) {
                        output.append("<td>" + nl);
                    } else {
                        output.append("\t");
                    }
                    output.append(ex1.termExSyl);
                    if (!plain) {
                        output.append(endTDplusNBSP);
                    }
                    String exLat = ex1.exampleLat;
                    StringBuffer exLat1 = new StringBuffer();
                    exLat1.append(exLat.substring(0, exLat.indexOf(91)));
                    if (!plain) {
                        exLat1.append("<span style=\"color:red\">");
                    }
                    exLat1.append(exLat.substring(exLat.indexOf(91) + 1, exLat.indexOf(93)));
                    if (!plain) {
                        exLat1.append("</span>");
                    }
                    exLat1.append(exLat.substring(exLat.indexOf(93) + 1));
                    if (!plain) {
                        output.append("<td>" + nl);
                    } else {
                        output.append("\t");
                    }
                    output.append(exLat1.toString());
                    if (!plain) {
                        output.append(endTDplusNBSP);
                    }
                    String exSyl = ex1.exampleSyl;
                    StringBuffer exSyl1 = new StringBuffer();
                    exSyl1.append(exSyl.substring(0, exSyl.indexOf(91)));
                    if (!plain) {
                        exSyl1.append("<span style=\"color:red\">");
                    }
                    exSyl1.append(exSyl.substring(exSyl.indexOf(91) + 1, exSyl.indexOf(93)));
                    if (!plain) {
                        exSyl1.append("</span>");
                    }
                    exSyl1.append(exSyl.substring(exSyl.indexOf(93) + 1));
                    if (!plain) {
                        output.append("<td>" + nl);
                    } else {
                        output.append("\t");
                    }
                    output.append(exSyl1.toString());
                    if (!plain) {
                        output.append(endTDplusNBSP);
                    }
                    if (!plain) {
                        output.append("<td>" + nl);
                    }
                    output.append(lang.equals("en") ? ex1.eng : ex1.fre);
                    if (!plain) {
                        output.append(fintd);
                    }
                    if (!plain) {
                        output.append("</tr>");
                    }
                    ++i;
                }
                keyFound = true;
                break;
            }
            ++ie;
        }
        if (!plain) {
            output.append("</table>");
        }
        if (!keyFound) {
            output.append(lang.equals("en") ? "No example available at this moment." : "Aucun exemple disponible pour le moment.");
        }
        output.append(Suffixes.endParagraph());
        String[] sources = aff.sources;
        if (sources != null) {
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append("Sources");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            int n = 0;
            while (n < sources.length) {
                Source src = LinguisticDataAbstract.getSource(sources[n]);
                output.append(String.valueOf(src.authorSurName) + ", " + src.authorFirstName);
                if (src.authorMidName != null) {
                    output.append(" " + src.authorMidName);
                }
                output.append(", \"");
                if (!plain) {
                    output.append("<i>");
                }
                output.append(src.title);
                if (src.subtitle != null) {
                    output.append(" " + src.subtitle);
                }
                output.append("\"");
                if (!plain) {
                    output.append("</i>");
                }
                output.append(". ");
                output.append(src.publisher);
                if (src.publisherMisc != null) {
                    output.append(", " + src.publisherMisc);
                }
                output.append(", " + src.location + ", " + src.year + ".");
                output.append(Suffixes.blankLine());
                ++n;
            }
            output.append(Suffixes.endParagraph());
        }
        return output.toString();
    }

    private static String process_marked_up(String marked_up) {
        Pattern pat = Pattern.compile("\\[\\[(.+?)\\]\\]");
        Matcher mpat = pat.matcher(marked_up);
        String res = "";
        int pos = 0;
        while (mpat.find(pos)) {
            res = String.valueOf(res) + marked_up.substring(pos, mpat.start());
            res = String.valueOf(res) + "<a href=\"javascript:appelerDescriptionItem('";
            res = String.valueOf(res) + mpat.group(1);
            res = String.valueOf(res) + "','";
            res = inuktitutDisplayFont == null ? String.valueOf(res) + "null" : String.valueOf(res) + inuktitutDisplayFont;
            res = String.valueOf(res) + "');\">";
            res = String.valueOf(res) + mpat.group(1);
            res = String.valueOf(res) + "</a>";
            pos = mpat.end();
        }
        res = String.valueOf(res) + marked_up.substring(pos);
        return res;
    }

    private static String composeAction1(Action action1, Suffix aff, String form, String cntxt, String lang) {
        String morpheme = aff.morpheme;
        StringBuffer output = new StringBuffer();
        int action1Type = action1.getType();
        if (action1Type == Action.UNKNOWN) {
            output.append(Util.premiereMaj(LinguisticDataAbstract.getTextualRendering("l'", lang)));
            if (lang.equals("en")) {
                output.append(" ");
            }
            output.append("action ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("estSing", lang)) + " ");
            output.append(LinguisticDataAbstract.getTextualRendering("inconnue", lang));
        } else if (action1Type == Action.NEUTRAL) {
            if (action1.getCondition() != null) {
                if (lang.equals("en")) {
                    output.append("If the stem ");
                    if (action1.getCondition().startsWith("!")) {
                        output.append("does not meet ");
                    } else {
                        output.append("meets ");
                    }
                    output.append("the condition ");
                } else if (lang.equals("fr")) {
                    output.append("Si le radical ");
                    if (action1.getCondition().startsWith("!")) {
                        output.append("ne rencontre pas ");
                    } else {
                        output.append("rencontre ");
                    }
                    output.append("la condition ");
                }
                if (action1.getCondition().startsWith("!(")) {
                    output.append(action1.getCondition().substring(2, action1.getCondition().length() - 1));
                } else if (action1.getCondition().startsWith("!")) {
                    output.append(action1.getCondition().substring(1));
                } else {
                    output.append(action1.getCondition());
                }
                output.append(", ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("il", lang)) + " ");
            } else {
                output.append(String.valueOf(Util.premiereMaj(LinguisticDataAbstract.getTextualRendering("il", lang))) + " ");
            }
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("neutre", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("la", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("finale", lang)) + " ");
            output.append(LinguisticDataAbstract.getTextualRendering("duradical", lang));
        } else if (action1Type == Action.DELETION) {
            output.append(String.valueOf(Util.premiereMaj(LinguisticDataAbstract.getTextualRendering("il", lang))) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("suppr", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("le", lang)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(LinguisticDataAbstract.getTextualRendering("duradical", lang));
        } else if (action1Type == Action.CONDITIONALDELETION) {
            if (lang.equals("en")) {
                output.append("If the stem ");
                if (action1.getCondition().startsWith("!")) {
                    output.append("does not meet ");
                } else {
                    output.append("meets ");
                }
                output.append("the condition ");
            } else if (lang.equals("fr")) {
                output.append("Si le radical ");
                if (action1.getCondition().startsWith("!")) {
                    output.append("ne rencontre pas ");
                } else {
                    output.append("rencontre ");
                }
                output.append("la condition ");
            }
            if (action1.getCondition().startsWith("!")) {
                output.append(action1.getCondition().substring(1));
            } else {
                output.append(action1.getCondition());
            }
            output.append(", ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("il", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("suppr", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("le", lang)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(LinguisticDataAbstract.getTextualRendering("duradical", lang));
        } else if (action1Type == Action.VOICING) {
            output.append(String.valueOf(Util.premiereMaj(LinguisticDataAbstract.getTextualRendering("il", lang))) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("sonor", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("le", lang)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("duradical", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("en", lang)) + " ");
            String son = Action.Voicing.changementPhonologique(cntxt.charAt(0));
            output.append(son);
            String orth = Roman.orthographyOfVoiced(son);
            if (!orth.equals(son)) {
                output.append(lang.equals("en") ? ", written " : ", \u00c3\u00a9crit ");
                output.append(orth);
            }
        } else if (action1Type == Action.NASALIZATION) {
            output.append(String.valueOf(Util.premiereMaj(LinguisticDataAbstract.getTextualRendering("il", lang))) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("nasal", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("le", lang)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("duradical", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("en", lang)) + " ");
            String son = Action.Nasalization.changementPhonologique(cntxt.charAt(0));
            output.append(son);
            String orth = Roman.orthographyOfVoiced(son);
            if (!orth.equals(son)) {
                output.append(lang.equals("en") ? ", written " : ", \u00c3\u00a9crit ");
                output.append(orth);
            }
        } else if (action1Type == Action.FUSION) {
            output.append(String.valueOf(Util.premiereMaj(LinguisticDataAbstract.getTextualRendering("il", lang))) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("fusion", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("le", lang)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("duradical", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("avec", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("le", lang)) + " ");
            output.append(String.valueOf(morpheme.substring(0, 1)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("dusuffixe", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("en", lang)) + " ");
            output.append(form.substring(0, 1));
        } else if (action1Type == Action.INSERTION) {
            output.append(String.valueOf(Util.premiereMaj(LinguisticDataAbstract.getTextualRendering("il", lang))) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("ins1", lang)) + " ");
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(action1.getInsert());
            if (!plain) {
                output.append("</span>");
            }
            output.append(" " + LinguisticDataAbstract.getTextualRendering("devantsuffixe", lang));
        } else if (action1Type == Action.ASSIMILATION) {
            output.append(String.valueOf(Util.premiereMaj(LinguisticDataAbstract.getTextualRendering("il", lang))) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("assim", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("le", lang)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("duradical", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("au", lang)) + " ");
            output.append(String.valueOf(form.substring(0, 1)) + " ");
            output.append(LinguisticDataAbstract.getTextualRendering("dusuffixe", lang));
        } else if (action1Type == Action.SPECIFICASSIMILATION) {
            output.append(String.valueOf(Util.premiereMaj(LinguisticDataAbstract.getTextualRendering("il", lang))) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("assim", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("le", lang)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("duradical", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("\u00c3\u00a0", lang)) + " ");
            output.append(action1.getAssimA());
        } else if (action1Type == Action.VOWELLENGTHENING) {
            output.append(String.valueOf(Util.premiereMaj(LinguisticDataAbstract.getTextualRendering("il", lang))) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("allonge", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("la", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("voyellefinale", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("duradical", lang)) + " ");
        } else if (action1Type == Action.DELETIONVOWELLENGTHENING) {
            output.append(String.valueOf(Util.premiereMaj(LinguisticDataAbstract.getTextualRendering("il", lang))) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("suppr", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("le", lang)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("duradical", lang)) + ".  ");
            output.append(lang.equals("en") ? "Then, it " : "Ensuite, il ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("allonge", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("la", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("voyellefinale", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("duradical", lang)) + " ");
        } else if (action1Type == Action.INSERTIONVOWELLENGTHENING) {
            output.append(String.valueOf(Util.premiereMaj(LinguisticDataAbstract.getTextualRendering("il", lang))) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("ins1", lang)) + " ");
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(action1.getInsert());
            if (!plain) {
                output.append("</span>");
            }
            output.append(" " + LinguisticDataAbstract.getTextualRendering("devantsuffixe", lang) + ".  ");
            output.append(lang.equals("en") ? "Then, it " : "Ensuite, il ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("allonge", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("la", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("voyellefinale", lang)) + " ");
            output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("duradical", lang)) + " ");
        }
        output.append(".");
        return output.toString();
    }

    private static String composeAction2(Action action1, Action action2, Suffix aff, String form, String cntxt, String lang) {
        StringBuffer output = new StringBuffer();
        int action1Type = action1.getType();
        int action2Type = action2.getType();
        if (action2Type != Action.NULLACTION) {
            output.append(lang.equals("en") ? "If" : "Si");
            if (action1Type != Action.NEUTRAL && action1Type != Action.UNKNOWN) {
                output.append(", ");
                output.append(lang.equals("en") ? "after " : "apr\u00c3\u00a8s ");
                output.append(action1.toString(lang));
                output.append(",");
            }
            output.append(" " + LinguisticDataAbstract.getTextualRendering("casVV", lang) + ", ");
            if (action2Type == Action.UNKNOWN) {
                output.append(LinguisticDataAbstract.getTextualRendering("l'", lang));
                if (lang.equals("en")) {
                    output.append(" ");
                }
                output.append("action ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("estSing", lang)) + " ");
                output.append(LinguisticDataAbstract.getTextualRendering("inconnue", lang));
            }
            if (action2Type == Action.INSERTION) {
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("il", lang)) + " ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("ins1", lang)) + " ");
                if (!plain) {
                    output.append("<span style=\"font-weight:bold\">");
                }
                output.append(action2.getInsert());
                if (!plain) {
                    output.append("</span>");
                }
                output.append(" " + LinguisticDataAbstract.getTextualRendering("devantsuffixe", lang));
            } else if (action2Type == Action.DELETION) {
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("il", lang)) + " ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("suppr", lang)) + " ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("la", lang)) + " ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("derniereVoyelle", lang)) + " ");
                output.append(LinguisticDataAbstract.getTextualRendering("duradical", lang));
            } else if (action2Type == Action.SPECIFICDELETION) {
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("et", lang)) + " ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("si", lang)) + " ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("la", lang)) + " ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("derniereVoyelle", lang)) + " ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("duradical", lang)) + " ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("estSing", lang)) + " ");
                output.append(String.valueOf(action2.getSuppr()) + ", ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("il", lang)) + " ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("suppr", lang)) + " ");
                output.append(String.valueOf(LinguisticDataAbstract.getTextualRendering("le", lang)) + " ");
                output.append(action2.getSuppr());
            }
            output.append(".");
        }
        return output.toString();
    }

    public static void displayListOfSuffixes(String[] args, PrintStream out) {
        lang = Util.getArgument(args, "l");
        Hashtable infs = LinguisticDataAbstract.getAllSuffixes();
        Roots.displayListOfMorphemes("suf", out, infs, lang);
    }

    static String makeCondStr(Conditions cond) {
        String text = cond.toText(lang);
        return text;
    }
}

