/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Affix;
import data.constraints.Conditions;
import data.constraints.Imacond;
import data.constraints.ParseException;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import utilities.Debugging;

public class VerbEnding
extends Affix {
    String mode;
    String spec = null;
    String subjPers = null;
    String subjNumber = null;
    String objPers = null;
    String objNumber = null;
    String sameSubject = null;
    String posneg = null;
    String tense = null;
    static Class conditionClass = null;
    public static Hashtable hash = new Hashtable();
    static String[] modes = new String[]{"caus", "cond", "dec", "dub", "freq", "ger", "imp", "int", "part"};
    static String[] numbers = new String[]{"d", "p", "s"};
    static String[] booleans = new String[]{"false", "true"};

    public VerbEnding() {
    }

    public VerbEnding(HashMap v) {
        String srcs;
        this.morpheme = (String)v.get("morpheme");
        Debugging.mess("VerbEnding/1", 1, "morpheme= " + this.morpheme);
        this.type = (String)v.get("type");
        this.mode = (String)v.get("mode");
        this.subjPers = (String)v.get("perSubject");
        this.subjNumber = (String)v.get("numbSubject");
        this.objPers = (String)v.get("perObject");
        this.objNumber = (String)v.get("numbObject");
        this.spec = this.objPers != null ? "sp" : "nsp";
        if (this.mode.equals("part")) {
            this.sameSubject = (String)v.get("sameSubject");
            this.posneg = (String)v.get("posneg");
            this.tense = (String)v.get("tense");
        }
        this.dbName = (String)v.get("dbName");
        this.tableName = (String)v.get("tableName");
        this.makeMeanings();
        String form = (String)v.get("V-form");
        String act1 = (String)v.get("V-action1");
        String act2 = (String)v.get("V-action2");
        this.makeFormsAndActions("V", this.morpheme, form, act1, act2);
        form = (String)v.get("t-form");
        act1 = (String)v.get("t-action1");
        act2 = (String)v.get("t-action2");
        this.makeFormsAndActions("t", this.morpheme, form, act1, act2);
        form = (String)v.get("k-form");
        act1 = (String)v.get("k-action1");
        act2 = (String)v.get("k-action2");
        this.makeFormsAndActions("k", this.morpheme, form, act1, act2);
        form = (String)v.get("q-form");
        act1 = (String)v.get("q-action1");
        act2 = (String)v.get("q-action2");
        this.makeFormsAndActions("q", this.morpheme, form, act1, act2);
        String cs = (String)v.get("condPrecSpecific");
        if (cs != null) {
            try {
                this.preCondition = (Conditions)((Object)new Imacond(new ByteArrayInputStream(cs.getBytes())).ParseCondition());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ((srcs = (String)v.get("sources")) != null) {
            StringTokenizer st2 = new StringTokenizer(srcs);
            this.sources = new String[st2.countTokens()];
            int n = 0;
            while (st2.hasMoreTokens()) {
                this.sources[n++] = st2.nextToken();
            }
        }
        this.setAttrs();
    }

    @Override
    public void addToHash(String key, Object obj) {
        hash.put(key, obj);
    }

    @Override
    public String getSignature() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.type);
        sb.append("-");
        sb.append(this.mode);
        sb.append("-");
        sb.append(this.subjPers);
        sb.append(this.subjNumber);
        if (this.objPers != null) {
            sb.append("-");
            sb.append(this.objPers);
            sb.append(this.objNumber);
        }
        if (this.mode.equals("part") && this.tense != null) {
            sb.append("-");
            sb.append(this.tense);
        }
        return sb.toString();
    }

    @Override
    public String getTransitivityConstraint() {
        if (this.spec.equals("nsp")) {
            return "i";
        }
        return "t";
    }

    @Override
    public String[] getCombiningParts() {
        return null;
    }

    @Override
    boolean agreeWithTransitivity(String trans) {
        return true;
    }

    @Override
    void setAttrs() {
        this.setAttributes();
        this.setId();
    }

    void setAttributes() {
        HashMap<String, String> tvAttrs = new HashMap<String, String>();
        tvAttrs.put("mode", this.mode);
        tvAttrs.put("spec", this.spec);
        tvAttrs.put("subjPers", this.subjPers);
        tvAttrs.put("subjNumber", this.subjNumber);
        tvAttrs.put("objPers", this.objPers);
        tvAttrs.put("objNumber", this.objNumber);
        tvAttrs.put("sameSubject", this.sameSubject);
        tvAttrs.put("posneg", this.posneg);
        tvAttrs.put("tense", this.tense);
        super.setAttributes(tvAttrs);
    }

    private void makeMeanings() {
        StringBuffer frenchMeaning1 = new StringBuffer();
        StringBuffer englishMeaning1 = new StringBuffer();
        if (this.mode.equals("dec") || this.mode.equals("ger")) {
            frenchMeaning1.append("d\u00c3\u00a9claration: ");
            englishMeaning1.append("declaration: ");
        } else if (this.mode.equals("int")) {
            if (this.subjPers.equals("3") || this.subjPers.equals("4")) {
                frenchMeaning1.append("question: est-ce qu'");
                if (this.subjNumber.equals("s")) {
                    englishMeaning1.append("question: does ");
                } else {
                    englishMeaning1.append("question: do ");
                }
            } else {
                frenchMeaning1.append("question: est-ce que ");
                englishMeaning1.append("question: do ");
            }
        } else if (this.mode.equals("imp")) {
            frenchMeaning1.append("ordre: ");
            englishMeaning1.append("order: ");
        } else if (this.mode.equals("part")) {
            if (this.tense == null) {
                frenchMeaning1.append("part: ");
                englishMeaning1.append("part: ");
            } else if (this.tense.equals("prespas")) {
                frenchMeaning1.append("part. pr\u00c3\u00a9sent/pass\u00c3\u00a9: ");
                englishMeaning1.append("part. present/past: ");
            } else if (this.tense.equals("fut")) {
                frenchMeaning1.append("part. futur: ");
                englishMeaning1.append("part. future: ");
            }
            if (this.subjPers.equals("3") || this.subjPers.equals("4")) {
                frenchMeaning1.append("alors/pendant qu'");
            } else {
                frenchMeaning1.append("alors/pendant que ");
            }
            englishMeaning1.append("while ");
        } else if (this.mode.equals("caus")) {
            if (this.subjPers.equals("3") || this.subjPers.equals("4")) {
                frenchMeaning1.append("causal: parce qu'");
            } else {
                frenchMeaning1.append("causal: parce que ");
            }
            englishMeaning1.append("becausative: because ");
        } else if (this.mode.equals("cond")) {
            if ((this.subjPers.equals("3") || this.subjPers.equals("4")) && this.subjNumber.equals("s")) {
                frenchMeaning1.append("conditionnel: s'");
            } else {
                frenchMeaning1.append("conditionnel: si ");
            }
            englishMeaning1.append("conditional: if ");
        } else if (this.mode.equals("dub")) {
            if ((this.subjPers.equals("3") || this.subjPers.equals("4")) && this.subjNumber.equals("s")) {
                frenchMeaning1.append("dubitatif: s'");
            } else {
                frenchMeaning1.append("dubitatif: si ");
            }
            englishMeaning1.append("dubitative: whether ");
        } else if (this.mode.equals("freq")) {
            if (this.subjPers.equals("3") || this.subjPers.equals("4")) {
                frenchMeaning1.append("fr\u00c3\u00a9quentatif: chaque fois qu' / lorsqu'");
            } else {
                frenchMeaning1.append("fr\u00c3\u00a9quentatif: chaque fois que / lorsque ");
            }
            englishMeaning1.append("frequentative: whenever ");
        }
        if (this.subjPers.equals("1")) {
            if (this.subjNumber.equals("s")) {
                frenchMeaning1.append("je ");
                englishMeaning1.append("I ");
            } else if (this.subjNumber.equals("d")) {
                frenchMeaning1.append("nous (deux) ");
                englishMeaning1.append("we (two) ");
            } else if (this.subjNumber.equals("p")) {
                frenchMeaning1.append("nous (plusieurs) ");
                englishMeaning1.append("we (many) ");
            }
        } else if (this.subjPers.equals("2")) {
            if (this.subjNumber.equals("s")) {
                frenchMeaning1.append("tu ");
                englishMeaning1.append("you ");
            } else if (this.subjNumber.equals("d")) {
                frenchMeaning1.append("vous (deux) ");
                englishMeaning1.append("you (two) ");
            } else if (this.subjNumber.equals("p")) {
                frenchMeaning1.append("vous (plusieurs) ");
                englishMeaning1.append("you (many) ");
            }
        } else if (this.subjPers.equals("3") || this.subjPers.equals("4")) {
            if (this.subjNumber.equals("s")) {
                frenchMeaning1.append("il/elle ");
                englishMeaning1.append("he/she/it ");
            } else if (this.subjNumber.equals("d")) {
                frenchMeaning1.append("ils/elles (deux) ");
                englishMeaning1.append("they (two) ");
            } else if (this.subjNumber.equals("p")) {
                frenchMeaning1.append("ils/elles (plusieurs) ");
                englishMeaning1.append("they (many) ");
            }
        }
        if (this.mode.equals("part") && this.posneg.equals("neg")) {
            frenchMeaning1.append("ne ");
            englishMeaning1.append("not ");
        }
        frenchMeaning1.append("...");
        englishMeaning1.append("...");
        if (this.mode.equals("part") && this.posneg.equals("neg")) {
            frenchMeaning1.append(" pas ");
        }
        if (this.spec.equals("sp")) {
            if (this.objPers.equals("1")) {
                if (this.objNumber.equals("s")) {
                    frenchMeaning1.append("moi");
                    englishMeaning1.append("me");
                } else if (this.objNumber.equals("d")) {
                    frenchMeaning1.append("nous (deux)");
                    englishMeaning1.append("us (two)");
                } else if (this.objNumber.equals("p")) {
                    frenchMeaning1.append("nous (plusieurs)");
                    englishMeaning1.append("us (many)");
                }
            } else if (this.objPers.equals("2")) {
                if (this.objNumber.equals("s")) {
                    frenchMeaning1.append("toi");
                    englishMeaning1.append("you");
                } else if (this.objNumber.equals("d")) {
                    frenchMeaning1.append("vous (deux)");
                    englishMeaning1.append("you (two)");
                } else if (this.objNumber.equals("p")) {
                    frenchMeaning1.append("vous (plusieurs)");
                    englishMeaning1.append("you (many)");
                }
            } else if (this.objPers.equals("3")) {
                if (this.objNumber.equals("s")) {
                    frenchMeaning1.append("lui/elle");
                    englishMeaning1.append("him/her/it");
                } else if (this.objNumber.equals("d")) {
                    frenchMeaning1.append("eux/elles (deux) ");
                    englishMeaning1.append("them (two) ");
                } else if (this.objNumber.equals("p")) {
                    frenchMeaning1.append("eux/elles (plusieurs) ");
                    englishMeaning1.append("them (many) ");
                }
            }
        }
        if (this.mode.equals("int")) {
            frenchMeaning1.append("?");
            englishMeaning1.append("?");
        }
        this.frenchMeaning = frenchMeaning1.toString();
        this.englishMeaning = englishMeaning1.toString();
    }

    @Override
    public String showData() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n[VerbEnding: morpheme= " + this.morpheme + "\n");
        sb.append("type= " + this.type + "\n");
        sb.append("mode= " + this.mode + "\n");
        if (this.mode.equals("part")) {
            sb.append("sameSubject= " + this.sameSubject + "\n");
            sb.append("posneg= " + this.posneg + "\n");
            sb.append("tense= " + this.tense + "\n");
        }
        sb.append("spec= " + this.spec + "\n");
        sb.append("subjPers= " + this.subjPers + "\n");
        sb.append("subjNumber= " + this.subjNumber + "\n");
        sb.append("objPers= " + this.objPers + "\n");
        sb.append("objNumber= " + this.objNumber + "\n");
        sb.append(super.showData());
        if (this.preCondition != null) {
            sb.append("precedingSpecificCondition= " + this.preCondition.toString() + "\n");
        }
        sb.append("dbName= " + this.dbName + "\n");
        sb.append("tableName= " + this.tableName + "\n");
        sb.append("sources= ");
        if (this.sources == null) {
            sb.append(this.sources);
        } else {
            int n = 0;
            while (n < this.sources.length) {
                sb.append(String.valueOf(this.sources[n]) + " ");
                ++n;
            }
        }
        sb.append("]\n");
        return sb.toString();
    }
}

