/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Affix;
import data.Base;
import data.SurfaceFormOfAffix;
import documents.NRC_HTMLDocument;
import fonts.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Element;
import lib.html;
import morph.AffixPartOfComposition;
import morph.Decomposition;
import morph.MorphInuk;
import morph.RootPartOfComposition;
import script.Roman;
import script.TransCoder;
import utilities.Debugging;
import utilities.Inuktitut;
import utilities.Text;
import utilities1.Util;

public class Words {
    static boolean syllabic = true;
    static String inuktitutDisplayFontByDefault = "Pigiarniq";
    static String inuktitutDisplayFont = null;
    static String fontRoman = "\"Times New Roman\"";
    static String fontOfQuery = null;
    static String fontOfQueryArg = null;
    static String lang = "en";
    static String lang_default = "en";
    static boolean HTML_OUTPUT = true;
    static String UTF8_BOM = "\ufeff";

    public static void getDef(String[] args, PrintStream out) {
        Words.getDef(args, out, HTML_OUTPUT);
    }

    public static void getDef(String[] args, PrintStream out, boolean htmlOutput) {
        StringBuffer outputHTML = null;
        String input = null;
        String file = null;
        String cacheName = null;
        file = Util.getArgument(args, "f");
        lang = Util.getArgument(args, "l");
        if (lang == null) {
            lang = Util.getArgument(args, "lang");
        }
        if (lang == null) {
            lang = lang_default;
        }
        outputHTML = new StringBuffer();
        if (!htmlOutput) {
            outputHTML.append(UTF8_BOM);
        }
        inuktitutDisplayFont = inuktitutDisplayFontByDefault;
        fontOfQuery = Util.getArgument(args, "inputType");
        if (fontOfQuery != null && fontOfQuery.equals("other")) {
            fontOfQuery = null;
        }
        if (fontOfQuery != null) {
            inuktitutDisplayFont = fontOfQuery;
            fontOfQueryArg = "'" + fontOfQuery + "'";
        } else {
            fontOfQueryArg = null;
        }
        cacheName = Util.getArgument(args, "cache");
        input = Util.getArgument(args, "m");
        if (input == null) {
            input = Util.getArgument(args, "query");
        }
        if (input != null) {
            input = input.trim();
        }
        String iag = null;
        iag = Util.getArgument(args, "#input_argument_string");
        if (iag != null && iag.contains("TranslitPage")) {
            file = null;
        }
        boolean procedeYesNo = false;
        String reason = null;
        String defWord = null;
        String defWordForDisplay = null;
        Text txt = new Text(input);
        if (txt.isNull()) {
            procedeYesNo = false;
            reason = lang.equals("en") ? "No selected word." : "Aucun mot s\u00c3\u00a9lectionn\u00c3\u00a9 \u00c3\u00a0 d\u00c3\u00a9finir.";
        } else if (txt.containsUnicodeInuktitut()) {
            procedeYesNo = true;
            syllabic = true;
            defWordForDisplay = defWord = input;
        } else if (txt.containsUnicode()) {
            procedeYesNo = false;
            reason = lang.equals("en") ? "This is not an Inuktitut word." : "Ce n'est pas un mot inuktitut.";
        } else if (file == null) {
            if (fontOfQuery == null) {
                procedeYesNo = true;
                syllabic = false;
                defWordForDisplay = defWord = input;
            } else if (Font.isLegacy((String)fontOfQuery)) {
                defWord = TransCoder.legacyToUnicode(input, fontOfQuery);
                defWordForDisplay = input;
                syllabic = true;
                procedeYesNo = true;
            }
        } else {
            Object[] res = Words.determineWord(file, input, cacheName);
            defWordForDisplay = defWord = (String)res[0];
            procedeYesNo = (Boolean)res[1];
            if (res[2] != null) {
                syllabic = (Boolean)res[2];
            }
            reason = (String)res[3];
        }
        if (htmlOutput) {
            outputHTML.append("<span style=\"font-family:" + inuktitutDisplayFont + ";color:green;\">");
            outputHTML.append("<span style=\"font-weight:bold;\">");
            outputHTML.append(defWordForDisplay);
            outputHTML.append("</span>");
            outputHTML.append("</span>");
            out.print(outputHTML.toString());
        }
        if (procedeYesNo) {
            String defWordLat = syllabic ? TransCoder.unicodeToRoman(defWord) : defWord;
            Decomposition[] decs = null;
            decs = MorphInuk.decomposeWord(defWordLat);
            Decomposition[] decomps = null;
            if (decs.length != 0) {
                decomps = Words.selectDecompositions(decs, false);
                decomps = Words.mergeNounEndings(decomps);
            }
            if (decomps == null) {
                if (htmlOutput) {
                    if (decs.length != 0) {
                        if (lang.equals("en")) {
                            out.print("<p>None of the " + decs.length + " decompositions has been retained.</p>");
                        } else {
                            out.print("<p>Aucune des " + decs.length + " d\u00c3\u00a9compositions n'a \u00c3\u00a9t\u00c3\u00a9 retenue.</p>");
                        }
                    } else if (lang.equals("en")) {
                        out.print("<p>No decomposition has been found.</p>");
                    } else {
                        out.print("<p>Aucune d\u00c3\u00a9composition n'a \u00c3\u00a9t\u00c3\u00a9 trouv\u00c3\u00a9e.</p>");
                    }
                }
            } else {
                int ndcs = 0;
                while (ndcs < decomps.length) {
                    String display = null;
                    if (decomps[ndcs] != null) {
                        display = htmlOutput ? Words.composeDisplay(decomps[ndcs], syllabic) : decomps[ndcs].toStr2().concat("\n");
                        out.print(display);
                    }
                    ++ndcs;
                }
            }
        } else {
            String reasonIntro;
            String string = reasonIntro = lang.equals("en") ? "Impossible to proceed: " : "Impossible de proc\u00c3\u00a9der: ";
            if (htmlOutput) {
                outputHTML.append(reasonIntro);
                outputHTML.append(reason);
                out.print(outputHTML.toString());
            }
        }
        if (htmlOutput) {
            out.print("</p>");
        }
        out.flush();
    }

    private static Object[] determineWord(String file, String input, String cacheName) {
        String defWord = null;
        boolean procedeYesNo = false;
        boolean syllabic = false;
        String reason = null;
        Object text = null;
        boolean trouve = false;
        Object elem = null;
        File cache = null;
        if (cacheName != null) {
            cache = new File(cacheName);
        }
        if (cache != null && cache.exists()) {
            BufferedReader in = null;
            boolean eof = false;
            try {
                in = new BufferedReader(new FileReader(cacheName));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            while (!eof) {
                String line = null;
                try {
                    line = in.readLine();
                    if (line == null) {
                        eof = true;
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(line, "\t");
                    String fileName = st.nextToken();
                    String fontName = st.nextToken();
                    if (!file.startsWith(fileName)) continue;
                    defWord = TransCoder.legacyToUnicode(input, fontName);
                    syllabic = true;
                    procedeYesNo = true;
                    in.close();
                    return new Object[]{defWord, new Boolean(procedeYesNo), new Boolean(syllabic), reason};
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                in.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        NRC_HTMLDocument doc = null;
        try {
            doc = new NRC_HTMLDocument(file);
        }
        catch (Exception e1) {
            if (doc != null) {
                doc.close();
            }
            Object[] objectArray = new Object[4];
            objectArray[1] = new Boolean(false);
            objectArray[3] = e1.getMessage().equals("not html") ? (lang.equals("en") ? "This URL is not an HTML page" : "Cet URL n'est pas une page HTML.") : e1.getMessage();
            return objectArray;
        }
        Object elementWithInputWord = doc.findWord(input);
        if (elementWithInputWord != null) {
            NRC_HTMLDocument.TexteHTML textHTML = doc.texteEnInuktitut((Element)elementWithInputWord);
            defWord = input;
            if (textHTML != null) {
                Vector morphParts = textHTML.getMorphParts();
                if (textHTML.getCodage() == Roman.UNICODE) {
                    syllabic = false;
                    int im = 0;
                    while (im < morphParts.size()) {
                        Inuktitut.MorceauTexte morphPart = (Inuktitut.MorceauTexte)morphParts.get(im);
                        if (morphPart.getTexte().equals(input)) {
                            syllabic = morphPart.isSyllabic();
                            break;
                        }
                        ++im;
                    }
                } else {
                    String font = ((Inuktitut.MorceauTexte)morphParts.get(0)).getPolice();
                    defWord = TransCoder.legacyToUnicode(input, font);
                    syllabic = true;
                    if (cacheName != null) {
                        try {
                            BufferedWriter out = new BufferedWriter(new FileWriter(cacheName, true));
                            out.newLine();
                            out.write(String.valueOf(file) + "\t" + font);
                            out.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                syllabic = false;
                defWord = input;
            }
            procedeYesNo = true;
        } else {
            procedeYesNo = false;
            reason = lang.equals("en") ? "The word cannot be found in the file." : "Le mot n'a pas \u00c3\u00a9t\u00c3\u00a9 trouv\u00c3\u00a9 dans le fichier.";
        }
        doc.close();
        return new Object[]{defWord, new Boolean(procedeYesNo), new Boolean(syllabic), reason};
    }

    private static Decomposition[] selectDecompositions(Decomposition[] decompositions, boolean eliminateSubordata) {
        Debugging.mess("selectDecompositions/1", 1, "> decompositions(" + decompositions.length + ")");
        Vector decompsKnownBases = new Vector();
        int i = 0;
        while (i < decompositions.length) {
            Decomposition dec = decompositions[i];
            RootPartOfComposition base = dec.getRootMorphpart();
            Base root = base.getRoot();
            Debugging.mess("selectDecompositions/1", 1, "racine= " + root);
            if (root.isKnown()) {
                decompsKnownBases.add(dec);
            }
            ++i;
        }
        Vector decomps = decompsKnownBases.size() != 0 ? (eliminateSubordata ? Words.eliminateSubordata(decompsKnownBases) : decompsKnownBases) : null;
        Debugging.mess("selectDecompositions/1", 1, "<");
        if (decomps != null) {
            Decomposition[] decs = new Decomposition[]{};
            decs = decomps.toArray(decs);
            return decs;
        }
        return null;
    }

    private static Vector eliminateSubordata(Vector decompsKnownBases) {
        Vector decomps = (Vector)decompsKnownBases.clone();
        Debugging.mess("eliminateSubordata/1", 1, "decomps.size() = " + decomps.size());
        int i = 0;
        while (i < decomps.size()) {
            Decomposition di = (Decomposition)decomps.elementAt(i);
            Object[] suffsI = di.getMorphParts();
            int j = i + 1;
            while (j < decomps.size()) {
                Decomposition dj = (Decomposition)decomps.elementAt(j);
                Object[] suffsJ = dj.getMorphParts();
                if (suffsI.length != suffsJ.length) {
                    Object[] suffsB;
                    Object[] suffsA;
                    if (suffsI.length < suffsJ.length) {
                        suffsA = suffsI;
                        suffsB = suffsJ;
                    } else {
                        suffsA = suffsJ;
                        suffsB = suffsI;
                    }
                    int kA = suffsA.length - 1;
                    int kB = suffsB.length - 1;
                    boolean goOn = true;
                    while (goOn && kA > -1) {
                        SurfaceFormOfAffix fA = ((AffixPartOfComposition)suffsA[kA--]).getForm();
                        SurfaceFormOfAffix fB = ((AffixPartOfComposition)suffsB[kB--]).getForm();
                        Affix morphemeA = fA.getAffix();
                        Affix morphemeB = fB.getAffix();
                        Debugging.mess("eliminateSubordata/1", 1, "  morphemeA=" + morphemeA + "\n  morphemeB=" + morphemeB);
                        if (morphemeA.morpheme.equals(morphemeB.morpheme) && morphemeA.type.equals(morphemeB.type)) continue;
                        goOn = false;
                    }
                    if (kA == -1) {
                        if (suffsI.length < suffsJ.length) {
                            decomps.remove(j);
                            continue;
                        }
                        decomps.remove(i);
                        j = decomps.size();
                        --i;
                        continue;
                    }
                    ++j;
                    continue;
                }
                ++j;
            }
            ++i;
        }
        if (decomps.size() == 0) {
            return null;
        }
        return decomps;
    }

    private static String composeDisplay(Decomposition decomp, boolean isSyllabic) {
        String meaning;
        Debugging.mess("composeDisplay/2", 1, ">" + decomp);
        RootPartOfComposition morphpartBase = decomp.getRootMorphpart();
        Base stem = morphpartBase.getRoot();
        String type = stem.type;
        String funct = "";
        StringBuffer output = new StringBuffer();
        StringBuffer word = new StringBuffer();
        output.append("<br><br>");
        output.append("<table border=1><thead>");
        output.append("<tr style=\"background-color:#ffffcc\">");
        output.append("<td colspan=2>");
        output.append("<font color=red>");
        output.append(lang.equals("en") ? "Root" : "Racine");
        output.append("</font>");
        output.append("<font color=black>");
        output.append("&amp;");
        output.append("</font>");
        output.append("<font color=green>");
        output.append(lang.equals("en") ? "affixes" : "affixes");
        output.append("</font>");
        output.append("</td><td>");
        output.append(lang.equals("en") ? "Meaning" : "Signification");
        output.append("</td></tr></thead>");
        output.append("<tbody>");
        output.append("<tr><td>");
        output.append("<font face=" + inuktitutDisplayFont + " color=red>");
        output.append("<b>");
        if (fontOfQuery == null) {
            output.append(isSyllabic ? TransCoder.romanToUnicode(morphpartBase.getTerm()) : morphpartBase.getTerm());
        } else {
            output.append(isSyllabic ? TransCoder.romanToLegacy(morphpartBase.getTerm(), inuktitutDisplayFont) : morphpartBase.getTerm());
        }
        output.append("</b>");
        output.append("</font>");
        output.append("</td>");
        output.append("<td>");
        output.append("<a href=\"javascript:appelerDescriptionRacine(");
        output.append("'" + stem.id + "'," + fontOfQueryArg);
        output.append(")\">");
        output.append("<font face=" + inuktitutDisplayFont + " color=red>");
        output.append("<b>");
        if (fontOfQuery == null) {
            output.append(isSyllabic ? TransCoder.romanToUnicode(stem.morpheme) : stem.morpheme);
        } else {
            output.append(isSyllabic ? TransCoder.romanToLegacy(stem.morpheme, inuktitutDisplayFont) : stem.morpheme);
        }
        output.append("</b>");
        output.append("</font>");
        output.append("</td>");
        output.append("<td>");
        output.append("<font face=" + fontRoman + " color=blue>");
        output.append("<b>");
        String string = meaning = lang.equals("en") ? stem.englishMeaning : stem.frenchMeaning;
        if (stem.isTransitiveVerb()) {
            meaning = stem.getTransitiveMeaning(lang);
            if (morphpartBase.getTransitivity() != null) {
                if (morphpartBase.getTransitivity().equals("t")) {
                    meaning = stem.getTransitiveMeaning(lang);
                } else {
                    String pass = stem.getPassiveMeaning(lang);
                    String refl = stem.getReflexiveMeaning(lang);
                    meaning = "";
                    if (pass != null) {
                        meaning = String.valueOf(lang.equals("en") ? "(passive) " : "(passif) ") + pass;
                    }
                    if (refl != null) {
                        meaning = String.valueOf(meaning) + " " + (lang.equals("en") ? "(reflexive) " : "(r\u00c3\u00a9fl\u00c3\u00a9chi) ") + refl;
                    }
                }
            }
        }
        output.append(meaning);
        output.append("</b>");
        output.append("</font>");
        output.append("</td></tr>");
        word.append("<font face=" + inuktitutDisplayFont + ">");
        word.append("<font color=red>");
        if (fontOfQuery == null) {
            word.append(isSyllabic ? TransCoder.romanToUnicode(morphpartBase.getTerm()) : morphpartBase.getTerm());
        } else {
            word.append(isSyllabic ? TransCoder.romanToLegacy(morphpartBase.getTerm(), inuktitutDisplayFont) : morphpartBase.getTerm());
        }
        word.append("</font>");
        boolean color = true;
        boolean reflexive = false;
        Object[] morphPartsInuk = decomp.getMorphParts();
        int i = 0;
        while (i < morphPartsInuk.length) {
            AffixPartOfComposition mi = (AffixPartOfComposition)morphPartsInuk[i];
            if (mi.getReflexive()) {
                reflexive = mi.getReflexive();
            }
            AffixPartOfComposition[] multipleMorphpart = mi.getMultipleMorphparts();
            output.append("<tr>");
            if (multipleMorphpart != null) {
                output.append("<td rowspan=" + multipleMorphpart.length + ">");
            } else {
                output.append("<td>");
            }
            output.append("<font face=" + inuktitutDisplayFont + " color=green>");
            String term = mi.getTerm();
            if (term.endsWith("*")) {
                term = term.substring(0, term.length() - 1);
            }
            if (fontOfQuery == null) {
                output.append(isSyllabic ? TransCoder.romanToUnicode(term) : term);
            } else {
                output.append(isSyllabic ? TransCoder.romanToLegacy(term, inuktitutDisplayFont) : term);
            }
            output.append("</font>");
            output.append("</td>");
            if (multipleMorphpart != null) {
                int j = 0;
                while (j < multipleMorphpart.length) {
                    if (j > 0) {
                        output.append("<tr>");
                    }
                    output.append("<td>");
                    AffixPartOfComposition dmi = multipleMorphpart[j];
                    SurfaceFormOfAffix fa = dmi.getForm();
                    Affix aff = fa.getAffix();
                    type = fa.type;
                    funct = aff.function;
                    if (type.equals("sn") || type.equals("sv")) {
                        output.append("<a href=\"javascript:appelerDescriptionSuffixe(");
                        output.append("'" + fa.uniqueId + "'," + fontOfQueryArg);
                        output.append(")\">");
                    }
                    output.append("<font face=" + inuktitutDisplayFont + " color=green>");
                    if (fontOfQuery == null) {
                        output.append(isSyllabic ? TransCoder.romanToUnicode(aff.morpheme) : aff.morpheme);
                    } else {
                        output.append(isSyllabic ? TransCoder.romanToLegacy(aff.morpheme, inuktitutDisplayFont) : aff.morpheme);
                    }
                    output.append("</font>");
                    output.append("</a>");
                    output.append("</td>");
                    output.append("<td>");
                    output.append("<font face=" + fontRoman + ">");
                    output.append(lang.equals("en") ? aff.englishMeaning : aff.frenchMeaning);
                    output.append("</td>");
                    if (j > 0) {
                        output.append("</tr>");
                    }
                    ++j;
                }
            } else {
                output.append("<td>");
                SurfaceFormOfAffix fa = mi.getForm();
                Affix aff = fa.getAffix();
                type = fa.type;
                funct = aff.function;
                if (type.equals("sn") || type.equals("sv")) {
                    output.append("<a href=\"javascript:appelerDescriptionSuffixe(");
                    output.append("'" + fa.uniqueId + "'," + fontOfQueryArg);
                    output.append(")\">");
                }
                output.append("<font face=" + inuktitutDisplayFont + " color=green>");
                if (fontOfQuery == null) {
                    output.append(isSyllabic ? TransCoder.romanToUnicode(aff.morpheme) : aff.morpheme);
                } else {
                    output.append(isSyllabic ? TransCoder.romanToLegacy(aff.morpheme, inuktitutDisplayFont) : aff.morpheme);
                }
                output.append("</font>");
                output.append("</a>");
                output.append("</td>");
                output.append("<td>");
                output.append("<font face=\"Times New Roman\">");
                output.append(lang.equals("en") ? aff.englishMeaning : aff.frenchMeaning);
                output.append("</td>");
            }
            output.append("</tr>");
            word.append("<font color=");
            word.append(color ? "blue" : "green");
            word.append(">");
            if (fontOfQuery == null) {
                word.append(isSyllabic ? TransCoder.romanToUnicode(term) : term);
            } else {
                word.append(isSyllabic ? TransCoder.romanToLegacy(term, inuktitutDisplayFont) : term);
            }
            word.append("</font>");
            color = !color;
            ++i;
        }
        output.append("</tbody></table>");
        word.append("</font>");
        word.append(" ");
        word.append("<font face=" + fontRoman + "><i>");
        word.append("(");
        if (type.equals("tv") || type.equals("v") || type.equals("sv") && funct.equals("vv") || type.equals("sn") && funct.equals("nv")) {
            word.append(lang.equals("en") ? "verb" : "verbe");
        } else if (type.equals("tn") || type.equals("n") || type.equals("sv") && funct.equals("vn") || type.equals("sn") && funct.equals("nn")) {
            word.append(lang.equals("en") ? "noun" : "nom");
        } else if (type.equals("a")) {
            word.append(lang.equals("en") ? "adverb" : "adverbe");
        } else if (type.equals("rad") || type.equals("tad") || type.equals("ad")) {
            word.append(lang.equals("en") ? "demonstrative adverb" : "adverbe d\u00c3\u00a9monstratif");
        } else if (type.equals("rpd") || type.equals("tpd") || type.equals("pd")) {
            word.append(lang.equals("en") ? "demonstrative pronoun" : "pronom d\u00c3\u00a9monstratif");
        } else if (type.equals("e")) {
            word.append(lang.equals("en") ? "expression or exclamation" : "expression ou exclamation");
        } else if (type.equals("c")) {
            word.append(lang.equals("en") ? "conjunction" : "conjonction");
        } else if (type.equals("p")) {
            word.append(lang.equals("en") ? "pronoun" : "pronom");
        }
        if (reflexive) {
            word.append(", " + (lang.equals("en") ? "reflexive action" : "action r\u00c3\u00a9flexive"));
        }
        word.append(")");
        word.append("</i></font>");
        output.append("");
        output.append(word);
        return output.toString();
    }

    private static StringBuffer writeScriptsJSP() {
        StringBuffer outputHTML = new StringBuffer();
        outputHTML.append(html.scriptDescRootJSP(lang, fontOfQuery));
        outputHTML.append(html.scriptDescSufJSP(lang, fontOfQuery));
        outputHTML.append(html.scriptDecWordJSP(lang, fontOfQuery));
        return outputHTML;
    }

    static Decomposition[] mergeNounEndings(Decomposition[] decomps) {
        Vector<Decomposition> v = new Vector<Decomposition>();
        Hashtable<Integer, Decomposition> hv = new Hashtable<Integer, Decomposition>();
        Pattern decPat = Pattern.compile("(\\x7B.+?\\x7D)+");
        Pattern signPat = Pattern.compile("\\x7B(.+?):(.+?)\\x7D");
        Hashtable<String, Vector> formsHT = new Hashtable<String, Vector>();
        int i = 0;
        while (i < decomps.length) {
            String stemSign;
            String form;
            AffixPartOfComposition dern = decomps[i].getLastMorphpart();
            String decSign = decomps[i].toStr2();
            if (dern == null) {
                form = "null";
                stemSign = decSign;
            } else {
                Matcher decSignMat = decPat.matcher(decSign);
                decSignMat.matches();
                int posStartLast = decSignMat.start(1);
                stemSign = decSign.substring(0, posStartLast);
                String lastSign = decSign.substring(posStartLast);
                Matcher lastSignMat = signPat.matcher(lastSign);
                lastSignMat.matches();
                form = lastSignMat.group(1);
            }
            Vector vs = formsHT.get(form) == null ? new Vector() : (Vector)formsHT.get(form);
            vs.add(new Object[]{decomps[i], dern, stemSign, new Integer(i)});
            formsHT.put(form, vs);
            ++i;
        }
        Enumeration e = formsHT.keys();
        while (e.hasMoreElements()) {
            Integer decNb;
            Object k = e.nextElement();
            Vector val = (Vector)formsHT.get(k);
            if (val.size() == 1) {
                v.add((Decomposition)((Object[])val.elementAt(0))[0]);
                hv.put((Integer)((Object[])val.elementAt(0))[3], (Decomposition)((Object[])val.elementAt(0))[0]);
                continue;
            }
            Hashtable<String, Object[]> ht = new Hashtable<String, Object[]>();
            int j = 0;
            while (j < val.size()) {
                Object[] o = (Object[])val.elementAt(j);
                Decomposition dec = (Decomposition)o[0];
                AffixPartOfComposition lastMorphpart = (AffixPartOfComposition)o[1];
                String stemSign = (String)o[2];
                decNb = (Integer)o[3];
                if (ht.get(stemSign) != null) {
                    Object[] oo = (Object[])ht.get(stemSign);
                    Vector vLast = (Vector)oo[1];
                    vLast.add(lastMorphpart);
                    oo[1] = vLast;
                    ht.put(stemSign, oo);
                } else {
                    Vector<AffixPartOfComposition> vLast = new Vector<AffixPartOfComposition>();
                    vLast.add(lastMorphpart);
                    ht.put(stemSign, new Object[]{dec, vLast, decNb});
                }
                ++j;
            }
            Enumeration f = ht.keys();
            while (f.hasMoreElements()) {
                Object kf = f.nextElement();
                Object[] o = (Object[])ht.get(kf);
                Decomposition dec = (Decomposition)o[0];
                Vector vLast = (Vector)o[1];
                decNb = (Integer)o[2];
                Object[] parts = dec.getMorphParts();
                AffixPartOfComposition dmc = (AffixPartOfComposition)parts[parts.length - 1];
                dmc.setMultipleMorphparts(vLast);
                parts[parts.length - 1] = dmc;
                dec.setMorphParts(parts);
                v.add(dec);
                hv.put(decNb, dec);
            }
        }
        Set hvKeys = hv.keySet();
        Object[] intHvKeys = hvKeys.toArray(new Integer[0]);
        Arrays.sort(intHvKeys);
        Decomposition[] decomps2 = new Decomposition[intHvKeys.length];
        int i2 = 0;
        while (i2 < decomps2.length) {
            decomps2[i2] = (Decomposition)hv.get(intHvKeys[i2]);
            ++i2;
        }
        return decomps2;
    }
}

