/*
 * Decompiled with CFR 0.152.
 */
package dataCSV;

import data.Data;
import data.LinguisticDataAbstract;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public final class LinguisticDataCSV
extends LinguisticDataAbstract {
    public static int OK = 0;
    public static int FILE_NOT_FOUND = 1;
    public static int IOEXCEPTION = 2;
    public static String[][] dataTables = new String[][]{{"Base", "Inuktitut", "RootsSpalding"}, {"Base", "Inuktitut", "RootsSchneider"}, {"Base", "Inuktitut", "WordsRelatedToRoots"}, {"Base", "Inuktitut", "UndecomposableCompositeWords"}, {"Base", "Inuktitut", "CommonCompositeWords"}, {"Base", "Inuktitut", "Locations"}, {"Base", "Inuktitut", "LoanWords"}, {"Suffix", "Inuktitut", "Suffixes"}, {"NounEnding", "Inuktitut", "Endings_noun"}, {"VerbEnding", "Inuktitut", "Endings_verb"}, {"VerbEnding", "Inuktitut", "Endings_verb_participle"}, {"Demonstrative", "Inuktitut", "Demonstratives"}, {"DemonstrativeEnding", "Inuktitut", "Endings_demonstrative"}, {"Pronoun", "Inuktitut", "Pronouns"}, {"VerbWord", "Inuktitut", "Passives_French"}, {"VerbWord", "Inuktitut", "Passives_English"}, {"Source", "Inuktitut", "Sources"}};
    static Class thisClass;

    public LinguisticDataCSV() {
        this.createLinguisticDataCSV(null);
    }

    public LinguisticDataCSV(String type) {
        this.createLinguisticDataCSV(type);
    }

    void createLinguisticDataCSV(String type) {
        if (type == null) {
            bases = new Hashtable();
            basesId = new Hashtable();
            words = new Hashtable();
            surfaceFormsOfAffixes = new Hashtable();
            affixesId = new Hashtable();
        } else if (type.equals("r")) {
            type = "Base";
            bases = new Hashtable();
            basesId = new Hashtable();
            words = new Hashtable();
        } else if (type.equals("s")) {
            type = "Suffix";
            surfaceFormsOfAffixes = new Hashtable();
            affixesId = new Hashtable();
        }
        sources = new Hashtable();
        int i = 0;
        while (i < dataTables.length) {
            if (type == null || dataTables[i][0].equals(type) || dataTables[i][0].equals("Source")) {
                LinguisticDataCSV.readLinguisticDataCSV(dataTables[i]);
            }
            ++i;
        }
    }

    public static void initAffixes() {
        affixesId = new Hashtable();
        surfaceFormsOfAffixes = new Hashtable();
    }

    public static int readLinguisticDataCSV(String[] data) {
        String type = data[0];
        String dbName = data[1];
        String tableName = data[2];
        try {
            String line;
            String fileName = String.valueOf(tableName) + ".csv";
            InputStream is = LinguisticDataCSV.class.getResourceAsStream(fileName);
            BufferedReader f = new BufferedReader(new InputStreamReader(is));
            String firstLine = f.readLine();
            String[] fieldNames = firstLine.split(",");
            while ((line = f.readLine()) != null) {
                HashMap nextRow = LinguisticDataCSV.getNextRow(line, fieldNames);
                nextRow.put("dbName", dbName);
                nextRow.put("tableName", tableName);
                if (type.equals("Base")) {
                    Data.makeBase(nextRow);
                    continue;
                }
                if (type.equals("Suffix")) {
                    Data.makeSuffix(nextRow);
                    continue;
                }
                if (type.equals("NounEnding")) {
                    Data.makeNounEnding(nextRow);
                    continue;
                }
                if (type.equals("VerbEnding")) {
                    Data.makeVerbEnding(nextRow);
                    continue;
                }
                if (type.equals("Demonstrative")) {
                    Data.makeDemonstrative(nextRow);
                    continue;
                }
                if (type.equals("DemonstrativeEnding")) {
                    Data.makeDemonstrativeEnding(nextRow);
                    continue;
                }
                if (type.equals("Pronoun")) {
                    Data.makePronoun(nextRow);
                    continue;
                }
                if (type.equals("VerbWord")) {
                    Data.makeVerbWord(nextRow);
                    continue;
                }
                if (!type.equals("Source")) continue;
                Data.makeSource(nextRow);
            }
        }
        catch (FileNotFoundException e) {
            return FILE_NOT_FOUND;
        }
        catch (IOException e) {
            return IOEXCEPTION;
        }
        return OK;
    }

    public static HashMap getNextRow(String line, String[] fieldNames) {
        HashMap<String, String> currentRow = new HashMap<String, String>();
        Vector<String> values = new Vector<String>();
        boolean inString = false;
        int pos = 0;
        int c = 0;
        int i = 0;
        while (i < line.length()) {
            c = line.charAt(i);
            if (c == 34) {
                if (inString) {
                    if (i < line.length() - 1) {
                        if (line.charAt(i + 1) != '\"') {
                            inString = false;
                        } else {
                            ++i;
                        }
                    }
                } else {
                    inString = true;
                }
            } else if (c == 44 && !inString) {
                values.add(line.substring(pos, i));
                pos = i + 1;
            }
            ++i;
        }
        if (c == 44) {
            values.add("");
        } else {
            values.add(line.substring(pos));
        }
        String[] valuesStr = values.toArray(new String[0]);
        int i2 = 0;
        while (i2 < valuesStr.length) {
            try {
                currentRow.put(fieldNames[i2], LinguisticDataCSV.removeQuotesAndNull(valuesStr[i2]));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("line: " + line);
            }
            ++i2;
        }
        return currentRow;
    }

    static String removeQuotesAndNull(String str) {
        if (str.equals("")) {
            return null;
        }
        if (str.charAt(0) == '\"') {
            String s = str.replaceFirst("^\"", "");
            String newStr = s.replaceFirst("\"$", "");
            newStr = newStr.replaceAll("\"\"", "\"");
            return newStr;
        }
        return str;
    }
}

