/*
 * Decompiled with CFR 0.152.
 */
package dataCompiled;

import data.Data;
import data.LinguisticDataAbstract;
import dataCompiled.LinguisticDataCompiledBase;
import dataCompiled.LinguisticDataCompiledDemonstrative;
import dataCompiled.LinguisticDataCompiledDemonstrativeEnding;
import dataCompiled.LinguisticDataCompiledNounEnding;
import dataCompiled.LinguisticDataCompiledPronoun;
import dataCompiled.LinguisticDataCompiledSource;
import dataCompiled.LinguisticDataCompiledSuffix;
import dataCompiled.LinguisticDataCompiledVerbEnding;
import dataCompiled.LinguisticDataCompiledVerbWord;
import java.util.HashMap;
import java.util.Hashtable;

public final class LinguisticDataCompiled
extends LinguisticDataAbstract {
    public LinguisticDataCompiled() {
        this._compile_bases();
        this._compile_suffixes();
        this._compile_sources();
    }

    public LinguisticDataCompiled(String type) {
        if (type == null || type.equals("r")) {
            this._compile_bases();
        }
        if (type == null || type.equals("s")) {
            this._compile_suffixes();
        }
        this._compile_sources();
    }

    public void _compile_bases() {
        bases = new Hashtable();
        basesId = new Hashtable();
        words = new Hashtable();
        LinguisticDataCompiledBase.process();
        LinguisticDataCompiledDemonstrative.process();
        LinguisticDataCompiledPronoun.process();
        LinguisticDataCompiledVerbWord.process();
    }

    public void _compile_suffixes() {
        surfaceFormsOfAffixes = new Hashtable();
        affixesId = new Hashtable();
        LinguisticDataCompiledSuffix.process();
        LinguisticDataCompiledNounEnding.process();
        LinguisticDataCompiledVerbEnding.process();
        LinguisticDataCompiledDemonstrativeEnding.process();
    }

    public void _compile_sources() {
        sources = new Hashtable();
        LinguisticDataCompiledSource.process();
    }

    public static void processBase(String[] data) {
        HashMap<String, String> hm = new HashMap<String, String>();
        int j = 0;
        while (j < data.length) {
            hm.put(data[j], data[j + 1]);
            j += 2;
        }
        Data.makeBase(hm);
    }

    public static void processSuffix(String[] data) {
        HashMap<String, String> hm = new HashMap<String, String>();
        int j = 0;
        while (j < data.length) {
            hm.put(data[j], data[j + 1]);
            j += 2;
        }
        Data.makeSuffix(hm);
    }

    public static void processPronoun(String[] data) {
        HashMap<String, String> hm = new HashMap<String, String>();
        int j = 0;
        while (j < data.length) {
            hm.put(data[j], data[j + 1]);
            j += 2;
        }
        Data.makePronoun(hm);
    }

    public static void processDemonstrative(String[] data) {
        HashMap<String, String> hm = new HashMap<String, String>();
        int j = 0;
        while (j < data.length) {
            hm.put(data[j], data[j + 1]);
            j += 2;
        }
        Data.makeDemonstrative(hm);
    }

    public static void processNounEnding(String[] data) {
        HashMap<String, String> hm = new HashMap<String, String>();
        int j = 0;
        while (j < data.length) {
            hm.put(data[j], data[j + 1]);
            j += 2;
        }
        Data.makeNounEnding(hm);
    }

    public static void processVerbEnding(String[] data) {
        HashMap<String, String> hm = new HashMap<String, String>();
        int j = 0;
        while (j < data.length) {
            hm.put(data[j], data[j + 1]);
            j += 2;
        }
        Data.makeVerbEnding(hm);
    }

    public static void processDemonstrativeEnding(String[] data) {
        HashMap<String, String> hm = new HashMap<String, String>();
        int j = 0;
        while (j < data.length) {
            hm.put(data[j], data[j + 1]);
            j += 2;
        }
        Data.makeDemonstrativeEnding(hm);
    }

    public static void processVerbWord(String[] data) {
        HashMap<String, String> hm = new HashMap<String, String>();
        int j = 0;
        while (j < data.length) {
            hm.put(data[j], data[j + 1]);
            j += 2;
        }
        Data.makeVerbWord(hm);
    }

    public static void processSource(String[] data) {
        HashMap<String, String> hm = new HashMap<String, String>();
        int j = 0;
        while (j < data.length) {
            hm.put(data[j], data[j + 1]);
            j += 2;
        }
        Data.makeSource(hm);
    }
}

