/*
 * Decompiled with CFR 0.152.
 */
package morph;

import data.Affix;
import data.Morpheme;
import data.SurfaceFormOfAffix;
import data.VerbEnding;
import java.util.Vector;
import morph.Decomposition;
import morph.PartOfComposition;

public class AffixPartOfComposition
extends PartOfComposition {
    SurfaceFormOfAffix form = null;
    boolean reflexive = false;
    VerbEnding tv = null;
    AffixPartOfComposition[] multipleMorphparts = null;

    public AffixPartOfComposition(int posAffix, SurfaceFormOfAffix f) {
        this.term = null;
        this.position = posAffix;
        this.form = f;
    }

    AffixPartOfComposition(int pos) {
        this.position = pos;
    }

    public SurfaceFormOfAffix getForm() {
        return this.form;
    }

    public boolean getReflexive() {
        return this.reflexive;
    }

    @Override
    public Morpheme getMorpheme() {
        return this.form.getAffix();
    }

    public Affix getAffix() {
        return this.form.getAffix();
    }

    public String getType() {
        return this.form.getAffix().type;
    }

    public VerbEnding getVerbEnding() {
        return this.tv;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[AffixPartOfComposition: ");
        sb.append("\nterm= ");
        sb.append(this.term);
        sb.append("\nposition= ");
        sb.append(this.position);
        sb.append("\nform= ");
        if (this.form == null) {
            sb.append("null");
        } else {
            sb.append(this.form.toString());
        }
        sb.append("\nreflexive= ");
        if (this.reflexive) {
            sb.append("true");
        } else {
            sb.append("false");
        }
        sb.append("\n]");
        return sb.toString();
    }

    public String toStr() {
        Affix aff = this.form.getAffix();
        String trm = this.term != null && this.term.length() != 0 && this.term.charAt(this.term.length() - 1) == '*' ? this.term.substring(0, this.term.length() - 1) : this.term;
        return new Decomposition.DecompositionExpression.DecPart((String)trm, (String)aff.id).str;
    }

    public void setMultipleMorphparts(Vector morphParts) {
        this.multipleMorphparts = morphParts.toArray(new AffixPartOfComposition[0]);
    }

    public AffixPartOfComposition[] getMultipleMorphparts() {
        return this.multipleMorphparts;
    }
}

