/*
 * Decompiled with CFR 0.152.
 */
package morph;

import data.Morpheme;
import data.constraints.Conditions;
import data.constraints.Imacond;
import data.constraints.ParseException;
import java.util.Vector;

public class Graph {
    static State[] states;
    public static State initialState;
    public static State finalState;
    public static State verbState;

    static {
        State v;
        State pp = null;
        State zero = null;
        State mq = new State("mq");
        State mqi = new State("mqi");
        State m = new State("m");
        State n = new State("n");
        verbState = v = new State("v");
        State a = new State("a");
        State e = new State("e");
        State c = new State("c");
        State rn = new State("rn");
        State rnc = new State("rnc");
        State rv = new State("rv");
        State ad = new State("ad");
        State pds = new State("pds");
        State pdp = new State("pdp");
        State d = new State("d");
        pp = new State("pp");
        State pp1 = new State("pp1");
        State pp2 = new State("pp2");
        State radpp1 = new State("radpp1");
        State radpp2 = new State("radpp2");
        State racpp1 = new State("racpp1");
        State racpp2 = new State("racpp2");
        zero = new State("0");
        mq.setArcs(new Arc[]{new Arc(Graph.makeCond("id:guuq/1q"), mqi), new Arc(Graph.makeCond("id:kia/1q"), mqi), new Arc(Graph.makeCond("id:ttauq/1q"), mqi), new Arc(Graph.makeCond("id:qai/1q"), mqi), new Arc(Graph.makeCond("type:q"), m), new Arc(null, m)});
        mqi.setArcs(new Arc[]{new Arc(Graph.makeCond("id:li/1q"), m), new Arc(Graph.makeCond("id:lu/1q"), m)});
        m.setArcs(new Arc[]{new Arc(null, n), new Arc(null, v), new Arc(null, e), new Arc(null, a), new Arc(null, c), new Arc(null, pp), new Arc(null, d), new Arc(null, rn)});
        n.setArcs(new Arc[]{new Arc(Graph.makeCond("type:tn"), rn), new Arc(Graph.makeCond("type:tn"), rnc), new Arc(Graph.makeCond("type:n,number:d"), zero), new Arc(Graph.makeCond("type:n,number:p"), zero), new Arc(Graph.makeCond("type:tn,number:s,possPers:null"), a)});
        v.setArcs(new Arc[]{new Arc(Graph.makeCond("type:tv"), rv)});
        a.setArcs(new Arc[]{new Arc(Graph.makeCond("type:a"), zero)});
        e.setArcs(new Arc[]{new Arc(Graph.makeCond("type:e"), zero)});
        c.setArcs(new Arc[]{new Arc(Graph.makeCond("type:c"), zero)});
        rn.setArcs(new Arc[]{new Arc(Graph.makeCond("function:nn"), rn), new Arc(Graph.makeCond("function:nn"), rnc), new Arc(Graph.makeCond("function:nn"), a), new Arc(Graph.makeCond("function:vn"), a), new Arc(Graph.makeCond("function:vn"), rv), new Arc(Graph.makeCond("type:n,number:s"), zero), new Arc(Graph.makeCond("type:p,!nature:per"), zero)});
        rnc.setArcs(new Arc[]{new Arc(Graph.makeCond("type:n,subtype:nc"), zero)});
        rv.setArcs(new Arc[]{new Arc(Graph.makeCond("function:vv"), rv), new Arc(Graph.makeCond("function:nv"), n), new Arc(Graph.makeCond("function:nv"), rn), new Arc(Graph.makeCond("function:nv"), rnc), new Arc(Graph.makeCond("function:nv"), a), new Arc(Graph.makeCond("function:nv"), d), new Arc(Graph.makeCond("type:v"), zero)});
        d.setArcs(new Arc[]{new Arc(Graph.makeCond("type:ad"), zero), new Arc(Graph.makeCond("type:pd"), zero), new Arc(Graph.makeCond("type:tad"), ad), new Arc(Graph.makeCond("type:tpd,number:s"), pds), new Arc(Graph.makeCond("type:tpd,number:p"), pdp)});
        ad.setArcs(new Arc[]{new Arc(Graph.makeCond("type:rad"), zero)});
        pds.setArcs(new Arc[]{new Arc(Graph.makeCond("type:rpd,number:s"), zero)});
        pdp.setArcs(new Arc[]{new Arc(Graph.makeCond("type:rpd,number:p"), zero)});
        pp.setArcs(new Arc[]{new Arc(null, pp1), new Arc(null, radpp1), new Arc(null, radpp2), new Arc(Graph.makeCond("type:tn,possPers:null"), radpp2), new Arc(Graph.makeCond("type:tn,possPers:null"), radpp2)});
        pp1.setArcs(new Arc[]{new Arc(Graph.makeCond("function:nn"), radpp1), new Arc(Graph.makeCond("function:nn"), pp1)});
        radpp1.setArcs(new Arc[]{new Arc(Graph.makeCond("type:tn,possPers:1,possNumber:number"), racpp1), new Arc(Graph.makeCond("type:tn,possPers:2,possNumber:number"), racpp2)});
        radpp2.setArcs(new Arc[]{new Arc(Graph.makeCond("type:pr"), zero), new Arc(Graph.makeCond("function:nn"), radpp2)});
        racpp1.setArcs(new Arc[]{new Arc(Graph.makeCond("id:uva/1rpr"), zero)});
        racpp2.setArcs(new Arc[]{new Arc(Graph.makeCond("id:ili/1rp"), zero)});
        initialState = mq;
        finalState = zero;
        states = new State[]{mq, mqi, m, n, v, a, e, c, rn, rv, ad, pds, pdp, d, pp, pp1, pp2, radpp1, radpp2, racpp1, racpp2, zero};
    }

    public static State getEtat(String str) {
        int i = 0;
        while (i < states.length) {
            if (states[i].getId().equals(str)) {
                return states[i];
            }
            ++i;
        }
        return null;
    }

    private static Conditions makeCond(String str) {
        try {
            return (Conditions)((Object)new Imacond(str).ParseCondition());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class Arc
    implements Cloneable {
        Conditions cond;
        State startState;
        State destState;

        public Arc(Conditions cond, State destState) {
            this.cond = cond;
            this.destState = destState;
        }

        private Arc() {
        }

        public State getDestinationState() {
            return this.destState;
        }

        public Conditions getCondition() {
            return this.cond;
        }

        public String getDestinationStateStr() {
            return this.destState.id;
        }

        public void setStartState(State ss) {
            this.startState = ss;
        }

        public Arc copy() {
            Arc arc = null;
            try {
                arc = (Arc)this.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return arc;
        }
    }

    public static class State
    implements Cloneable {
        public String id;
        Arc[] arcs;

        public State(String id) {
            this.id = id;
        }

        private State() {
        }

        public String getId() {
            return this.id;
        }

        public Arc[] getArcs() {
            return this.arcs;
        }

        private void setArcs(Arc[] arcs) {
            this.arcs = arcs;
            int i = 0;
            while (i < arcs.length) {
                arcs[i].setStartState(this);
                ++i;
            }
        }

        public Vector verify(Morpheme affixe) {
            Vector<Arc> possibles = new Vector<Arc>();
            int i = 0;
            while (i < this.arcs.length) {
                if (this.arcs[i].getCondition() == null) {
                    Vector possibles1 = this.arcs[i].destState.verify(affixe);
                    possibles.addAll(possibles1);
                } else if (this.arcs[i].getCondition().isMetByFullMorphem(affixe)) {
                    possibles.add(this.arcs[i]);
                }
                ++i;
            }
            return possibles;
        }

        public Object clone() {
            State cl = new State();
            cl.id = new String(this.id);
            cl.arcs = (Arc[])this.arcs.clone();
            return cl;
        }
    }
}

