/*
 * Decompiled with CFR 0.152.
 */
package morph;

import data.Action;
import data.Affix;
import data.Base;
import data.Lexicon;
import data.Morpheme;
import data.SurfaceFormOfAffix;
import data.constraints.Condition;
import data.constraints.Conditions;
import data.constraints.Imacond;
import data.constraints.ParseException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morph.AffixPartOfComposition;
import morph.Decomposition;
import morph.Graph;
import morph.RootPartOfComposition;
import phonology.Dialect;
import script.Orthography;
import script.Roman;
import utilities1.Util;

public class MorphInuk {
    private static Hashtable arcsByMorpheme = new Hashtable();

    public static Decomposition[] decomposeWord(String word) {
        ArrayList<Object> decsList = new ArrayList<Object>();
        Vector<String> words = null;
        words = new Vector<String>();
        words.add(word);
        int i = 0;
        while (i < words.size()) {
            Vector newDecomps;
            Vector decomps = null;
            try {
                decomps = MorphInuk.decompose((String)words.elementAt(i), false, false);
            }
            catch (OutOfMemoryError e) {
                decomps = new Vector();
                System.out.println("Out of memory in decomposeWord for word '" + words.elementAt(i) + "'");
            }
            if (decomps == null) {
                decomps = new Vector();
            }
            if (Roman.typeOfLetterLat(word.charAt(word.length() - 1)) == Roman.V) {
                newDecomps = MorphInuk.decompose(String.valueOf(word) + "*", false, false);
            } else if (word.charAt(word.length() - 1) == 'n') {
                newDecomps = MorphInuk.decompose(String.valueOf(word.substring(0, word.length() - 1)) + "t", false, false);
                if (newDecomps != null) {
                    int j = 0;
                    while (j < newDecomps.size()) {
                        Decomposition dec = (Decomposition)newDecomps.elementAt(j);
                        Object[] max = dec.morphParts;
                        AffixPartOfComposition affixPart = null;
                        if (max.length != 0) {
                            affixPart = (AffixPartOfComposition)max[max.length - 1];
                            affixPart.setTerme(String.valueOf(affixPart.getTerm().substring(0, affixPart.getTerm().length() - 1)) + "n");
                        }
                        ++j;
                    }
                }
            } else {
                newDecomps = new Vector();
            }
            if (newDecomps != null) {
                decomps.addAll(newDecomps);
            }
            Decomposition[] decsM = new Decomposition[]{};
            decsM = decomps.toArray(decsM);
            Decomposition[] decsC = Decomposition.removeCombinedSuffixes(decsM);
            Object[] decs = Decomposition.removeMultiples(decsC);
            Arrays.sort(decs);
            decsList.addAll(Arrays.asList(decs));
            ++i;
        }
        Decomposition[] decs = decsList.toArray(new Decomposition[0]);
        return decs;
    }

    private static Vector decompose(String term, boolean isSyllabic, boolean decomposeBase) {
        Vector morphPartsInit = new Vector();
        Vector decomposition = null;
        String simplifiedTerm = null;
        Conditions preCond = null;
        arcsByMorpheme.clear();
        if (!isSyllabic) {
            term = Util.enMinuscule(term);
        }
        Graph.State state = decomposeBase ? null : Graph.initialState;
        try {
            if (term != null) {
                simplifiedTerm = Orthography.simplifiedOrthography(term, isSyllabic);
                String transitivity = null;
                decomposition = MorphInuk.decompose_simplified_term(simplifiedTerm, simplifiedTerm, simplifiedTerm, morphPartsInit, new Graph.State[]{state}, preCond, transitivity, isSyllabic);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decomposition;
    }

    private static Vector decompose_simplified_term(String term, String termOrig, String word, Vector morphParts, Graph.State[] states, Conditions preCond, String transitivity, boolean isSyllabic) {
        Vector completeAnalysis = new Vector();
        String termICI = Orthography.orthographyICI(term, isSyllabic);
        String termOrigICI = Orthography.orthographyICI(termOrig, isSyllabic);
        Vector rootAnalyses = MorphInuk.analyzeRoot(termICI, termOrigICI, term, isSyllabic, word, morphParts, states, preCond, transitivity);
        completeAnalysis.addAll(rootAnalyses);
        try {
            int positionAffixStart;
            int positionAffix = 0;
            positionAffix = positionAffixStart = term.length() - 1;
            while (positionAffix > 1) {
                Vector othersFoundDim;
                Vector onesFoundDim;
                String affixCandidate = term.substring(positionAffix);
                String stem = term.substring(0, positionAffix);
                Vector onesFound = null;
                Vector othersFound = null;
                onesFound = Lexicon.lookForForms(affixCandidate, isSyllabic);
                Vector newCandidates = null;
                newCandidates = Dialect.newCandidates(stem, affixCandidate, null);
                if (newCandidates != null) {
                    int k = 0;
                    while (k < newCandidates.size()) {
                        Vector tr = Lexicon.lookForForms((String)newCandidates.elementAt(k), isSyllabic);
                        if (othersFound == null) {
                            othersFound = new Vector();
                        }
                        if (tr != null) {
                            othersFound.addAll(tr);
                        }
                        ++k;
                    }
                }
                if ((onesFoundDim = MorphInuk.eliminateByArcsFollowedEtc(onesFound, states, morphParts, positionAffix, preCond, transitivity)) != null) {
                    Vector anas = MorphInuk.decomposeByAffixes(onesFoundDim, stem, affixCandidate, states, preCond, transitivity, positionAffix, morphParts, word, true);
                    completeAnalysis.addAll(anas);
                }
                if ((othersFoundDim = MorphInuk.eliminateByArcsFollowedEtc(othersFound, states, morphParts, positionAffix, preCond, transitivity)) != null) {
                    Vector anas = MorphInuk.decomposeByAffixes(othersFoundDim, stem, affixCandidate, states, preCond, transitivity, positionAffix, morphParts, word, false);
                    completeAnalysis.addAll(anas);
                }
                --positionAffix;
            }
            return completeAnalysis;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return completeAnalysis;
        }
    }

    private static Vector eliminateByArcsFollowedEtc(Vector onesFound, Graph.State[] states, Vector morphParts, int positionAffix, Conditions preCond, String transitivity) {
        if (onesFound == null) {
            return null;
        }
        Vector<Affix> toBeRemoved = new Vector<Affix>();
        Vector<SurfaceFormOfAffix> onesFoundDimin = new Vector<SurfaceFormOfAffix>();
        String keyStateIDs = "0";
        int i = 0;
        while (i < states.length) {
            keyStateIDs = String.valueOf(keyStateIDs) + "+" + states[i].id;
            ++i;
        }
        i = 0;
        while (i < onesFound.size()) {
            SurfaceFormOfAffix formOfAffix = (SurfaceFormOfAffix)onesFound.elementAt(i);
            Affix aff = formOfAffix.getAffix();
            if (!(!toBeRemoved.contains(aff) && MorphInuk.arcsSuivis(aff, states, keyStateIDs) != null && MorphInuk.sameAsNext(aff, morphParts) && MorphInuk.samePosition(positionAffix, morphParts) && aff.meetsConditions(preCond, morphParts) && aff.meetsTransitivityCondition(transitivity))) {
                toBeRemoved.add(aff);
            } else {
                onesFoundDimin.add(formOfAffix);
            }
            ++i;
        }
        return onesFoundDimin;
    }

    private static Vector decomposeByAffixes(Vector onesFound, String stem, String affixCandidateOrig, Graph.State[] states, Conditions preCond, String transitivity, int positionAffix, Vector morphParts, String word, boolean notResultingFromDialectalPhonologicalTransformation) {
        Vector completeAnalysis = new Vector();
        String keyStateIDs = "0";
        int i = 0;
        while (i < states.length) {
            keyStateIDs = String.valueOf(keyStateIDs) + "+" + states[i].id;
            ++i;
        }
        Enumeration e = onesFound.elements();
        while (e.hasMoreElements()) {
            SurfaceFormOfAffix form = (SurfaceFormOfAffix)e.nextElement();
            Affix affix1 = form.getAffix();
            Affix affix = null;
            try {
                affix = (Affix)affix1.copyOf();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            boolean accepted = true;
            Graph.Arc[] arcsFollowed = null;
            Graph.State[] nextStates = null;
            Object[][] stemAffs = null;
            arcsFollowed = MorphInuk.arcsSuivis(affix, states, keyStateIDs);
            if (arcsFollowed != null && (stemAffs = MorphInuk.agreeWithContextAndActions(affixCandidateOrig, affix, stem, positionAffix, form, notResultingFromDialectalPhonologicalTransformation)) != null) {
                accepted = true;
                nextStates = new Graph.State[arcsFollowed.length];
                int i2 = 0;
                while (i2 < arcsFollowed.length) {
                    Graph.State dest = arcsFollowed[i2].getDestinationState();
                    nextStates[i2] = (Graph.State)dest.clone();
                    ++i2;
                }
            } else {
                accepted = false;
            }
            if (!accepted) continue;
            Conditions newCond = affix.getPrecCond();
            String newTransitivity = affix.getTransitivityConstraint();
            if (newTransitivity == null) {
                newTransitivity = transitivity;
            }
            int iro = 0;
            while (iro < stemAffs.length) {
                Vector newMorphparts = (Vector)morphParts.clone();
                AffixPartOfComposition partIro = (AffixPartOfComposition)stemAffs[iro][2];
                partIro.arcs = arcsFollowed;
                newMorphparts.add(0, partIro);
                Vector analyses = MorphInuk.decompose_simplified_term((String)stemAffs[iro][0], (String)stemAffs[iro][1], word, newMorphparts, nextStates, newCond, newTransitivity, false);
                if (analyses != null && analyses.size() != 0) {
                    completeAnalysis.addAll(analyses);
                }
                ++iro;
            }
        }
        return completeAnalysis;
    }

    private static Object[][] validateContextActions(String context, Action action1, Action action2, String stem, int posAffix, Affix affix, SurfaceFormOfAffix form, boolean isSyllabic, boolean checkPossibleDialectalChanges, String affixCandidate) {
        AffixPartOfComposition npartOfComp;
        String insert;
        String cond;
        int action1Type = action1.getType();
        int action2Type = action2.getType();
        Vector<Object[]> res = new Vector<Object[]>();
        char stemEndChar = stem.charAt(stem.length() - 1);
        int stemPenultEndChar = 65535;
        if (stem.length() > 1) {
            stemPenultEndChar = stem.charAt(stem.length() - 2);
        }
        char formFirstChar = affixCandidate.charAt(0);
        int typeOfStemEndChar = Roman.typeOfLetterLat(stemEndChar);
        int typeOfStemPenultEndChar = Roman.typeOfLetterLat((char)stemPenultEndChar);
        int typeOfFormFirstChar = Roman.typeOfLetterLat(formFirstChar);
        AffixPartOfComposition partOfComp = new AffixPartOfComposition(posAffix, form);
        if (affix.isNonMobileSuffix()) {
            Condition.NonMobilityOfInfix avc = new Condition.NonMobilityOfInfix(affix.id);
            affix.addPrecConstraint(avc);
        }
        if (action1Type == Action.NEUTRAL && action2Type == Action.NULLACTION) {
            if (context == null) {
                res.add(new Object[]{stem, stem, partOfComp});
            } else if (context.equals("V")) {
                if (typeOfStemEndChar == Roman.V) {
                    res.add(new Object[]{stem, stem, partOfComp});
                }
            } else {
                Object[] x;
                boolean doubleConsonants;
                Vector grs;
                String stemOrig = new String(stem);
                if (stemEndChar == 'i' && form.form.length() > 1 && form.form.substring(0, 2).equals("ta")) {
                    stem = String.valueOf(stem) + 't';
                    stemEndChar = 't';
                    stemPenultEndChar = 105;
                    typeOfStemEndChar = Roman.C;
                    typeOfStemPenultEndChar = Roman.V;
                }
                if (stemEndChar == context.charAt(0)) {
                    res.add(new Object[]{stem, stemOrig, partOfComp});
                }
                if (typeOfStemEndChar == Roman.C && typeOfFormFirstChar == Roman.C && (grs = Dialect.equivalentGroups(stemEndChar, formFirstChar)) != null) {
                    int i = 0;
                    while (i < grs.size()) {
                        if (((String)grs.elementAt(i)).charAt(0) == context.charAt(0) && ((String)grs.elementAt(i)).charAt(1) == formFirstChar) {
                            res.add(new Object[]{String.valueOf(stem.substring(0, stem.length() - 1)) + context, stemOrig, partOfComp});
                            break;
                        }
                        ++i;
                    }
                }
                if (typeOfStemEndChar == Roman.V && typeOfFormFirstChar == Roman.C && (doubleConsonants = ((Boolean)(x = Dialect.schneiderStateAtEnd(stemOrig))[0]).booleanValue())) {
                    res.add(new Object[]{String.valueOf(stemOrig) + context, stemOrig, partOfComp});
                }
            }
            cond = action1.getCondition();
            if (res.size() != 0 && cond != null && cond.startsWith("id:")) {
                try {
                    Condition avc = new Imacond(new ByteArrayInputStream(cond.getBytes())).ParseCondition();
                    affix.addPrecConstraint(avc);
                }
                catch (ParseException avc) {}
            }
        } else if (action1Type == Action.NEUTRAL && action2Type == Action.DELETION) {
            if (context.equals("V")) {
                if (typeOfStemEndChar == Roman.V && (typeOfStemPenultEndChar == -1 || typeOfStemPenultEndChar == Roman.C)) {
                    res.add(new Object[]{stem, stem, partOfComp});
                    res.add(new Object[]{String.valueOf(stem) + "a", stem, partOfComp});
                    res.add(new Object[]{String.valueOf(stem) + "i", stem, partOfComp});
                    res.add(new Object[]{String.valueOf(stem) + "u", stem, partOfComp});
                }
            } else if (stem.length() > 1) {
                char charBeforeStemEndChar = stem.charAt(stem.length() - 2);
                int typeOfCharBeforeStemEndChar = Roman.typeOfLetterLat(charBeforeStemEndChar);
                if (typeOfStemEndChar == Roman.V && typeOfCharBeforeStemEndChar == Roman.V) {
                    res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
                }
            }
        } else if (action1Type == Action.NEUTRAL && action2Type == Action.INSERTION) {
            insert = Orthography.simplifiedOrthography(action2.getInsert(), isSyllabic);
            int linsert = insert.length();
            int lstem = stem.length();
            if (context.equals("V")) {
                if (stem.endsWith(insert) && lstem > linsert + 2 && Roman.typeOfLetterLat(stem.charAt(lstem - linsert - 1)) == Roman.V && Roman.typeOfLetterLat(stem.charAt(lstem - linsert - 2)) == Roman.V) {
                    AffixPartOfComposition npartOfComp2 = new AffixPartOfComposition(posAffix - linsert, form);
                    res.add(new Object[]{stem.substring(0, lstem - linsert), stem.substring(0, lstem - linsert), npartOfComp2});
                } else if (typeOfStemEndChar == Roman.V) {
                    res.add(new Object[]{stem, stem, partOfComp});
                }
            }
        } else if (action1Type == Action.DELETION && action2Type == Action.NULLACTION) {
            if ((context.equals("t") || context.equals("k") || context.equals("q")) && typeOfStemEndChar == Roman.V) {
                res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
            }
        } else if (action1Type == Action.DELETIONINSERTION && action2Type == Action.NULLACTION) {
            String carsInsere = Orthography.simplifiedOrthography(action1.getInsert(), isSyllabic);
            int linsert = carsInsere.length();
            int lstem = stem.length();
            if (stem.endsWith(carsInsere)) {
                AffixPartOfComposition npartOfComp3 = new AffixPartOfComposition(posAffix - linsert, form);
                res.add(new Object[]{String.valueOf(stem.substring(0, lstem - linsert)) + context, stem.substring(0, lstem - linsert), npartOfComp3});
            }
        } else if (action1Type == Action.CONDITIONALDELETION && action2Type == Action.NULLACTION) {
            if ((context.equals("t") || context.equals("k") || context.equals("q")) && typeOfStemEndChar == Roman.V || context.equals("V") && typeOfStemEndChar == Roman.C) {
                cond = action1.getCondition();
                if (cond.startsWith("id:")) {
                    try {
                        Condition avc = new Imacond(new ByteArrayInputStream(cond.getBytes())).ParseCondition();
                        affix.addPrecConstraint(avc);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (!context.equals("V")) {
                        res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
                    } else {
                        Vector grs;
                        String formInCond = cond.substring(3, cond.indexOf("/"));
                        res.add(new Object[]{String.valueOf(stem) + formInCond.substring(formInCond.length() - 1), stem, partOfComp});
                        if (typeOfStemEndChar == Roman.C && typeOfFormFirstChar == Roman.C && checkPossibleDialectalChanges && (grs = Dialect.equivalentGroups(stemEndChar, formFirstChar)) != null) {
                            int i = 0;
                            while (i < grs.size()) {
                                if (((String)grs.elementAt(i)).charAt(1) == formFirstChar) {
                                    res.add(new Object[]{String.valueOf(stem.substring(0, stem.length() - 1)) + ((String)grs.elementAt(i)).charAt(0) + formInCond.substring(formInCond.length() - 1), stem, partOfComp});
                                }
                                ++i;
                            }
                        }
                    }
                } else {
                    Pattern pattern = Pattern.compile(action1.getCondition());
                    Matcher matcher = pattern.matcher(stem);
                    if (matcher.find()) {
                        res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
                    }
                }
            }
        } else if (action1Type == Action.VOICING && action2Type == Action.NULLACTION) {
            if (!context.equals("V")) {
                Vector grs;
                char voicedCorrespondingChar = Roman.voicedOfOcclusiveUnvoicedLat(context.charAt(0));
                if (stemEndChar == voicedCorrespondingChar) {
                    res.add(new Object[]{String.valueOf(stem.substring(0, stem.length() - 1)) + context, stem, partOfComp});
                } else if (typeOfStemEndChar == Roman.V) {
                    Object[] x;
                    boolean doubleConsonants;
                    if (typeOfStemEndChar == Roman.V && typeOfFormFirstChar == Roman.C && (doubleConsonants = ((Boolean)(x = Dialect.schneiderStateAtEnd(stem))[0]).booleanValue())) {
                        res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
                    }
                } else if (checkPossibleDialectalChanges && (grs = Dialect.equivalentGroups(stemEndChar, formFirstChar)) != null) {
                    int i = 0;
                    while (i < grs.size()) {
                        if (((String)grs.elementAt(i)).charAt(0) == voicedCorrespondingChar && ((String)grs.elementAt(i)).charAt(1) == formFirstChar) {
                            res.add(new Object[]{String.valueOf(stem.substring(0, stem.length() - 1)) + context, stem, partOfComp});
                            break;
                        }
                        ++i;
                    }
                }
            }
        } else if (action1Type == Action.NASALIZATION) {
            if (!context.equals("V")) {
                Vector grs;
                char nasalCorrespondingChar = Roman.nasalOfOcclusiveUnvoicedLat(context.charAt(0));
                if (stemEndChar == nasalCorrespondingChar) {
                    res.add(new Object[]{String.valueOf(stem.substring(0, stem.length() - 1)) + context, stem, partOfComp});
                } else if (typeOfStemEndChar == Roman.V) {
                    Object[] x;
                    boolean doubleConsonants;
                    if (typeOfStemEndChar == Roman.V && typeOfFormFirstChar == Roman.C && (doubleConsonants = ((Boolean)(x = Dialect.schneiderStateAtEnd(stem))[0]).booleanValue())) {
                        res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
                    }
                } else if (checkPossibleDialectalChanges && (grs = Dialect.equivalentGroups(stemEndChar, formFirstChar)) != null) {
                    int i = 0;
                    while (i < grs.size()) {
                        if (((String)grs.elementAt(i)).charAt(0) == nasalCorrespondingChar && ((String)grs.elementAt(i)).charAt(1) == formFirstChar) {
                            res.add(new Object[]{String.valueOf(stem.substring(0, stem.length() - 1)) + context, stem, partOfComp});
                            break;
                        }
                        ++i;
                    }
                }
            }
        } else if (action1Type == Action.CONDITIONALNASALIZATION) {
            Vector grs;
            Condition avc;
            cond = action1.getCondition();
            char nasalCorrespondingChar = Roman.nasalOfOcclusiveUnvoicedLat(context.charAt(0));
            if (stemEndChar == nasalCorrespondingChar) {
                try {
                    Condition avc2 = new Imacond(new ByteArrayInputStream(cond.getBytes())).ParseCondition();
                    affix.addPrecConstraint(avc2);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                res.add(new Object[]{String.valueOf(stem.substring(0, stem.length() - 1)) + context, stem, partOfComp});
            } else if (typeOfStemEndChar == Roman.V) {
                Object[] x;
                boolean doubleConsonants;
                if (typeOfStemEndChar == Roman.V && typeOfFormFirstChar == Roman.C && (doubleConsonants = ((Boolean)(x = Dialect.schneiderStateAtEnd(stem))[0]).booleanValue())) {
                    try {
                        avc = new Imacond(new ByteArrayInputStream(cond.getBytes())).ParseCondition();
                        affix.addPrecConstraint(avc);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
                }
            } else if (checkPossibleDialectalChanges && (grs = Dialect.equivalentGroups(stemEndChar, formFirstChar)) != null) {
                int i = 0;
                while (i < grs.size()) {
                    if (((String)grs.elementAt(i)).charAt(0) == nasalCorrespondingChar && ((String)grs.elementAt(i)).charAt(1) == formFirstChar) {
                        try {
                            avc = new Imacond(new ByteArrayInputStream(cond.getBytes())).ParseCondition();
                            affix.addPrecConstraint(avc);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        res.add(new Object[]{String.valueOf(stem.substring(0, stem.length() - 1)) + context, stem, partOfComp});
                        break;
                    }
                    ++i;
                }
            }
        } else if (action1Type == Action.INSERTION && action2Type == Action.NULLACTION) {
            if (context.equals("V") && (stem.endsWith("a") || stem.endsWith("i") || stem.endsWith("u")) || stem.endsWith(context)) {
                res.add(new Object[]{stem, stem, partOfComp});
            }
        } else if (action1Type == Action.FUSION && action2Type == Action.NULLACTION) {
            if ((context.equals("t") || context.equals("k") || context.equals("q")) && typeOfStemEndChar == Roman.V) {
                res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
            }
        } else if (action1Type == Action.ASSIMILATION && action2Type == Action.NULLACTION) {
            Object[] x;
            boolean doubleConsonants;
            if (typeOfStemEndChar == Roman.C && stemEndChar == form.form.charAt(0)) {
                res.add(new Object[]{String.valueOf(stem.substring(0, stem.length() - 1)) + context, stem, partOfComp});
            }
            if (typeOfStemEndChar == Roman.V && typeOfFormFirstChar == Roman.C && (doubleConsonants = ((Boolean)(x = Dialect.schneiderStateAtEnd(stem))[0]).booleanValue())) {
                res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
            }
        } else if (action1Type == Action.SPECIFICASSIMILATION && action2Type == Action.NULLACTION) {
            if (stemEndChar == action1.getAssimA().charAt(0)) {
                res.add(new Object[]{String.valueOf(stem.substring(0, stem.length() - 1)) + context, stem, partOfComp});
            }
        } else if (action1Type == Action.DELETION && action2Type == Action.SPECIFICDELETION) {
            if (typeOfStemEndChar == Roman.V) {
                res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
                if (action2.getCondition() != null) {
                    cond = action2.getCondition();
                    Pattern p = Pattern.compile(cond);
                    Matcher m = p.matcher(stem);
                    if (m.find()) {
                        res.add(new Object[]{String.valueOf(stem) + action2.getSuppr() + context, stem, partOfComp});
                    }
                } else {
                    res.add(new Object[]{String.valueOf(stem) + action2.getSuppr() + context, stem, partOfComp});
                }
            }
        } else if (action1Type == Action.DELETION && action2Type == Action.INSERTION) {
            insert = Orthography.simplifiedOrthography(action2.getInsert(), isSyllabic);
            int lstem = stem.length();
            int linsert = insert.length();
            String cntx = null;
            cntx = context.equals("V") ? "" : context;
            if (stem.endsWith(insert) && lstem - linsert > 2 && Roman.typeOfLetterLat(stem.charAt(lstem - linsert - 1)) == Roman.V && Roman.typeOfLetterLat(stem.charAt(lstem - linsert - 2)) == Roman.V) {
                AffixPartOfComposition npartOfComp4;
                if (Roman.typeOfLetterLat(stem.charAt(lstem - 1)) == Roman.V && Roman.typeOfLetterLat(stem.charAt(lstem - 2)) == Roman.C) {
                    npartOfComp4 = new AffixPartOfComposition(posAffix - linsert, form);
                    res.add(new Object[]{String.valueOf(stem.substring(0, lstem - linsert)) + cntx, stem.substring(0, lstem - linsert), npartOfComp4});
                    res.add(new Object[]{String.valueOf(stem) + cntx, stem, partOfComp});
                } else {
                    npartOfComp4 = new AffixPartOfComposition(posAffix - linsert, form);
                    res.add(new Object[]{String.valueOf(stem.substring(0, lstem - linsert)) + cntx, stem.substring(0, lstem - linsert), npartOfComp4});
                }
            } else if (lstem > 2 && Roman.typeOfLetterLat(stem.charAt(lstem - 1)) == Roman.V && Roman.typeOfLetterLat(stem.charAt(lstem - 2)) == Roman.C) {
                res.add(new Object[]{String.valueOf(stem) + cntx, stem, partOfComp});
            }
        } else if (action1Type == Action.VOWELLENGTHENING && action2Type == Action.CANCELLATION) {
            if (typeOfStemEndChar == Roman.V) {
                if (stem.length() > 3 && stem.charAt(stem.length() - 2) == stemEndChar) {
                    npartOfComp = new AffixPartOfComposition(posAffix - 1, form);
                    res.add(new Object[]{stem.substring(0, stem.length() - 1), stem.substring(0, stem.length() - 1), npartOfComp});
                    res.add(new Object[]{stem, stem, partOfComp});
                } else if (stem.length() > 3 && Roman.typeOfLetterLat(stem.charAt(stem.length() - 2)) == Roman.V) {
                    res.add(new Object[]{stem, stem, partOfComp});
                }
            }
        } else if (action1Type == Action.DELETIONVOWELLENGTHENING && action2Type == Action.CANCELLATION) {
            if (typeOfStemEndChar == Roman.V) {
                if (stem.length() > 3 && stem.charAt(stem.length() - 2) == stemEndChar) {
                    npartOfComp = new AffixPartOfComposition(posAffix - 1, form);
                    res.add(new Object[]{String.valueOf(stem.substring(0, stem.length() - 1)) + context, stem.substring(0, stem.length() - 1), npartOfComp});
                    res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
                } else if (stem.length() > 3 && Roman.typeOfLetterLat(stem.charAt(stem.length() - 2)) == Roman.V) {
                    res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
                }
            }
        } else if (action1Type == Action.INSERTIONVOWELLENGTHENING && action2Type == Action.NULLACTION) {
            if (stemEndChar == action1.getInsert().charAt(0) && stem.length() > 3 && stem.charAt(stem.length() - 2) == stemEndChar && stem.charAt(stem.length() - 3) == context.charAt(0)) {
                res.add(new Object[]{stem.substring(0, stem.length() - 2), stem.substring(0, stem.length() - 2), partOfComp});
            }
        } else if (action1Type == Action.NEUTRAL && action2Type == Action.SELFDECAPITATION) {
            if (typeOfStemEndChar == Roman.V && stem.length() > 1) {
                if (Roman.typeOfLetterLat(stem.charAt(stem.length() - 2)) == Roman.V && form.form.length() == form.getAffix().morpheme.length() - 1) {
                    res.add(new Object[]{stem, stem, partOfComp});
                } else if (Roman.typeOfLetterLat(stem.charAt(stem.length() - 2)) == Roman.C && form.form.length() == form.getAffix().morpheme.length()) {
                    res.add(new Object[]{stem, stem, partOfComp});
                }
            }
        } else if (action1Type == Action.DELETION && action2Type == Action.SELFDECAPITATION) {
            if (typeOfStemEndChar == Roman.V && stem.length() > 2) {
                if (Roman.typeOfLetterLat(stem.charAt(stem.length() - 2)) == Roman.V && form.form.length() == form.getAffix().morpheme.length() - 1) {
                    res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
                } else if (Roman.typeOfLetterLat(stem.charAt(stem.length() - 2)) == Roman.C && form.form.length() == form.getAffix().morpheme.length()) {
                    res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
                }
            }
        } else if (action1Type == Action.DELETION && action2Type == Action.DELETION && typeOfStemEndChar == Roman.V) {
            res.add(new Object[]{String.valueOf(stem) + context, stem, partOfComp});
            res.add(new Object[]{String.valueOf(stem) + "a" + context, stem, partOfComp});
            res.add(new Object[]{String.valueOf(stem) + "i" + context, stem, partOfComp});
            res.add(new Object[]{String.valueOf(stem) + "u" + context, stem, partOfComp});
        }
        if (!affix.type.equals("tad")) {
            int i = 0;
            while (i < res.size()) {
                String stemres = (String)((Object[])res.get(i))[0];
                if (stemres.length() > 2 && Roman.typeOfLetterLat(stemres.charAt(stemres.length() - 1)) == Roman.C && Roman.typeOfLetterLat(stemres.charAt(stemres.length() - 2)) == Roman.C) {
                    res.remove(i--);
                }
                ++i;
            }
        }
        if (res.size() == 0) {
            return null;
        }
        return (Object[][])res.toArray((T[])new Object[0][]);
    }

    private static Vector analyzeRoot(String termICI, String termOrigICI, String term, boolean isSyllabic, String word, Vector morphParts, Graph.State[] states, Conditions preCond, String transitivity) {
        if (termOrigICI.endsWith("*")) {
            termOrigICI = termOrigICI.substring(0, termOrigICI.length() - 1);
        }
        Vector lexs = null;
        Vector newCandidates = null;
        lexs = Lexicon.lookForBase(termICI, isSyllabic);
        newCandidates = Dialect.newRootCandidates(termICI);
        if (newCandidates != null) {
            int k = 0;
            while (k < newCandidates.size()) {
                Vector tr = Lexicon.lookForBase((String)newCandidates.elementAt(k), isSyllabic);
                if (tr != null) {
                    if (lexs == null) {
                        lexs = (Vector)tr.clone();
                    } else {
                        lexs.addAll(tr);
                    }
                }
                ++k;
            }
        }
        Vector analyses = MorphInuk.checkRoots(lexs, word, termOrigICI, morphParts, states, preCond, transitivity);
        Vector analyses2 = new Vector();
        Vector allAnalyses = new Vector();
        allAnalyses.addAll(analyses);
        allAnalyses.addAll(analyses2);
        return allAnalyses;
    }

    private static Vector checkRoots(Vector lexs, String word, String termOrigICI, Vector morphParts, Graph.State[] states, Conditions preCond, String transitivity) {
        String keyStateIDs = "0";
        int i = 0;
        while (i < states.length) {
            keyStateIDs = String.valueOf(keyStateIDs) + "+" + states[i].id;
            ++i;
        }
        Vector<Decomposition> rootAnalyses = new Vector<Decomposition>();
        char typeBase = '\u0000';
        if (lexs == null) {
            lexs = new Vector();
        }
        int ib = 0;
        while (ib < lexs.size()) {
            Base root = (Base)lexs.elementAt(ib);
            typeBase = root.type.charAt(0);
            if (typeBase == '?') {
                Decomposition res = new Decomposition(word, new RootPartOfComposition(termOrigICI, root, transitivity, null), morphParts.toArray());
                rootAnalyses.add(res);
            } else {
                boolean accepted = true;
                Graph.Arc arcFollowed = null;
                Graph.Arc[] arcsFollowed = null;
                arcsFollowed = MorphInuk.arcsSuivis(root, states, keyStateIDs);
                accepted = arcsFollowed != null && (arcFollowed = MorphInuk.arcToZero(arcsFollowed)) != null && root.meetsConditions(preCond, morphParts) && (!root.type.equals("v") || root.meetsTransitivityCondition(transitivity));
                if (accepted) {
                    Graph.Arc arc = arcFollowed.copy();
                    RootPartOfComposition mr = new RootPartOfComposition(termOrigICI, root, transitivity, arc);
                    Decomposition res = new Decomposition(word, mr, morphParts.toArray());
                    rootAnalyses.add(res);
                }
            }
            ++ib;
        }
        return rootAnalyses;
    }

    private static Graph.Arc arcToZero(Graph.Arc[] arcsFollowed) {
        int i = 0;
        while (i < arcsFollowed.length) {
            if (arcsFollowed[i].getDestinationState() == Graph.finalState) {
                return arcsFollowed[i];
            }
            ++i;
        }
        return null;
    }

    private static boolean sameAsNext(Morpheme morpheme, Vector partsAlreadyAnalyzed) {
        boolean res = true;
        if (partsAlreadyAnalyzed.size() != 0) {
            Affix affPrec = ((AffixPartOfComposition)partsAlreadyAnalyzed.elementAt(0)).getAffix();
            if (morpheme.id.equals(affPrec.id)) {
                res = false;
            }
        }
        return res;
    }

    private static boolean samePosition(int positionAffixInWord, Vector partsAlreadyAnalyzed) {
        AffixPartOfComposition nextMorphpart;
        boolean res = true;
        if (partsAlreadyAnalyzed.size() != 0 && (nextMorphpart = (AffixPartOfComposition)partsAlreadyAnalyzed.elementAt(0)).getPosition() == positionAffixInWord) {
            res = false;
        }
        return res;
    }

    private static Graph.Arc[] arcsSuivis(Morpheme morpheme, Graph.State[] states, String keyStateIDs) {
        Graph.Arc[] arcsFollowed = null;
        String keyMorphemeStateIDs = String.valueOf(morpheme.id) + ":" + keyStateIDs;
        Graph.Arc[] arcsFollowedByHash = (Graph.Arc[])arcsByMorpheme.get(keyMorphemeStateIDs);
        if (arcsFollowedByHash == null) {
            Vector arcs = null;
            Vector arcsFollowedV = new Vector();
            int j = 0;
            while (j < states.length) {
                arcs = states[j].verify(morpheme);
                arcsFollowedV.addAll(arcs);
                ++j;
            }
            if (arcsFollowedV.size() != 0) {
                arcsFollowed = arcsFollowedV.toArray(new Graph.Arc[0]);
                arcsByMorpheme.put(keyMorphemeStateIDs, arcsFollowed);
            }
        } else {
            arcsFollowed = arcsFollowedByHash;
        }
        return arcsFollowed;
    }

    private static Object[][] agreeWithContextAndActions(String affixCandidateOrig, Affix affix, String stem, int positionAffixInWord, SurfaceFormOfAffix form, boolean notResultingFromDialectalPhonologicalTransformation) {
        Object[][] stemAffs = null;
        boolean checkStartOfConsonantsGroup = true;
        if (!notResultingFromDialectalPhonologicalTransformation && Roman.isConsonant(form.form.charAt(0)) && Roman.isConsonant(affixCandidateOrig.charAt(0)) && form.form.charAt(0) != affixCandidateOrig.charAt(0)) {
            checkStartOfConsonantsGroup = false;
        }
        String context = form.context;
        Action action1 = form.action1;
        Action action2 = form.action2;
        stemAffs = MorphInuk.validateContextActions(context, action1, action2, stem, positionAffixInWord, affix, form, false, checkStartOfConsonantsGroup, affixCandidateOrig);
        return stemAffs;
    }

    private static Vector checkForDoubleConsonantInVerbalRoots(Vector rootCandidates) {
        int j;
        Vector newLexs = new Vector();
        Vector<String> newRootCandidates = new Vector<String>();
        int i = 0;
        while (i < rootCandidates.size()) {
            String rootCandidate = (String)rootCandidates.elementAt(i);
            j = rootCandidate.length() - 2;
            while (j > 0) {
                if (Roman.isConsonant(rootCandidate.charAt(j))) {
                    if (rootCandidate.charAt(j - 1) != rootCandidate.charAt(j) || !Roman.isVowel(rootCandidate.charAt(rootCandidate.length() - 1)) && rootCandidate.charAt(rootCandidate.length() - 1) != 'q') break;
                    String newRootCandidate = String.valueOf(rootCandidate.substring(0, j - 1)) + rootCandidate.substring(j);
                    if (newRootCandidate.charAt(newRootCandidate.length() - 1) == 'q') {
                        newRootCandidates.add(newRootCandidate.substring(0, newRootCandidate.length() - 1));
                    }
                    newRootCandidates.add(newRootCandidate);
                    break;
                }
                --j;
            }
            ++i;
        }
        i = 0;
        while (i < newRootCandidates.size()) {
            Vector tr = Lexicon.lookForBase((String)newRootCandidates.elementAt(i), false);
            if (tr != null) {
                j = 0;
                while (j < tr.size()) {
                    if (((Base)tr.elementAt((int)j)).type.equals("v")) {
                        newLexs.add(tr.elementAt(j));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return newLexs;
    }
}

