/*
 * Decompiled with CFR 0.152.
 */
package phonology;

import data.LinguisticDataAbstract;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import phonology.PhonologicalTransformation;
import script.Orthography;
import script.Roman;

public class Dialect {
    private static String[][] groups = new String[][]{{"bl", "ll"}, {"bj", "jj"}, {"bg", "gg"}, {"bv", "vv"}, {"pl", "ll"}, {"pk", "kk"}, {"pg", "gg"}, {"pv", "vv"}, {"pq", "qq"}, {"ps", "ts"}, {"ps", "ss"}, {"pt", "tt"}, {"mN", "NN"}, {"mn", "nn"}, {"mp", "pp"}, {"tp", "pp"}, {"tk", "kk"}, {"tj", "jj"}, {"ts", "ss"}, {"ts", "tt"}, {"t&", "ts"}, {"t&", "tt"}, {"&&", "tt"}, {"lv", "vv"}, {"nN", "NN"}, {"nm", "mm"}, {"kt", "tt"}, {"ks", "ss"}, {"kp", "pp"}, {"kv", "vv"}, {"ks", "ts"}, {"k&", "ss"}, {"k&", "ts"}, {"k&", "kt"}, {"gl", "ll"}, {"gv", "vv"}, {"Nm", "mm"}, {"Nn", "nn"}, {"qt", "tt"}, {"q&", "r&"}, {"qt", "rt"}, {"ql", "rl"}, {"qp", "rp"}, {"qs", "rs"}, {"q&", "qs"}, {"q&", "qt"}, {"rq", "qq"}};
    private static String[][] groups2 = new String[][]{{"it", "is"}};

    public static String[] getKeys() {
        String[] keys = new String[groups.length * 2];
        int i = 0;
        while (i < groups.length) {
            int j = i * 2;
            keys[j] = groups[i][0];
            keys[j + 1] = groups[i][1];
            ++i;
        }
        return keys;
    }

    public static Vector equivalentGroups(char l1, char l2) {
        String group = new String(new char[]{l1, l2});
        Vector<String> terms = new Vector<String>();
        int i = 0;
        while (i < groups.length) {
            if (groups[i][0].equals(group)) {
                terms.add(groups[i][1]);
            }
            if (groups[i][1].equals(group)) {
                terms.add(groups[i][0]);
            }
            ++i;
        }
        if (terms.size() == 0) {
            return null;
        }
        return terms;
    }

    public static Vector newCandidates(String stem, String candidateMorpheme, String followingMorpheme) {
        Vector<String> cands = new Vector<String>();
        ArrayList<Object> candsAndChanges = new ArrayList<Object>();
        if (stem != null) {
            String groupOrig;
            Vector grps;
            char finalStem = stem.charAt(stem.length() - 1);
            char initialFollowingMorpheme = candidateMorpheme.charAt(0);
            if (Roman.typeOfLetterLat(initialFollowingMorpheme) == Roman.C && (grps = Dialect.equivalentGroups((groupOrig = new String(new char[]{finalStem, initialFollowingMorpheme})).charAt(0), groupOrig.charAt(1))) != null) {
                int j = 0;
                while (j < grps.size()) {
                    String groupj = (String)grps.elementAt(j);
                    char c = groupj.charAt(1);
                    String candStr = String.valueOf(c) + candidateMorpheme.substring(1);
                    if (!cands.contains(candStr)) {
                        cands.add(candStr);
                        ArrayList<PhonologicalTransformation> l = new ArrayList<PhonologicalTransformation>();
                        l.add(new PhonologicalTransformation(groupOrig, groupj, 0));
                        candsAndChanges.add(new Object[]{candStr, l});
                    }
                    ++j;
                }
            }
        }
        Vector<String> cands2 = new Vector<String>();
        cands2.add(candidateMorpheme);
        cands2.addAll(cands);
        ArrayList<Object> candsAndChanges2 = new ArrayList<Object>();
        Object[] objectArray = new Object[2];
        objectArray[0] = candidateMorpheme;
        candsAndChanges2.add(objectArray);
        candsAndChanges2.addAll(candsAndChanges);
        int m = 0;
        while (m < cands2.size()) {
            String candStr = (String)cands2.elementAt(m);
            Vector correspondingTerms = Dialect.correspondingTerms(candStr);
            ArrayList correspTermsAndChanges = Dialect.correspondingTermsEquivalentGroups(candStr, 0);
            if (correspondingTerms != null) {
                ArrayList ltf = (ArrayList)((Object[])candsAndChanges2.get(m))[1];
                if (ltf != null) {
                    PhonologicalTransformation tf = (PhonologicalTransformation)ltf.get(0);
                    int i = 0;
                    while (i < correspTermsAndChanges.size()) {
                        ArrayList l = (ArrayList)((Object[])correspTermsAndChanges.get(i))[1];
                        l.add(tf);
                        ++i;
                    }
                }
                int n = 0;
                while (n < correspondingTerms.size()) {
                    String candN = (String)correspondingTerms.elementAt(n);
                    if (!cands.contains(candN)) {
                        cands.add(candN);
                        candsAndChanges.add(correspTermsAndChanges.get(n));
                    }
                    ++n;
                }
            }
            ++m;
        }
        if (cands.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < cands.size()) {
            if (((String)cands.elementAt(i)).equals(candidateMorpheme)) {
                cands.remove(i);
                candsAndChanges.remove(i--);
            }
            ++i;
        }
        Vector schCands = Dialect.schneiderCandidates(stem, candidateMorpheme);
        int i2 = 0;
        while (i2 < cands.size()) {
            schCands.addAll(Dialect.schneiderCandidates(stem, (String)cands.elementAt(i2)));
            while (schCands.removeElement((String)cands.elementAt(i2))) {
            }
            ++i2;
        }
        cands.addAll(schCands);
        if (cands.size() == 0) {
            return null;
        }
        while (cands.removeElement(candidateMorpheme)) {
        }
        return cands;
    }

    public static Vector newRootCandidates(String rootICI) {
        Vector<String> cands = new Vector<String>();
        Vector correspondingTerms = Dialect.correspondingTerms(rootICI);
        if (correspondingTerms != null) {
            int n = 0;
            while (n < correspondingTerms.size()) {
                String candN = Orthography.orthographyICILat((String)correspondingTerms.elementAt(n));
                if (!cands.contains(candN)) {
                    cands.add(candN);
                }
                ++n;
            }
        }
        if (cands.size() == 0) {
            return null;
        }
        while (cands.removeElement(rootICI)) {
        }
        Vector schCands = Dialect.schneiderCandidates(null, rootICI);
        int i = 0;
        while (i < cands.size()) {
            schCands.addAll(Dialect.schneiderCandidates(null, (String)cands.elementAt(i)));
            while (schCands.removeElement((String)cands.elementAt(i))) {
            }
            ++i;
        }
        cands.addAll(schCands);
        if (cands.size() == 0) {
            return null;
        }
        while (cands.removeElement(rootICI)) {
        }
        return cands;
    }

    public static Object[] schneiderStateAtEnd(String stem) {
        Object cands = null;
        boolean doubleConsonants = false;
        if (stem == null) {
            doubleConsonants = false;
            int vcState = Roman.V;
            return new Object[]{new Boolean(doubleConsonants), new Integer(vcState)};
        }
        int i = stem.length() - 1;
        while (i > 0) {
            if (Roman.isConsonant(stem.charAt(i))) {
                if (Roman.isConsonant(stem.charAt(i - 1))) {
                    doubleConsonants = true;
                    break;
                }
                doubleConsonants = false;
                break;
            }
            --i;
        }
        int vcState = Roman.isConsonant(stem.charAt(stem.length() - 1)) ? Roman.C : Roman.V;
        return new Object[]{new Boolean(doubleConsonants), new Integer(vcState)};
    }

    private static Vector correspondingTerms(String term) {
        Vector termsGC = Dialect.correspondingTermsEquivalentGroups(term);
        return termsGC;
    }

    public static Vector correspondingTermsEquivalentGroups(String term) {
        Vector<String> terms = new Vector<String>();
        int i = 0;
        while (i < term.length() - 1) {
            Vector greqs = Dialect.equivalentGroups(term.charAt(i), term.charAt(i + 1));
            char l3 = i == term.length() - 2 ? (char)'\uffff' : (char)term.charAt(i + 2);
            Vector greqs2 = Dialect.equivalentGroups2(term.charAt(i), term.charAt(i + 1), l3);
            if (greqs2 != null) {
                if (greqs != null) {
                    greqs.addAll(greqs2);
                } else {
                    greqs = (Vector)greqs2.clone();
                }
            }
            if (greqs != null) {
                greqs.add(new String(new char[]{term.charAt(i), term.charAt(i + 1)}));
                Vector remains = Dialect.correspondingTermsEquivalentGroups(term.substring(i + 2));
                int j = 0;
                while (j < greqs.size()) {
                    String termTemp = String.valueOf(term.substring(0, i)) + (String)greqs.elementAt(j);
                    if (remains.size() > 0) {
                        int k = 0;
                        while (k < remains.size()) {
                            terms.add(String.valueOf(termTemp) + (String)remains.elementAt(k));
                            ++k;
                        }
                    } else {
                        terms.add(termTemp);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        if (i == term.length() - 1) {
            terms.add(term);
        }
        return terms;
    }

    public static ArrayList correspondingTermsEquivalentGroups(String term, int pos) {
        ArrayList<Object[]> termsAndAlterations = new ArrayList<Object[]>();
        int i = pos;
        while (i < term.length() - 1) {
            String groupOfConsonants = new String(new char[]{term.charAt(i), term.charAt(i + 1)});
            Vector greqs = Dialect.equivalentGroups(term.charAt(i), term.charAt(i + 1));
            char l3 = i == term.length() - 2 ? (char)'\uffff' : (char)term.charAt(i + 2);
            Vector greqs2 = Dialect.equivalentGroups2(term.charAt(i), term.charAt(i + 1), l3);
            if (greqs2 != null) {
                if (greqs != null) {
                    greqs.addAll(greqs2);
                } else {
                    greqs = (Vector)greqs2.clone();
                }
            }
            if (greqs != null) {
                greqs.add(groupOfConsonants);
                ArrayList remainsAndAlterations = Dialect.correspondingTermsEquivalentGroups(term, i + 2);
                int j = 0;
                while (j < greqs.size()) {
                    String grp = (String)greqs.elementAt(j);
                    String termTemp = String.valueOf(term.substring(pos, i)) + grp;
                    PhonologicalTransformation tp = new PhonologicalTransformation(groupOfConsonants, grp, i);
                    if (remainsAndAlterations.size() > 0) {
                        int k = 0;
                        while (k < remainsAndAlterations.size()) {
                            String newTerm = String.valueOf(termTemp) + (String)((Object[])remainsAndAlterations.get(k))[0];
                            ArrayList alterations = (ArrayList)((ArrayList)((Object[])remainsAndAlterations.get(k))[1]).clone();
                            alterations.add(0, tp);
                            termsAndAlterations.add(new Object[]{newTerm, alterations});
                            ++k;
                        }
                    } else {
                        ArrayList<PhonologicalTransformation> alterations = new ArrayList<PhonologicalTransformation>();
                        alterations.add(tp);
                        termsAndAlterations.add(new Object[]{termTemp, alterations});
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        if (i == term.length() - 1) {
            termsAndAlterations.add(new Object[]{term.substring(pos), new ArrayList()});
        }
        return termsAndAlterations;
    }

    private static Vector equivalentGroups2(char l1, char l2, char l3) {
        String group = new String(new char[]{l1, l2});
        Vector<String> terms = new Vector<String>();
        if (l3 != '\uffff' && Roman.typeOfLetterLat(l3) == Roman.V) {
            int i = 0;
            while (i < groups2.length) {
                if (groups2[i][0].equals(group)) {
                    terms.add(groups2[i][1]);
                }
                if (groups2[i][1].equals(group)) {
                    terms.add(groups2[i][0]);
                }
                ++i;
            }
        }
        if (terms.size() == 0) {
            return null;
        }
        return terms;
    }

    public static Vector schneiderCandidates(String stem, String candidate) {
        return Dialect.schneiderCandidates(stem, candidate, '@');
    }

    private static Vector schneiderCandidates(String stem, String candidate, char mark) {
        String markedCandidate = Dialect.schneiderCandidatesToString(stem, candidate, mark);
        Vector cands = Dialect.explode(markedCandidate);
        return cands;
    }

    public static String schneiderCandidatesToString(String stem, String candidate, char mark) {
        String candSimp = candidate;
        boolean doubleConsonants = false;
        Object[] x = Dialect.schneiderStateAtEnd(stem);
        doubleConsonants = (Boolean)x[0];
        int vcState = (Integer)x[1];
        String markedCandidate = Dialect.markCandidate(candSimp, vcState, doubleConsonants, mark);
        return markedCandidate;
    }

    public static String markCandidate(String cand, int vcState, boolean doubleConsonants, char mark) {
        String marked = "";
        String str = cand;
        if (doubleConsonants && vcState == 0) {
            str = "XXa" + str;
        }
        Pattern p = Pattern.compile("(([^aiu][^aiu][aiu][aiu]?)([^aiu][aiu]))");
        Matcher m = p.matcher(str);
        int pos = 0;
        while (m.find(pos)) {
            marked = String.valueOf(marked) + str.substring(pos, m.start(1));
            marked = String.valueOf(marked) + m.group(2);
            marked = String.valueOf(marked) + mark;
            marked = String.valueOf(marked) + m.group(3);
            pos = m.end(1);
        }
        marked = String.valueOf(marked) + str.substring(pos);
        marked = marked.replaceFirst("^XXa", "");
        return marked;
    }

    private static Vector explode(String s) {
        if (s.length() == 0) {
            return new Vector();
        }
        return Dialect.explode2(s);
    }

    private static Vector explode2(String s) {
        Vector<String> a = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '@') {
                Vector grCons = (Vector)LinguisticDataAbstract.groupsOfConsonants.get(new Character(s.charAt(i + 1)));
                if (grCons == null) break;
                int j = 0;
                while (j < grCons.size()) {
                    a.addAll(Dialect.explode(String.valueOf(new String()) + (String)grCons.elementAt(j) + s.substring(i + 2)));
                    ++j;
                }
                break;
            }
            sb.append(s.charAt(i));
            ++i;
        }
        if (a.size() == 0) {
            a.add("");
        }
        String deb = sb.toString();
        int i2 = 0;
        while (i2 < a.size()) {
            a.setElementAt(String.valueOf(deb) + (String)a.elementAt(i2), i2);
            ++i2;
        }
        return a;
    }
}

