/*
 * Decompiled with CFR 0.152.
 */
package script;

import fonts.Font;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import script.Roman;

public class Orthography {
    static int[] doubleVowelsSyl = new int[]{5131, 5124, 5126, 5265, 5260, 5262, 5422, 5417, 5419, 5235, 5230, 5232, 5339, 5334, 5336, 5291, 5286, 5288, 5320, 5315, 5317, 5177, 5170, 5172, 5508, 5504, 5506, 5452, 5447, 5449, 5365, 5360, 5362, 5206, 5199, 5201, 5466, 5462, 5464, 5524, 5520, 5522, 5541, 5537, 5539, 5750, 5746, 5748, 5498, 5494, 5496};
    static int[] vowelsSyl = new int[]{5130, 5131, 5123, 5124, 5125, 5126, 5264, 5265, 5259, 5260, 5261, 5262, 5421, 5422, 5416, 5417, 5418, 5419, 5234, 5235, 5229, 5230, 5231, 5232, 5338, 5339, 5333, 5334, 5335, 5336, 5290, 5291, 5285, 5286, 5287, 5288, 5319, 5320, 5314, 5315, 5316, 5317, 5176, 5177, 5169, 5170, 5171, 5172, 5507, 5508, 5503, 5504, 5505, 5506, 5451, 5452, 5446, 5447, 5448, 5449, 5364, 5365, 5359, 5360, 5361, 5362, 5205, 5206, 5198, 5199, 5200, 5201, 5465, 5466, 5461, 5462, 5463, 5464, 5523, 5524, 5519, 5520, 5521, 5522, 5540, 5541, 5536, 5537, 5538, 5539, 5749, 5750, 5745, 5746, 5747, 5748, 5497, 5498, 5493, 5494, 5495, 5496};
    static String UnicodeWordChars = "[a-zA-Z\\u1400-\\u167f0-9\\-\\&\u00e2\\u0142]";

    public static String simplifiedOrthography(String term, boolean isSyllabic) {
        return isSyllabic ? Orthography.simplifiedOrthographySyl(term) : Orthography.simplifiedOrthographyLat(term);
    }

    public static String simplifiedOrthographyLat(String term) {
        StringBuffer sb = new StringBuffer();
        int lengthTerm = term.length();
        int i = 0;
        while (i < lengthTerm) {
            if (term.charAt(i) == 'n') {
                if (i < lengthTerm - 1) {
                    if (term.charAt(i + 1) == 'n') {
                        if (i < lengthTerm - 2 && term.charAt(i + 2) == 'g') {
                            sb.append("NN");
                            i += 2;
                        } else {
                            sb.append("nn");
                            ++i;
                        }
                    } else if (term.charAt(i + 1) == 'g') {
                        sb.append("N");
                        ++i;
                    } else {
                        sb.append(term.substring(i, i + 1));
                    }
                } else {
                    sb.append(term.substring(i, i + 1));
                }
            } else {
                sb.append(term.substring(i, i + 1));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String simplifiedOrthographyLatB(String term) {
        StringBuffer sb = new StringBuffer();
        int lengthTerm = term.length();
        int i = 0;
        while (i < lengthTerm) {
            if (term.charAt(i) == 'n') {
                if (i < lengthTerm - 1) {
                    if (term.charAt(i + 1) == 'n') {
                        if (i < lengthTerm - 2 && term.charAt(i + 2) == 'g') {
                            sb.append("X");
                            i += 2;
                        } else {
                            sb.append("nn");
                            ++i;
                        }
                    } else if (term.charAt(i + 1) == 'g') {
                        sb.append("N");
                        ++i;
                    } else {
                        sb.append(term.substring(i, i + 1));
                    }
                } else {
                    sb.append(term.substring(i, i + 1));
                }
            } else if (term.charAt(i) == 'q' && i < lengthTerm - 1 && term.charAt(i + 1) == 'q') {
                sb.append("qk");
                ++i;
            } else {
                sb.append(term.substring(i, i + 1));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String simplifiedOrthographySyl(String term) {
        Arrays.sort(doubleVowelsSyl);
        StringBuffer sb = new StringBuffer();
        int lengthTerm = term.length();
        try {
            int i = 0;
            while (i < lengthTerm) {
                char charac = term.charAt(i);
                int indDV = Arrays.binarySearch(doubleVowelsSyl, (int)charac);
                if (charac == '\u1585') {
                    if (i < lengthTerm - 1) {
                        char charac1 = term.charAt(i + 1);
                        if (charac1 == '\u1472') {
                            sb.append(new char[]{'\u1585', '\u1583'});
                            ++i;
                        } else if (charac1 == '\u146d') {
                            sb.append(new char[]{'\u1585', '\u157f'});
                            ++i;
                        } else if (charac1 == '\u146f') {
                            sb.append(new char[]{'\u1585', '\u1581'});
                            ++i;
                        } else if (charac1 == '\u1473') {
                            sb.append(new char[]{'\u1585', '\u1583', '\u140a'});
                            ++i;
                        } else if (charac1 == '\u146e') {
                            sb.append(new char[]{'\u1585', '\u157f', '\u1403'});
                            ++i;
                        } else if (charac1 == '\u1470') {
                            sb.append(new char[]{'\u1585', '\u1581', '\u1405'});
                            ++i;
                        } else {
                            sb.append(term.substring(i, i + 1));
                        }
                    } else {
                        sb.append(term.substring(i, i + 1));
                    }
                } else if (indDV >= 0) {
                    sb.append(new String(Roman.longToDouble(charac)));
                } else {
                    sb.append(term.substring(i, i + 1));
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String orthographyICI(String term, boolean isSyllabic) {
        return isSyllabic ? Orthography.orthographyICISyl(term) : Orthography.orthographyICILat(term);
    }

    public static String orthographyICILat(String term) {
        int lengthTerm = term.length();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < lengthTerm) {
            if (term.charAt(i) == 'X') {
                sb.append("nng");
            } else if (term.charAt(i) == 'N') {
                if (i < lengthTerm - 1 && term.charAt(i + 1) == 'N') {
                    sb.append("nng");
                    ++i;
                } else {
                    sb.append("ng");
                }
            } else {
                sb.append(term.substring(i, i + 1));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String orthographyICILat(char charac) {
        String term = new String(new char[]{charac});
        int lengthTerm = term.length();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < lengthTerm) {
            if (term.charAt(i) == 'X') {
                sb.append("nng");
            } else if (term.charAt(i) == 'N') {
                if (i < lengthTerm - 1 && term.charAt(i + 1) == 'N') {
                    sb.append("nng");
                    ++i;
                } else {
                    sb.append("ng");
                }
            } else {
                sb.append(term.substring(i, i + 1));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String orthographyICISyl(String term) {
        int lengthTerm = term.length();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < lengthTerm) {
            char charac = term.charAt(i);
            if (i == lengthTerm - 1) {
                sb.append(term.substring(i));
            } else if (Roman.sylWithSameVowel(charac, term.charAt(i + 1))) {
                sb.append(new String(new char[]{Roman.shortToLong(charac)}));
                ++i;
            } else {
                sb.append(term.substring(i, i + 1));
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isWordDelimiter(char c, String fontName) {
        Pattern pwordChars = null;
        String cs = "" + c;
        pwordChars = Font.isLegacy((String)fontName) ? Pattern.compile(Font.getWordChars((String)fontName)) : Pattern.compile(UnicodeWordChars);
        Matcher m = pwordChars.matcher(cs);
        return !m.matches();
    }

    public static boolean isWordChar(char c, String fontName) {
        String cs = "" + c;
        Pattern pwordChars = Font.isLegacy((String)fontName) ? Pattern.compile(Font.getWordChars((String)fontName)) : Pattern.compile(UnicodeWordChars);
        Matcher m = pwordChars.matcher(cs);
        return m.matches();
    }
}

